# Generated by default/object.tt
package Paws::Firehose::HttpEndpointConfiguration;
  use Moose;
  has AccessKey => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has Url => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Firehose::HttpEndpointConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Firehose::HttpEndpointConfiguration object:

  $service_obj->Method(Att1 => { AccessKey => $value, ..., Url => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Firehose::HttpEndpointConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AccessKey

=head1 DESCRIPTION

Describes the configuration of the HTTP endpoint to which Kinesis
Firehose delivers data.

=head1 ATTRIBUTES


=head2 AccessKey => Str

The access key required for Kinesis Firehose to authenticate with the
HTTP endpoint selected as the destination.


=head2 Name => Str

The name of the HTTP endpoint selected as the destination.


=head2 B<REQUIRED> Url => Str

The URL of the HTTP endpoint selected as the destination.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Firehose>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

