/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.ResultSetStatisticsFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;

abstract class NoRowsResultSetImpl
implements ResultSet {
    protected final Activation activation;
    private boolean isTopResultSet = true;
    private boolean dumpedStats;
    protected NoPutResultSet[] subqueryTrackingArray;
    private final boolean statisticsTimingOn;
    private boolean isClosed;
    protected String indent;
    protected String subIndent;
    protected int sourceDepth;
    protected final LanguageConnectionContext lcc;
    protected long beginTime;
    protected long endTime;
    protected long beginExecutionTime;
    protected long endExecutionTime;

    NoRowsResultSetImpl(Activation activation) throws StandardException {
        this.activation = activation;
        this.lcc = activation.getLanguageConnectionContext();
        this.statisticsTimingOn = this.lcc.getStatisticsTiming();
        this.beginExecutionTime = this.beginTime = this.getCurrentTimeMillis();
        StatementContext statementContext = this.lcc.getStatementContext();
        statementContext.setTopResultSet(this, null);
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = statementContext.getSubqueryTrackingArray();
        }
    }

    public final boolean returnsRows() {
        return false;
    }

    public int modifiedRowCount() {
        return 0;
    }

    public ResultDescription getResultDescription() {
        return null;
    }

    public ExecRow getAbsoluteRow(int n) throws StandardException {
        throw StandardException.newException("XCL01.S", "absolute");
    }

    public ExecRow getRelativeRow(int n) throws StandardException {
        throw StandardException.newException("XCL01.S", "relative");
    }

    public ExecRow setBeforeFirstRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "beforeFirst");
    }

    public ExecRow getFirstRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "first");
    }

    public ExecRow getNextRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "next");
    }

    public ExecRow getPreviousRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "previous");
    }

    public ExecRow getLastRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "last");
    }

    public ExecRow setAfterLastRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "afterLast");
    }

    public boolean checkRowPosition(int n) {
        return false;
    }

    public int getRowNumber() {
        return 0;
    }

    public void close() throws StandardException {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void finish() throws StandardException {
        if (!this.dumpedStats) {
            if (this.lcc.getRunTimeStatisticsMode() && !this.doesCommit()) {
                HeaderPrintWriter headerPrintWriter;
                this.endExecutionTime = this.getCurrentTimeMillis();
                ExecutionContext executionContext = this.lcc.getExecutionContext();
                ResultSetStatisticsFactory resultSetStatisticsFactory = executionContext.getResultSetStatisticsFactory();
                this.lcc.setRunTimeStatisticsObject(resultSetStatisticsFactory.getRunTimeStatistics(this.activation, this, this.subqueryTrackingArray));
                HeaderPrintWriter headerPrintWriter2 = headerPrintWriter = this.lcc.getLogQueryPlan() ? Monitor.getStream() : null;
                if (headerPrintWriter != null) {
                    headerPrintWriter.printlnWithHeader("(XID = " + this.lcc.getTransactionExecute().getTransactionIdString() + "), " + "(SESSIONID = " + this.lcc.getInstanceNumber() + "), " + this.lcc.getRunTimeStatisticsObject().getStatementText() + " ******* " + this.lcc.getRunTimeStatisticsObject().getStatementExecutionPlanText());
                }
            }
            this.dumpedStats = true;
        }
        int n = this.subqueryTrackingArray == null ? 0 : this.subqueryTrackingArray.length;
        for (int i = 0; i < n; ++i) {
            if (this.subqueryTrackingArray[i] == null || this.subqueryTrackingArray[i].isClosed()) continue;
            this.subqueryTrackingArray[i].close();
        }
    }

    public long getExecuteTime() {
        return this.endTime - this.beginTime;
    }

    public Timestamp getBeginExecutionTimestamp() {
        if (this.beginExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.beginExecutionTime);
    }

    public Timestamp getEndExecutionTimestamp() {
        if (this.endExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.endExecutionTime);
    }

    public String getQueryPlanText(int n) {
        return MessageService.getTextMessage("42Z47.U", this.getClass().getName());
    }

    public long getTimeSpent(int n) {
        return 0L;
    }

    public final NoPutResultSet[] getSubqueryTrackingArray(int n) {
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = new NoPutResultSet[n];
        }
        return this.subqueryTrackingArray;
    }

    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    public String getCursorName() {
        return null;
    }

    protected final long getCurrentTimeMillis() {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    public static void evaluateACheckConstraint(GeneratedMethod generatedMethod, String string, long l, Activation activation) throws StandardException {
        DataValueDescriptor dataValueDescriptor;
        if (generatedMethod != null && (dataValueDescriptor = (DataValueDescriptor)generatedMethod.invoke(activation)) != null && !dataValueDescriptor.isNull() && !dataValueDescriptor.getBoolean()) {
            DataDictionary dataDictionary = activation.getLanguageConnectionContext().getDataDictionary();
            ConglomerateDescriptor conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(l);
            TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(conglomerateDescriptor.getTableID());
            StandardException standardException = StandardException.newException("23513", tableDescriptor.getQualifiedName(), (Object)string);
            throw standardException;
        }
    }

    public static void evaluateCheckConstraints(GeneratedMethod generatedMethod, Activation activation) throws StandardException {
        if (generatedMethod != null) {
            generatedMethod.invoke(activation);
        }
    }

    public boolean doesCommit() {
        return false;
    }

    public SQLWarning getWarnings() {
        return null;
    }
}

