BEGIN {
	eval "use Digest::SHA qw(sha1)";
	if ($@) {
		print "1..0 # Skipped: Digest::SHA not installed\n";
		exit;
	}
}

use strict;
use FileHandle;
use Crypt::SHAVS;

my ($vectors, $check) = ("vec$$.tmp", "chk$$.tmp");
END { 1 while unlink ($vectors, $check) }

my $numtests = 0;
my $fh = FileHandle->new($vectors, "w");
while (<DATA>) { print $fh $_; $numtests++ if /^MD\s*=/ }  close($fh);

$fh = FileHandle->new($check, "w+");
my $stdout = select($fh);
Crypt::SHAVS->new(\&sha1)->check($vectors);
select($stdout);

my $testnum = 1;
print "1..$numtests\n";
$fh->seek(0, 0);
while (<$fh>) {
	print "not " unless /OK\s*$/;
	print "ok ", $testnum++, "\n";
}
close($fh);

__DATA__
#  CAVS 11.0
#  "SHA-1 LongMsg" information 
#  SHA tests are configured for BYTE oriented implementations
#  Generated on Tue Mar 15 08:23:35 2011

[L = 20]

Len = 1304
Msg = 7c9c67323a1df1adbfe5ceb415eaef0155ece2820f4d50c1ec22cba4928ac656c83fe585db6a78ce40bc42757aba7e5a3f582428d6ca68d0c3978336a6efb729613e8d9979016204bfd921322fdd5222183554447de5e6e9bbe6edf76d7b71e18dc2e8d6dc89b7398364f652fafc734329aafa3dcd45d4f31e388e4fafd7fc6495f37ca5cbab7f54d586463da4bfeaa3bae09f7b8e9239d832b4f0a733aa609cc1f8d4
MD = d8fd6a91ef3b6ced05b98358a99107c1fac8c807

Len = 2096
Msg = 6cb70d19c096200f9249d2dbc04299b0085eb068257560be3a307dbd741a3378ebfa03fcca610883b07f7fea563a866571822472dade8a0bec4b98202d47a344312976a7bcb3964427eacb5b0525db22066599b81be41e5adaf157d925fac04b06eb6e01deb753babf33be16162b214e8db017212fafa512cdc8c0d0a15c10f632e8f4f47792c64d3f026004d173df50cf0aa7976066a79a8d78deeeec951dab7cc90f68d16f786671feba0b7d269d92941c4f02f432aa5ce2aab6194dcc6fd3ae36c8433274ef6b1bd0d314636be47ba38d1948343a38bf9406523a0b2a8cd78ed6266ee3c9b5c60620b308cc6b3a73c6060d5268a7d82b6a33b93a6fd6fe1de55231d12c97
MD = 4a75a406f4de5f9e1132069d66717fc424376388

Len = 2888
Msg = 6487972d88d0dd390d8d09d134860f263f88df7a3412457adf510dcf164e6cf041679b3a19fcc542af6a236ab03d66b2e8a155d1061ab7859f75732775fff682f8f4d5e50d3ab3770f4f66cb138155b4715d245b8069948ea016a45b7ef0fdde93188c57eef4717f3425181de5b9a5d4e0a2963f2a67a340eb1ae994b98a48ab19b90ab74391c50426d28287ac4f1eb93f5af1a68c7dae40876b8afaaf35a19293c1952e957978abee40ec32f2aa880c956c7eb72f117b397cefcfb4e75ace3b081776e46b13521e93559d453e32ab74ebc0859b9a8dd4d1d39000ebe95f984d80a3f5004dc91a051dfbdfe9194f4f9a483e4e7955577fb0933464c63eaec771044d59abc3029a079519f8460a693b25b4ce207ae9d9447fc4c5446e6dad234e9afdec0c562798cd0297318399e838be385845c6dd79ede66e2ae80afec6738d4d9bf44c8d9eddff6c5cd2c94e340e0ddac40384b9a1408c9a4b98c37a6081d5220fba92f1d03144db
MD = a135e32581bb06289b8c83f040e9421ec79bbe01

Len = 3680
Msg = bd74e7f607cd7d905e90175d67650a6dc2f8a4e2d4ab1249ca88812bda7984deccbbb6a1ba90a0e91434ddf5e6137ba85e39a598890a7f635d335242fce0e9e037303b6c51e54aec06614ad5ccce06d9599c80016530d7fbb1da6eb548084b2b05babd7d553642443efda726a1fd71a8bc087c44f285e2bccf661ead475a72673e4386fc4eea5197c4f13c0feb0a85bc8e67e28ab872684bbebdaa527f3c253debb2dc12c2693f8e9e2651b9345c0abed7a0fafa3e5d305386c95acb7a172e5413ef08e73b1bd4d0d6832e4c035bc8559f9b0cbd0caf037a30707641c0545356bee151a24068d70674ef1befe16f872aef4060faaad1a968c39c45dbd7595de8f472016b5ab812d77e545fca55000ee5ce773edaa129eac6473410c2499013b4be895f6c0f734becfe994306e776262d4528ed8577218e3cc5201f1d9e5f3f62230eb2caea014becfba60fcb1f3997aa5b3bb622b7205c714348ba155c30a79a2cea43b070cada807e630b4086b129051898e1d9e68d1d0ecc9429d20d6a1403e0035a442b37bf508eb87e8ea347a3e68427b6d48ed299ba65ecb37b38754f4547423eaea2aec403338db2dcfe61cff4a8d17c383656981e1838a23866b91d09698f39175d98af4175caed53
MD = b22b87ea30f4050913f8f0241fc2ae2c319f52e7
