#!/usr/bin/perl

package eBay::API::XML::DataType::SearchStoreFilterType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SearchStoreFilterType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SearchStoreFilterType

=head1 DESCRIPTION

One of the data filters used when searching for items using
GetSearchResults. Allows filtering based on an item's appearing in a
specific eBay Store.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SearchStoreFilterType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::StoreSearchCodeType;


my @gaProperties = ( [ 'StoreName', 'xs:string', '', '', '' ]
	, [ 'StoreSearch', 'ns:StoreSearchCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StoreSearchCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setStoreName()

The name of the eBay Store in which the item is listed.
The name of the store is case sensitive.

  Calls: GetSearchResults
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setStoreName {
  my $self = shift;
  $self->{'StoreName'} = shift
}

=head2 getStoreName()

#    Returns: 'xs:string'

=cut

sub getStoreName {
  my $self = shift;
  return $self->{'StoreName'};
}


=head2 setStoreSearch()

Specifies the type of store search used in the filtering: one eBay Store (name
specified in StoreName) or all eBay stores, and also by listing type. Possible
values are enumerated in the StoreSearchCodeType code list.

  Calls: GetSearchResults
  RequiredInput: No

#    Argument: 'ns:StoreSearchCodeType'

=cut

sub setStoreSearch {
  my $self = shift;
  $self->{'StoreSearch'} = shift
}

=head2 getStoreSearch()

#    Returns: 'ns:StoreSearchCodeType'

=cut

sub getStoreSearch {
  my $self = shift;
  return $self->{'StoreSearch'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
