use Unicode::Collate::CJK::Stroke;
+{
   overrideCJK => \&Unicode::Collate::CJK::Stroke::weightStroke,
   entry => <<'ENTRY', # for DUCET v6.0.0
0101      ; [.15A3.001C.0002.0101] # LATIN SMALL LETTER A WITH MACRON
0061 0304 ; [.15A3.001C.0002.0101] # LATIN SMALL LETTER A WITH MACRON
0100      ; [.15A3.001C.0008.0100] # LATIN CAPITAL LETTER A WITH MACRON
0041 0304 ; [.15A3.001C.0008.0100] # LATIN CAPITAL LETTER A WITH MACRON
00E1      ; [.15A3.001D.0002.00E1] # LATIN SMALL LETTER A WITH ACUTE
0061 0301 ; [.15A3.001D.0002.00E1] # LATIN SMALL LETTER A WITH ACUTE
0061 0341 ; [.15A3.001D.0002.00E1] # LATIN SMALL LETTER A WITH ACUTE
00C1      ; [.15A3.001D.0008.00C1] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0301 ; [.15A3.001D.0008.00C1] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0341 ; [.15A3.001D.0008.00C1] # LATIN CAPITAL LETTER A WITH ACUTE
01CE      ; [.15A3.001E.0002.01CE] # LATIN SMALL LETTER A WITH CARON
0061 030C ; [.15A3.001E.0002.01CE] # LATIN SMALL LETTER A WITH CARON
01CD      ; [.15A3.001E.0008.01CD] # LATIN CAPITAL LETTER A WITH CARON
0041 030C ; [.15A3.001E.0008.01CD] # LATIN CAPITAL LETTER A WITH CARON
00E0      ; [.15A3.001F.0002.00E0] # LATIN SMALL LETTER A WITH GRAVE
0061 0300 ; [.15A3.001F.0002.00E0] # LATIN SMALL LETTER A WITH GRAVE
0061 0340 ; [.15A3.001F.0002.00E0] # LATIN SMALL LETTER A WITH GRAVE
00C0      ; [.15A3.001F.0008.00C0] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0300 ; [.15A3.001F.0008.00C0] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0340 ; [.15A3.001F.0008.00C0] # LATIN CAPITAL LETTER A WITH GRAVE
0113      ; [.15FF.001C.0002.0113] # LATIN SMALL LETTER E WITH MACRON
0065 0304 ; [.15FF.001C.0002.0113] # LATIN SMALL LETTER E WITH MACRON
0112      ; [.15FF.001C.0008.0112] # LATIN CAPITAL LETTER E WITH MACRON
0045 0304 ; [.15FF.001C.0008.0112] # LATIN CAPITAL LETTER E WITH MACRON
00E9      ; [.15FF.001D.0002.00E9] # LATIN SMALL LETTER E WITH ACUTE
0065 0301 ; [.15FF.001D.0002.00E9] # LATIN SMALL LETTER E WITH ACUTE
0065 0341 ; [.15FF.001D.0002.00E9] # LATIN SMALL LETTER E WITH ACUTE
00C9      ; [.15FF.001D.0008.00C9] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0301 ; [.15FF.001D.0008.00C9] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0341 ; [.15FF.001D.0008.00C9] # LATIN CAPITAL LETTER E WITH ACUTE
011B      ; [.15FF.001E.0002.011B] # LATIN SMALL LETTER E WITH CARON
0065 030C ; [.15FF.001E.0002.011B] # LATIN SMALL LETTER E WITH CARON
011A      ; [.15FF.001E.0008.011A] # LATIN CAPITAL LETTER E WITH CARON
0045 030C ; [.15FF.001E.0008.011A] # LATIN CAPITAL LETTER E WITH CARON
00E8      ; [.15FF.001F.0002.00E8] # LATIN SMALL LETTER E WITH GRAVE
0065 0300 ; [.15FF.001F.0002.00E8] # LATIN SMALL LETTER E WITH GRAVE
0065 0340 ; [.15FF.001F.0002.00E8] # LATIN SMALL LETTER E WITH GRAVE
00C8      ; [.15FF.001F.0008.00C8] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0300 ; [.15FF.001F.0008.00C8] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0340 ; [.15FF.001F.0008.00C8] # LATIN CAPITAL LETTER E WITH GRAVE
00EA 0304 ; [.15FF.0021.0002.00EA] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
00CA 0304 ; [.15FF.0021.0008.00CA] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
0065 0302 0304 ; [.15FF.0021.0002.00EA] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
0045 0302 0304 ; [.15FF.0021.0008.00CA] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
1EBF      ; [.15FF.0022.0002.1EBF] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0301 ; [.15FF.0022.0002.1EBF] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0341 ; [.15FF.0022.0002.1EBF] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
1EBE      ; [.15FF.0022.0008.1EBE] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0301 ; [.15FF.0022.0008.1EBE] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0341 ; [.15FF.0022.0008.1EBE] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
00EA 0301 ; [.15FF.0022.0002.1EBF] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00EA 0341 ; [.15FF.0022.0002.1EBF] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00CA 0301 ; [.15FF.0022.0008.1EBE] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00CA 0341 ; [.15FF.0022.0008.1EBE] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00EA 030C ; [.15FF.0023.0002.00EA] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
00CA 030C ; [.15FF.0023.0008.00CA] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
0065 0302 030C ; [.15FF.0023.0002.00EA] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
0045 0302 030C ; [.15FF.0023.0008.00CA] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
1EC1      ; [.15FF.0024.0002.1EC1] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0300 ; [.15FF.0024.0002.1EC1] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0340 ; [.15FF.0024.0002.1EC1] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
1EC0      ; [.15FF.0024.0008.1EC0] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0300 ; [.15FF.0024.0008.1EC0] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0340 ; [.15FF.0024.0008.1EC0] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
00EA 0300 ; [.15FF.0024.0002.1EC1] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00EA 0340 ; [.15FF.0024.0002.1EC1] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00CA 0300 ; [.15FF.0024.0008.1EC0] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00CA 0340 ; [.15FF.0024.0008.1EC0] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00EA      ; [.15FF.0025.0002.00EA] # LATIN SMALL LETTER E WITH CIRCUMFLEX
0065 0302 ; [.15FF.0025.0002.00EA] # LATIN SMALL LETTER E WITH CIRCUMFLEX
00CA      ; [.15FF.0025.0008.00CA] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
0045 0302 ; [.15FF.0025.0008.00CA] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
1EC5      ; [.15FF.0025.0002.00EA][.0000.004E.0002.0303] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
1EC4      ; [.15FF.0025.0008.00CA][.0000.004E.0002.0303] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
1EC3      ; [.15FF.0025.0002.00EA][.0000.0064.0002.0309] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC2      ; [.15FF.0025.0008.00CA][.0000.0064.0002.0309] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC7      ; [.15FF.0025.0002.00EA][.0000.0070.0002.0323] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
1EC6      ; [.15FF.0025.0008.00CA][.0000.0070.0002.0323] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
012B      ; [.1680.001C.0002.012B] # LATIN SMALL LETTER I WITH MACRON
0069 0304 ; [.1680.001C.0002.012B] # LATIN SMALL LETTER I WITH MACRON
012A      ; [.1680.001C.0008.012A] # LATIN CAPITAL LETTER I WITH MACRON
0049 0304 ; [.1680.001C.0008.012A] # LATIN CAPITAL LETTER I WITH MACRON
00ED      ; [.1680.001D.0002.00ED] # LATIN SMALL LETTER I WITH ACUTE
0069 0301 ; [.1680.001D.0002.00ED] # LATIN SMALL LETTER I WITH ACUTE
0069 0341 ; [.1680.001D.0002.00ED] # LATIN SMALL LETTER I WITH ACUTE
00CD      ; [.1680.001D.0008.00CD] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0301 ; [.1680.001D.0008.00CD] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0341 ; [.1680.001D.0008.00CD] # LATIN CAPITAL LETTER I WITH ACUTE
01D0      ; [.1680.001E.0002.01D0] # LATIN SMALL LETTER I WITH CARON
0069 030C ; [.1680.001E.0002.01D0] # LATIN SMALL LETTER I WITH CARON
01CF      ; [.1680.001E.0008.01CF] # LATIN CAPITAL LETTER I WITH CARON
0049 030C ; [.1680.001E.0008.01CF] # LATIN CAPITAL LETTER I WITH CARON
00EC      ; [.1680.001F.0002.00EC] # LATIN SMALL LETTER I WITH GRAVE
0069 0300 ; [.1680.001F.0002.00EC] # LATIN SMALL LETTER I WITH GRAVE
0069 0340 ; [.1680.001F.0002.00EC] # LATIN SMALL LETTER I WITH GRAVE
00CC      ; [.1680.001F.0008.00CC] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0300 ; [.1680.001F.0008.00CC] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0340 ; [.1680.001F.0008.00CC] # LATIN CAPITAL LETTER I WITH GRAVE
006D 0304 ; [.16F4.001C.0002.006D] # <LATIN SMALL LETTER M, COMBINING MACRON>
004D 0304 ; [.16F4.001C.0008.004D] # <LATIN CAPITAL LETTER M, COMBINING MACRON>
1E3F      ; [.16F4.001D.0002.1E3F] # LATIN SMALL LETTER M WITH ACUTE
006D 0301 ; [.16F4.001D.0002.1E3F] # LATIN SMALL LETTER M WITH ACUTE
006D 0341 ; [.16F4.001D.0002.1E3F] # LATIN SMALL LETTER M WITH ACUTE
1E3E      ; [.16F4.001D.0008.1E3E] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0301 ; [.16F4.001D.0008.1E3E] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0341 ; [.16F4.001D.0008.1E3E] # LATIN CAPITAL LETTER M WITH ACUTE
006D 030C ; [.16F4.001E.0002.006D] # <LATIN SMALL LETTER M, COMBINING CARON>
004D 030C ; [.16F4.001E.0008.004D] # <LATIN CAPITAL LETTER M, COMBINING CARON>
006D 0300 ; [.16F4.001F.0002.006D] # <LATIN SMALL LETTER M, COMBINING GRAVE ACCENT>
006D 0340 ; [.16F4.001F.0002.006D] # <LATIN SMALL LETTER M, COMBINING GRAVE TONE MARK>
004D 0300 ; [.16F4.001F.0008.004D] # <LATIN CAPITAL LETTER M, COMBINING GRAVE ACCENT>
004D 0340 ; [.16F4.001F.0008.004D] # <LATIN CAPITAL LETTER M, COMBINING GRAVE TONE MARK>
006E 0304 ; [.1702.001C.0002.006E] # <LATIN SMALL LETTER N, COMBINING MACRON>
004E 0304 ; [.1702.001C.0008.004E] # <LATIN CAPITAL LETTER N, COMBINING MACRON>
0144      ; [.1702.001D.0002.0144] # LATIN SMALL LETTER N WITH ACUTE
006E 0301 ; [.1702.001D.0002.0144] # LATIN SMALL LETTER N WITH ACUTE
006E 0341 ; [.1702.001D.0002.0144] # LATIN SMALL LETTER N WITH ACUTE
0143      ; [.1702.001D.0008.0143] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0301 ; [.1702.001D.0008.0143] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0341 ; [.1702.001D.0008.0143] # LATIN CAPITAL LETTER N WITH ACUTE
0148      ; [.1702.001E.0002.0148] # LATIN SMALL LETTER N WITH CARON
006E 030C ; [.1702.001E.0002.0148] # LATIN SMALL LETTER N WITH CARON
0147      ; [.1702.001E.0008.0147] # LATIN CAPITAL LETTER N WITH CARON
004E 030C ; [.1702.001E.0008.0147] # LATIN CAPITAL LETTER N WITH CARON
01F9      ; [.1702.001F.0002.01F9] # LATIN SMALL LETTER N WITH GRAVE
006E 0300 ; [.1702.001F.0002.01F9] # LATIN SMALL LETTER N WITH GRAVE
006E 0340 ; [.1702.001F.0002.01F9] # LATIN SMALL LETTER N WITH GRAVE
01F8      ; [.1702.001F.0008.01F8] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0300 ; [.1702.001F.0008.01F8] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0340 ; [.1702.001F.0008.01F8] # LATIN CAPITAL LETTER N WITH GRAVE
014D      ; [.1724.001C.0002.014D] # LATIN SMALL LETTER O WITH MACRON
006F 0304 ; [.1724.001C.0002.014D] # LATIN SMALL LETTER O WITH MACRON
014C      ; [.1724.001C.0008.014C] # LATIN CAPITAL LETTER O WITH MACRON
004F 0304 ; [.1724.001C.0008.014C] # LATIN CAPITAL LETTER O WITH MACRON
00F3      ; [.1724.001D.0002.00F3] # LATIN SMALL LETTER O WITH ACUTE
006F 0301 ; [.1724.001D.0002.00F3] # LATIN SMALL LETTER O WITH ACUTE
006F 0341 ; [.1724.001D.0002.00F3] # LATIN SMALL LETTER O WITH ACUTE
00D3      ; [.1724.001D.0008.00D3] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0301 ; [.1724.001D.0008.00D3] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0341 ; [.1724.001D.0008.00D3] # LATIN CAPITAL LETTER O WITH ACUTE
01D2      ; [.1724.001E.0002.01D2] # LATIN SMALL LETTER O WITH CARON
006F 030C ; [.1724.001E.0002.01D2] # LATIN SMALL LETTER O WITH CARON
01D1      ; [.1724.001E.0008.01D1] # LATIN CAPITAL LETTER O WITH CARON
004F 030C ; [.1724.001E.0008.01D1] # LATIN CAPITAL LETTER O WITH CARON
00F2      ; [.1724.001F.0002.00F2] # LATIN SMALL LETTER O WITH GRAVE
006F 0300 ; [.1724.001F.0002.00F2] # LATIN SMALL LETTER O WITH GRAVE
006F 0340 ; [.1724.001F.0002.00F2] # LATIN SMALL LETTER O WITH GRAVE
00D2      ; [.1724.001F.0008.00D2] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0300 ; [.1724.001F.0008.00D2] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0340 ; [.1724.001F.0008.00D2] # LATIN CAPITAL LETTER O WITH GRAVE
016B      ; [.17E9.001C.0002.016B] # LATIN SMALL LETTER U WITH MACRON
0075 0304 ; [.17E9.001C.0002.016B] # LATIN SMALL LETTER U WITH MACRON
016A      ; [.17E9.001C.0008.016A] # LATIN CAPITAL LETTER U WITH MACRON
0055 0304 ; [.17E9.001C.0008.016A] # LATIN CAPITAL LETTER U WITH MACRON
00FA      ; [.17E9.001D.0002.00FA] # LATIN SMALL LETTER U WITH ACUTE
0075 0301 ; [.17E9.001D.0002.00FA] # LATIN SMALL LETTER U WITH ACUTE
0075 0341 ; [.17E9.001D.0002.00FA] # LATIN SMALL LETTER U WITH ACUTE
00DA      ; [.17E9.001D.0008.00DA] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0301 ; [.17E9.001D.0008.00DA] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0341 ; [.17E9.001D.0008.00DA] # LATIN CAPITAL LETTER U WITH ACUTE
01D4      ; [.17E9.001E.0002.01D4] # LATIN SMALL LETTER U WITH CARON
0075 030C ; [.17E9.001E.0002.01D4] # LATIN SMALL LETTER U WITH CARON
01D3      ; [.17E9.001E.0008.01D3] # LATIN CAPITAL LETTER U WITH CARON
0055 030C ; [.17E9.001E.0008.01D3] # LATIN CAPITAL LETTER U WITH CARON
00F9      ; [.17E9.001F.0002.00F9] # LATIN SMALL LETTER U WITH GRAVE
0075 0300 ; [.17E9.001F.0002.00F9] # LATIN SMALL LETTER U WITH GRAVE
0075 0340 ; [.17E9.001F.0002.00F9] # LATIN SMALL LETTER U WITH GRAVE
00D9      ; [.17E9.001F.0008.00D9] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0300 ; [.17E9.001F.0008.00D9] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0340 ; [.17E9.001F.0008.00D9] # LATIN CAPITAL LETTER U WITH GRAVE
01D6      ; [.17E9.0021.0002.01D6] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
0075 0308 0304 ; [.17E9.0021.0002.01D6] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
01D5      ; [.17E9.0021.0008.01D5] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
0055 0308 0304 ; [.17E9.0021.0008.01D5] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
00FC 0304 ; [.17E9.0021.0002.01D6] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING MACRON>
00DC 0304 ; [.17E9.0021.0008.01D5] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING MACRON>
01D8      ; [.17E9.0022.0002.01D8] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0301 ; [.17E9.0022.0002.01D8] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0341 ; [.17E9.0022.0002.01D8] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
01D7      ; [.17E9.0022.0008.01D7] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0301 ; [.17E9.0022.0008.01D7] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0341 ; [.17E9.0022.0008.01D7] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
00FC 0301 ; [.17E9.0022.0002.01D8] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00FC 0341 ; [.17E9.0022.0002.01D8] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
00DC 0301 ; [.17E9.0022.0008.01D7] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00DC 0341 ; [.17E9.0022.0008.01D7] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
01DA      ; [.17E9.0023.0002.01DA] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
0075 0308 030C ; [.17E9.0023.0002.01DA] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
01D9      ; [.17E9.0023.0008.01D9] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
0055 0308 030C ; [.17E9.0023.0008.01D9] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
00FC 030C ; [.17E9.0023.0002.01DA] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING CARON>
00DC 030C ; [.17E9.0023.0008.01D9] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING CARON>
01DC      ; [.17E9.0024.0002.01DC] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0300 ; [.17E9.0024.0002.01DC] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0340 ; [.17E9.0024.0002.01DC] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
01DB      ; [.17E9.0024.0008.01DB] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0300 ; [.17E9.0024.0008.01DB] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0340 ; [.17E9.0024.0008.01DB] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
00FC 0300 ; [.17E9.0024.0002.01DC] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00FC 0340 ; [.17E9.0024.0002.01DC] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00DC 0300 ; [.17E9.0024.0008.01DB] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00DC 0340 ; [.17E9.0024.0008.01DB] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00FC      ; [.17E9.0025.0002.00FC] # LATIN SMALL LETTER U WITH DIAERESIS
0075 0308 ; [.17E9.0025.0002.00FC] # LATIN SMALL LETTER U WITH DIAERESIS
00DC      ; [.17E9.0025.0008.00DC] # LATIN CAPITAL LETTER U WITH DIAERESIS
0055 0308 ; [.17E9.0025.0008.00DC] # LATIN CAPITAL LETTER U WITH DIAERESIS
FDD0 2801 ; [.8000.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-1>
2E84      ; [.8007.0020.0002.2E84] # CJK RADICAL SECOND THREE
3006      ; [.8012.0020.0002.3006] # IDEOGRAPHIC CLOSING MARK
3007      ; [.8013.0020.0002.3007] # IDEOGRAPHIC NUMBER ZERO
3021      ; [.8014.0020.0002.3021] # HANGZHOU NUMERAL ONE
3025      ; [.8015.0020.0002.3025] # HANGZHOU NUMERAL FIVE
303B      ; [.8016.0020.0002.303B] # VERTICAL IDEOGRAPHIC ITERATION MARK
FDD0 2802 ; [.8017.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-2>
2E86      ; [.8031.0020.0002.2E86] # CJK RADICAL BOX
2E87      ; [.8035.0020.0002.2E87] # CJK RADICAL TABLE
2E88      ; [.8038.0020.0002.2E88] # CJK RADICAL KNIFE ONE
2E8A      ; [.8042.0020.0002.2E8A] # CJK RADICAL DIVINATION
2E80      ; [.8047.0020.0002.2E80] # CJK RADICAL REPEAT
2ECF      ; [.804B.0020.0002.2ECF] # CJK RADICAL CITY
2ED6      ; [.804C.0020.0002.2ED6] # CJK RADICAL MOUND TWO
3022      ; [.804E.0020.0002.3022] # HANGZHOU NUMERAL TWO
3024      ; [.804F.0020.0002.3024] # HANGZHOU NUMERAL FOUR
3026      ; [.8050.0020.0002.3026] # HANGZHOU NUMERAL SIX
FDD0 2803 ; [.8051.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-12>
2E8C      ; [.808F.0020.0002.2E8C] # CJK RADICAL SMALL ONE
2E8D      ; [.8090.0020.0002.2E8D] # CJK RADICAL SMALL TWO
2E95      ; [.80A8.0020.0002.2E95] # CJK RADICAL SNOUT TWO
2EBE      ; [.80B3.0020.0002.2EBE] # CJK RADICAL GRASS ONE
2ECC      ; [.80B5.0020.0002.2ECC] # CJK RADICAL SIMPLIFIED WALK
3005      ; [.80BB.0020.0002.3005] # IDEOGRAPHIC ITERATION MARK
3023      ; [.80BC.0020.0002.3023] # HANGZHOU NUMERAL THREE
3027      ; [.80BD.0020.0002.3027] # HANGZHOU NUMERAL SEVEN
FDD0 2804 ; [.80BE.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-3>
2E9C      ; [.815B.0020.0002.2E9C] # CJK RADICAL SUN
2E9D      ; [.815E.0020.0002.2E9D] # CJK RADICAL MOON
2EA5      ; [.8170.0020.0002.2EA5] # CJK RADICAL PAW TWO
2EA7      ; [.817A.0020.0002.2EA7] # CJK RADICAL COW
2EBC      ; [.8185.0020.0002.2EBC] # CJK RADICAL MEAT
2ECD      ; [.818E.0020.0002.2ECD] # CJK RADICAL WALK ONE
3028      ; [.8193.0020.0002.3028] # HANGZHOU NUMERAL EIGHT
3029      ; [.8194.0020.0002.3029] # HANGZHOU NUMERAL NINE
FDD0 2805 ; [.8195.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-13>
2EAA      ; [.82B3.0020.0002.2EAA] # CJK RADICAL BOLT OF CLOTH
2EAC      ; [.82BF.0020.0002.2EAC] # CJK RADICAL SPIRIT ONE
FDD0 2806 ; [.82E7.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-23>
2EAE      ; [.84B2.0020.0002.2EAE] # CJK RADICAL BAMBOO
2EB6      ; [.84C6.0020.0002.2EB6] # CJK RADICAL SHEEP
FDD0 2807 ; [.8529.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-123>
2EC6      ; [.887A.0020.0002.2EC6] # CJK RADICAL SIMPLIFIED HORN
2ECA      ; [.889A.0020.0002.2ECA] # CJK RADICAL FOOT
FDD0 2808 ; [.88FA.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-4>
FA24      ; [.8E20.0020.0002.FA24] # CJK COMPATIBILITY IDEOGRAPH-FA24
2ED7      ; [.8E5B.0020.0002.2ED7] # CJK RADICAL RAIN
FDD0 2809 ; [.8E7C.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-14>
2EDE      ; [.94AC.0020.0002.2EDE] # CJK RADICAL EAT TWO
2EE3      ; [.94C3.0020.0002.2EE3] # CJK RADICAL BONE
FDD0 280A ; [.94CA.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-24>
FA0F      ; [.95F1.0020.0002.FA0F] # CJK COMPATIBILITY IDEOGRAPH-FA0F
FDD0 280B ; [.9C16.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-124>
FA21      ; [.A279.0020.0002.FA21] # CJK COMPATIBILITY IDEOGRAPH-FA21
FA23      ; [.A312.0020.0002.FA23] # CJK COMPATIBILITY IDEOGRAPH-FA23
FDD0 280C ; [.A41D.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-34>
FA11      ; [.A5A3.0020.0002.FA11] # CJK COMPATIBILITY IDEOGRAPH-FA11
FDD0 280D ; [.AC7F.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-134>
FA0E      ; [.ACD0.0020.0002.FA0E] # CJK COMPATIBILITY IDEOGRAPH-FA0E
FA13      ; [.AEF8.0020.0002.FA13] # CJK COMPATIBILITY IDEOGRAPH-FA13
FA29      ; [.B3B4.0020.0002.FA29] # CJK COMPATIBILITY IDEOGRAPH-FA29
FDD0 280E ; [.B44A.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-234>
FA14      ; [.B690.0020.0002.FA14] # CJK COMPATIBILITY IDEOGRAPH-FA14
FDD0 280F ; [.BB5A.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-1234>
FA27      ; [.C173.0020.0002.FA27] # CJK COMPATIBILITY IDEOGRAPH-FA27
FDD0 2810 ; [.C276.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-5>
FA28      ; [.C748.0020.0002.FA28] # CJK COMPATIBILITY IDEOGRAPH-FA28
FDD0 2811 ; [.C860.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-15>
FDD0 2812 ; [.CD3D.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-25>
FDD0 2813 ; [.D0E6.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-125>
FA1F      ; [.D23D.0020.0002.FA1F] # CJK COMPATIBILITY IDEOGRAPH-FA1F
FDD0 2814 ; [.D41B.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-35>
FDD0 2815 ; [.D68C.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-135>
FDD0 2816 ; [.D846.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-235>
FDD0 2817 ; [.D993.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-1235>
FDD0 2818 ; [.DA95.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-45>
FDD0 2819 ; [.DB3D.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-145>
FDD0 281A ; [.DBB4.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-245>
FDD0 281B ; [.DBF1.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-1245>
FDD0 281C ; [.DC29.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-345>
FDD0 281D ; [.DC4D.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-1345>
FDD0 281E ; [.DC5C.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-2345>
FDD0 281F ; [.DC6C.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-12345>
FDD0 2820 ; [.DC71.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-6>
FDD0 2821 ; [.DC76.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-16>
FDD0 2823 ; [.DC7C.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-126>
FDD0 2824 ; [.DC7E.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-36>
FDD0 2827 ; [.DC80.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-1236>
FDD0 2830 ; [.DC82.0020.0002.FDD0] # <noncharacter-FDD0, BRAILLE PATTERN DOTS-56>
3220      ; [*030E.0020.0004.3220][.8001.0020.0004.3220][*030F.0020.001F.3220] # PARENTHESIZED IDEOGRAPH ONE
3226      ; [*030E.0020.0004.3226][.801A.0020.0004.3226][*030F.0020.001F.3226] # PARENTHESIZED IDEOGRAPH SEVEN
3222      ; [*030E.0020.0004.3222][.8054.0020.0004.3222][*030F.0020.001F.3222] # PARENTHESIZED IDEOGRAPH THREE
3228      ; [*030E.0020.0004.3228][.8027.0020.0004.3228][*030F.0020.001F.3228] # PARENTHESIZED IDEOGRAPH NINE
3221      ; [*030E.0020.0004.3221][.802A.0020.0004.3221][*030F.0020.001F.3221] # PARENTHESIZED IDEOGRAPH TWO
3224      ; [*030E.0020.0004.3224][.80D7.0020.0004.3224][*030F.0020.001F.3224] # PARENTHESIZED IDEOGRAPH FIVE
3239      ; [*030E.0020.0004.3239][.81C2.0020.0004.3239][*030F.0020.001F.3239] # PARENTHESIZED IDEOGRAPH REPRESENT
323D      ; [*030E.0020.0004.323D][.831C.0020.0004.323D][*030F.0020.001F.323D] # PARENTHESIZED IDEOGRAPH ENTERPRISE
3241      ; [*030E.0020.0004.3241][.832C.0020.0004.3241][*030F.0020.001F.3241] # PARENTHESIZED IDEOGRAPH REST
3227      ; [*030E.0020.0004.3227][.8030.0020.0004.3227][*030F.0020.001F.3227] # PARENTHESIZED IDEOGRAPH EIGHT
3225      ; [*030E.0020.0004.3225][.80F5.0020.0004.3225][*030F.0020.001F.3225] # PARENTHESIZED IDEOGRAPH SIX
3238      ; [*030E.0020.0004.3238][.85A8.0020.0004.3238][*030F.0020.001F.3238] # PARENTHESIZED IDEOGRAPH LABOR
3229      ; [*030E.0020.0004.3229][.8041.0020.0004.3229][*030F.0020.001F.3229] # PARENTHESIZED IDEOGRAPH TEN
323F      ; [*030E.0020.0004.323F][.899D.0020.0004.323F][*030F.0020.001F.323F] # PARENTHESIZED IDEOGRAPH ALLIANCE
3234      ; [*030E.0020.0004.3234][.839D.0020.0004.3234][*030F.0020.001F.3234] # PARENTHESIZED IDEOGRAPH NAME
323A      ; [*030E.0020.0004.323A][.89D5.0020.0004.323A][*030F.0020.001F.323A] # PARENTHESIZED IDEOGRAPH CALL
3223      ; [*030E.0020.0004.3223][.822D.0020.0004.3223][*030F.0020.001F.3223] # PARENTHESIZED IDEOGRAPH FOUR
322F      ; [*030E.0020.0004.322F][.8081.0020.0004.322F][*030F.0020.001F.322F] # PARENTHESIZED IDEOGRAPH EARTH
323B      ; [*030E.0020.0004.323B][.8A8D.0020.0004.323B][*030F.0020.001F.323B] # PARENTHESIZED IDEOGRAPH STUDY
3230      ; [*030E.0020.0004.3230][.815C.0020.0004.3230][*030F.0020.001F.3230] # PARENTHESIZED IDEOGRAPH SUN
322A      ; [*030E.0020.0004.322A][.815F.0020.0004.322A][*030F.0020.001F.322A] # PARENTHESIZED IDEOGRAPH MOON
3232      ; [*030E.0020.0004.3232][.845A.0020.0004.3232][*030F.0020.001F.3232] # PARENTHESIZED IDEOGRAPH HAVE
322D      ; [*030E.0020.0004.322D][.8160.0020.0004.322D][*030F.0020.001F.322D] # PARENTHESIZED IDEOGRAPH WOOD
3231      ; [*030E.0020.0004.3231][.979F.0020.0004.3231][*030F.0020.001F.3231] # PARENTHESIZED IDEOGRAPH STOCK
322C      ; [*030E.0020.0004.322C][.816D.0020.0004.322C][*030F.0020.001F.322C] # PARENTHESIZED IDEOGRAPH WATER
322B      ; [*030E.0020.0004.322B][.816E.0020.0004.322B][*030F.0020.001F.322B] # PARENTHESIZED IDEOGRAPH FIRE
3235      ; [*030E.0020.0004.3235][.9895.0020.0004.3235][*030F.0020.001F.3235] # PARENTHESIZED IDEOGRAPH SPECIAL
323C      ; [*030E.0020.0004.323C][.B79A.0020.0004.323C][*030F.0020.001F.323C] # PARENTHESIZED IDEOGRAPH SUPERVISE
3233      ; [*030E.0020.0004.3233][.8D2E.0020.0004.3233][*030F.0020.001F.3233] # PARENTHESIZED IDEOGRAPH SOCIETY
3237      ; [*030E.0020.0004.3237][.9970.0020.0004.3237][*030F.0020.001F.3237] # PARENTHESIZED IDEOGRAPH CONGRATULATION
3240      ; [*030E.0020.0004.3240][.A100.0020.0004.3240][*030F.0020.001F.3240] # PARENTHESIZED IDEOGRAPH FESTIVAL
3242      ; [*030E.0020.0004.3242][.84D8.0020.0004.3242][*030F.0020.001F.3242] # PARENTHESIZED IDEOGRAPH SELF
3243      ; [*030E.0020.0004.3243][.84D9.0020.0004.3243][*030F.0020.001F.3243] # PARENTHESIZED IDEOGRAPH REACH
3236      ; [*030E.0020.0004.3236][.9B3B.0020.0004.3236][*030F.0020.001F.3236] # PARENTHESIZED IDEOGRAPH FINANCIAL
323E      ; [*030E.0020.0004.323E][.B2A5.0020.0004.323E][*030F.0020.001F.323E] # PARENTHESIZED IDEOGRAPH RESOURCE
322E      ; [*030E.0020.0004.322E][.8E33.0020.0004.322E][*030F.0020.001F.322E] # PARENTHESIZED IDEOGRAPH METAL
3358      ; [.1599.0020.0004.3358][.9216.0020.0004.3358] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO
33E9      ; [.159A.0020.0004.33E9][.1599.0020.0004.33E9][.815C.0020.001F.33E9] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN
32C9      ; [.159A.0020.0004.32C9][.1599.0020.0004.32C9][.815F.0020.001F.32C9] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER
3362      ; [.159A.0020.0004.3362][.1599.0020.0004.3362][.9216.0020.001F.3362] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN
33EA      ; [.159A.0020.0004.33EA][.159A.0020.0004.33EA][.815C.0020.001F.33EA] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN
32CA      ; [.159A.0020.0004.32CA][.159A.0020.0004.32CA][.815F.0020.001F.32CA] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER
3363      ; [.159A.0020.0004.3363][.159A.0020.0004.3363][.9216.0020.001F.3363] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN
33EB      ; [.159A.0020.0004.33EB][.159B.0020.0004.33EB][.815C.0020.001F.33EB] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE
32CB      ; [.159A.0020.0004.32CB][.159B.0020.0004.32CB][.815F.0020.001F.32CB] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER
3364      ; [.159A.0020.0004.3364][.159B.0020.0004.3364][.9216.0020.001F.3364] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE
33EC      ; [.159A.0020.0004.33EC][.159C.0020.0004.33EC][.815C.0020.001F.33EC] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN
3365      ; [.159A.0020.0004.3365][.159C.0020.0004.3365][.9216.0020.001F.3365] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN
33ED      ; [.159A.0020.0004.33ED][.159D.0020.0004.33ED][.815C.0020.001F.33ED] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN
3366      ; [.159A.0020.0004.3366][.159D.0020.0004.3366][.9216.0020.001F.3366] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN
33EE      ; [.159A.0020.0004.33EE][.159E.0020.0004.33EE][.815C.0020.001F.33EE] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN
3367      ; [.159A.0020.0004.3367][.159E.0020.0004.3367][.9216.0020.001F.3367] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN
33EF      ; [.159A.0020.0004.33EF][.159F.0020.0004.33EF][.815C.0020.001F.33EF] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN
3368      ; [.159A.0020.0004.3368][.159F.0020.0004.3368][.9216.0020.001F.3368] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN
33F0      ; [.159A.0020.0004.33F0][.15A0.0020.0004.33F0][.815C.0020.001F.33F0] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN
3369      ; [.159A.0020.0004.3369][.15A0.0020.0004.3369][.9216.0020.001F.3369] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN
33F1      ; [.159A.0020.0004.33F1][.15A1.0020.0004.33F1][.815C.0020.001F.33F1] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN
336A      ; [.159A.0020.0004.336A][.15A1.0020.0004.336A][.9216.0020.001F.336A] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN
33F2      ; [.159A.0020.0004.33F2][.15A2.0020.0004.33F2][.815C.0020.001F.33F2] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN
336B      ; [.159A.0020.0004.336B][.15A2.0020.0004.336B][.9216.0020.001F.336B] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN
33E0      ; [.159A.0020.0004.33E0][.815C.0020.0004.33E0] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE
32C0      ; [.159A.0020.0004.32C0][.815F.0020.0004.32C0] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY
3359      ; [.159A.0020.0004.3359][.9216.0020.0004.3359] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE
33F3      ; [.159B.0020.0004.33F3][.1599.0020.0004.33F3][.815C.0020.001F.33F3] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY
336C      ; [.159B.0020.0004.336C][.1599.0020.0004.336C][.9216.0020.001F.336C] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY
33F4      ; [.159B.0020.0004.33F4][.159A.0020.0004.33F4][.815C.0020.001F.33F4] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE
336D      ; [.159B.0020.0004.336D][.159A.0020.0004.336D][.9216.0020.001F.336D] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE
33F5      ; [.159B.0020.0004.33F5][.159B.0020.0004.33F5][.815C.0020.001F.33F5] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO
336E      ; [.159B.0020.0004.336E][.159B.0020.0004.336E][.9216.0020.001F.336E] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO
33F6      ; [.159B.0020.0004.33F6][.159C.0020.0004.33F6][.815C.0020.001F.33F6] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE
336F      ; [.159B.0020.0004.336F][.159C.0020.0004.336F][.9216.0020.001F.336F] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE
33F7      ; [.159B.0020.0004.33F7][.159D.0020.0004.33F7][.815C.0020.001F.33F7] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR
3370      ; [.159B.0020.0004.3370][.159D.0020.0004.3370][.9216.0020.001F.3370] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR
33F8      ; [.159B.0020.0004.33F8][.159E.0020.0004.33F8][.815C.0020.001F.33F8] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE
33F9      ; [.159B.0020.0004.33F9][.159F.0020.0004.33F9][.815C.0020.001F.33F9] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX
33FA      ; [.159B.0020.0004.33FA][.15A0.0020.0004.33FA][.815C.0020.001F.33FA] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN
33FB      ; [.159B.0020.0004.33FB][.15A1.0020.0004.33FB][.815C.0020.001F.33FB] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT
33FC      ; [.159B.0020.0004.33FC][.15A2.0020.0004.33FC][.815C.0020.001F.33FC] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE
33E1      ; [.159B.0020.0004.33E1][.815C.0020.0004.33E1] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO
32C1      ; [.159B.0020.0004.32C1][.815F.0020.0004.32C1] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY
335A      ; [.159B.0020.0004.335A][.9216.0020.0004.335A] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO
33FD      ; [.159C.0020.0004.33FD][.1599.0020.0004.33FD][.815C.0020.001F.33FD] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY
33FE      ; [.159C.0020.0004.33FE][.159A.0020.0004.33FE][.815C.0020.001F.33FE] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE
33E2      ; [.159C.0020.0004.33E2][.815C.0020.0004.33E2] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE
32C2      ; [.159C.0020.0004.32C2][.815F.0020.0004.32C2] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH
335B      ; [.159C.0020.0004.335B][.9216.0020.0004.335B] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE
33E3      ; [.159D.0020.0004.33E3][.815C.0020.0004.33E3] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR
32C3      ; [.159D.0020.0004.32C3][.815F.0020.0004.32C3] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL
335C      ; [.159D.0020.0004.335C][.9216.0020.0004.335C] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR
33E4      ; [.159E.0020.0004.33E4][.815C.0020.0004.33E4] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE
32C4      ; [.159E.0020.0004.32C4][.815F.0020.0004.32C4] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY
335D      ; [.159E.0020.0004.335D][.9216.0020.0004.335D] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE
33E5      ; [.159F.0020.0004.33E5][.815C.0020.0004.33E5] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX
32C5      ; [.159F.0020.0004.32C5][.815F.0020.0004.32C5] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE
335E      ; [.159F.0020.0004.335E][.9216.0020.0004.335E] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX
33E6      ; [.15A0.0020.0004.33E6][.815C.0020.0004.33E6] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN
32C6      ; [.15A0.0020.0004.32C6][.815F.0020.0004.32C6] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY
335F      ; [.15A0.0020.0004.335F][.9216.0020.0004.335F] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN
33E7      ; [.15A1.0020.0004.33E7][.815C.0020.0004.33E7] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT
32C7      ; [.15A1.0020.0004.32C7][.815F.0020.0004.32C7] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST
3360      ; [.15A1.0020.0004.3360][.9216.0020.0004.3360] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT
33E8      ; [.15A2.0020.0004.33E8][.815C.0020.0004.33E8] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE
32C8      ; [.15A2.0020.0004.32C8][.815F.0020.0004.32C8] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER
3361      ; [.15A2.0020.0004.3361][.9216.0020.0004.3361] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE
1F241     ; [*0356.0020.0004.1F241][.8054.0020.0004.1F241][*0357.0020.001F.1F241] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-4E09
1F242     ; [*0356.0020.0004.1F242][.802A.0020.0004.1F242][*0357.0020.001F.1F242] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-4E8C
1F247     ; [*0356.0020.0004.1F247][.A465.0020.0004.1F247][*0357.0020.001F.1F247] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-52DD
1F243     ; [*0356.0020.0004.1F243][.83F0.0020.0004.1F243][*0357.0020.001F.1F243] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-5B89
1F245     ; [*0356.0020.0004.1F245][.8277.0020.0004.1F245][*0357.0020.001F.1F245] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6253
1F248     ; [*0356.0020.0004.1F248][.9EDA.0020.0004.1F248][*0357.0020.001F.1F248] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6557
1F240     ; [*0356.0020.0004.1F240][.8283.0020.0004.1F240][*0357.0020.001F.1F240] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-672C
1F244     ; [*0356.0020.0004.1F244][.9216.0020.0004.1F244][*0357.0020.001F.1F244] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-70B9
1F246     ; [*0356.0020.0004.1F246][.A0BD.0020.0004.1F246][*0357.0020.001F.1F246] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-76D7
2F00      ; [.8001.0020.0004.2F00] # KANGXI RADICAL ONE
3192      ; [.8001.0020.0014.3192] # IDEOGRAPHIC ANNOTATION ONE MARK
3280      ; [.8001.0020.0006.3280] # CIRCLED IDEOGRAPH ONE
1F229     ; [.8001.0020.001C.1F229] # SQUARED CJK UNIFIED IDEOGRAPH-4E00
319C      ; [.8018.0020.0014.319C] # IDEOGRAPHIC ANNOTATION FOURTH MARK
3286      ; [.801A.0020.0006.3286] # CIRCLED IDEOGRAPH SEVEN
3194      ; [.8054.0020.0014.3194] # IDEOGRAPHIC ANNOTATION THREE MARK
3282      ; [.8054.0020.0006.3282] # CIRCLED IDEOGRAPH THREE
1F22A     ; [.8054.0020.001C.1F22A] # SQUARED CJK UNIFIED IDEOGRAPH-4E09
3196      ; [.8055.0020.0014.3196] # IDEOGRAPHIC ANNOTATION TOP MARK
32A4      ; [.8055.0020.0006.32A4] # CIRCLED IDEOGRAPH HIGH
3198      ; [.8056.0020.0014.3198] # IDEOGRAPHIC ANNOTATION BOTTOM MARK
32A6      ; [.8056.0020.0006.32A6] # CIRCLED IDEOGRAPH LOW
319B      ; [.819C.0020.0014.319B] # IDEOGRAPHIC ANNOTATION THIRD MARK
2F01      ; [.8002.0020.0004.2F01] # KANGXI RADICAL LINE
3197      ; [.80C6.0020.0014.3197] # IDEOGRAPHIC ANNOTATION MIDDLE MARK
32A5      ; [.80C6.0020.0006.32A5] # CIRCLED IDEOGRAPH CENTRE
1F22D     ; [.80C6.0020.001C.1F22D] # SQUARED CJK UNIFIED IDEOGRAPH-4E2D
2F02      ; [.8003.0020.0004.2F02] # KANGXI RADICAL DOT
2F03      ; [.8004.0020.0004.2F03] # KANGXI RADICAL SLASH
2F04      ; [.8008.0020.0004.2F04] # KANGXI RADICAL SECOND
319A      ; [.8008.0020.0014.319A] # IDEOGRAPHIC ANNOTATION SECOND MARK
3288      ; [.8027.0020.0006.3288] # CIRCLED IDEOGRAPH NINE
2F05      ; [.8010.0020.0004.2F05] # KANGXI RADICAL HOOK
2F06      ; [.802A.0020.0004.2F06] # KANGXI RADICAL TWO
3193      ; [.802A.0020.0014.3193] # IDEOGRAPHIC ANNOTATION TWO MARK
3281      ; [.802A.0020.0006.3281] # CIRCLED IDEOGRAPH TWO
1F214     ; [.802A.0020.001C.1F214] # SQUARED CJK UNIFIED IDEOGRAPH-4E8C
3284      ; [.80D7.0020.0006.3284] # CIRCLED IDEOGRAPH FIVE
2F07      ; [.802B.0020.0004.2F07] # KANGXI RADICAL LID
1F218     ; [.8300.0020.001C.1F218] # SQUARED CJK UNIFIED IDEOGRAPH-4EA4
2F08      ; [.802C.0020.0004.2F08] # KANGXI RADICAL MAN
319F      ; [.802C.0020.0014.319F] # IDEOGRAPHIC ANNOTATION MAN MARK
32AD      ; [.831C.0020.0006.32AD] # CIRCLED IDEOGRAPH ENTERPRISE
32A1      ; [.832C.0020.0006.32A1] # CIRCLED IDEOGRAPH REST
329D      ; [.C86C.0020.0006.329D] # CIRCLED IDEOGRAPH EXCELLENT
2F09      ; [.802E.0020.0004.2F09] # KANGXI RADICAL LEGS
2F0A      ; [.802F.0020.0004.2F0A] # KANGXI RADICAL ENTER
2F0B      ; [.8030.0020.0004.2F0B] # KANGXI RADICAL EIGHT
3287      ; [.8030.0020.0006.3287] # CIRCLED IDEOGRAPH EIGHT
3285      ; [.80F5.0020.0006.3285] # CIRCLED IDEOGRAPH SIX
2F0C      ; [.8032.0020.0004.2F0C] # KANGXI RADICAL DOWN BOX
1F21E     ; [.8356.0020.001C.1F21E] # SQUARED CJK UNIFIED IDEOGRAPH-518D
2F0D      ; [.8033.0020.0004.2F0D] # KANGXI RADICAL COVER
32A2      ; [.81D8.0020.0006.32A2] # CIRCLED IDEOGRAPH COPY
2F0E      ; [.8034.0020.0004.2F0E] # KANGXI RADICAL ICE
2F0F      ; [.8036.0020.0004.2F0F] # KANGXI RADICAL TABLE
2F10      ; [.8037.0020.0004.2F10] # KANGXI RADICAL OPEN BOX
2F11      ; [.8039.0020.0004.2F11] # KANGXI RADICAL KNIFE
1F220     ; [.858C.0020.001C.1F220] # SQUARED CJK UNIFIED IDEOGRAPH-521D
1F21C     ; [.8EE7.0020.001C.1F21C] # SQUARED CJK UNIFIED IDEOGRAPH-524D
1F239     ; [.A45F.0020.001C.1F239] # SQUARED CJK UNIFIED IDEOGRAPH-5272
2F12      ; [.803C.0020.0004.2F12] # KANGXI RADICAL POWER
3298      ; [.85A8.0020.0006.3298] # CIRCLED IDEOGRAPH LABOR
2F13      ; [.803D.0020.0004.2F13] # KANGXI RADICAL WRAP
2F14      ; [.803E.0020.0004.2F14] # KANGXI RADICAL SPOON
2F15      ; [.803F.0020.0004.2F15] # KANGXI RADICAL RIGHT OPEN BOX
2F16      ; [.8040.0020.0004.2F16] # KANGXI RADICAL HIDING ENCLOSURE
32A9      ; [.85B0.0020.0006.32A9] # CIRCLED IDEOGRAPH MEDICINE
2F17      ; [.8041.0020.0004.2F17] # KANGXI RADICAL TEN
3038      ; [.8041.0020.0004.3038] # HANGZHOU NUMERAL TEN
3289      ; [.8041.0020.0006.3289] # CIRCLED IDEOGRAPH TEN
3039      ; [.8059.0020.0004.3039] # HANGZHOU NUMERAL TWENTY
303A      ; [.8118.0020.0004.303A] # HANGZHOU NUMERAL THIRTY
32AF      ; [.899D.0020.0006.32AF] # CIRCLED IDEOGRAPH ALLIANCE
2F18      ; [.8043.0020.0004.2F18] # KANGXI RADICAL DIVINATION
2F19      ; [.8044.0020.0004.2F19] # KANGXI RADICAL SEAL
329E      ; [.8384.0020.0006.329E] # CIRCLED IDEOGRAPH PRINT
2F1A      ; [.8045.0020.0004.2F1A] # KANGXI RADICAL CLIFF
2F1B      ; [.8046.0020.0004.2F1B] # KANGXI RADICAL PRIVATE
2F1C      ; [.8048.0020.0004.2F1C] # KANGXI RADICAL AGAIN
1F212     ; [.8128.0020.001C.1F212] # SQUARED CJK UNIFIED IDEOGRAPH-53CC
2F1D      ; [.807F.0020.0004.2F1D] # KANGXI RADICAL MOUTH
1F251     ; [.8218.0020.0006.1F251] # CIRCLED IDEOGRAPH ACCEPT
32A8      ; [.821C.0020.0006.32A8] # CIRCLED IDEOGRAPH RIGHT
1F22E     ; [.821C.0020.001C.1F22E] # SQUARED CJK UNIFIED IDEOGRAPH-53F3
1F234     ; [.8398.0020.001C.1F234] # SQUARED CJK UNIFIED IDEOGRAPH-5408
3294      ; [.839D.0020.0006.3294] # CIRCLED IDEOGRAPH NAME
1F225     ; [.85E1.0020.001C.1F225] # SQUARED CJK UNIFIED IDEOGRAPH-5439
3244      ; [.9CC0.0020.0006.3244] # CIRCLED IDEOGRAPH QUESTION
1F23A     ; [.9CFD.0020.001C.1F23A] # SQUARED CJK UNIFIED IDEOGRAPH-55B6
2F1E      ; [.8080.0020.0004.2F1E] # KANGXI RADICAL ENCLOSURE
3195      ; [.822D.0020.0014.3195] # IDEOGRAPHIC ANNOTATION FOUR MARK
3283      ; [.822D.0020.0006.3283] # CIRCLED IDEOGRAPH FOUR
2F1F      ; [.8081.0020.0004.2F1F] # KANGXI RADICAL EARTH
328F      ; [.8081.0020.0006.328F] # CIRCLED IDEOGRAPH EARTH
319E      ; [.83B9.0020.0014.319E] # IDEOGRAPHIC ANNOTATION EARTH MARK
2F20      ; [.8082.0020.0004.2F20] # KANGXI RADICAL SCHOLAR
1F224     ; [.8649.0020.001C.1F224] # SQUARED CJK UNIFIED IDEOGRAPH-58F0
2F21      ; [.8083.0020.0004.2F21] # KANGXI RADICAL GO
2F22      ; [.8084.0020.0004.2F22] # KANGXI RADICAL GO SLOWLY
2F23      ; [.8085.0020.0004.2F23] # KANGXI RADICAL EVENING
1F215     ; [.83C8.0020.001C.1F215] # SQUARED CJK UNIFIED IDEOGRAPH-591A
32B0      ; [.8A3E.0020.0006.32B0] # CIRCLED IDEOGRAPH NIGHT
2F24      ; [.8086.0020.0004.2F24] # KANGXI RADICAL BIG
337D      ; [.8086.0020.001C.337D][.8288.0020.001F.337D] # SQUARE ERA NAME TAISYOU
319D      ; [.8130.0020.0014.319D] # IDEOGRAPHIC ANNOTATION HEAVEN MARK
1F217     ; [.8130.0020.001C.1F217] # SQUARED CJK UNIFIED IDEOGRAPH-5929
2F25      ; [.8088.0020.0004.2F25] # KANGXI RADICAL WOMAN
329B      ; [.8088.0020.0006.329B] # CIRCLED IDEOGRAPH FEMALE
2F26      ; [.8089.0020.0004.2F26] # KANGXI RADICAL CHILD
1F211     ; [.83E8.0020.001C.1F211] # SQUARED CJK UNIFIED IDEOGRAPH-5B57
32AB      ; [.8A8D.0020.0006.32AB] # CIRCLED IDEOGRAPH STUDY
2F27      ; [.808D.0020.0004.2F27] # KANGXI RADICAL ROOF
32AA      ; [.8A94.0020.0006.32AA] # CIRCLED IDEOGRAPH RELIGION
2F28      ; [.808E.0020.0004.2F28] # KANGXI RADICAL INCH
2F29      ; [.8091.0020.0004.2F29] # KANGXI RADICAL SMALL
2F2A      ; [.8092.0020.0004.2F2A] # KANGXI RADICAL LAME
2F2B      ; [.8095.0020.0004.2F2B] # KANGXI RADICAL CORPSE
2F2C      ; [.8096.0020.0004.2F2C] # KANGXI RADICAL SPROUT
2F2D      ; [.8097.0020.0004.2F2D] # KANGXI RADICAL MOUNTAIN
2F2E      ; [.8098.0020.0004.2F2E] # KANGXI RADICAL RIVER
2F2F      ; [.809B.0020.0004.2F2F] # KANGXI RADICAL WORK
32A7      ; [.8256.0020.0006.32A7] # CIRCLED IDEOGRAPH LEFT
1F22C     ; [.8256.0020.001C.1F22C] # SQUARED CJK UNIFIED IDEOGRAPH-5DE6
2F30      ; [.809C.0020.0004.2F30] # KANGXI RADICAL ONESELF
2F31      ; [.809F.0020.0004.2F31] # KANGXI RADICAL TURBAN
2F32      ; [.80A0.0020.0004.2F32] # KANGXI RADICAL DRY
337B      ; [.825F.0020.001C.337B][.8435.0020.001F.337B] # SQUARE ERA NAME HEISEI
2F33      ; [.80A2.0020.0004.2F33] # KANGXI RADICAL SHORT THREAD
3245      ; [.8260.0020.0006.3245] # CIRCLED IDEOGRAPH KINDERGARTEN
2F34      ; [.80A3.0020.0004.2F34] # KANGXI RADICAL DOTTED CLIFF
2F35      ; [.80A4.0020.0004.2F35] # KANGXI RADICAL LONG STRIDE
2F36      ; [.80A5.0020.0004.2F36] # KANGXI RADICAL TWO HANDS
2F37      ; [.80A6.0020.0004.2F37] # KANGXI RADICAL SHOOT
2F38      ; [.80A7.0020.0004.2F38] # KANGXI RADICAL BOW
2F39      ; [.80A9.0020.0004.2F39] # KANGXI RADICAL SNOUT
2F3A      ; [.80AB.0020.0004.2F3A] # KANGXI RADICAL BRISTLE
2F3B      ; [.80AC.0020.0004.2F3B] # KANGXI RADICAL STEP
1F21D     ; [.9050.0020.001C.1F21D] # SQUARED CJK UNIFIED IDEOGRAPH-5F8C
1F250     ; [.9E0E.0020.0006.1F250] # CIRCLED IDEOGRAPH ADVANTAGE
2F3C      ; [.8149.0020.0004.2F3C] # KANGXI RADICAL HEART
2F3D      ; [.814B.0020.0004.2F3D] # KANGXI RADICAL HALBERD
2F3E      ; [.814C.0020.0004.2F3E] # KANGXI RADICAL DOOR
2F3F      ; [.814F.0020.0004.2F3F] # KANGXI RADICAL HAND
1F210     ; [.814F.0020.001C.1F210] # SQUARED CJK UNIFIED IDEOGRAPH-624B
1F231     ; [.8277.0020.001C.1F231] # SQUARED CJK UNIFIED IDEOGRAPH-6253
1F227     ; [.873A.0020.001C.1F227] # SQUARED CJK UNIFIED IDEOGRAPH-6295
1F22F     ; [.90B6.0020.001C.1F22F] # SQUARED CJK UNIFIED IDEOGRAPH-6307
1F228     ; [.9724.0020.001C.1F228] # SQUARED CJK UNIFIED IDEOGRAPH-6355
2F40      ; [.8152.0020.0004.2F40] # KANGXI RADICAL BRANCH
2F41      ; [.8153.0020.0004.2F41] # KANGXI RADICAL RAP
2F42      ; [.8155.0020.0004.2F42] # KANGXI RADICAL SCRIPT
3246      ; [.8155.0020.0006.3246] # CIRCLED IDEOGRAPH SCHOOL
2F43      ; [.8156.0020.0004.2F43] # KANGXI RADICAL DIPPER
1F21B     ; [.9745.0020.001C.1F21B] # SQUARED CJK UNIFIED IDEOGRAPH-6599
2F44      ; [.8157.0020.0004.2F44] # KANGXI RADICAL AXE
1F21F     ; [.AE69.0020.001C.1F21F] # SQUARED CJK UNIFIED IDEOGRAPH-65B0
2F45      ; [.8158.0020.0004.2F45] # KANGXI RADICAL SQUARE
2F46      ; [.8159.0020.0004.2F46] # KANGXI RADICAL NOT
2F47      ; [.815C.0020.0004.2F47] # KANGXI RADICAL SUN
3290      ; [.815C.0020.0006.3290] # CIRCLED IDEOGRAPH SUN
337E      ; [.8BBF.0020.001C.337E][.8C54.0020.001F.337E] # SQUARE ERA NAME MEIZI
1F219     ; [.90F3.0020.001C.1F219] # SQUARED CJK UNIFIED IDEOGRAPH-6620
337C      ; [.9100.0020.001C.337C][.89E5.0020.001F.337C] # SQUARE ERA NAME SYOUWA
2F48      ; [.815D.0020.0004.2F48] # KANGXI RADICAL SAY
2F49      ; [.815F.0020.0004.2F49] # KANGXI RADICAL MOON
328A      ; [.815F.0020.0006.328A] # CIRCLED IDEOGRAPH MOON
1F237     ; [.815F.0020.001C.1F237] # SQUARED CJK UNIFIED IDEOGRAPH-6708
3292      ; [.845A.0020.0006.3292] # CIRCLED IDEOGRAPH HAVE
1F236     ; [.845A.0020.001C.1F236] # SQUARED CJK UNIFIED IDEOGRAPH-6709
2F4A      ; [.8160.0020.0004.2F4A] # KANGXI RADICAL TREE
328D      ; [.8160.0020.0006.328D] # CIRCLED IDEOGRAPH WOOD
3291      ; [.979F.0020.0006.3291] # CIRCLED IDEOGRAPH STOCK
337F      ; [.979F.0020.001C.337F][.841D.0020.001F.337F][.8335.0020.001F.337F][.8D2E.0020.001F.337F] # SQUARE CORPORATION
2F4B      ; [.8163.0020.0004.2F4B] # KANGXI RADICAL LACK
2F4C      ; [.8164.0020.0004.2F4C] # KANGXI RADICAL STOP
32A3      ; [.8288.0020.0006.32A3] # CIRCLED IDEOGRAPH CORRECT
2F4D      ; [.8165.0020.0004.2F4D] # KANGXI RADICAL DEATH
2F4E      ; [.8166.0020.0004.2F4E] # KANGXI RADICAL WEAPON
2F4F      ; [.8167.0020.0004.2F4F] # KANGXI RADICAL DO NOT
2E9F      ; [.828A.0020.0004.2E9F] # CJK RADICAL MOTHER
2F50      ; [.8169.0020.0004.2F50] # KANGXI RADICAL COMPARE
2F51      ; [.816A.0020.0004.2F51] # KANGXI RADICAL FUR
2F52      ; [.816B.0020.0004.2F52] # KANGXI RADICAL CLAN
2F53      ; [.816C.0020.0004.2F53] # KANGXI RADICAL STEAM
2F54      ; [.816D.0020.0004.2F54] # KANGXI RADICAL WATER
328C      ; [.816D.0020.0006.328C] # CIRCLED IDEOGRAPH WATER
329F      ; [.8C7F.0020.0006.329F] # CIRCLED IDEOGRAPH ATTENTION
1F235     ; [.A7C6.0020.001C.1F235] # SQUARED CJK UNIFIED IDEOGRAPH-6E80
1F226     ; [.B6D2.0020.001C.1F226] # SQUARED CJK UNIFIED IDEOGRAPH-6F14
2F55      ; [.816E.0020.0004.2F55] # KANGXI RADICAL FIRE
328B      ; [.816E.0020.0006.328B] # CIRCLED IDEOGRAPH FIRE
1F21A     ; [.A7EB.0020.001C.1F21A] # SQUARED CJK UNIFIED IDEOGRAPH-7121
2F56      ; [.8171.0020.0004.2F56] # KANGXI RADICAL CLAW
2F57      ; [.8173.0020.0004.2F57] # KANGXI RADICAL FATHER
2F58      ; [.8174.0020.0004.2F58] # KANGXI RADICAL DOUBLE X
2F59      ; [.8176.0020.0004.2F59] # KANGXI RADICAL HALF TREE TRUNK
2F5A      ; [.8177.0020.0004.2F5A] # KANGXI RADICAL SLICE
2F5B      ; [.8179.0020.0004.2F5B] # KANGXI RADICAL FANG
2F5C      ; [.817B.0020.0004.2F5C] # KANGXI RADICAL COW
3295      ; [.9895.0020.0006.3295] # CIRCLED IDEOGRAPH SPECIAL
2F5D      ; [.817D.0020.0004.2F5D] # KANGXI RADICAL DOG
2F5E      ; [.82A2.0020.0004.2F5E] # KANGXI RADICAL PROFOUND
2F5F      ; [.82A3.0020.0004.2F5F] # KANGXI RADICAL JADE
2F60      ; [.82A7.0020.0004.2F60] # KANGXI RADICAL MELON
2F61      ; [.82A8.0020.0004.2F61] # KANGXI RADICAL TILE
2F62      ; [.82A9.0020.0004.2F62] # KANGXI RADICAL SWEET
2F63      ; [.82AA.0020.0004.2F63] # KANGXI RADICAL LIFE
1F222     ; [.82AA.0020.001C.1F222] # SQUARED CJK UNIFIED IDEOGRAPH-751F
2F64      ; [.82AB.0020.0004.2F64] # KANGXI RADICAL USE
2F65      ; [.82AD.0020.0004.2F65] # KANGXI RADICAL FIELD
3199      ; [.82AF.0020.0014.3199] # IDEOGRAPHIC ANNOTATION FIRST MARK
1F238     ; [.82B0.0020.001C.1F238] # SQUARED CJK UNIFIED IDEOGRAPH-7533
329A      ; [.8815.0020.0006.329A] # CIRCLED IDEOGRAPH MALE
2F66      ; [.82B4.0020.0004.2F66] # KANGXI RADICAL BOLT OF CLOTH
2F67      ; [.82B6.0020.0004.2F67] # KANGXI RADICAL SICKNESS
2F68      ; [.82B7.0020.0004.2F68] # KANGXI RADICAL DOTTED TENT
2F69      ; [.82B8.0020.0004.2F69] # KANGXI RADICAL WHITE
2F6A      ; [.82B9.0020.0004.2F6A] # KANGXI RADICAL SKIN
2F6B      ; [.82BA.0020.0004.2F6B] # KANGXI RADICAL DISH
32AC      ; [.B79A.0020.0006.32AC] # CIRCLED IDEOGRAPH SUPERVISE
2F6C      ; [.82BB.0020.0004.2F6C] # KANGXI RADICAL EYE
2F6D      ; [.82BC.0020.0004.2F6D] # KANGXI RADICAL SPEAR
2F6E      ; [.82BD.0020.0004.2F6E] # KANGXI RADICAL ARROW
2F6F      ; [.82BE.0020.0004.2F6F] # KANGXI RADICAL STONE
2F70      ; [.82C0.0020.0004.2F70] # KANGXI RADICAL SPIRIT
3293      ; [.8D2E.0020.0006.3293] # CIRCLED IDEOGRAPH SOCIETY
3297      ; [.9970.0020.0006.3297] # CIRCLED IDEOGRAPH CONGRATULATION
1F232     ; [.B0A6.0020.001C.1F232] # SQUARED CJK UNIFIED IDEOGRAPH-7981
2F71      ; [.82C1.0020.0004.2F71] # KANGXI RADICAL TRACK
2F72      ; [.82C2.0020.0004.2F72] # KANGXI RADICAL GRAIN
3299      ; [.9977.0020.0006.3299] # CIRCLED IDEOGRAPH SECRET
2F73      ; [.82C3.0020.0004.2F73] # KANGXI RADICAL CAVE
1F233     ; [.8D3E.0020.001C.1F233] # SQUARED CJK UNIFIED IDEOGRAPH-7A7A
2F74      ; [.82C4.0020.0004.2F74] # KANGXI RADICAL STAND
2F75      ; [.84B5.0020.0004.2F75] # KANGXI RADICAL BAMBOO
3247      ; [.B822.0020.0006.3247] # CIRCLED IDEOGRAPH KOTO
2F76      ; [.84B6.0020.0004.2F76] # KANGXI RADICAL RICE
2F77      ; [.84B7.0020.0004.2F77] # KANGXI RADICAL SILK
1F221     ; [.A172.0020.001C.1F221] # SQUARED CJK UNIFIED IDEOGRAPH-7D42
2F78      ; [.84C4.0020.0004.2F78] # KANGXI RADICAL JAR
2F79      ; [.84C5.0020.0004.2F79] # KANGXI RADICAL NET
2F7A      ; [.84C7.0020.0004.2F7A] # KANGXI RADICAL SHEEP
2F7B      ; [.84CA.0020.0004.2F7B] # KANGXI RADICAL FEATHER
2F7C      ; [.84CB.0020.0004.2F7C] # KANGXI RADICAL OLD
2F7D      ; [.84CD.0020.0004.2F7D] # KANGXI RADICAL AND
2F7E      ; [.84CE.0020.0004.2F7E] # KANGXI RADICAL PLOW
2F7F      ; [.84CF.0020.0004.2F7F] # KANGXI RADICAL EAR
2F80      ; [.84D0.0020.0004.2F80] # KANGXI RADICAL BRUSH
2F81      ; [.84D2.0020.0004.2F81] # KANGXI RADICAL MEAT
2F82      ; [.84D7.0020.0004.2F82] # KANGXI RADICAL MINISTER
2F83      ; [.84D8.0020.0004.2F83] # KANGXI RADICAL SELF
2F84      ; [.84D9.0020.0004.2F84] # KANGXI RADICAL ARRIVE
2F85      ; [.84DA.0020.0004.2F85] # KANGXI RADICAL MORTAR
2F86      ; [.84DC.0020.0004.2F86] # KANGXI RADICAL TONGUE
2F87      ; [.84DD.0020.0004.2F87] # KANGXI RADICAL OPPOSE
2F88      ; [.84DE.0020.0004.2F88] # KANGXI RADICAL BOAT
2F89      ; [.84DF.0020.0004.2F89] # KANGXI RADICAL STOPPING
2F8A      ; [.84E0.0020.0004.2F8A] # KANGXI RADICAL COLOR
2F8B      ; [.84E1.0020.0004.2F8B] # KANGXI RADICAL GRASS
2F8C      ; [.84EA.0020.0004.2F8C] # KANGXI RADICAL TIGER
2F8D      ; [.84EB.0020.0004.2F8D] # KANGXI RADICAL INSECT
2F8E      ; [.84EC.0020.0004.2F8E] # KANGXI RADICAL BLOOD
2F8F      ; [.84ED.0020.0004.2F8F] # KANGXI RADICAL WALK ENCLOSURE
2F90      ; [.84EE.0020.0004.2F90] # KANGXI RADICAL CLOTHES
2F91      ; [.84EF.0020.0004.2F91] # KANGXI RADICAL WEST
2F92      ; [.8878.0020.0004.2F92] # KANGXI RADICAL SEE
2F93      ; [.887B.0020.0004.2F93] # KANGXI RADICAL HORN
1F216     ; [.B258.0020.001C.1F216] # SQUARED CJK UNIFIED IDEOGRAPH-89E3
2F94      ; [.887D.0020.0004.2F94] # KANGXI RADICAL SPEECH
2F95      ; [.8891.0020.0004.2F95] # KANGXI RADICAL VALLEY
2F96      ; [.8892.0020.0004.2F96] # KANGXI RADICAL BEAN
2F97      ; [.8893.0020.0004.2F97] # KANGXI RADICAL PIG
2F98      ; [.8894.0020.0004.2F98] # KANGXI RADICAL BADGER
2F99      ; [.8895.0020.0004.2F99] # KANGXI RADICAL SHELL
3296      ; [.9B3B.0020.0006.3296] # CIRCLED IDEOGRAPH FINANCIAL
1F223     ; [.A2FD.0020.001C.1F223] # SQUARED CJK UNIFIED IDEOGRAPH-8CA9
32AE      ; [.B2A5.0020.0006.32AE] # CIRCLED IDEOGRAPH RESOURCE
2F9A      ; [.8898.0020.0004.2F9A] # KANGXI RADICAL RED
2F9B      ; [.8899.0020.0004.2F9B] # KANGXI RADICAL RUN
1F230     ; [.8899.0020.001C.1F230] # SQUARED CJK UNIFIED IDEOGRAPH-8D70
2F9C      ; [.889B.0020.0004.2F9C] # KANGXI RADICAL FOOT
2F9D      ; [.889C.0020.0004.2F9D] # KANGXI RADICAL BODY
2F9E      ; [.889D.0020.0004.2F9E] # KANGXI RADICAL CART
2F9F      ; [.88A1.0020.0004.2F9F] # KANGXI RADICAL BITTER
2FA0      ; [.88A2.0020.0004.2FA0] # KANGXI RADICAL MORNING
2FA1      ; [.88A3.0020.0004.2FA1] # KANGXI RADICAL WALK
1F22B     ; [.B30B.0020.001C.1F22B] # SQUARED CJK UNIFIED IDEOGRAPH-904A
329C      ; [.C10A.0020.0006.329C] # CIRCLED IDEOGRAPH SUITABLE
2FA2      ; [.88B4.0020.0004.2FA2] # KANGXI RADICAL CITY
2FA3      ; [.88C5.0020.0004.2FA3] # KANGXI RADICAL WINE
2FA4      ; [.88C6.0020.0004.2FA4] # KANGXI RADICAL DISTINGUISH
2FA5      ; [.88C7.0020.0004.2FA5] # KANGXI RADICAL VILLAGE
2FA6      ; [.8E33.0020.0004.2FA6] # KANGXI RADICAL GOLD
328E      ; [.8E33.0020.0006.328E] # CIRCLED IDEOGRAPH METAL
2FA7      ; [.8E40.0020.0004.2FA7] # KANGXI RADICAL LONG
2FA8      ; [.8E42.0020.0004.2FA8] # KANGXI RADICAL GATE
2FA9      ; [.8E45.0020.0004.2FA9] # KANGXI RADICAL MOUND
2FAA      ; [.8E59.0020.0004.2FAA] # KANGXI RADICAL SLAVE
2FAB      ; [.8E5A.0020.0004.2FAB] # KANGXI RADICAL SHORT TAILED BIRD
2FAC      ; [.8E5C.0020.0004.2FAC] # KANGXI RADICAL RAIN
2FAD      ; [.8E5D.0020.0004.2FAD] # KANGXI RADICAL BLUE
2FAE      ; [.8E5F.0020.0004.2FAE] # KANGXI RADICAL WRONG
2FAF      ; [.949C.0020.0004.2FAF] # KANGXI RADICAL FACE
2FB0      ; [.949D.0020.0004.2FB0] # KANGXI RADICAL LEATHER
2FB1      ; [.949E.0020.0004.2FB1] # KANGXI RADICAL TANNED LEATHER
2FB2      ; [.94A0.0020.0004.2FB2] # KANGXI RADICAL LEEK
2FB3      ; [.94A1.0020.0004.2FB3] # KANGXI RADICAL SOUND
2FB4      ; [.94A2.0020.0004.2FB4] # KANGXI RADICAL LEAF
32A0      ; [.AC44.0020.0006.32A0] # CIRCLED IDEOGRAPH ITEM
2FB5      ; [.94A7.0020.0004.2FB5] # KANGXI RADICAL WIND
2FB6      ; [.94AB.0020.0004.2FB6] # KANGXI RADICAL FLY
2FB7      ; [.94AD.0020.0004.2FB7] # KANGXI RADICAL EAT
2FB8      ; [.94B7.0020.0004.2FB8] # KANGXI RADICAL HEAD
2FB9      ; [.94B9.0020.0004.2FB9] # KANGXI RADICAL FRAGRANT
2FBA      ; [.9BF9.0020.0004.2FBA] # KANGXI RADICAL HORSE
2FBB      ; [.9C00.0020.0004.2FBB] # KANGXI RADICAL BONE
2FBC      ; [.9C01.0020.0004.2FBC] # KANGXI RADICAL TALL
2FBD      ; [.9C02.0020.0004.2FBD] # KANGXI RADICAL HAIR
2FBE      ; [.9C03.0020.0004.2FBE] # KANGXI RADICAL FIGHT
2FBF      ; [.9C04.0020.0004.2FBF] # KANGXI RADICAL SACRIFICIAL WINE
2FC0      ; [.9C05.0020.0004.2FC0] # KANGXI RADICAL CAULDRON
2FC1      ; [.9C06.0020.0004.2FC1] # KANGXI RADICAL GHOST
2FC2      ; [.A408.0020.0004.2FC2] # KANGXI RADICAL FISH
2FC3      ; [.A40A.0020.0004.2FC3] # KANGXI RADICAL BIRD
2FC4      ; [.A414.0020.0004.2FC4] # KANGXI RADICAL SALT
2FC5      ; [.A415.0020.0004.2FC5] # KANGXI RADICAL DEER
2FC6      ; [.A416.0020.0004.2FC6] # KANGXI RADICAL WHEAT
2FC7      ; [.A418.0020.0004.2FC7] # KANGXI RADICAL HEMP
2FC8      ; [.AC78.0020.0004.2FC8] # KANGXI RADICAL YELLOW
2FC9      ; [.AC7A.0020.0004.2FC9] # KANGXI RADICAL MILLET
2FCA      ; [.AC7B.0020.0004.2FCA] # KANGXI RADICAL BLACK
2FCB      ; [.AC7C.0020.0004.2FCB] # KANGXI RADICAL EMBROIDERY
2FCC      ; [.B440.0020.0004.2FCC] # KANGXI RADICAL FROG
2FCD      ; [.B442.0020.0004.2FCD] # KANGXI RADICAL TRIPOD
2FCE      ; [.B443.0020.0004.2FCE] # KANGXI RADICAL DRUM
2FCF      ; [.B445.0020.0004.2FCF] # KANGXI RADICAL RAT
2FD0      ; [.BB56.0020.0004.2FD0] # KANGXI RADICAL NOSE
2FD1      ; [.BB57.0020.0004.2FD1] # KANGXI RADICAL EVEN
2FD2      ; [.C273.0020.0004.2FD2] # KANGXI RADICAL TOOTH
2FD3      ; [.C85E.0020.0004.2FD3] # KANGXI RADICAL DRAGON
2FD4      ; [.C85F.0020.0004.2FD4] # KANGXI RADICAL TURTLE
2EF3      ; [.88F9.0020.0004.2EF3] # CJK RADICAL C-SIMPLIFIED TURTLE
2FD5      ; [.CD3C.0020.0004.2FD5] # KANGXI RADICAL FLUTE
ENTRY
};
