/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.Serializable;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class JMSAppender
extends AppenderSkeleton {
    TopicConnection topicConnection;
    TopicSession topicSession;
    TopicPublisher topicPublisher;
    String topicBindingName;
    String tcfBindingName;
    boolean locationInfo;

    public void setTopicConnectionFactoryBindingName(String string) {
        this.tcfBindingName = string;
    }

    public String getTopicConnectionFactoryBindingName() {
        return this.tcfBindingName;
    }

    public void setTopicBindingName(String string) {
        this.topicBindingName = string;
    }

    public String getTopicBindingName() {
        return this.topicBindingName;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void activateOptions() {
        try {
            InitialContext initialContext = new InitialContext();
            TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)this.lookup(initialContext, this.tcfBindingName);
            this.topicConnection = topicConnectionFactory.createTopicConnection();
            this.topicConnection.start();
            this.topicSession = this.topicConnection.createTopicSession(false, 1);
            Topic topic = (Topic)this.lookup(initialContext, this.topicBindingName);
            this.topicPublisher = this.topicSession.createPublisher(topic);
            initialContext.close();
        }
        catch (Exception exception) {
            this.errorHandler.error("Error while activating options for appender named [" + this.name + "].", exception, 0);
        }
    }

    protected Object lookup(Context context, String string) throws NamingException {
        try {
            return context.lookup(string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            LogLog.error("Could not find name [" + string + "].");
            throw nameNotFoundException;
        }
    }

    protected boolean checkEntryConditions() {
        String string = null;
        if (this.topicConnection == null) {
            string = "No TopicConnection";
        } else if (this.topicSession == null) {
            string = "No TopicSession";
        } else if (this.topicPublisher == null) {
            string = "No TopicPublisher";
        }
        if (string != null) {
            this.errorHandler.error(string + " for JMSAppender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        LogLog.debug("Closing appender [" + this.name + "].");
        this.closed = true;
        try {
            if (this.topicSession != null) {
                this.topicSession.close();
            }
            if (this.topicConnection != null) {
                this.topicConnection.close();
            }
        }
        catch (Exception exception) {
            LogLog.error("Error while closing JMSAppender [" + this.name + "].", exception);
        }
        this.topicPublisher = null;
        this.topicSession = null;
        this.topicConnection = null;
    }

    public void append(LoggingEvent loggingEvent) {
        if (!this.checkEntryConditions()) {
            return;
        }
        try {
            ObjectMessage objectMessage = this.topicSession.createObjectMessage();
            if (this.locationInfo) {
                loggingEvent.getLocationInformation();
            }
            objectMessage.setObject((Serializable)loggingEvent);
            this.topicPublisher.publish((Message)objectMessage);
        }
        catch (Exception exception) {
            this.errorHandler.error("Could not publish message in JMSAppender [" + this.name + "].", exception, 0);
        }
    }

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    public boolean requiresLayout() {
        return false;
    }
}

