#
#  This file is part of Task::WebDyne::Plack.
#
#  This software is copyright (c) 2026 by Andrew Speer <andrew.speer@isolutions.com.au>.
#
#  This is free software; you can redistribute it and/or modify it under
#  the same terms as the Perl 5 programming language system itself.
#
#  Full license text is available at:
#
#  <http://dev.perl.org/licenses/>
#

#
#
package Task::WebDyne::Plack;


#  Pragma
#
use strict qw(vars);
use vars qw($VERSION $VERSION_GIT_REF);
use warnings;


#  Version information in a format suitable for CPAN etc. Must be
#  all on one line
#
$VERSION='0.002';
$VERSION_GIT_REF='0abc78a';


#  All done, init finished
#
1;
#===================================================================================================


# Documentation in Markdown. Convert to POD using markpod from 
#
# https://github.com/aspeer/pl-markpod.git 

=begin markdown

# NAME

Task::WebDyne::Plack - Optional Plack integration for WebDyne

# SYNOPSIS

module synopsis
```bash
#  Using CPAN
#
cpan Task::WebDyne::Plack


#  Using CPANMinus
#
cpanm Task::WebDyne::Plack
```

# DESCRIPTION

Task::WebDyne::Plack install WebDyne and Plack (including Starman) modules

# AUTHOR

Andrew Speer andrew.speer@isolutions.com.au

# LICENSE and COPYRIGHT

This file is part of Task::WebDyne::Plack.

This software is copyright (c) 2026 by Andrew Speer <andrew.speer@isolutions.com.au>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

Full license text is available at:

<http://dev.perl.org/licenses/>


=end markdown

