/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.graph2.Measurer;
import net.sourceforge.plantuml.graph2.SortedListImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RectanglesCollection
implements Iterable<Rectangle2D.Double> {
    private final List<Rectangle2D.Double> areas = new ArrayList<Rectangle2D.Double>();
    private final SortedListImpl<Rectangle2D.Double> sortedX1 = new SortedListImpl<Rectangle2D.Double>(new Measurer<Rectangle2D.Double>(){

        @Override
        public int getMeasure(Rectangle2D.Double double_) {
            return (int)double_.x;
        }
    });
    private final SortedListImpl<Rectangle2D.Double> sortedX2 = new SortedListImpl<Rectangle2D.Double>(new Measurer<Rectangle2D.Double>(){

        @Override
        public int getMeasure(Rectangle2D.Double double_) {
            return (int)(double_.x + double_.width);
        }
    });
    private final SortedListImpl<Rectangle2D.Double> sortedY1 = new SortedListImpl<Rectangle2D.Double>(new Measurer<Rectangle2D.Double>(){

        @Override
        public int getMeasure(Rectangle2D.Double double_) {
            return (int)double_.y;
        }
    });
    private final SortedListImpl<Rectangle2D.Double> sortedY2 = new SortedListImpl<Rectangle2D.Double>(new Measurer<Rectangle2D.Double>(){

        @Override
        public int getMeasure(Rectangle2D.Double double_) {
            return (int)(double_.y + double_.height);
        }
    });
    private Rectangle2D.Double max = null;
    private static long TPS1;
    private static long TPS2;

    public RectanglesCollection() {
    }

    public RectanglesCollection(Rectangle2D.Double double_) {
        this();
        this.add(double_);
    }

    public double getSurf() {
        if (this.max == null) {
            return 0.0;
        }
        return this.max.getWidth() * this.max.getHeight();
    }

    public void add(Rectangle2D.Double double_) {
        this.areas.add(double_);
        this.max = this.max == null ? double_ : (Rectangle2D.Double)this.max.createUnion(double_);
    }

    @Override
    public Iterator<Rectangle2D.Double> iterator() {
        return this.areas.iterator();
    }

    public boolean intersect(RectanglesCollection rectanglesCollection) {
        if (this.size() > rectanglesCollection.size()) {
            return RectanglesCollection.intersectSeveral(this, rectanglesCollection);
        }
        return RectanglesCollection.intersectSeveral(rectanglesCollection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean intersectSeveral(RectanglesCollection rectanglesCollection, RectanglesCollection rectanglesCollection2) {
        boolean bl;
        long l;
        block5: {
            boolean bl2;
            block4: {
                assert (rectanglesCollection.size() >= rectanglesCollection2.size());
                l = System.currentTimeMillis();
                try {
                    for (Rectangle2D.Double double_ : rectanglesCollection2) {
                        if (!rectanglesCollection.intersectSimple(double_)) continue;
                        bl2 = true;
                        Object var8_7 = null;
                        break block4;
                    }
                    bl = false;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    TPS2 += System.currentTimeMillis() - l;
                    throw throwable;
                }
            }
            TPS2 += System.currentTimeMillis() - l;
            return bl2;
        }
        Object var8_8 = null;
        TPS2 += System.currentTimeMillis() - l;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean intersectSimple(Rectangle2D.Double double_) {
        boolean bl;
        long l;
        block6: {
            boolean bl2;
            block5: {
                boolean bl3;
                block4: {
                    l = System.currentTimeMillis();
                    try {
                        if (this.max == null || !this.max.intersects(double_)) {
                            bl3 = false;
                            Object var8_6 = null;
                            break block4;
                        }
                        for (Rectangle2D.Double double_2 : this.areas) {
                            if (!double_.intersects(double_2)) continue;
                            bl2 = true;
                            break block5;
                        }
                        bl = false;
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        TPS1 += System.currentTimeMillis() - l;
                        throw throwable;
                    }
                }
                TPS1 += System.currentTimeMillis() - l;
                return bl3;
            }
            Object var8_7 = null;
            TPS1 += System.currentTimeMillis() - l;
            return bl2;
        }
        Object var8_8 = null;
        TPS1 += System.currentTimeMillis() - l;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean intersectSimpleOld(Rectangle2D.Double double_) {
        boolean bl;
        long l;
        block17: {
            boolean bl2;
            block16: {
                boolean bl3;
                block15: {
                    boolean bl4;
                    block14: {
                        boolean bl5;
                        block13: {
                            boolean bl6;
                            block12: {
                                boolean bl7;
                                block11: {
                                    l = System.currentTimeMillis();
                                    try {
                                        List<Rectangle2D.Double> list;
                                        List<Rectangle2D.Double> list2;
                                        List<Rectangle2D.Double> list3;
                                        if (this.max == null || !this.max.intersects(double_)) {
                                            bl7 = false;
                                            Object var13_5 = null;
                                            break block11;
                                        }
                                        List<Rectangle2D.Double> list4 = list3 = this.sortedX1.lesserOrEquals((int)(double_.x + double_.width));
                                        if (list3.size() == 0) {
                                            bl6 = false;
                                            break block12;
                                        }
                                        List<Rectangle2D.Double> list5 = this.sortedX2.biggerOrEquals((int)double_.x);
                                        if (list5.size() == 0) {
                                            bl5 = false;
                                            break block13;
                                        }
                                        if (list5.size() < list4.size()) {
                                            list4 = list5;
                                        }
                                        if ((list2 = this.sortedY1.lesserOrEquals((int)(double_.y + double_.height))).size() == 0) {
                                            bl4 = false;
                                            break block14;
                                        }
                                        if (list2.size() < list4.size()) {
                                            list4 = list2;
                                        }
                                        if ((list = this.sortedY2.biggerOrEquals((int)double_.y)).size() == 0) {
                                            bl3 = false;
                                            break block15;
                                        }
                                        if (list.size() < list4.size()) {
                                            list4 = list;
                                        }
                                        for (Rectangle2D.Double double_2 : list4) {
                                            if (!double_.intersects(double_2)) continue;
                                            bl2 = true;
                                            break block16;
                                        }
                                        bl = false;
                                        break block17;
                                    }
                                    catch (Throwable throwable) {
                                        Object var13_12 = null;
                                        TPS1 += System.currentTimeMillis() - l;
                                        throw throwable;
                                    }
                                }
                                TPS1 += System.currentTimeMillis() - l;
                                return bl7;
                            }
                            Object var13_6 = null;
                            TPS1 += System.currentTimeMillis() - l;
                            return bl6;
                        }
                        Object var13_7 = null;
                        TPS1 += System.currentTimeMillis() - l;
                        return bl5;
                    }
                    Object var13_8 = null;
                    TPS1 += System.currentTimeMillis() - l;
                    return bl4;
                }
                Object var13_9 = null;
                TPS1 += System.currentTimeMillis() - l;
                return bl3;
            }
            Object var13_10 = null;
            TPS1 += System.currentTimeMillis() - l;
            return bl2;
        }
        Object var13_11 = null;
        TPS1 += System.currentTimeMillis() - l;
        return bl;
    }

    public int size() {
        return this.areas.size();
    }

    public void addAll(RectanglesCollection rectanglesCollection) {
        for (Rectangle2D.Double double_ : rectanglesCollection.areas) {
            this.add(double_);
        }
    }
}

