# This Makefile.PL for Log-Any-Adapter-MacOS-OSLog was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

use version 0.77;
use FFI::Build::MM;
die "This module can only be built on macOS (darwin)\n"
  if $^O ne 'darwin';
my $macos = `sw_vers -productVersion`;
chomp $macos;
die "This module requires macOS 10.12 Sierra or newer\n"
  if version->parse($macos) < version->parse('10.12');
my $fbmm = FFI::Build::MM->new();
my %fbmm_args = $fbmm->mm_args(
  DISTNAME     => 'Log-Any-Adapter-MacOS-OSLog',
  NAME         => 'Log::Any::Adapter::MacOS::OSLog',
  VERSION_FROM => 'lib/Log/Any/Adapter/MacOS/OSLog.pm',
);
$fbmm_args{CCFLAGS} .= ' -mmacosx-version-min=10.12';

my %WriteMakefileArgs = (
  "ABSTRACT" => "log to macOS' unified logging system",
  "AUTHOR" => "Mark Gardner <mjgardner\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "FFI::Build::MM" => "0.96",
    "version" => "0.77"
  },
  "DISTNAME" => "Log-Any-Adapter-MacOS-OSLog",
  "EXE_FILES" => [
    "bin/maclog"
  ],
  "LICENSE" => "perl",
  "NAME" => "Log::Any::Adapter::MacOS::OSLog",
  "PREREQ_PM" => {
    "Carp" => 0,
    "FFI::Platypus" => "2.00",
    "File::Basename" => 0,
    "File::Spec::Functions" => 0,
    "Getopt::Long" => 0,
    "Log::Any::Adapter" => 0,
    "Log::Any::Adapter::Base" => 0,
    "Log::Any::Adapter::Util" => 0,
    "Pod::Usage" => 0,
    "namespace::autoclean" => 0,
    "parent" => 0,
    "strict" => 0,
    "version" => "0.77",
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "English" => 0,
    "File::Spec" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Log::Any" => 0,
    "Log::Any::Test" => 0,
    "Test2::V0" => 0,
    "Test::More" => 0,
    "Test::Script" => "1.05"
  },
  "VERSION" => "0.0.6",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    %fbmm_args,
);

my %FallbackPrereqs = (
  "Carp" => 0,
  "English" => 0,
  "FFI::Platypus" => "2.00",
  "File::Basename" => 0,
  "File::Spec" => 0,
  "File::Spec::Functions" => 0,
  "Getopt::Long" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "Log::Any" => 0,
  "Log::Any::Adapter" => 0,
  "Log::Any::Adapter::Base" => 0,
  "Log::Any::Adapter::Util" => 0,
  "Log::Any::Test" => 0,
  "Pod::Usage" => 0,
  "Test2::V0" => 0,
  "Test::More" => 0,
  "Test::Script" => "1.05",
  "namespace::autoclean" => 0,
  "parent" => 0,
  "strict" => 0,
  "version" => "0.77",
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

sub MY::postamble { $fbmm->mm_postamble }
