#!/usr/local/ls6/bin/perl
#                              -*- Mode: Perl -*- 
# Regel.pm -- 
# ITIID           : $ITI$ $Header $__Header$
# Author          : Ulrich Pfeifer
# Created On      : Thu Feb  1 09:10:48 1996
# Last Modified By: Ulrich Pfeifer
# Last Modified On: Tue Feb  6 17:52:16 1996
# Language        : Perl
# Update Count    : 68
# Status          : Unknown, Use with caution!
# 
# (C) Copyright 1996, Universitt Dortmund, all rights reserved.
# 
# $Locker: pfeifer $
# $Log: Regel.pm,v $
# Revision 1.1  1996/02/01 15:17:04  pfeifer
# Initial revision
#
# 

package Text::German::Regel;
use Text::German::Util;

@REGEL = ();                    # -w
while (<DATA>) {
    chomp;
    my ($regel, $a,$b,$c,$d,$e,@f) = split(/:/, $_);
    next unless $regel;
    push(@{$REGEL[$regel]}, [$a,
                             $b,
                             $c,
                             bit_to_int($d),
                             bit_to_int($e),
                             @f]);
}
close DATA;

sub reduce {
    my($v,$s,$e) = @_;
    #my $init = join ':', ($v,$s,$e);
    #local ($debug) = ($s eq 'Mit')?4:0;
     
    return undef if length($s.$e) < 3;
    while (length($s)<3) {
	$s .= substr($e,0,1);
	$e = substr($e,1);
    }   
    while (1) {
        my @tmp = reduce1($v,$s,$e);
        if ($#tmp) {
            my $tmp = join ':', @tmp;
            #print STDERR "$init => $tmp\n";
            return @tmp; # if $tmp  ne $init;
        }
        return @tmp if !$e;
        $s .= substr($e,0,1);
	$e = substr($e,1);
    }
}

sub reduce1 {
    my($v,$s,$e) = @_;
    my $fc;
    my $fr;
    my $did_match;

    while (1) {
	$fr = Text::German::Endung::regel($e); # || '001'; # ???
	last if defined $fr;
	last unless $e;
	$s .= substr($e,0,1);
	$e = substr($e,1);
    }
    return undef unless $fr;
    $fc = Text::German::Endung::wort_klasse($e);
    
  ruleset: 
    while (defined $REGEL[$fr]) {
	for $r (@{$REGEL[$fr]}) {
	    next unless $r->[4] | $fc; # allowed wordclasses
	    my $match = $r->[5];
	    $match =~ s/\+/[bcdfghjklmnpqrstvwxyz]/;
	    $match =~ s/\%/[aeiou\344\366\374]/;
	    #my $ns = $s.$e;
	    #$ns = substr($ns,0,length($ns)-$r->[1]);
	    #$e  = substr($e, length($e)-$r->[1]);
	    print "\tREGEL: $fr:", (join ':', @{$r}),"\t($s,$match)\n"
		if $debug > 1;
	    if ($s =~ /$match$/) {
                $did_match++;
		print "\tREGEL: $fr:", (join ':', @{$r}),"\t$s => "
		    if $debug;
		$s = (substr($s,0,length($s)-$r->[7])) if $r->[7];
                $s .= $r->[8] if $r->[8];
		print "$s\n" if $debug;
		if ($r->[6]) { # vorsilbe 'ge' kann entfallen?
		    $v =~ s/^ge//;
		}
		$fr = $r->[0];
		$fc = $r->[3]; # ???
		if ($fr ne '000') {
		    next ruleset;
		} else {
		    #$s = substr($s,0,length($s)-$r->[1]);
		    last;
		}
	    }
	}
	last;
    }
    if ($did_match) {
        return ($v,$s,$e);
    } else {
        return undef;
    }
}

1;

# regel
# 0 Folgeregel
# 1 # zeichen entfernen
# 2
# 3 new wc
# 4 KLASSE fuer match
# 5 MATCH
# 6 vorsilbe ge
# 7 #chars to remove
# 8 string to append
# 017:000:2:te:01001:01001:nn:1:3:ann
__DATA__
001:000:1:e:11100:00100:isch:0:0:
001:000:1:e:11100:10100:icht:0:0:
001:000:1:e:11100:10100:sch:0:0:
001:000:1:e:11100:00100:haft:0:0:
001:000:1:e:11100:00100:lich:0:0:
001:000:1:e:11100:00100:voll:0:0:
001:000:1:e:11100:10100:wert:0:0:
001:000:1:e:11100:10000:bold:0:0:
001:000:1:e:11100:10000:ling:0:0:
001:000:1:e:11100:10000:rich:0:0:
001:000:1:e:11100:10000:werk:0:0:
001:000:1:e:11100:00100:reich:0:0:
001:000:1:e:11100:10100:ond:0:0:e
001:000:1:e:11100:10000:iss:0:1:
001:000:1:e:11100:00100:abl:0:2:bel
001:000:1:e:11100:00100:ant:0:0:
001:000:1:e:11100:00100:ell:0:0:
001:000:1:e:11100:00100:ent:0:0:
001:000:1:e:11100:00100:esk:0:0:
001:000:1:e:11100:00100:ibl:0:2:bel
001:000:1:e:11100:10100:ff:0:0:
001:000:1:e:11100:00100:los:0:0:
001:000:1:e:11100:00100:sam:0:0:
001:000:1:e:11100:10100:sal:0:0:
001:000:1:e:11100:01000:ifizier:0:0:en
001:000:1:e:11100:01000:isier:0:0:en
001:000:1:e:11100:10100:weis:0:0:e
001:000:1:e:11100:10000:zeug:0:0:
001:000:1:e:11100:10100:r:0:0:
001:000:1:e:11100:10100:oid:0:0:
001:000:1:e:11100:00100:s:0:0:
001:000:1:e:11100:10000:l:0:3:al
001:000:1:e:11100:10000:eur:0:0:
001:000:1:e:11100:10000:ier:0:0:
001:000:1:e:11100:10100:ad:0:0:e
001:000:1:e:11100:10100:od:0:0:e
001:000:1:e:11100:10100:ud:0:0:e
001:000:1:e:11100:10100:ed:0:0:
001:000:1:e:11100:10100:id:0:0:
001:000:1:e:11100:10100:ig:0:0:
001:000:1:e:11100:10100:al:0:0:
001:000:1:e:11100:10100:er:0:0:
001:000:1:e:11100:00100:ig:0:0:
001:000:1:e:11100:00100:iv:0:0:
001:000:1:e:11100:00100:os:0:0:
001:000:1:e:11100:10000:an:0:0:
001:000:1:e:11100:10100:ar:0:0:
001:000:1:e:11100:10000:at:0:0:
001:000:1:e:11100:10100:%b:0:0:e
001:000:1:e:11100:10100:c:0:0:e
001:000:1:e:11100:10000:ng:0:3:ang
001:000:1:e:11100:10100:g:0:0:e
001:000:1:e:11100:10100:f:0:0:e
001:000:1:e:11100:00100:frei:0:0:
001:000:1:e:11100:10100:i:0:0:e
001:000:1:e:11100:10000:ys:0:0:e
001:000:1:e:11100:10000:stnd:0:3:and
001:000:1:e:11100:10000::0:0:e
002:010:2:en:11101:00100:isch:0:0:
002:010:2:en:11101:10100:icht:0:0:
002:010:2:en:11101:10100:schaft:0:0:
002:010:2:en:11101:00100:haft:0:0:
002:010:2:en:11101:00100:lich:0:0:
002:010:2:en:11101:00100:voll:0:0:
002:010:2:en:11101:10100:wert:0:0:
002:010:2:en:11101:10000:bold:0:0:
002:010:2:en:11101:10000:ling:0:0:
002:010:2:en:11101:10000:niss:0:1:
002:010:2:en:11101:10000:rich:0:0:
002:010:2:en:11101:10000:werk:0:0:
002:010:2:en:11101:00100:reich:0:0:
002:010:2:en:11101:10000:ism:0:0:us
002:010:2:en:11101:00100:abl:0:2:bel
002:010:2:en:11101:10100:ant:0:0:
002:010:2:en:11101:00100:ell:0:0:
002:010:2:en:11101:00100:ent:0:0:
002:010:2:en:11101:00100:esk:0:0:
002:010:2:en:11101:00100:ibl:0:2:bel
002:010:2:en:11101:10000:anz:0:0:
002:010:2:en:11101:10000:enz:0:0:
002:010:2:en:11101:10000:inn:0:1:
002:010:2:en:11101:10000:ist:0:0:
002:010:2:en:11101:10000:ung:0:0:
002:010:2:en:11101:10100:amm:0:0:
002:010:2:en:11101:10100:rn:0:0:
002:010:2:en:11101:10100:mp:0:0:e
002:010:2:en:11101:10100:tr:0:0:um
002:010:2:en:11101:10100:los:0:0:
002:010:2:en:11101:00100:sam:0:0:
002:010:2:en:11101:10100:sal:0:0:
002:010:2:en:11101:10000:hem:0:0:a
002:010:2:en:11101:01000:ifizier:0:0:en
002:010:2:en:11101:01000:isier:0:0:en
002:010:2:en:11101:10000:itt:0:0:
002:010:2:en:11101:10000:heit:0:0:
002:010:2:en:11101:10000:keit:0:0:
002:010:2:en:11101:10000:zeug:0:0:
002:010:2:en:11101:10100:oid:0:0:
002:010:2:en:11101:00100:s:0:0:
002:010:2:en:11101:10100:r:0:0:
002:010:2:en:11101:10000:l:0:3:al
002:010:2:en:11101:10100:eur:0:0:
002:010:2:en:11101:10100:eus:0:0:e
002:010:2:en:11101:10000:ier:0:0:
002:010:2:en:11101:01000:ier:0:0:en
002:010:2:en:11101:10000:ion:0:0:
002:010:2:en:11101:11100:eid:0:0:en
002:010:2:en:11101:11100:iem:0:0:en
002:010:2:en:11101:10100:al:0:0:
002:010:2:en:11101:10100:er:0:0:
002:010:2:en:11101:00100:ig:0:0:
002:010:2:en:11101:00100:iv:0:0:
002:010:2:en:11101:00100:os:0:0:
002:010:2:en:11101:10100:ad:0:0:e
002:010:2:en:11101:10100:an:0:0:
002:010:2:en:11101:10100:ar:0:0:
002:010:2:en:11101:10100:at:0:0:
002:010:2:en:11101:10000:ik:0:0:
002:010:2:en:11101:10000:or:0:0:
002:010:2:en:11101:10100:id:0:0:
002:010:2:en:11101:10100:od:0:0:e
002:010:2:en:11101:10100:ud:0:0:e
002:010:2:en:11101:10100:em:0:0:
002:010:2:en:11101:10100:op:0:0:
002:010:2:en:11101:10100:ur:0:0:
002:010:2:en:11101:10000:radi:0:0:us
002:010:2:en:11101:10000:di:0:0:um
002:010:2:en:11101:00100:frei:0:0:
002:010:2:en:11101:10000:ei:0:0:
002:010:2:en:11101:10100:i:0:0:e
002:010:2:en:11101:10100:e:0:0:e
002:010:2:en:11101:10000:ys:0:0:e
002:010:2:en:11101:10000:wes:0:0:en
002:010:2:en:11101:10000:Wes:0:0:en
002:010:2:en:11101:10000:orm:0:0:
002:010:2:en:11101:10000:ng:0:3:ang
003:011:3:end:00010:00010::0:0:en
004:000:2:em:00100:00100:isch:0:0:
004:000:2:em:00100:00100:haft:0:0:
004:000:2:em:00100:00100:lich:0:0:
004:000:2:em:00100:00100:voll:0:0:
004:000:2:em:00100:00100:wert:0:0:
004:000:2:em:00100:00100:reich:0:0:
004:000:2:em:00100:00100:abl:0:2:bel
004:000:2:em:00100:00100:ant:0:0:
004:000:2:em:00100:00100:ell:0:0:
004:000:2:em:00100:00100:ent:0:0:
004:000:2:em:00100:00100:esk:0:0:
004:000:2:em:00100:00100:ibl:0:2:bel
004:000:2:em:00100:00100:los:0:0:
004:000:2:em:00100:00100:sam:0:0:
004:000:2:em:00100:00100:r:0:0:
004:000:2:em:00100:00100:oid:0:0:
004:000:2:em:00100:00100:s:0:0:
004:000:2:em:00100:00100:al:0:0:
004:000:2:em:00100:00100:ar:0:0:
004:000:2:em:00100:00100:er:0:0:
004:000:2:em:00100:00100:ig:0:0:
004:000:2:em:00100:00100:iv:0:0:
004:000:2:em:00100:00100:os:0:0:
004:000:2:em:00100:00100:frei:0:0:
005:000:2:er:10100:00100:isch:0:0:
005:000:2:er:10100:00100:haft:0:0:
005:000:2:er:10100:00100:lich:0:0:
005:000:2:er:10100:00100:voll:0:0:
005:000:2:er:10100:00100:wert:0:0:
005:000:2:er:10100:00100:reich:0:0:
005:000:2:er:10100:00100:abl:0:2:bel
005:000:2:er:10100:00100:ant:0:0:
005:000:2:er:10100:00100:ell:0:0:
005:000:2:er:10100:00100:ent:0:0:
005:000:2:er:10100:00100:esk:0:0:
005:000:2:er:10100:00100:ibl:0:2:bel
005:000:2:er:10100:00100:los:0:0:
005:000:2:er:10100:00100:sam:0:0:
005:000:2:er:10100:00100:r:0:0:
005:000:2:er:10100:00100:oid:0:0:
005:000:2:er:10100:00100:s:0:0:
005:000:2:er:10100:00100:al:0:0:
005:000:2:er:10100:00100:ar:0:0:
005:000:2:er:10100:00100:ig:0:0:
005:000:2:er:10100:00100:iv:0:0:
005:000:2:er:00100:00100:os:0:0:
005:000:2:er:00100:00100:frei:0:0:
005:000:2:er:00100:10000:ust:0:0:er
006:010:3:ern:10000:10000::0:0:
007:012:2:es:10100:10100:niss:0:1:
007:012:2:es:10100:10100:abl:0:2:bel
007:012:2:es:10100:10100:ibl:0:2:bel
007:012:2:es:10100:10100:cod:0:0:es
007:012:2:es:10100:10100:mod:0:0:es
007:012:2:es:10100:10100:iz:0:2:ex
007:012:2:es:10100:10100:ei:0:0:
007:012:2:es:10100:10100:i:0:0:es
007:012:2:es:10100:10100::0:0:
008:013:3:est:00100:00100:cht:0:0:en
008:013:3:est:00100:00100:haft:0:0:
008:013:3:est:00100:00100:wert:0:0:
008:013:3:est:00100:00100:ant:0:0:
008:013:3:est:00100:00100:ent:0:0:
008:013:3:est:00100:00100:los:0:0:
008:013:3:est:00100:00100:oid:0:0:
008:013:3:est:00100:00100:s:0:0:
008:013:3:est:00100:00100:os:0:0:
008:013:3:est:00100:00100:n:0:0:en
008:013:3:est:00100:00100:frei:0:0:
009:014:2:et:00001:00001:cht:1:0:en
009:014:2:et:00001:00001:magn:0:0:et
009:014:2:et:00001:00001:n:1:0:en
009:014:2:et:00001:00001:eit:1:0:en
010:000:1:n:11000:10000:enser:0:0:
010:000:1:n:11000:10000:aner:0:0:
010:000:1:n:11000:10000:iker:0:0:
010:000:1:n:11000:10000:iner:0:0:
010:000:1:n:11000:10000:ler:0:0:
010:000:1:n:11000:10000:ner:0:0:
010:000:1:n:11000:10000:el:0:0:
010:000:1:n:11000:10000:er:0:0:
010:000:1:n:11000:01000:el:0:0:n
010:000:1:n:11000:01000:er:0:0:n
010:000:1:n:11000:10000:io:0:0:n
010:000:1:n:11000:10000::0:0:

011:000:2:nd:00010:00010::0:0:nd
012:000:1:s:10000:10000:wach:0:0:s
012:000:1:s:10000:10000:llap:0:0:s
012:000:1:s:10000:10000:pul:0:0:s
012:000:1:s:10000:10000:seit:0:0:s
012:000:1:s:10000:10000:s:0:0:s
012:000:1:s:10000:10000:gla:0:0:s
012:000:1:s:10000:10000:ga:0:0:s
012:000:1:s:10000:10000:lo:0:0:s
012:000:1:s:10000:10000::0:0:s
012:000:1:s:10000:10000:au:0:0:
012:000:1:s:10000:10000:i:0:0:s
012:000:1:s:10000:10000:u:0:0:s
012:000:1:s:10000:10000::0:0:
013:014:2:st:01000:01000:isch:0:0:
013:014:2:st:01000:01000:lich:0:0:
013:014:2:st:01000:01000:voll:0:0:
013:014:2:st:01000:01000:reich:0:0:
013:014:2:st:01000:01000:ell:0:0:
013:014:2:st:01000:01000:esk:0:0:
013:014:2:st:01000:01000:abel:0:0:
013:014:2:st:01000:01000:ibel:0:0:
013:014:2:st:01000:01000:sam:0:0:
013:014:2:st:01000:01000:r:0:0:
013:014:2:st:01000:01000:ier:0:0:en
013:014:2:st:01000:01000:al:0:0:
013:014:2:st:01000:01000:er:0:0:
013:014:2:st:01000:01000:ig:0:0:
013:014:2:st:01000:01000:iv:0:0:
013:014:2:st:01000:01000:el:0:0:en
013:014:2:st:01000:01000:er:0:0:en
014:000:1:t:01001:01001:haf:0:0:t
014:000:1:t:01001:01001:wer:0:0:t
014:000:1:t:01001:01001:ier:1:0:en
014:000:1:t:01001:01001:en:0:0:t
014:000:1:t:01001:01001:an:0:0:t
014:000:1:t:01001:01001:er:1:0:n
014:000:1:t:01001:01001:el:1:0:n
014:000:1:t:01001:01001:ig:1:0:en
014:000:1:t:01001:01001:t:0:0:t
014:000:1:t:01001:01001:%:0:0:t
014:000:1:t:01001:01001::1:0:en
015:008:4:test:01000:01000:ier:0:0:en
015:008:4:test:01000:01000:er:0:0:n
015:008:4:test:01000:01000:el:0:0:n
015:008:4:test:01000:01000:ig:0:0:en
015:008:4:test:01000:01000:s:0:0:en
015:008:4:test:01000:01000:+me:0:0:n
015:008:4:test:01000:01000:+ne:0:0:n
015:008:4:test:01000:01000:te:0:0:n
015:008:4:test:01000:01000:de:0:0:n
016:009:3:tet:01000:01000:ier:0:0:en
016:009:3:tet:01000:01000:er:0:0:n
016:009:3:tet:01000:01000:el:0:0:n
016:009:3:tet:01000:01000:ig:0:0:en
016:009:3:tet:01000:01000:s:0:0:en
016:009:3:tet:01000:01000:+me:0:0:n
016:009:3:tet:01000:01000:+ne:0:0:n
016:009:3:tet:01000:01000:te:0:0:n
016:009:3:tet:01000:01000:de:0:0:n
017:001:2:te:01001:01001:ier:1:0:en
017:001:2:te:01001:01001:er:1:0:n
017:001:2:te:01001:01001:el:1:0:n
017:001:2:te:01001:01001:ig:1:0:en
018:002:3:ten:01001:01001:ier:1:0:en
018:002:3:ten:01001:01001:%er:1:0:en
018:002:3:ten:01001:01001:er:1:0:n
018:002:3:ten:01001:01001:el:1:0:n
018:002:3:ten:01001:01001:%g:1:0:en
018:002:3:ten:01001:01001:ei:0:0:ten
018:002:3:ten:01001:01001:i:1:0:t
019:004:3:tem:00001:00001:wer:0:0:t
019:004:3:tem:00001:00001:haf:0:0:t
019:004:3:tem:00001:00001:en:0:0:t
019:004:3:tem:00001:00001:an:0:0:t
019:004:3:tem:00001:00001::1:0:en
020:005:3:ter:00001:00001::1:0:en
021:007:3:tes:00001:00001::1:0:en
022:092:4:tere:00001:00001::1:0:en
023:093:5:teren:00001:00001::1:0:en
024:094:5:terem:00001:00001::1:0:en
025:095:5:terer:00001:00001::1:0:en
026:096:5:teres:00001:00001::1:0:en
027:097:5:teste:00001:00001::1:0:en
028:098:6:testen:00001:00001::1:0:en
029:099:6:testem:00001:00001::1:0:en
030:100:6:tester:00001:00001::1:0:en
031:101:6:testes:00001:00001::1:0:en
032:001:3:ene:00001: : : : : 
033:002:4:enen:00001: : : : : 
034:004:4:enem:00001: : : : : 
035:005:4:ener:00001: : : : : 
036:007:4:enes:00001: : : : : 
037:047:4:ende:00010:00010::0:0:end
038:048:5:enden:00010:00010::0:0:end
039:049:5:endem:00010:00010::0:0:end
040:050:5:ender:00010:00010::0:0:end
041:051:5:endes:00010:00010::0:0:en
042:017:3:ete:00001:00001:+m:1:0:en
042:017:3:ete:00001:00001:+n:1:0:en
042:017:3:ete:00001:00001:t:1:0:en
042:017:3:ete:00001:00001:d:1:0:en
043:018:4:eten:00001:00001:+m:1:0:en
043:018:4:eten:00001:00001:+n:1:0:en
043:018:4:eten:00001:00001:t:1:0:en
043:018:4:eten:00001:00001:d:1:0:en
043:018:4:eten:00001:00001:a:0:0:et
043:018:4:eten:00001:00001:i:0:0:eten
044:019:4:etem:00001:00001:+m:1:0:en
044:019:4:etem:00001:00001:+n:1:0:en
044:019:4:etem:00001:00001:t:1:0:en
044:019:4:etem:00001:00001:d:1:0:en
045:020:4:eter:00001:00001:+m:1:0:en
045:020:4:eter:00001:00001:+n:1:0:en
045:020:4:eter:00001:00001:t:1:0:en
045:020:4:eter:00001:00001:d:1:0:en
046:021:4:etes:00001:00001:+m:1:0:en
046:021:4:etes:00001:00001:+n:1:0:en
046:021:4:etes:00001:00001:t:1:0:en
046:021:4:etes:00001:00001:d:1:0:en
047:001:3:nde:00010:00010:r:0:0:nd
047:001:3:nde:00010:00010:l:0:0:nd
048:002:4:nden:00010:00010:r:0:0:nd
048:002:4:nden:00010:00010:l:0:0:nd
049:004:4:ndem:00010:00010:r:0:0:nd
049:004:4:ndem:00010:00010:l:0:0:nd
050:005:4:nder:00010:00010:r:0:0:nd
050:005:4:nder:00010:00010:l:0:0:nd
051:007:4:ndes:00010:00010:r:0:0:nd
051:007:4:ndes:00010:00010:l:0:0:nd
052:092:5:enere:00001: : : : : 
053:093:6:eneren:00001: : : : : 
054:094:6:enerem:00001: : : : : 
055:095:6:enerer:00001: : : : : 
056:096:6:eneres:00001: : : : : 
057:067:6:endere:00010:00010::0:0:end
058:068:7:enderen:00010:00010::0:0:end
059:069:7:enderem:00010:00010::0:0:end
060:070:7:enderer:00010:00010::0:0:end
061:071:7:enderes:00010:00010::0:0:end
062:022:5:etere:00001:00001:+m:1:0:en
062:022:5:etere:00001:00001:+n:1:0:en
062:022:5:etere:00001:00001:t:1:0:en
062:022:5:etere:00001:00001:d:1:0:en
063:023:6:eteren:00001:00001:+m:1:0:en
063:023:6:eteren:00001:00001:+n:1:0:en
063:023:6:eteren:00001:00001:t:1:0:en
063:023:6:eteren:00001:00001:d:1:0:en
064:024:6:eterem:00001:00001:+m:1:0:en
064:024:6:eterem:00001:00001:+n:1:0:en
064:024:6:eterem:00001:00001:t:1:0:en
064:024:6:eterem:00001:00001:d:1:0:en
065:025:6:eterer:00001:00001:+m:1:0:en
065:025:6:eterer:00001:00001:+n:1:0:en
065:025:6:eterer:00001:00001:t:1:0:en
065:025:6:eterer:00001:00001:d:1:0:en
066:026:6:eteres:00001:00001:+m:1:0:en
066:026:6:eteres:00001:00001:+n:1:0:en
066:026:6:eteres:00001:00001:t:1:0:en
066:026:6:eteres:00001:00001:d:1:0:en
067:092:5:ndere:00010:00010:r:0:0:nd
067:092:5:ndere:00010:00010:l:0:0:nd
068:093:6:nderen:00010:00010:r:0:0:nd
068:093:6:nderen:00010:00010:l:0:0:nd
069:094:6:nderem:00010:00010:r:0:0:nd
069:094:6:nderem:00010:00010:l:0:0:nd
070:095:6:nderer:00010:00010:r:0:0:nd
070:095:6:nderer:00010:00010:l:0:0:nd
071:096:6:nderes:00010:00010:r:0:0:nd
071:096:6:nderes:00010:00010:l:0:0:nd
072:102:5:enste:00001: : : : : 
073:103:6:ensten:00001: : : : : 
074:104:6:enstem:00001: : : : : 
075:105:6:enster:00001: : : : : 
076:106:6:enstes:00001: : : : : 
077:087:6:endste:00010:00010::0:0:end
078:088:7:endsten:00010:00010::0:0:end
079:079:7:endstem:00010:00010::0:0:end
080:090:7:endster:00010:00010::0:0:end
081:091:7:endstes:00010:00010::0:0:end
082:102:5:etste:00001:00001:+m:1:0:en
082:102:5:etste:00001:00001:+n:1:0:en
082:102:5:etste:00001:00001:t:1:0:en
082:102:5:etste:00001:00001:d:1:0:en
083:103:6:etsten:00001:00001:+m:1:0:en
083:103:6:etsten:00001:00001:+n:1:0:en
083:103:6:etsten:00001:00001:t:1:0:en
083:103:6:etsten:00001:00001:d:1:0:en
084:104:6:etstem:00001:00001:+m:1:0:en
084:104:6:etstem:00001:00001:+n:1:0:en
084:104:6:etstem:00001:00001:t:1:0:en
084:104:6:etstem:00001:00001:d:1:0:en
085:105:6:etster:00001:00001:+m:1:0:en
085:105:6:etster:00001:00001:+n:1:0:en
085:105:6:etster:00001:00001:t:1:0:en
085:105:6:etster:00001:00001:d:1:0:en
086:106:6:etstes:00001:00001:+m:1:0:en
086:106:6:etstes:00001:00001:+n:1:0:en
086:106:6:etstes:00001:00001:t:1:0:en
086:106:6:etstes:00001:00001:d:1:0:en
087:102:5:ndste:00010:00010:r:0:0:nd
087:102:5:ndste:00010:00010:l:0:0:nd
088:103:6:ndsten:00010:00010:r:0:0:nd
088:103:6:ndsten:00010:00010:l:0:0:nd
089:104:6:ndstem:00010:00010:r:0:0:nd
089:104:6:ndstem:00010:00010:l:0:0:nd
090:105:6:ndster:00010:00010:r:0:0:nd
090:105:6:ndster:00010:00010:l:0:0:nd
091:106:6:ndstes:00010:00010:r:0:0:nd
091:106:6:ndstes:00010:00010:l:0:0:nd
092:001:3:ere:00100:00100:e:0:0:er
092:001:3:ere:00100:00100::0:0:
093:002:4:eren:00100:00100:i:0:0:eren
093:002:4:eren:00100:00100::0:0:
094:004:4:erem:00100:00100::0:0:
095:005:4:erer:00100:00100::0:0:
096:007:4:eres:00100:00100::0:0:
097:102:4:este:00100:00100::0:0:
098:103:5:esten:00100:00100::0:0:
099:104:5:estem:00100:00100:f:0:0:est
099:104:5:estem:00100:00100::0:0:
100:005:5:ester:00100:00100::0:0:
101:106:5:estes:00100:00100::0:0:
102:017:3:ste:00100:00100::0:0:
103:018:4:sten:00100:00100::0:0:
104:019:4:stem:00100:00100:y:0:0:stem
104:019:4:stem:00100:00100::0:0:
105:020:4:ster:00100:00100::0:0:
106:021:4:stes:00100:00100::0:0:
