# Generated by default/object.tt
package Paws::Honeycode::UpsertRowsResult;
  use Moose;
  has RowIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'rowIds', traits => ['NameInRequest'], required => 1);
  has UpsertAction => (is => 'ro', isa => 'Str', request_name => 'upsertAction', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Honeycode::UpsertRowsResult

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Honeycode::UpsertRowsResult object:

  $service_obj->Method(Att1 => { RowIds => $value, ..., UpsertAction => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Honeycode::UpsertRowsResult object:

  $result = $service_obj->Method(...);
  $result->Att1->RowIds

=head1 DESCRIPTION

An object that represents the result of a single upsert row request.

=head1 ATTRIBUTES


=head2 B<REQUIRED> RowIds => ArrayRef[Str|Undef]

The list of row ids that were changed as part of an upsert row
operation. If the upsert resulted in an update, this list could
potentially contain multiple rows that matched the filter and hence got
updated. If the upsert resulted in an append, this list would only have
the single row that was appended.


=head2 B<REQUIRED> UpsertAction => Str

The result of the upsert action.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Honeycode>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

