/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.couchbase.mock.Info;
import org.couchbase.mock.memcached.Item;
import org.couchbase.mock.memcached.KeySpec;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class VBucketStore {
    private volatile long casCounter;
    private static final long THIRTY_DAYS = 2592000L;
    private final Map<KeySpec, Item> kv = new ConcurrentHashMap<KeySpec, Item>();
    public ItemAction onItemDelete;
    public ItemAction onItemMutated;

    private Item lookup(KeySpec ks) {
        Item ii = this.kv.get(ks);
        if (ii == null) {
            return null;
        }
        long now = new Date().getTime() + Info.getClockOffset() * 1000L;
        if (ii.getExpiryTime() == 0 || now < ii.getExpiryTimeInMillis()) {
            return ii;
        }
        this.onItemDelete.onAction(this, ii);
        this.kv.remove(ks);
        return null;
    }

    public ErrorCode add(Item item) {
        Item old = this.lookup(item.getKeySpec());
        if (old != null || item.getCas() != 0L) {
            return ErrorCode.KEY_EEXISTS;
        }
        item.setCas(++this.casCounter);
        this.kv.put(item.getKeySpec(), item);
        this.onItemMutated.onAction(this, item);
        return ErrorCode.SUCCESS;
    }

    public ErrorCode replace(Item item) {
        Item old = this.lookup(item.getKeySpec());
        if (old == null) {
            return ErrorCode.KEY_ENOENT;
        }
        if (item.getCas() != old.getCas() && item.getCas() != 0L) {
            return ErrorCode.KEY_EEXISTS;
        }
        if (!old.ensureUnlocked(item.getCas())) {
            return ErrorCode.KEY_EEXISTS;
        }
        item.setCas(++this.casCounter);
        this.kv.put(item.getKeySpec(), item);
        this.onItemMutated.onAction(this, item);
        return ErrorCode.SUCCESS;
    }

    public ErrorCode set(Item item) {
        if (item.getCas() == 0L) {
            Item old = this.lookup(item.getKeySpec());
            if (old != null && old.isLocked()) {
                return ErrorCode.KEY_EEXISTS;
            }
            item.setCas(++this.casCounter);
            this.kv.put(item.getKeySpec(), item);
            this.onItemMutated.onAction(this, item);
            return ErrorCode.SUCCESS;
        }
        return this.replace(item);
    }

    public ErrorCode delete(KeySpec ks, long cas) {
        Item i = this.lookup(ks);
        if (i == null) {
            return ErrorCode.KEY_ENOENT;
        }
        if (!i.ensureUnlocked(cas)) {
            return ErrorCode.ETMPFAIL;
        }
        if (cas == 0L || cas == i.getCas()) {
            this.kv.remove(ks);
            this.onItemDelete.onAction(this, i);
            return ErrorCode.SUCCESS;
        }
        return ErrorCode.KEY_EEXISTS;
    }

    private ErrorCode modifyItemValue(Item i, boolean isAppend) {
        Item old = this.lookup(i.getKeySpec());
        if (old == null) {
            return ErrorCode.KEY_ENOENT;
        }
        if (!old.ensureUnlocked(i.getCas())) {
            return ErrorCode.KEY_EEXISTS;
        }
        if (isAppend) {
            old.append(i);
        } else {
            old.prepend(i);
        }
        old.setCas(++this.casCounter);
        this.onItemMutated.onAction(this, old);
        return ErrorCode.SUCCESS;
    }

    public ErrorCode append(Item i) {
        return this.modifyItemValue(i, true);
    }

    public ErrorCode prepend(Item i) {
        return this.modifyItemValue(i, false);
    }

    public Item get(KeySpec ks) {
        return this.lookup(ks);
    }

    public Map<KeySpec, Item> getMap() {
        return this.kv;
    }

    public static int convertExpiryTime(int original) {
        if (original == 0) {
            return original;
        }
        if ((long)original > 2592000L) {
            return original + (int)Info.getClockOffset();
        }
        return (int)(new Date().getTime() / 1000L + (long)original + Info.getClockOffset());
    }

    public static interface ItemAction {
        public void onAction(VBucketStore var1, Item var2);
    }
}

