/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.views;

import java.io.IOException;
import org.couchbase.mock.util.ReaderUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;

public class Reducer {
    private final Function reduceFunc;
    private static final String REDUCE_JS;

    private Reducer(String reduceTxt, Context cx) {
        ImporterTopLevel scope = new ImporterTopLevel(cx);
        cx.evaluateString(scope, REDUCE_JS, "reduce.js", 1, null);
        Scriptable builtins = (Scriptable)scope.get("BUILTIN_REDUCERS", (Scriptable)scope);
        this.reduceFunc = builtins.has(reduceTxt, builtins) ? (Function)builtins.get(reduceTxt, builtins) : cx.compileFunction(scope, reduceTxt, "reduce", 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reducer create(String txt) {
        Context cx = Context.enter();
        try {
            Reducer reducer = new Reducer(txt, cx);
            return reducer;
        }
        finally {
            Context.exit();
        }
    }

    public Function getFunction() {
        return this.reduceFunc;
    }

    static {
        try {
            REDUCE_JS = ReaderUtils.fromResource("views/reduce.js");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

