# Generated by default/object.tt
package Paws::Kafka::Sasl;
  use Moose;
  has Iam => (is => 'ro', isa => 'Paws::Kafka::Iam', request_name => 'iam', traits => ['NameInRequest']);
  has Scram => (is => 'ro', isa => 'Paws::Kafka::Scram', request_name => 'scram', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kafka::Sasl

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kafka::Sasl object:

  $service_obj->Method(Att1 => { Iam => $value, ..., Scram => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kafka::Sasl object:

  $result = $service_obj->Method(...);
  $result->Att1->Iam

=head1 DESCRIPTION

Details for client authentication using SASL.

=head1 ATTRIBUTES


=head2 Iam => L<Paws::Kafka::Iam>

Indicates whether IAM access control is enabled.


=head2 Scram => L<Paws::Kafka::Scram>

Details for SASL/SCRAM client authentication.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kafka>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

