
package MouseX::Getopt::Meta::Attribute;
use Mouse;
use Mouse::Util::TypeConstraints;

extends 'Mouse::Meta::Attribute'; # << Mouse extending Mouse :)
   with 'MouseX::Getopt::Meta::Attribute::Trait';

no Mouse;

# register this as a metaclass alias ...
package # stop confusing PAUSE 
    Mouse::Meta::Attribute::Custom::Getopt;
sub register_implementation { 'MouseX::Getopt::Meta::Attribute' }

1;

__END__

=pod

=head1 NAME

MouseX::Getopt::Meta::Attribute - Optional meta attribute for custom option names

=head1 SYNOPSIS

  package App;
  use Mouse;
  
  with 'MouseX::Getopt';
  
  has 'data' => (
      metaclass => 'MouseX::Getopt::Meta::Attribute',     
      is        => 'ro',
      isa       => 'Str',
      default   => 'file.dat',

      # tells MouseX::Getopt to use --somedata as the 
      # command line flag instead of the normal 
      # autogenerated one (--data)
      cmd_flag  => 'somedata',

      # tells MouseX::Getopt to also allow --moosedata,
      # -m, and -d as aliases for this same option on
      # the commandline.
      cmd_aliases => [qw/ moosedata m d /],

      # Or, you can use a plain scalar for a single alias:
      cmd_aliases => 'm',
  );

=head1 DESCRIPTION

This is a custom attribute metaclass which can be used to specify a 
the specific command line flag to use instead of the default one 
which L<MouseX::Getopt> will create for you. 

This is certainly not the prettiest way to go about this, but for 
now it works for those who might need such a feature.

=head2 Custom Metaclass alias

This now takes advantage of the Mouse 0.19 feature to support 
custom attribute metaclass aliases. This means you can also
use this as the B<Getopt> alias, like so:

  has 'foo' => (metaclass => 'Getopt', cmd_flag => 'f');

=head1 METHODS

These methods are of little use to most users, they are used interally 
within L<MouseX::Getopt>.

=over 4

=item B<cmd_flag>

Changes the commandline flag to be this value, instead of the default,
which is the same as the attribute name.

=item B<cmd_aliases>

Adds more aliases for this commandline flag, useful for short options
and such.

=item B<has_cmd_flag>

=item B<has_cmd_aliases>

=item B<meta>

=back

=head1 SEE ALSO

L<MouseX::Getopt>

=cut
