use strict;
use lib qw(lib ../lib);
use Template::Test;
use Template::Plugin::TruncateByWord;

test_expect(\*DATA);


__DATA__

-- test --
[% USE TruncateByWord 'big5' -%]
[% 'abcdefg' | truncate_by_word(4) %]
-- expect --
abcd

-- test --
[% USE TruncateByWord 'big5' -%]
[% 'ڽsXX' | truncate_by_word(3) %]
-- expect --
ڽs

-- test --
[% USE TruncateByWord 'big5' -%]
[% 'asXbXcdefg' | truncate_by_word(3) %]
-- expect --
a

-- test --
[% USE TruncateByWord 'big5' -%]
[% 'asXbXcdefg' | truncate_by_word %]
-- expect --
asXbXcdefg

-- test --
[% USE TruncateByWord 'big5' -%]
[% 'asXbXcdefg' | truncate_by_word(5,'...') %]
-- expect --
asX...

-- test --
[% USE TruncateByWord 'big5' -%]
[% 'asXbXcdefg' | truncate_by_word(36,'...') %]
-- expect --
asXbXcdefg

-- test --
[% USE TruncateByWord('big5', name='my_truncate') -%]
[% 'asXbXcdefg' | my_truncate(3) %]
-- expect --
a

-- test --
[% USE TruncateByWord 'big5' name='my_truncate' -%]
[% FILTER my_truncate(5,'..') -%]
asXbXcdefg
[% END %]
-- expect --
asX..

-- test --
[% USE TruncateByWord enc='big5' name='my_truncate' -%]
[% FILTER my_truncate(5,'..') -%]
asXbXcdefg
[% END %]
-- expect --
asX..
