/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.regex;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.functions.regex.JDK15RegexTranslator;
import net.sf.saxon.functions.regex.JRegexIterator;
import net.sf.saxon.functions.regex.JTokenIterator;
import net.sf.saxon.functions.regex.RegexIterator;
import net.sf.saxon.functions.regex.RegexSyntaxException;
import net.sf.saxon.functions.regex.RegularExpression;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRegularExpression
implements RegularExpression {
    Pattern pattern;
    String javaRegex;
    int flagBits;

    public JRegularExpression(String javaRegex, int flagBits) {
        this.flagBits = flagBits;
        this.javaRegex = javaRegex;
        this.pattern = Pattern.compile(javaRegex, flagBits & 0xFFFFFFFB);
    }

    public JRegularExpression(CharSequence regex, int options, int flagBits, List<RegexSyntaxException> warnings) throws XPathException {
        if ((flagBits & 0x10) != 0 && (options & 4) == 0) {
            throw new XPathException("The 'q' flag is not allowed in this XPath/XQuery version");
        }
        this.flagBits = flagBits;
        try {
            if ((options & 8) != 0 || (flagBits & 0x10) != 0) {
                this.javaRegex = ((Object)regex).toString();
                this.pattern = Pattern.compile(this.javaRegex, flagBits);
            } else {
                this.javaRegex = JDK15RegexTranslator.translate(regex, options, flagBits, warnings);
                this.pattern = Pattern.compile(this.javaRegex, flagBits & 0xFFFFFFB9);
            }
        }
        catch (RegexSyntaxException e) {
            XPathException err = new XPathException(e.getMessage());
            err.setErrorCode("FORX0002");
            throw err;
        }
    }

    public String getJavaRegularExpression() {
        return this.javaRegex;
    }

    public int getFlagBits() {
        return this.flagBits;
    }

    @Override
    public RegexIterator analyze(CharSequence input) {
        return new JRegexIterator(((Object)input).toString(), this.pattern);
    }

    @Override
    public boolean containsMatch(CharSequence input) {
        return this.pattern.matcher(input).find();
    }

    @Override
    public boolean matches(CharSequence input) {
        return this.pattern.matcher(input).matches();
    }

    @Override
    public CharSequence replace(CharSequence input, CharSequence replacement) throws XPathException {
        Matcher matcher = this.pattern.matcher(input);
        try {
            return matcher.replaceAll(((Object)replacement).toString());
        }
        catch (IndexOutOfBoundsException e) {
            int gps = matcher.groupCount();
            if (gps >= 9) {
                throw e;
            }
            String r = ((Object)replacement).toString();
            String f = "\\$[" + (gps + 1) + "-9]";
            String rep = Pattern.compile(f).matcher(r).replaceAll("");
            return matcher.replaceAll(rep);
        }
    }

    @Override
    public SequenceIterator tokenize(CharSequence input) {
        if (input.length() == 0) {
            return EmptyIterator.getInstance();
        }
        return new JTokenIterator(input, this.pattern);
    }

    public static int setFlags(CharSequence inFlags) throws XPathException {
        int flags = 1;
        block8: for (int i = 0; i < inFlags.length(); ++i) {
            char c = inFlags.charAt(i);
            switch (c) {
                case 'm': {
                    flags |= 8;
                    continue block8;
                }
                case 'i': {
                    flags |= 2;
                    flags |= 0x40;
                    continue block8;
                }
                case 's': {
                    flags |= 0x20;
                    continue block8;
                }
                case 'x': {
                    flags |= 4;
                    continue block8;
                }
                case 'q': {
                    flags |= 0x10;
                    continue block8;
                }
                case '!': {
                    continue block8;
                }
                default: {
                    XPathException err = new XPathException("Invalid character '" + c + "' in regular expression flags");
                    err.setErrorCode("FORX0001");
                    throw err;
                }
            }
        }
        return flags;
    }

    public static void main(String[] args) {
        System.err.println(System.getProperty("java.version"));
        Pattern p = Pattern.compile("([aA])(?:\\1)", 1);
        System.err.println("Find: " + p.matcher("aA").find());
    }
}

