#!/usr/bin/env perl
#-*-perl-*-
#
#

## make this a module
package ISO::639::5;

# use 5.006;
use strict;
use warnings;

use utf8;
use open ':locale';
use Pod::Usage;
# use ISO::639::3;

=head1 NAME

ISO::639::5 - Language groups

=head1 VERSION

Version 0.05

=cut

our $VERSION      = '0.05';

use Exporter 'import';
our @EXPORT = qw(
    language_group
    language_parent
    language_group_children
    iso2glottolog
    glottolog2iso
);
our %EXPORT_TAGS = ( all => \@EXPORT );


=head1 SYNOPSIS

    use ISO::639::5 qw/:all/;

=cut

our $LanguageGroup;
our $LanguageParent;
our $ISO2Glottolog;
our $Glottolog2ISO;

$LanguageGroup = {
  'roa' => [
    'acf',
    'aoa',
    'arg',
    'ast',
    'cat',
    'cbk',
    'ccd',
    'cks',
    'cos',
    'cpf',
    'cpp',
    'cri',
    'crs',
    'dlm',
    'drc',
    'egl',
    'ext',
    'fab',
    'fax',
    'fra',
    'frc',
    'frm',
    'fro',
    'frp',
    'fur',
    'gcf',
    'gcr',
    'glg',
    'hat',
    'idb',
    'ist',
    'ita',
    'itk',
    'kea',
    'kmv',
    'lad',
    'lij',
    'lld',
    'lmo',
    'lou',
    'mcm',
    'mfe',
    'mwl',
    'mxi',
    'mzs',
    'nap',
    'nrf',
    'oci',
    'osp',
    'pap',
    'pcd',
    'pln',
    'pms',
    'por',
    'pov',
    'pre',
    'pro',
    'rcf',
    'rgn',
    'roh',
    'ron',
    'ruo',
    'rup',
    'ruq',
    'scf',
    'scn',
    'sdc',
    'sdn',
    'spa',
    'spq',
    'src',
    'srd',
    'sro',
    'tmg',
    'tvy',
    'vec',
    'vkp',
    'wln'
  ],
  'bik' => [
    'agk',
    'agz',
    'atl',
    'bcl',
    'bln',
    'bto',
    'fbl',
    'lbl',
    'rbl',
    'ubl'
  ],
  'cai' => [
    'azc',
    'cba',
    'ccr',
    'chd',
    'clo',
    'cuy',
    'hok',
    'hue',
    'huv',
    'hve',
    'hvv',
    'len',
    'mco',
    'miq',
    'mir',
    'mtn',
    'mto',
    'mxp',
    'mxq',
    'myn',
    'mzl',
    'neq',
    'omq',
    'plo',
    'poi',
    'poq',
    'pos',
    'pua',
    'pxm',
    'tcw',
    'tee',
    'tku',
    'tlc',
    'tlp',
    'toc',
    'too',
    'top',
    'tos',
    'tpp',
    'tpt',
    'tqt',
    'tsz',
    'ulw',
    'xin',
    'yan',
    'zoc',
    'zoh',
    'zoq',
    'zor',
    'zos'
  ],
  'ngb' => [
    'sag'
  ],
  'ypk' => [
    'ems',
    'ess',
    'esu',
    'ynk',
    'ysr'
  ],
  'azc' => [
    'chl',
    'cok',
    'com',
    'crn',
    'cup',
    'hch',
    'hop',
    'lui',
    'mfy',
    'mnr',
    'nah',
    'ntp',
    'ood',
    'opt',
    'pao',
    'par',
    'pia',
    'ppl',
    'ser',
    'shh',
    'stp',
    'tac',
    'tar',
    'tbu',
    'tcu',
    'tep',
    'thh',
    'tla',
    'tub',
    'twr',
    'ute',
    'var',
    'xaw',
    'xgf',
    'yaq'
  ],
  'euq' => [
    'eus'
  ],
  'nah' => [
    'azd',
    'azn',
    'azz',
    'naz',
    'nch',
    'nci',
    'ncj',
    'ncl',
    'ncx',
    'ngu',
    'nhc',
    'nhe',
    'nhg',
    'nhi',
    'nhk',
    'nhm',
    'nhn',
    'nhp',
    'nhq',
    'nht',
    'nhv',
    'nhw',
    'nhx',
    'nhy',
    'nhz',
    'nlv',
    'npl',
    'nsu',
    'nuz',
    'ppl',
    'xpo'
  ],
  'sqj' => [
    'aae',
    'aat',
    'aln',
    'als'
  ],
  'myn' => [
    'acr',
    'agu',
    'caa',
    'cac',
    'cak',
    'chf',
    'cob',
    'ctu',
    'emy',
    'hus',
    'itz',
    'ixl',
    'jac',
    'kek',
    'kjb',
    'knj',
    'lac',
    'mam',
    'mhc',
    'mop',
    'poc',
    'poh',
    'quc',
    'qum',
    'quv',
    'toj',
    'ttc',
    'tzh',
    'tzj',
    'tzo',
    'usp',
    'yua'
  ],
  'gme' => [
    'got',
    'xvn'
  ],
  'son' => [
    'ddn',
    'dje',
    'dsq',
    'hmb',
    'kcy',
    'khq',
    'ses',
    'tda',
    'tst',
    'twq'
  ],
  'grk' => [
    'cpg',
    'ell',
    'gmy',
    'grc',
    'pnt',
    'tsd',
    'yej'
  ],
  'ccn' => [
    'abk',
    'abq',
    'ady',
    'agx',
    'akv',
    'ani',
    'aqc',
    'ava',
    'bbl',
    'bdk',
    'bph',
    'che',
    'cji',
    'dar',
    'ddo',
    'gdo',
    'gin',
    'huz',
    'inh',
    'kap',
    'kbd',
    'khv',
    'kjj',
    'kpt',
    'kry',
    'kva',
    'lbe',
    'lez',
    'rut',
    'tab',
    'tin',
    'tkr',
    'uby',
    'udi'
  ],
  'bnt' => [
    'abb',
    'agh',
    'akw',
    'asa',
    'auh',
    'axk',
    'baf',
    'bag',
    'bas',
    'bbg',
    'bbi',
    'bbm',
    'bcp',
    'bdp',
    'bdu',
    'beb',
    'bem',
    'beq',
    'bez',
    'bhy',
    'bip',
    'biw',
    'biz',
    'bja',
    'bkf',
    'bkh',
    'bkj',
    'bkp',
    'bkt',
    'bkw',
    'bli',
    'blv',
    'bmb',
    'bmg',
    'bml',
    'bmw',
    'bng',
    'bni',
    'bnm',
    'bnx',
    'boh',
    'bok',
    'bou',
    'boy',
    'bpj',
    'bqm',
    'bqu',
    'bqz',
    'brf',
    'bri',
    'brl',
    'bsi',
    'bss',
    'btb',
    'btc',
    'buf',
    'bui',
    'bum',
    'buu',
    'buw',
    'bvb',
    'bvg',
    'bvx',
    'bwc',
    'bwg',
    'bwl',
    'bws',
    'bwt',
    'bww',
    'bwz',
    'bxc',
    'bxg',
    'bxk',
    'bxp',
    'byi',
    'bzm',
    'bzo',
    'cce',
    'ccl',
    'cgg',
    'chw',
    'cjk',
    'coh',
    'cuh',
    'cwa',
    'cwb',
    'cwe',
    'dav',
    'dde',
    'dez',
    'dhm',
    'dhs',
    'dig',
    'dii',
    'diu',
    'diz',
    'dma',
    'dmx',
    'dne',
    'doe',
    'dov',
    'dua',
    'dug',
    'dzn',
    'ebo',
    'ebu',
    'ekm',
    'eko',
    'eto',
    'ewo',
    'fan',
    'fip',
    'flr',
    'fwe',
    'gev',
    'gey',
    'gmx',
    'gog',
    'guz',
    'gwe',
    'gwr',
    'gyi',
    'han',
    'haq',
    'hav',
    'hay',
    'hba',
    'heh',
    'hem',
    'her',
    'hij',
    'hka',
    'hke',
    'hol',
    'hom',
    'hoo',
    'hum',
    'ida',
    'ifm',
    'ikz',
    'ilb',
    'isn',
    'iyx',
    'jgb',
    'jit',
    'jmc',
    'job',
    'kam',
    'kbj',
    'kbs',
    'kck',
    'kcu',
    'kcv',
    'kcw',
    'kcz',
    'kdc',
    'kde',
    'kdg',
    'kdn',
    'keb',
    'ked',
    'khu',
    'khx',
    'khy',
    'kik',
    'kin',
    'kiv',
    'kiz',
    'kki',
    'kkj',
    'kkq',
    'kkw',
    'kmb',
    'kme',
    'kmw',
    'kng',
    'kny',
    'koh',
    'kon',
    'koo',
    'koq',
    'kqn',
    'ksb',
    'ksf',
    'ksv',
    'ktf',
    'ktu',
    'kty',
    'kua',
    'kuj',
    'kwc',
    'kwm',
    'kwn',
    'kws',
    'kwu',
    'kwy',
    'kxx',
    'kya',
    'kzn',
    'kzo',
    'kzy',
    'lag',
    'lai',
    'lam',
    'lch',
    'ldi',
    'lea',
    'leb',
    'leh',
    'lej',
    'lel',
    'lem',
    'leo',
    'lfa',
    'lgm',
    'lgz',
    'lie',
    'lik',
    'lin',
    'liz',
    'lkb',
    'lke',
    'lko',
    'lks',
    'llb',
    'lli',
    'lnb',
    'lol',
    'lon',
    'loo',
    'loq',
    'loz',
    'lri',
    'lrm',
    'lse',
    'lsm',
    'lto',
    'lts',
    'lua',
    'lub',
    'lue',
    'lug',
    'luj',
    'lum',
    'lun',
    'lup',
    'luy',
    'lwa',
    'lwg',
    'lyn',
    'mbm',
    'mbo',
    'mck',
    'mcp',
    'mcx',
    'mdn',
    'mdp',
    'mdq',
    'mdt',
    'mdu',
    'mdw',
    'mer',
    'mfu',
    'mgg',
    'mgh',
    'mgq',
    'mgr',
    'mgs',
    'mgv',
    'mgw',
    'mgy',
    'mgz',
    'mhb',
    'mhm',
    'mho',
    'mhw',
    'mjh',
    'mkk',
    'mkw',
    'mlb',
    'mlk',
    'mmu',
    'mmz',
    'mny',
    'mow',
    'mpa',
    'mvw',
    'mwe',
    'mwn',
    'mws',
    'mwz',
    'mxc',
    'mxg',
    'mxo',
    'myc',
    'mye',
    'myx',
    'mzd',
    'nba',
    'nbd',
    'nbl',
    'nda',
    'ndc',
    'nde',
    'ndg',
    'ndh',
    'ndj',
    'ndk',
    'ndl',
    'ndn',
    'ndo',
    'ndq',
    'ndw',
    'ngc',
    'ngd',
    'ngl',
    'ngo',
    'ngp',
    'ngq',
    'ngy',
    'ngz',
    'nih',
    'nim',
    'nix',
    'njx',
    'njy',
    'nka',
    'nkc',
    'nkn',
    'nkt',
    'nkv',
    'nkw',
    'nle',
    'nlj',
    'nlo',
    'nmd',
    'nmg',
    'nmq',
    'nnb',
    'nne',
    'nnq',
    'noq',
    'now',
    'nql',
    'nra',
    'nse',
    'nso',
    'nsx',
    'nte',
    'ntk',
    'nto',
    'nui',
    'nuj',
    'nvo',
    'nxd',
    'nxi',
    'nxo',
    'nya',
    'nyc',
    'nyd',
    'nye',
    'nyf',
    'nyg',
    'nyj',
    'nyk',
    'nym',
    'nyn',
    'nyo',
    'nyr',
    'nyu',
    'nyy',
    'nzb',
    'nzd',
    'old',
    'olu',
    'oml',
    'ozm',
    'pae',
    'pbr',
    'pem',
    'phm',
    'pic',
    'piw',
    'pkb',
    'pmm',
    'pof',
    'poy',
    'puu',
    'rag',
    'reg',
    'rim',
    'rnd',
    'rng',
    'rnw',
    'rof',
    'rub',
    'ruc',
    'ruf',
    'run',
    'rwk',
    'rwm',
    'sak',
    'sbk',
    'sbm',
    'sbp',
    'sbs',
    'sbw',
    'sby',
    'sdj',
    'seg',
    'seh',
    'sgm',
    'shc',
    'shq',
    'shr',
    'sie',
    'skt',
    'slx',
    'smd',
    'smx',
    'sna',
    'sng',
    'snq',
    'soc',
    'sod',
    'soe',
    'soo',
    'sop',
    'sot',
    'sox',
    'soz',
    'ssc',
    'ssw',
    'sub',
    'suj',
    'suk',
    'suw',
    'swa',
    'swb',
    'swc',
    'swh',
    'swj',
    'swk',
    'sxb',
    'sxe',
    'syi',
    'syx',
    'szg',
    'szv',
    'tap',
    'tbt',
    'tck',
    'teg',
    'tek',
    'tga',
    'thk',
    'tii',
    'tke',
    'tlj',
    'tll',
    'tmv',
    'tny',
    'tog',
    'toh',
    'toi',
    'tsa',
    'tsc',
    'tsn',
    'tso',
    'tsv',
    'ttf',
    'ttj',
    'ttl',
    'tum',
    'tvs',
    'tvu',
    'twl',
    'two',
    'twx',
    'tyi',
    'tyx',
    'ukh',
    'umb',
    'vau',
    'ven',
    'vid',
    'vif',
    'vin',
    'vmk',
    'vmr',
    'vmw',
    'vum',
    'vun',
    'wbh',
    'wbi',
    'wdd',
    'wlc',
    'wmw',
    'wni',
    'won',
    'wum',
    'wun',
    'xdo',
    'xho',
    'xku',
    'xkv',
    'xma',
    'xmc',
    'xog',
    'xsq',
    'yaf',
    'yao',
    'yas',
    'yat',
    'yav',
    'yel',
    'yey',
    'yko',
    'ymk',
    'yns',
    'yom',
    'zaj',
    'zak',
    'zdj',
    'zga',
    'zin',
    'zmb',
    'zmf',
    'zmn',
    'zmp',
    'zmq',
    'zms',
    'zmw',
    'zmx',
    'zul'
  ],
  'cba' => [
    'arh',
    'brn',
    'bzd',
    'cbg',
    'chb',
    'cjp',
    'cuk',
    'gut',
    'gym',
    'kog',
    'kvn',
    'mbp',
    'mot',
    'pay',
    'rma',
    'sab',
    'tbn',
    'tfr',
    'tnb',
    'tnd',
    'tuf'
  ],
  'afa' => [
    'ber',
    'bxe',
    'cdc',
    'cop',
    'cus',
    'egx',
    'egy',
    'omv',
    'sem',
    'zwa'
  ],
  'sit' => [
    'acn',
    'adi',
    'adl',
    'aeu',
    'ahk',
    'aim',
    'ajz',
    'anl',
    'aot',
    'aph',
    'apt',
    'atb',
    'aub',
    'aza',
    'bap',
    'bca',
    'bee',
    'bfc',
    'bfs',
    'bft',
    'bfu',
    'bgg',
    'bgr',
    'bhj',
    'biu',
    'brd',
    'bro',
    'bxd',
    'byh',
    'byo',
    'byw',
    'bzi',
    'cbl',
    'cda',
    'cdf',
    'cdm',
    'cdn',
    'cek',
    'cfm',
    'cgk',
    'chx',
    'cik',
    'ckh',
    'clk',
    'clt',
    'cmn',
    'cmr',
    'cna',
    'cnb',
    'cnc',
    'cng',
    'cnh',
    'cnk',
    'cnw',
    'csh',
    'csv',
    'csy',
    'ctd',
    'ctn',
    'cur',
    'cuw',
    'cvg',
    'czt',
    'dao',
    'der',
    'dhi',
    'dis',
    'dka',
    'dln',
    'dng',
    'drd',
    'dre',
    'drq',
    'dus',
    'dzl',
    'dzo',
    'emg',
    'enu',
    'ero',
    'ghe',
    'ghh',
    'ght',
    'gnb',
    'goe',
    'grt',
    'gvr',
    'hle',
    'hlt',
    'hmr',
    'hni',
    'how',
    'hpo',
    'hra',
    'hut',
    'iii',
    'int',
    'jda',
    'jee',
    'jih',
    'jiq',
    'jiu',
    'jiy',
    'jkr',
    'jmn',
    'jna',
    'jnl',
    'jul',
    'kac',
    'kaf',
    'kar',
    'kbg',
    'kdq',
    'kdv',
    'kfk',
    'kfw',
    'kgj',
    'kgy',
    'khg',
    'kif',
    'kip',
    'kix',
    'kjl',
    'kjz',
    'kkf',
    'kkt',
    'kle',
    'klr',
    'kmm',
    'kte',
    'ktp',
    'kzq',
    'lae',
    'lax',
    'lbf',
    'lbj',
    'lbr',
    'lep',
    'lgh',
    'lhi',
    'lhm',
    'lhp',
    'lif',
    'lis',
    'lkc',
    'lkh',
    'llh',
    'lmk',
    'loy',
    'lpn',
    'lrr',
    'lsh',
    'lsi',
    'luk',
    'lus',
    'lwm',
    'lwu',
    'lya',
    'lzh',
    'lzn',
    'mgp',
    'mhu',
    'mhx',
    'mjw',
    'mni',
    'mpz',
    'mrd',
    'mrg',
    'mrh',
    'mro',
    'muk',
    'mvm',
    'mwq',
    'mya',
    'nao',
    'nbc',
    'nbe',
    'nbi',
    'nbt',
    'nbu',
    'ncd',
    'nct',
    'neh',
    'nes',
    'new',
    'njb',
    'njh',
    'njm',
    'njn',
    'njz',
    'nkb',
    'nkd',
    'nkh',
    'nki',
    'nma',
    'nme',
    'nmf',
    'nmh',
    'nmm',
    'nmo',
    'nmy',
    'nng',
    'nnl',
    'nnp',
    'nos',
    'npa',
    'nph',
    'npo',
    'nre',
    'nri',
    'nru',
    'nsa',
    'nsd',
    'nsf',
    'nsm',
    'nst',
    'nty',
    'nuf',
    'nwc',
    'nxq',
    'nzm',
    'obr',
    'ola',
    'ole',
    'onp',
    'pck',
    'phh',
    'pho',
    'phq',
    'pkh',
    'pmi',
    'pmj',
    'pmx',
    'prx',
    'pub',
    'pum',
    'pyx',
    'pyy',
    'pzn',
    'qvy',
    'qxs',
    'raa',
    'rab',
    'raf',
    'rah',
    'ral',
    'raq',
    'rau',
    'rav',
    'raw',
    'rgk',
    'ria',
    'rji',
    'rki',
    'rmz',
    'rnl',
    'rnp',
    'ruh',
    'sbu',
    'sch',
    'scp',
    'scu',
    'sdp',
    'sez',
    'sgk',
    'sgp',
    'sgt',
    'shl',
    'sip',
    'sjl',
    'skj',
    'slt',
    'smh',
    'smt',
    'spt',
    'ssk',
    'suv',
    'suz',
    'sxg',
    'syw',
    'taj',
    'tbq',
    'tcl',
    'tcn',
    'tco',
    'tcp',
    'tcz',
    'tdg',
    'tdh',
    'tge',
    'tgf',
    'tgj',
    'thf',
    'ths',
    'tij',
    'tji',
    'tjs',
    'tpe',
    'tpq',
    'tro',
    'tsj',
    'tsk',
    'ttz',
    'tvn',
    'tvt',
    'txg',
    'txo',
    'ugo',
    'umn',
    'usi',
    'vap',
    'vay',
    'wly',
    'wme',
    'wuh',
    'xac',
    'xct',
    'xkf',
    'xkz',
    'xns',
    'xsr',
    'xzh',
    'ybh',
    'ybi',
    'ybk',
    'ych',
    'ycl',
    'ycp',
    'ygp',
    'yhl',
    'yif',
    'yig',
    'yik',
    'yim',
    'yip',
    'yiq',
    'yit',
    'yiu',
    'yiv',
    'yix',
    'yiz',
    'ykl',
    'ykn',
    'ykt',
    'yku',
    'ylm',
    'ylo',
    'ymc',
    'ymd',
    'ymh',
    'ymi',
    'ymq',
    'ymx',
    'ymz',
    'yna',
    'ypa',
    'ypb',
    'ypg',
    'yph',
    'ypm',
    'ypn',
    'ypo',
    'ypp',
    'ypz',
    'ysd',
    'ysg',
    'ysn',
    'yso',
    'ysy',
    'yta',
    'ytl',
    'ytp',
    'ywl',
    'ywq',
    'ywt',
    'ywu',
    'yyz',
    'yzk',
    'zal',
    'zau',
    'zhb',
    'zhx',
    'zkr',
    'zom',
    'zyp'
  ],
  'inc' => [
    'aee',
    'aeq',
    'anp',
    'anr',
    'asm',
    'awa',
    'bdv',
    'ben',
    'bfb',
    'bfy',
    'bfz',
    'bgc',
    'bgd',
    'bge',
    'bgq',
    'bgw',
    'bha',
    'bhb',
    'bhd',
    'bhe',
    'bhi',
    'bho',
    'bht',
    'bhu',
    'bjj',
    'bkk',
    'bmj',
    'bns',
    'bpx',
    'bpy',
    'bra',
    'btv',
    'ccp',
    'cdh',
    'cdi',
    'cdj',
    'cih',
    'clh',
    'ctg',
    'dcc',
    'dgo',
    'dhd',
    'dhn',
    'dho',
    'div',
    'dmk',
    'dml',
    'doi',
    'dry',
    'dty',
    'dub',
    'duh',
    'dwz',
    'emx',
    'gas',
    'gbk',
    'gbl',
    'gbm',
    'gda',
    'gdx',
    'ggg',
    'ghr',
    'gig',
    'gjk',
    'gju',
    'glh',
    'gom',
    'gra',
    'guj',
    'gwc',
    'gwf',
    'gwt',
    'haj',
    'hca',
    'hif',
    'hii',
    'hin',
    'hlb',
    'hnd',
    'hne',
    'hno',
    'hns',
    'hoj',
    'jat',
    'jdg',
    'jml',
    'jnd',
    'jns',
    'kas',
    'kbu',
    'keq',
    'key',
    'kfr',
    'kfs',
    'kft',
    'kfu',
    'kfv',
    'kfx',
    'kfy',
    'khn',
    'khw',
    'kjo',
    'kls',
    'knn',
    'kok',
    'kra',
    'ksy',
    'kvx',
    'kxp',
    'kyw',
    'lah',
    'lbm',
    'lhl',
    'lmn',
    'lss',
    'luv',
    'mag',
    'mai',
    'mar',
    'mby',
    'mjl',
    'mjz',
    'mkb',
    'mke',
    'mki',
    'mtr',
    'mup',
    'mve',
    'mvy',
    'mwr',
    'nag',
    'nep',
    'nhh',
    'nli',
    'nlx',
    'noe',
    'noi',
    'npi',
    'odk',
    'omr',
    'ori',
    'ort',
    'ory',
    'pan',
    'paq',
    'pcl',
    'pgg',
    'phd',
    'phl',
    'phr',
    'pli',
    'plk',
    'plp',
    'pmh',
    'pmu',
    'pnb',
    'pra',
    'psh',
    'psi',
    'psu',
    'pwr',
    'qpp',
    'raj',
    'rei',
    'rhg',
    'rjs',
    'rkt',
    'rmc',
    'rmf',
    'rmi',
    'rml',
    'rmn',
    'rmo',
    'rmq',
    'rmt',
    'rmw',
    'rmy',
    'rom',
    'rtw',
    'rwr',
    'saz',
    'sbn',
    'sck',
    'scl',
    'sdg',
    'sdr',
    'shd',
    'sin',
    'sjp',
    'skr',
    'smm',
    'smv',
    'snd',
    'soi',
    'spv',
    'srx',
    'ssi',
    'sts',
    'swv',
    'syl',
    'tdb',
    'the',
    'thl',
    'thq',
    'thr',
    'tkb',
    'tkt',
    'tnv',
    'tra',
    'trw',
    'urd',
    'ush',
    'vaa',
    'vah',
    'vas',
    'vav',
    'ved',
    'vgr',
    'wbr',
    'wry',
    'wsv',
    'wtm',
    'xhe',
    'xka',
    'xnr'
  ],
  'zls' => [
    'bos',
    'bul',
    'chu',
    'hrv',
    'kjv',
    'mkd',
    'slv',
    'srp',
    'svm'
  ],
  'kro' => [
    'ahi',
    'ahm',
    'ald',
    'bet',
    'bev',
    'bjw',
    'blh',
    'bsq',
    'btg',
    'das',
    'dee',
    'dic',
    'gbo',
    'gec',
    'ggb',
    'gie',
    'glr',
    'god',
    'grb',
    'grj',
    'grv',
    'gry',
    'gud',
    'gxx',
    'hwa',
    'klu',
    'kqo',
    'krn',
    'krw',
    'ktj',
    'kwp',
    'kyf',
    'ney',
    'nwb',
    'oub',
    'pye',
    'ted',
    'tja',
    'wec',
    'wob'
  ],
  'sdv' => [
    'ach',
    'alz',
    'anu',
    'bfa',
    'ddd',
    'din',
    'enb',
    'eyo',
    'kdj',
    'keo',
    'kln',
    'kpz',
    'lky',
    'lot',
    'lpx',
    'luo',
    'mas',
    'mqu',
    'muz',
    'niq',
    'nsg',
    'nub',
    'nus',
    'saq',
    'sgc',
    'shk',
    'tec',
    'teo',
    'toq',
    'tuv',
    'tuy'
  ],
  'sai' => [
    'aqa',
    'awd',
    'cba',
    'qwe',
    'tup'
  ],
  'ber' => [
    'auj',
    'cnu',
    'gha',
    'gho',
    'gnc',
    'grr',
    'jbe',
    'jbn',
    'kab',
    'mzb',
    'nxm',
    'oua',
    'rif',
    'sds',
    'shi',
    'shy',
    'siz',
    'sjs',
    'swn',
    'taq',
    'tez',
    'thv',
    'thz',
    'tia',
    'tjo',
    'tmh',
    'ttq',
    'tzm',
    'zen',
    'zgh'
  ],
  'egx' => [
    'egy'
  ],
  'ccs' => [
    'jge',
    'kat',
    'lzz',
    'oge',
    'sva',
    'xmf'
  ],
  'poz' => [
    'abc',
    'abd',
    'abf',
    'abp',
    'agn',
    'agt',
    'agv',
    'agy',
    'alj',
    'aol',
    'apf',
    'apg',
    'aqn',
    'atk',
    'atm',
    'atp',
    'atq',
    'att',
    'atz',
    'ayt',
    'azt',
    'bac',
    'bdb',
    'bdx',
    'bei',
    'bep',
    'bfg',
    'bfx',
    'bgb',
    'bgi',
    'bgz',
    'bhk',
    'bhp',
    'bhq',
    'bhr',
    'bhv',
    'bhz',
    'bjx',
    'bkb',
    'bkn',
    'bkr',
    'bks',
    'bku',
    'bld',
    'blj',
    'bls',
    'blw',
    'blx',
    'blz',
    'bmm',
    'bna',
    'bnb',
    'bne',
    'bnj',
    'bnu',
    'bny',
    'bpq',
    'bpr',
    'bps',
    'bqr',
    'brs',
    'bsb',
    'bsy',
    'bth',
    'btj',
    'btn',
    'btw',
    'bup',
    'bve',
    'bvk',
    'bvu',
    'bvy',
    'bya',
    'byd',
    'bzb',
    'bzc',
    'bzl',
    'cbw',
    'ccm',
    'clu',
    'cml',
    'coa',
    'cts',
    'cyo',
    'daw',
    'dgc',
    'djo',
    'dkk',
    'dkr',
    'dmg',
    'dms',
    'dmv',
    'dok',
    'dpp',
    'dro',
    'dtb',
    'dtp',
    'due',
    'dul',
    'duo',
    'duy',
    'emb',
    'end',
    'gad',
    'gdg',
    'gnq',
    'grm',
    'hji',
    'hnn',
    'hov',
    'hvn',
    'ifa',
    'ifb',
    'ifk',
    'ifu',
    'ill',
    'inn',
    'iry',
    'isd',
    'itb',
    'itd',
    'iti',
    'itt',
    'itv',
    'ity',
    'ivb',
    'ivv',
    'iwk',
    'jak',
    'jas',
    'jax',
    'jvn',
    'kag',
    'kei',
    'kgx',
    'khc',
    'kkg',
    'kkv',
    'kkx',
    'klg',
    'kli',
    'kll',
    'klw',
    'kly',
    'kmd',
    'kmk',
    'kml',
    'knb',
    'kne',
    'knl',
    'knx',
    'kqe',
    'kqt',
    'kqv',
    'ksc',
    'ksn',
    'ktr',
    'kvb',
    'kve',
    'kvh',
    'kxi',
    'kxn',
    'kyb',
    'kyn',
    'kzf',
    'kzi',
    'kzj',
    'kzp',
    'kzs',
    'kzt',
    'laa',
    'law',
    'lbk',
    'lew',
    'lgi',
    'lhn',
    'lix',
    'lje',
    'lji',
    'lkj',
    'llm',
    'llq',
    'lnd',
    'loe',
    'low',
    'lra',
    'lrt',
    'max',
    'mbf',
    'mel',
    'meo',
    'mfp',
    'mhp',
    'mkn',
    'mli',
    'mlz',
    'mmn',
    'mnb',
    'mqg',
    'mqj',
    'mqq',
    'mqx',
    'mqy',
    'mry',
    'msh',
    'msi',
    'msk',
    'mtw',
    'mvp',
    'mvv',
    'mwt',
    'mxd',
    'npy',
    'nsy',
    'ntd',
    'nxe',
    'orn',
    'ors',
    'osi',
    'pea',
    'pee',
    'pez',
    'plc',
    'ple',
    'plf',
    'plt',
    'plv',
    'plw',
    'plz',
    'pmf',
    'pmy',
    'pna',
    'pnc',
    'pne',
    'pni',
    'pnm',
    'pnp',
    'pns',
    'ppk',
    'pqe',
    'pqw',
    'prf',
    'prh',
    'psn',
    'ptt',
    'ptu',
    'pud',
    'puf',
    'puj',
    'pwm',
    'rir',
    'rob',
    'rol',
    'ruu',
    'sbl',
    'sbr',
    'sbx',
    'scg',
    'sci',
    'sdm',
    'sdo',
    'sdu',
    'sdx',
    'sfe',
    'sgb',
    'sge',
    'sib',
    'sjb',
    'skg',
    'ski',
    'skn',
    'sko',
    'skp',
    'skx',
    'slg',
    'sly',
    'smk',
    'snb',
    'sne',
    'spg',
    'sre',
    'srg',
    'srk',
    'srv',
    'stb',
    'suc',
    'swu',
    'syb',
    'tao',
    'tbk',
    'tbw',
    'tdj',
    'tdy',
    'tes',
    'tgb',
    'tgl',
    'tgn',
    'tgq',
    'tgt',
    'tih',
    'tis',
    'tiu',
    'tiy',
    'tld',
    'tln',
    'tmn',
    'tmw',
    'toy',
    'trx',
    'tsg',
    'ttg',
    'ttp',
    'ttw',
    'tvw',
    'twb',
    'txa',
    'txe',
    'txm',
    'txx',
    'ues',
    'ulm',
    'umi',
    'ums',
    'unz',
    'urk',
    'vkk',
    'vkt',
    'whk',
    'wlo',
    'wmm',
    'wtw',
    'xay',
    'xbr',
    'xdy',
    'xem',
    'xkd',
    'xke',
    'xkl',
    'xkn',
    'xks',
    'xky',
    'xmm',
    'xnn',
    'xsb',
    'xxk',
    'yog',
    'zbt',
    'zka',
    'zlm',
    'zmi',
    'zsm'
  ],
  'swa' => [
    'swc'
  ],
  'wen' => [
    'dsb',
    'hsb'
  ],
  'nic' => [
    'alv',
    'dmn',
    'eka',
    'kdo',
    'lam',
    'nqo',
    'nyo',
    'tog',
    'znd'
  ],
  'iir' => [
    'ask',
    'bih',
    'bsh',
    'inc',
    'ira',
    'prn',
    'trm',
    'wbk',
    'xvi'
  ],
  'plf' => [
    'alo',
    'amv',
    'gal',
    'hbu',
    'kje',
    'lti',
    'mhs',
    'szn',
    'tet',
    'tlv',
    'txn',
    'wha'
  ],
  'gmq' => [
    'dan',
    'fao',
    'isl',
    'jut',
    'nno',
    'nob',
    'non',
    'nrn',
    'ovd',
    'qer',
    'rmg',
    'swe'
  ],
  'paa' => [
    'aau',
    'anz',
    'ddg',
    'gak',
    'kax',
    'kmo',
    'lvk',
    'mok',
    'nas',
    'ngf',
    'pgu',
    'saj',
    'tcm',
    'tft',
    'tif',
    'tlb',
    'tqu',
    'waj',
    'wli',
    'yee',
    'zuh'
  ],
  'nai' => [
    'aql',
    'azc',
    'cdd',
    'hok',
    'iro',
    'sal',
    'sio',
    'wak',
    'xnd'
  ],
  'cpp' => [
    'aoa',
    'cri',
    'fab',
    'kea',
    'mzs',
    'pap',
    'pov',
    'pre',
    'srm',
    'xmm'
  ],
  'tut' => [
    'nog',
    'trk',
    'tuw',
    'xgn'
  ],
  'kdo' => [
    'acz',
    'dec',
    'eli',
    'fuj',
    'hbn',
    'iof',
    'jle',
    'kcp',
    'kcr',
    'kec',
    'kgo',
    'kib',
    'laf',
    'lmd',
    'mor',
    'otr',
    'ras',
    'shw',
    'tag',
    'taz',
    'tbr',
    'tey',
    'tic',
    'tlo',
    'tms',
    'tqr',
    'wrn',
    'xtc'
  ],
  'jpx' => [
    'jpn'
  ],
  'dmn' => [
    'bam',
    'bbo',
    'bib',
    'bof',
    'boo',
    'boz',
    'bqc',
    'bqp',
    'bus',
    'bwq',
    'bxl',
    'bxw',
    'bza',
    'bze',
    'bzx',
    'cpo',
    'daf',
    'dnj',
    'dnn',
    'dux',
    'dyu',
    'emk',
    'ggu',
    'gkp',
    'gnj',
    'goa',
    'jad',
    'jek',
    'jod',
    'jow',
    'jud',
    'kao',
    'kfo',
    'kga',
    'kke',
    'knk',
    'kno',
    'knu',
    'kpe',
    'lig',
    'llc',
    'lok',
    'lom',
    'man',
    'men',
    'mev',
    'mfg',
    'mku',
    'mlq',
    'mnk',
    'moa',
    'msc',
    'mwk',
    'mxx',
    'mzj',
    'neb',
    'nhb',
    'rkm',
    'sbd',
    'sho',
    'skq',
    'snk',
    'sos',
    'stj',
    'sus',
    'sym',
    'tjn',
    'tod',
    'tye',
    'vai',
    'wan',
    'xgb',
    'xkg',
    'xpe',
    'yal',
    'yre',
    'zil'
  ],
  'cpf' => [
    'acf',
    'cks',
    'crs',
    'gcf',
    'gcr',
    'hat',
    'kmv',
    'lou',
    'mfe',
    'rcf'
  ],
  'pqw' => [
    'abl',
    'abs',
    'abx',
    'ban',
    'bdg',
    'bdl',
    'bdr',
    'beg',
    'bew',
    'bjn',
    'bkz',
    'bsu',
    'btk',
    'buc',
    'bug',
    'cha',
    'cia',
    'cmc',
    'day',
    'dbj',
    'drg',
    'dtr',
    'dun',
    'dup',
    'duq',
    'duw',
    'eno',
    'gay',
    'goq',
    'iba',
    'ind',
    'jav',
    'kaw',
    'kge',
    'kjc',
    'kjk',
    'kqr',
    'ktq',
    'kvr',
    'kxd',
    'kyi',
    'kys',
    'lbw',
    'lbx',
    'lce',
    'lcf',
    'ley',
    'liw',
    'ljp',
    'llk',
    'mad',
    'mak',
    'mdr',
    'mfa',
    'mfb',
    'mhy',
    'min',
    'mkm',
    'mlg',
    'mqn',
    'msa',
    'mtd',
    'mui',
    'mwv',
    'mxr',
    'myl',
    'mzq',
    'nia',
    'nij',
    'nrm',
    'otd',
    'pau',
    'pdo',
    'pel',
    'phi',
    'pku',
    'pse',
    'raz',
    'ree',
    'rej',
    'sas',
    'sda',
    'sjm',
    'skh',
    'slm',
    'sml',
    'smr',
    'smw',
    'snv',
    'ssb',
    'sse',
    'sun',
    'sya',
    'tdi',
    'tdu',
    'tdx',
    'tjg',
    'tkg',
    'tlk',
    'twy',
    'txy',
    'ulu',
    'vkl',
    'vko',
    'wow',
    'wru',
    'xkq',
    'xmv',
    'xmw',
    'xmz',
    'yka',
    'zbc',
    'zbe',
    'zbw'
  ],
  'tbq' => [
    'adx',
    'anm',
    'bod',
    'bqh',
    'brx',
    'duu',
    'ers',
    'gqi',
    'gro',
    'jya',
    'kar',
    'lhu',
    'lpo',
    'mxj',
    'njo',
    'nun',
    'trp',
    'twm'
  ],
  'sal' => [
    'blc',
    'cea',
    'cjh',
    'clm',
    'col',
    'coo',
    'cow',
    'crd',
    'fla',
    'hur',
    'lil',
    'lut',
    'nok',
    'oka',
    'ptw',
    'qun',
    'sec',
    'shs',
    'slh',
    'spo',
    'squ',
    'str',
    'thp',
    'til',
    'twa'
  ],
  'cus' => [
    'aar',
    'aas',
    'ahg',
    'alw',
    'arv',
    'awn',
    'bds',
    'bej',
    'bji',
    'bnl',
    'bob',
    'bsw',
    'byn',
    'dal',
    'dbr',
    'dox',
    'drs',
    'dsh',
    'elo',
    'gax',
    'gaz',
    'gdl',
    'gex',
    'gow',
    'gwd',
    'hae',
    'hdy',
    'irk',
    'jii',
    'ktb',
    'kxc',
    'liq',
    'muu',
    'orc',
    'orm',
    'rel',
    'sid',
    'som',
    'ssn',
    'ssy',
    'tqq',
    'tsb',
    'wbj',
    'wka',
    'xan',
    'ymm'
  ],
  'omv' => [
    'aiw',
    'bcq',
    'bwo',
    'dim',
    'doz',
    'jnj',
    'mdx',
    'noz',
    'she',
    'wal',
    'zay'
  ],
  'esx' => [
    'ale',
    'esi',
    'esk',
    'ike',
    'ikt',
    'iku',
    'ipk',
    'kal',
    'ypk',
    'ysr'
  ],
  'znd' => [
    'brm',
    'geq',
    'nzk',
    'pmb',
    'zne'
  ],
  'sla' => [
    'zle',
    'zls',
    'zlw'
  ],
  'cel' => [
    'bre',
    'cor',
    'cym',
    'ghc',
    'gla',
    'gle',
    'glv',
    'mga',
    'nrc',
    'obt',
    'owl',
    'sga',
    'wlm',
    'xbm',
    'xcb',
    'xce',
    'xcg',
    'xga',
    'xlp',
    'xpi',
    'xtg',
    'xve'
  ],
  'zhx' => [
    'cdo',
    'cjy',
    'cpx',
    'czh',
    'czo',
    'gan',
    'hak',
    'hsn',
    'ltc',
    'mnp',
    'nan',
    'och',
    'wuu',
    'wxa',
    'yue',
    'zho'
  ],
  'tup' => [
    'cod',
    'eme',
    'grn',
    'gui',
    'guq',
    'gyr',
    'kay',
    'kgk',
    'kpn',
    'ktn',
    'kyr',
    'mpu',
    'myu',
    'nhd',
    'omg',
    'psm',
    'skf',
    'srq',
    'tpj',
    'tpn',
    'tpr',
    'tpw',
    'twt',
    'wyr',
    'yrl'
  ],
  'mul' => [
    'aav',
    'afa',
    'aqa',
    'aql',
    'art',
    'auf',
    'aus',
    'awd',
    'azc',
    'cau',
    'cba',
    'cdd',
    'dra',
    'esx',
    'euq',
    'hmx',
    'hok',
    'ine',
    'iro',
    'jpx',
    'khi',
    'map',
    'myn',
    'nic',
    'omq',
    'paa',
    'sal',
    'sgn',
    'sio',
    'sit',
    'ssa',
    'tai',
    'tup',
    'tut',
    'urj',
    'wak',
    'xnd'
  ],
  'apa' => [
    'apj',
    'apk',
    'apl',
    'apm',
    'apw',
    'nav'
  ],
  'fox' => [
    'bnn',
    'bzg',
    'ckv',
    'dru',
    'fos',
    'pwn',
    'pyu',
    'ssf',
    'sxr',
    'tay',
    'trv',
    'tsu',
    'uun',
    'xnb',
    'xsy'
  ],
  'hyx' => [
    'axm',
    'hye',
    'hyw',
    'xcl'
  ],
  'auf' => [
    'aru',
    'cul',
    'dny',
    'jaa',
    'pad',
    'swx'
  ],
  'art' => [
    'afh',
    'avk',
    'bzt',
    'dws',
    'epo',
    'ido',
    'igs',
    'ile',
    'ina',
    'jbo',
    'ldn',
    'lfn',
    'neu',
    'nov',
    'qya',
    'rmv',
    'sjn',
    'tlh',
    'tzl',
    'vol',
    'zbl'
  ],
  'pra' => [
    'pli',
    'san'
  ],
  'cmc' => [
    'ace',
    'cja',
    'cje',
    'cjm',
    'hro',
    'huq',
    'ibh',
    'jra',
    'rad',
    'rgs',
    'roc',
    'rog'
  ],
  'pqe' => [
    'aai',
    'aaw',
    'aaz',
    'adr',
    'adz',
    'aek',
    'agf',
    'agw',
    'ahb',
    'aia',
    'aie',
    'aix',
    'aji',
    'akg',
    'akr',
    'akt',
    'alm',
    'alo',
    'alp',
    'alu',
    'amk',
    'amq',
    'amv',
    'and',
    'ane',
    'anx',
    'aok',
    'aol',
    'aor',
    'aoz',
    'apb',
    'apo',
    'app',
    'apr',
    'aps',
    'apx',
    'aqr',
    'asl',
    'asz',
    'aty',
    'aua',
    'aud',
    'aui',
    'aul',
    'auq',
    'aut',
    'avb',
    'axx',
    'baa',
    'baj',
    'bay',
    'bbn',
    'bbv',
    'bcd',
    'bch',
    'bcm',
    'bcu',
    'bdd',
    'bed',
    'bek',
    'bgt',
    'bgy',
    'bhc',
    'bhp',
    'bhw',
    'biq',
    'bjk',
    'bjl',
    'bki',
    'bkx',
    'blp',
    'blq',
    'bmc',
    'bmk',
    'bmn',
    'bnd',
    'bnf',
    'bnk',
    'bnp',
    'bnr',
    'bpa',
    'bpg',
    'bpk',
    'bpz',
    'brj',
    'brr',
    'brz',
    'bsm',
    'btp',
    'btr',
    'bty',
    'buk',
    'bvc',
    'bvd',
    'bvt',
    'bwa',
    'bwb',
    'bwd',
    'bwf',
    'bxa',
    'bxf',
    'bxh',
    'bzh',
    'bzn',
    'bzq',
    'cal',
    'cam',
    'chk',
    'cir',
    'crc',
    'dac',
    'dad',
    'ddi',
    'ddw',
    'dgg',
    'dhv',
    'dij',
    'dix',
    'dmr',
    'dnk',
    'dob',
    'don',
    'dor',
    'drn',
    'drr',
    'dsn',
    'duf',
    'dva',
    'dww',
    'elu',
    'emi',
    'emw',
    'end',
    'erg',
    'erk',
    'erw',
    'etn',
    'faf',
    'far',
    'fij',
    'fnb',
    'frd',
    'frt',
    'fud',
    'fut',
    'fwa',
    'gal',
    'gar',
    'gdd',
    'gei',
    'ges',
    'gfk',
    'gga',
    'ggt',
    'ghn',
    'gil',
    'gip',
    'gli',
    'gmb',
    'goc',
    'goo',
    'gop',
    'gri',
    'grw',
    'grz',
    'gve',
    'gvs',
    'gzn',
    'hah',
    'hao',
    'haw',
    'hbu',
    'heg',
    'hgw',
    'hik',
    'hiw',
    'hla',
    'hoa',
    'hob',
    'hot',
    'hrk',
    'hrw',
    'hti',
    'htu',
    'hud',
    'huk',
    'hul',
    'huw',
    'hvk',
    'hvn',
    'iai',
    'idt',
    'iff',
    'ila',
    'ilu',
    'imr',
    'ire',
    'irh',
    'ism',
    'jae',
    'jaj',
    'jal',
    'jau',
    'jaz',
    'jmd',
    'kbi',
    'kbm',
    'kbt',
    'kbw',
    'kcl',
    'kdf',
    'kdk',
    'kei',
    'kem',
    'kgb',
    'khl',
    'khz',
    'kij',
    'kis',
    'kje',
    'kji',
    'kjr',
    'kkk',
    'klv',
    'klx',
    'koa',
    'kod',
    'kos',
    'kpd',
    'kpg',
    'kqf',
    'kqw',
    'krd',
    'krf',
    'ksd',
    'kse',
    'ksg',
    'ksl',
    'ksx',
    'ktk',
    'ktm',
    'kud',
    'kuk',
    'kuv',
    'kvc',
    'kvh',
    'kvo',
    'kvp',
    'kvv',
    'kwd',
    'kwf',
    'kwh',
    'kxa',
    'kxr',
    'kyd',
    'kzb',
    'kzd',
    'kzk',
    'kzl',
    'kzu',
    'kzx',
    'laz',
    'lbb',
    'lbq',
    'lbu',
    'lbv',
    'lcc',
    'lcd',
    'lcl',
    'lcm',
    'lcq',
    'lcs',
    'lek',
    'ler',
    'let',
    'leu',
    'lex',
    'lga',
    'lgb',
    'lgk',
    'lgl',
    'lgr',
    'lgu',
    'lhh',
    'lht',
    'lib',
    'lid',
    'lih',
    'lio',
    'ljl',
    'lka',
    'lkn',
    'lle',
    'llf',
    'llg',
    'llp',
    'llu',
    'llx',
    'lmb',
    'lmf',
    'lmg',
    'lmj',
    'lml',
    'lmq',
    'lmr',
    'lmu',
    'lmv',
    'lmy',
    'lnn',
    'loj',
    'los',
    'lox',
    'lpa',
    'lrn',
    'lrv',
    'lrz',
    'lti',
    'ltu',
    'lva',
    'lvu',
    'lwe',
    'lwt',
    'lww',
    'lzl',
    'mah',
    'mbh',
    'mbk',
    'mbq',
    'mcy',
    'mee',
    'mek',
    'met',
    'meu',
    'mft',
    'mgl',
    'mgm',
    'mhs',
    'mhz',
    'mjk',
    'mjm',
    'mkj',
    'mkt',
    'mkv',
    'mky',
    'mla',
    'mll',
    'mln',
    'mlu',
    'mlv',
    'mlx',
    'mme',
    'mmg',
    'mmm',
    'mmo',
    'mmt',
    'mmw',
    'mmx',
    'mna',
    'mnl',
    'mnv',
    'mox',
    'mpl',
    'mpn',
    'mpo',
    'mpr',
    'mpx',
    'mpy',
    'mqa',
    'mqc',
    'mqi',
    'mqm',
    'mqp',
    'mqy',
    'mqz',
    'mrb',
    'mri',
    'mrk',
    'mrl',
    'mrm',
    'mrn',
    'mrp',
    'mrq',
    'mrs',
    'mrv',
    'msn',
    'msq',
    'mss',
    'msu',
    'mte',
    'mth',
    'mtt',
    'mum',
    'mva',
    'mvd',
    'mvn',
    'mvo',
    'mvr',
    'mvt',
    'mvx',
    'mwa',
    'mwc',
    'mwg',
    'mwh',
    'mwi',
    'mwo',
    'mxe',
    'mxm',
    'mxz',
    'myw',
    'mzz',
    'nae',
    'nak',
    'nal',
    'nau',
    'nbn',
    'ncc',
    'ncf',
    'ncn',
    'nee',
    'nek',
    'nem',
    'nen',
    'nfa',
    'nfl',
    'ngr',
    'nho',
    'nil',
    'niu',
    'nke',
    'nkk',
    'nkp',
    'nkr',
    'nlg',
    'nlz',
    'nmb',
    'nmk',
    'nms',
    'nmt',
    'nmw',
    'nnd',
    'nni',
    'npn',
    'nrg',
    'nrz',
    'nsn',
    'nss',
    'nsw',
    'ntu',
    'nua',
    'nul',
    'num',
    'nuq',
    'nur',
    'nuw',
    'nvh',
    'nwi',
    'nxa',
    'nxe',
    'nxg',
    'nxl',
    'ojv',
    'olr',
    'omb',
    'oni',
    'onu',
    'ora',
    'orz',
    'oum',
    'oyy',
    'pat',
    'pdn',
    'pek',
    'pex',
    'pfa',
    'pgk',
    'pif',
    'piv',
    'pix',
    'piz',
    'pkg',
    'pkp',
    'plb',
    'ple',
    'plh',
    'pma',
    'pme',
    'pmo',
    'pmt',
    'pnh',
    'pon',
    'pop',
    'ppm',
    'ppn',
    'pri',
    'pss',
    'psw',
    'ptn',
    'ptp',
    'ptr',
    'ptv',
    'puw',
    'pwg',
    'rai',
    'rak',
    'rap',
    'rar',
    'ray',
    'reb',
    'rga',
    'rgu',
    'riu',
    'rjg',
    'rkh',
    'rmm',
    'rnn',
    'roe',
    'ror',
    'row',
    'rri',
    'rro',
    'rtm',
    'rug',
    'sau',
    'sax',
    'sbb',
    'sbc',
    'sbe',
    'sbh',
    'seu',
    'sew',
    'sgu',
    'sgz',
    'sih',
    'sij',
    'sjr',
    'ske',
    'ski',
    'sku',
    'sky',
    'skz',
    'slp',
    'slu',
    'slz',
    'smo',
    'snc',
    'sns',
    'sob',
    'sol',
    'sov',
    'spb',
    'spe',
    'spr',
    'sps',
    'srf',
    'srw',
    'sry',
    'ssg',
    'sso',
    'ssv',
    'ssz',
    'ste',
    'stn',
    'stw',
    'svb',
    'sve',
    'swp',
    'sws',
    'sww',
    'szn',
    'szw',
    'tah',
    'tbc',
    'tbe',
    'tbf',
    'tbj',
    'tbo',
    'tbx',
    'tdt',
    'tet',
    'tev',
    'tgc',
    'tgg',
    'tgi',
    'tgo',
    'tgp',
    'tgs',
    'tio',
    'tkd',
    'tkl',
    'tkp',
    'tkv',
    'tkw',
    'tlm',
    'tlr',
    'tls',
    'tlt',
    'tlu',
    'tlv',
    'tlx',
    'tmb',
    'tmi',
    'tmq',
    'tmt',
    'tmy',
    'tni',
    'tnk',
    'tnl',
    'tnn',
    'tnp',
    'tns',
    'tnx',
    'ton',
    'tox',
    'tpa',
    'tpf',
    'tpv',
    'tpz',
    'tql',
    'tqp',
    'trb',
    'tre',
    'tsr',
    'tte',
    'tti',
    'ttu',
    'ttv',
    'tuc',
    'tva',
    'tve',
    'tvk',
    'tvl',
    'tvm',
    'twp',
    'twu',
    'txn',
    'txq',
    'tzn',
    'ubr',
    'udj',
    'uge',
    'uli',
    'una',
    'unu',
    'upv',
    'urn',
    'urr',
    'urv',
    'utp',
    'uur',
    'uve',
    'uvl',
    'val',
    'vao',
    'vbb',
    'viv',
    'vlp',
    'vme',
    'vmg',
    'vnk',
    'vnm',
    'vnp',
    'vra',
    'vrs',
    'vrt',
    'wab',
    'wad',
    'wag',
    'wah',
    'wat',
    'waz',
    'wbb',
    'wbw',
    'wed',
    'weo',
    'wet',
    'wew',
    'wgb',
    'wgo',
    'wha',
    'wiv',
    'wkd',
    'wlr',
    'wls',
    'wmh',
    'wmn',
    'wnk',
    'woc',
    'woe',
    'woo',
    'wrp',
    'wrx',
    'wsa',
    'wsi',
    'wuv',
    'wuy',
    'wwo',
    'wyy',
    'xbr',
    'xkx',
    'xmt',
    'xmx',
    'xsi',
    'xxk',
    'yap',
    'yki',
    'ykk',
    'ykm',
    'ylu',
    'yly',
    'yml',
    'ymn',
    'ymp',
    'yob',
    'zeg',
    'zgr',
    'zsa',
    'zsu'
  ],
  'gmw' => [
    'act',
    'afr',
    'afs',
    'aig',
    'ang',
    'bah',
    'bar',
    'bis',
    'bjs',
    'brc',
    'bzj',
    'bzk',
    'cim',
    'dcr',
    'deu',
    'djk',
    'drt',
    'dum',
    'eng',
    'enm',
    'fpe',
    'frk',
    'frr',
    'fry',
    'gcl',
    'gct',
    'geh',
    'gmh',
    'gml',
    'goh',
    'gos',
    'gpe',
    'gsw',
    'gul',
    'gyn',
    'hrx',
    'hwc',
    'icr',
    'jam',
    'jvd',
    'kri',
    'ksh',
    'kww',
    'lim',
    'lng',
    'ltz',
    'mhn',
    'nds',
    'nld',
    'odt',
    'ofs',
    'oor',
    'osx',
    'pcm',
    'pdc',
    'pdt',
    'pey',
    'pfl',
    'pih',
    'pis',
    'qlm',
    'rop',
    'sco',
    'sdz',
    'skw',
    'sli',
    'srm',
    'srn',
    'stl',
    'stq',
    'svc',
    'swg',
    'sxu',
    'tch',
    'tcs',
    'tgh',
    'tpi',
    'trf',
    'twd',
    'uln',
    'vel',
    'vic',
    'vls',
    'vmf',
    'wae',
    'wep',
    'wes',
    'wym',
    'ydd',
    'yec',
    'yid',
    'yih',
    'zea'
  ],
  'map' => [
    'ais',
    'ami',
    'byq',
    'fox',
    'kae',
    'lcl',
    'lnd',
    'poz',
    'ppu'
  ],
  'alv' => [
    'aaa',
    'aab',
    'aba',
    'abi',
    'abm',
    'abn',
    'abo',
    'abr',
    'abu',
    'acd',
    'acp',
    'ada',
    'add',
    'ade',
    'adj',
    'adq',
    'ael',
    'afe',
    'afo',
    'afu',
    'agb',
    'agc',
    'agq',
    'ags',
    'aha',
    'ahl',
    'ahn',
    'ahp',
    'ahs',
    'aik',
    'aiy',
    'ajg',
    'aka',
    'akd',
    'akf',
    'akp',
    'aks',
    'aku',
    'ala',
    'alf',
    'amb',
    'amo',
    'anf',
    'ann',
    'anv',
    'anw',
    'any',
    'aqg',
    'asg',
    'asj',
    'ass',
    'atg',
    'ati',
    'ato',
    'aug',
    'aum',
    'avi',
    'avn',
    'awc',
    'awo',
    'ayb',
    'aye',
    'ayg',
    'ayi',
    'ayk',
    'ayu',
    'azo',
    'bab',
    'bad',
    'bai',
    'bau',
    'bav',
    'baw',
    'bax',
    'bba',
    'bbe',
    'bbk',
    'bbq',
    'bbs',
    'bbu',
    'bbw',
    'bby',
    'bce',
    'bcg',
    'bci',
    'bcn',
    'bcs',
    'bcv',
    'bcz',
    'bda',
    'bdj',
    'bdt',
    'bec',
    'beh',
    'bes',
    'bfd',
    'bff',
    'bfj',
    'bfl',
    'bfm',
    'bfo',
    'bfp',
    'bga',
    'bgf',
    'bgj',
    'bgo',
    'bgu',
    'bif',
    'bij',
    'bil',
    'bim',
    'bin',
    'biv',
    'bjg',
    'bjt',
    'bju',
    'bka',
    'bkc',
    'bkm',
    'bkv',
    'bky',
    'ble',
    'blo',
    'bly',
    'bma',
    'bmd',
    'bme',
    'bmf',
    'bmo',
    'bmq',
    'bmv',
    'bnt',
    'bnz',
    'boe',
    'bom',
    'bov',
    'box',
    'bqa',
    'bqd',
    'bqg',
    'bqj',
    'bqo',
    'bqt',
    'bqv',
    'bqw',
    'bqx',
    'brt',
    'bsc',
    'bse',
    'bsf',
    'bsj',
    'bsl',
    'bsp',
    'bsr',
    'bsx',
    'bte',
    'btt',
    'btu',
    'bub',
    'bud',
    'buj',
    'bun',
    'buy',
    'buz',
    'bvi',
    'bvj',
    'bvm',
    'bvo',
    'bwh',
    'bwj',
    'bwu',
    'bwy',
    'bxs',
    'byb',
    'byc',
    'byf',
    'byj',
    'byp',
    'bys',
    'bzv',
    'bzw',
    'bzy',
    'bzz',
    'cae',
    'cbj',
    'cbo',
    'cbq',
    'ccg',
    'cch',
    'ccj',
    'cdr',
    'cen',
    'cfa',
    'cfd',
    'cfg',
    'cib',
    'cko',
    'ckx',
    'cli',
    'cll',
    'cme',
    'cou',
    'cpn',
    'cry',
    'csk',
    'cug',
    'cwt',
    'dae',
    'dag',
    'dai',
    'dam',
    'dbd',
    'dbi',
    'dbm',
    'dbo',
    'deg',
    'deq',
    'dga',
    'dgd',
    'dgi',
    'dgs',
    'dio',
    'dir',
    'dmm',
    'dmo',
    'doh',
    'doo',
    'dop',
    'dos',
    'dow',
    'doy',
    'dri',
    'dud',
    'dur',
    'duz',
    'dya',
    'dyi',
    'dyo',
    'dza',
    'ebg',
    'ebr',
    'efa',
    'efi',
    'ega',
    'ego',
    'ehu',
    'eja',
    'eka',
    'eke',
    'eki',
    'ekp',
    'ekr',
    'elm',
    'ema',
    'emn',
    'enn',
    'env',
    'enw',
    'eot',
    'epi',
    'erh',
    'etb',
    'ets',
    'etu',
    'etx',
    'evh',
    'ewe',
    'eze',
    'fah',
    'fak',
    'fal',
    'fam',
    'fap',
    'fer',
    'ffm',
    'fir',
    'fll',
    'fni',
    'fod',
    'fon',
    'fub',
    'fuc',
    'fue',
    'fuf',
    'fuh',
    'fui',
    'ful',
    'fum',
    'fuq',
    'fuv',
    'gaa',
    'gba',
    'gbg',
    'gbh',
    'gbp',
    'gbq',
    'gbr',
    'gbs',
    'gbv',
    'gbx',
    'gby',
    'gdi',
    'ged',
    'gej',
    'gel',
    'gix',
    'gjn',
    'gke',
    'gkn',
    'glc',
    'glj',
    'gmd',
    'gmm',
    'gmn',
    'gna',
    'gne',
    'gng',
    'gnh',
    'gnz',
    'gol',
    'goy',
    'gpa',
    'grh',
    'gsl',
    'gso',
    'gua',
    'gur',
    'guw',
    'gux',
    'gvm',
    'gwa',
    'gwb',
    'gwg',
    'gwx',
    'gya',
    'gye',
    'gyg',
    'hag',
    'hhr',
    'hoe',
    'ibb',
    'ibe',
    'ibm',
    'ibn',
    'ibo',
    'ibr',
    'ica',
    'ich',
    'idc',
    'idd',
    'ide',
    'idr',
    'idu',
    'ife',
    'igb',
    'ige',
    'igl',
    'igw',
    'ijj',
    'ijo',
    'iki',
    'ikk',
    'ikl',
    'iko',
    'ikp',
    'ikv',
    'ikw',
    'ilv',
    'iri',
    'ish',
    'isi',
    'iso',
    'isu',
    'itm',
    'its',
    'itw',
    'iya',
    'iyo',
    'izi',
    'izr',
    'jab',
    'jar',
    'jbu',
    'jen',
    'jer',
    'jib',
    'jid',
    'jku',
    'jmr',
    'jms',
    'jni',
    'jrr',
    'jub',
    'juh',
    'juk',
    'juo',
    'juw',
    'jwi',
    'kad',
    'kaj',
    'kbn',
    'kbp',
    'kcc',
    'kcf',
    'kcg',
    'kci',
    'kcj',
    'kcq',
    'kdh',
    'kdl',
    'kdm',
    'kdp',
    'kdx',
    'kdz',
    'kef',
    'ken',
    'kes',
    'keu',
    'kez',
    'kfl',
    'kfn',
    'kfz',
    'kgt',
    'khj',
    'kia',
    'kid',
    'kka',
    'kkd',
    'kkm',
    'klc',
    'klk',
    'klo',
    'kma',
    'kmi',
    'kmp',
    'kmy',
    'knf',
    'kni',
    'knp',
    'knz',
    'koc',
    'kou',
    'kov',
    'kow',
    'kph',
    'kpk',
    'kpl',
    'kpo',
    'kqg',
    'kqk',
    'kqm',
    'kqs',
    'krh',
    'kro',
    'krp',
    'krx',
    'ksm',
    'kss',
    'kst',
    'kub',
    'kug',
    'kus',
    'kvm',
    'kwb',
    'kxb',
    'kye',
    'kza',
    'kzc',
    'kzr',
    'lak',
    'lan',
    'lar',
    'las',
    'ldb',
    'ldg',
    'ldh',
    'ldj',
    'ldk',
    'ldl',
    'ldm',
    'ldo',
    'ldp',
    'ldq',
    'lee',
    'lef',
    'lgq',
    'lia',
    'lip',
    'lla',
    'lma',
    'lmp',
    'lmx',
    'lns',
    'lnu',
    'lob',
    'loi',
    'lop',
    'lor',
    'luq',
    'luw',
    'mae',
    'maw',
    'mbu',
    'mbv',
    'mcj',
    'mcs',
    'mcu',
    'mda',
    'mdd',
    'mdm',
    'mea',
    'mfc',
    'mfd',
    'mff',
    'mfn',
    'mfo',
    'mfq',
    'mfv',
    'mgi',
    'mgj',
    'mgn',
    'mgo',
    'mhk',
    'mij',
    'mka',
    'mkl',
    'mko',
    'mlo',
    'mma',
    'mnf',
    'mnh',
    'moi',
    'moj',
    'mor',
    'mos',
    'mql',
    'mru',
    'msj',
    'msw',
    'mtb',
    'mtk',
    'mua',
    'muc',
    'muh',
    'muo',
    'mxl',
    'myg',
    'myj',
    'myk',
    'mzk',
    'mzm',
    'mzv',
    'mzw',
    'naj',
    'nar',
    'nat',
    'naw',
    'nbb',
    'nbm',
    'nbo',
    'nbp',
    'nbr',
    'nbv',
    'nbw',
    'ncr',
    'ncu',
    'ndb',
    'ndd',
    'ndi',
    'ndr',
    'ndt',
    'ndu',
    'ndv',
    'ndz',
    'ned',
    'nfd',
    'nfr',
    'nfu',
    'nga',
    'ngb',
    'nge',
    'ngg',
    'ngj',
    'ngn',
    'ngv',
    'nhu',
    'nie',
    'nin',
    'njj',
    'njr',
    'nku',
    'nkz',
    'nlu',
    'nml',
    'nmr',
    'nmz',
    'nns',
    'nnu',
    'nnw',
    'noy',
    'nqg',
    'nqk',
    'nsh',
    'nti',
    'ntm',
    'ntr',
    'nuh',
    'nup',
    'nuv',
    'nyb',
    'nza',
    'nzi',
    'nzy',
    'obl',
    'obu',
    'odu',
    'ofu',
    'ogb',
    'ogc',
    'ogg',
    'ogo',
    'ogu',
    'okb',
    'oke',
    'oks',
    'oku',
    'okx',
    'olm',
    'opa',
    'org',
    'orx',
    'oso',
    'ost',
    'otr',
    'ozm',
    'pai',
    'pbl',
    'pbn',
    'pbo',
    'pbp',
    'pcn',
    'pfe',
    'pgs',
    'pil',
    'plr',
    'pmn',
    'png',
    'pnl',
    'pnq',
    'pny',
    'pnz',
    'pug',
    'pwb',
    'pym',
    'rax',
    'res',
    'rin',
    'rod',
    'ruk',
    'saf',
    'sav',
    'scv',
    'sde',
    'sef',
    'sen',
    'sep',
    'seq',
    'sev',
    'sfw',
    'sgi',
    'sha',
    'shz',
    'sig',
    'sil',
    'sld',
    'snf',
    'snj',
    'snw',
    'soy',
    'spp',
    'sqa',
    'sqh',
    'sqm',
    'srr',
    'ssl',
    'swf',
    'sxs',
    'sxw',
    'tbm',
    'tbz',
    'tcd',
    'tdl',
    'tdo',
    'tdq',
    'tdv',
    'tem',
    'tfi',
    'tgw',
    'tgy',
    'thy',
    'tik',
    'tiq',
    'tiv',
    'tkq',
    'tnr',
    'toz',
    'tpm',
    'tsp',
    'tsw',
    'ttb',
    'tug',
    'tui',
    'tul',
    'tuz',
    'tvd',
    'twn',
    'uba',
    'uda',
    'uha',
    'uiv',
    'uji',
    'ukp',
    'ukq',
    'uku',
    'ukw',
    'ula',
    'ulb',
    'umm',
    'une',
    'urh',
    'usk',
    'uta',
    'utr',
    'uya',
    'vag',
    'ver',
    'vig',
    'vit',
    'vki',
    'vor',
    'vut',
    'wav',
    'wbf',
    'wci',
    'weh',
    'wem',
    'wib',
    'wja',
    'wlx',
    'wof',
    'wok',
    'wol',
    'wom',
    'wss',
    'wud',
    'wwa',
    'www',
    'xab',
    'xkb',
    'xkt',
    'xmb',
    'xoc',
    'xon',
    'xrb',
    'xsh',
    'xsm',
    'xsn',
    'xuo',
    'xwe',
    'xwl',
    'xxb',
    'yam',
    'yav',
    'yay',
    'yaz',
    'yba',
    'ybj',
    'ybl',
    'yei',
    'yer',
    'yes',
    'yky',
    'yng',
    'ynq',
    'yor',
    'yot',
    'yun',
    'zhi',
    'zhw',
    'zir',
    'zna',
    'znd'
  ],
  'bad' => [
    'bbp',
    'bfl',
    'bjo',
    'bpd',
    'bqk',
    'gox',
    'kuw',
    'liy',
    'lna',
    'lnl',
    'mnh',
    'nue',
    'nuu',
    'tor',
    'yaj',
    'zmz'
  ],
  'syd' => [
    'enf',
    'enh',
    'mtm',
    'nio',
    'sel',
    'xas',
    'yrk'
  ],
  'awd' => [
    'aca',
    'ame',
    'aox',
    'apu',
    'arw',
    'auf',
    'bae',
    'brg',
    'bvv',
    'bwi',
    'cab',
    'cbb',
    'ccc',
    'cjo',
    'cni',
    'cot',
    'cox',
    'cpb',
    'cpc',
    'cpu',
    'crb',
    'cui',
    'cuj',
    'gae',
    'gob',
    'guc',
    'guh',
    'guo',
    'ign',
    'inp',
    'kpc',
    'mbn',
    'mcb',
    'mht',
    'mmh',
    'mpd',
    'mpw',
    'not',
    'pab',
    'pbg',
    'pib',
    'pio',
    'plu',
    'pnk',
    'prq',
    'rgr',
    'sar',
    'tae',
    'ter',
    'tnq',
    'trn',
    'unk',
    'wap',
    'wau',
    'xir',
    'yaw',
    'ybn',
    'ycn',
    'yvt'
  ],
  'sio' => [
    'asb',
    'bll',
    'chc',
    'cro',
    'dak',
    'hid',
    'iow',
    'ksk',
    'lkt',
    'mhq',
    'ofo',
    'oma',
    'osa',
    'qua',
    'sto',
    'tta',
    'win',
    'xwc'
  ],
  'zle' => [
    'bel',
    'orv',
    'rue',
    'rus',
    'ukr'
  ],
  'crp' => [
    'cpe',
    'cpf',
    'cpp'
  ],
  'trk' => [
    'aib',
    'alt',
    'atv',
    'azb',
    'aze',
    'azj',
    'bak',
    'bgx',
    'chg',
    'chv',
    'cjs',
    'clw',
    'crh',
    'dlg',
    'gag',
    'ili',
    'jct',
    'kaa',
    'kaz',
    'kdr',
    'kim',
    'kir',
    'kjh',
    'klj',
    'kmz',
    'krc',
    'kum',
    'nog',
    'ota',
    'otk',
    'oui',
    'qwm',
    'qxq',
    'sah',
    'slq',
    'slr',
    'sty',
    'tat',
    'tuk',
    'tur',
    'tyv',
    'uig',
    'uum',
    'uzb',
    'uzn',
    'uzs',
    'xbo',
    'xpc',
    'ybe'
  ],
  'qwe' => [
    'cqu',
    'inb',
    'inj',
    'qub',
    'qud',
    'quf',
    'qug',
    'quh',
    'quk',
    'qul',
    'qup',
    'qur',
    'qus',
    'quw',
    'qux',
    'quy',
    'quz',
    'qva',
    'qvc',
    'qve',
    'qvh',
    'qvi',
    'qvj',
    'qvl',
    'qvm',
    'qvn',
    'qvo',
    'qvp',
    'qvs',
    'qvw',
    'qvz',
    'qwa',
    'qwc',
    'qwh',
    'qws',
    'qxa',
    'qxc',
    'qxh',
    'qxl',
    'qxn',
    'qxo',
    'qxp',
    'qxr',
    'qxt',
    'qxu',
    'qxw'
  ],
  'ira' => [
    'aiq',
    'atn',
    'avd',
    'ave',
    'bal',
    'bcc',
    'bgn',
    'bgp',
    'bhh',
    'bjm',
    'bqi',
    'bsg',
    'ckb',
    'def',
    'deh',
    'diq',
    'esh',
    'fas',
    'fay',
    'gbz',
    'glk',
    'goz',
    'gzi',
    'hac',
    'haz',
    'hrz',
    'isk',
    'jdt',
    'jpr',
    'kfm',
    'kgn',
    'kho',
    'kiu',
    'kmr',
    'ktl',
    'kur',
    'lki',
    'lrc',
    'lrl',
    'lsa',
    'luz',
    'mnj',
    'mzn',
    'ntz',
    'nyq',
    'okh',
    'oos',
    'oru',
    'oss',
    'pal',
    'pbt',
    'pbu',
    'peo',
    'pes',
    'phv',
    'prc',
    'prs',
    'pst',
    'pus',
    'rat',
    'rdb',
    'sdb',
    'sdf',
    'sdh',
    'sgh',
    'sgl',
    'sgr',
    'sgy',
    'shm',
    'siy',
    'smy',
    'sog',
    'soj',
    'sqo',
    'srh',
    'srz',
    'tgk',
    'tks',
    'tly',
    'tov',
    'ttt',
    'vaf',
    'vmh',
    'wbl',
    'wne',
    'xbc',
    'xco',
    'xkc',
    'xkj',
    'xkp',
    'xpr',
    'xsc',
    'xtq',
    'yah',
    'yai',
    'ydg',
    'zum',
    'zza'
  ],
  'omq' => [
    'amu',
    'azg',
    'azm',
    'cco',
    'chj',
    'chq',
    'chz',
    'cip',
    'cle',
    'cly',
    'cnl',
    'cnt',
    'coz',
    'cpa',
    'csa',
    'cso',
    'cta',
    'cte',
    'ctl',
    'ctp',
    'ctz',
    'cuc',
    'cut',
    'cux',
    'cvn',
    'cya',
    'czn',
    'ixc',
    'jmx',
    'maa',
    'mab',
    'maj',
    'maq',
    'mau',
    'mbz',
    'mce',
    'mdv',
    'meh',
    'mib',
    'mie',
    'mig',
    'mih',
    'mii',
    'mil',
    'mim',
    'mio',
    'mip',
    'mit',
    'miu',
    'mix',
    'miy',
    'miz',
    'mjc',
    'mks',
    'mom',
    'mpm',
    'mqh',
    'mtu',
    'mtx',
    'mvg',
    'mxa',
    'mxb',
    'mxs',
    'mxt',
    'mxv',
    'mxy',
    'mza',
    'mzi',
    'oto',
    'pbe',
    'pbf',
    'pbs',
    'pca',
    'pls',
    'pmq',
    'pmz',
    'poe',
    'pow',
    'pps',
    'sut',
    'tcf',
    'tpc',
    'tpl',
    'tpx',
    'trc',
    'trq',
    'trs',
    'vmc',
    'vmj',
    'vmm',
    'vmp',
    'vmq',
    'vmx',
    'vmy',
    'vmz',
    'xta',
    'xtb',
    'xtd',
    'xti',
    'xtj',
    'xtl',
    'xtm',
    'xtn',
    'xtp',
    'xts',
    'xtt',
    'xtu',
    'xty',
    'zaa',
    'zab',
    'zac',
    'zad',
    'zae',
    'zaf',
    'zai',
    'zam',
    'zao',
    'zap',
    'zaq',
    'zar',
    'zas',
    'zat',
    'zav',
    'zaw',
    'zax',
    'zca',
    'zoo',
    'zpa',
    'zpb',
    'zpc',
    'zpd',
    'zpe',
    'zpf',
    'zpg',
    'zph',
    'zpi',
    'zpj',
    'zpk',
    'zpl',
    'zpm',
    'zpn',
    'zpo',
    'zpp',
    'zpq',
    'zpr',
    'zps',
    'zpt',
    'zpu',
    'zpv',
    'zpw',
    'zpx',
    'zpy',
    'zpz',
    'zsr',
    'zte',
    'ztg',
    'ztl',
    'ztm',
    'ztn',
    'ztp',
    'ztq',
    'zts',
    'ztt',
    'ztu',
    'ztx',
    'zty'
  ],
  'cau' => [
    'ccn',
    'ccs'
  ],
  'ath' => [
    'aht',
    'apa',
    'bcr',
    'bea',
    'caf',
    'chp',
    'clc',
    'coq',
    'crx',
    'den',
    'dgr',
    'gce',
    'gwi',
    'haa',
    'hoi',
    'hup',
    'ing',
    'kkz',
    'koy',
    'ktw',
    'kuu',
    'mvb',
    'scs',
    'sek',
    'srs',
    'taa',
    'tau',
    'tcb',
    'tce',
    'tfn',
    'tgx',
    'tht',
    'tol',
    'ttm',
    'tuu',
    'txc',
    'wlk',
    'xsl',
    'xup'
  ],
  'khi' => [
    'hts',
    'ktz',
    'kwz',
    'naq',
    'nmn',
    'sad'
  ],
  'ngf' => [
    'aax',
    'abg',
    'abw',
    'aey',
    'aez',
    'agd',
    'age',
    'ahh',
    'aip',
    'akh',
    'ali',
    'anh',
    'aoe',
    'asc',
    'asd',
    'asi',
    'aso',
    'asx',
    'asy',
    'ate',
    'auu',
    'auy',
    'awb',
    'awm',
    'aws',
    'awu',
    'awv',
    'awx',
    'awy',
    'bbd',
    'bbr',
    'bef',
    'bhg',
    'bhl',
    'bie',
    'bir',
    'bjr',
    'bjz',
    'bmh',
    'bmp',
    'bmu',
    'bmx',
    'boj',
    'bop',
    'bpi',
    'bpm',
    'bpu',
    'bql',
    'buq',
    'bwp',
    'cjv',
    'cns',
    'dah',
    'daz',
    'ded',
    'dev',
    'dge',
    'dgx',
    'diy',
    'dmc',
    'dna',
    'dni',
    'dnr',
    'dnt',
    'dnw',
    'doa',
    'dui',
    'duk',
    'eip',
    'ekg',
    'ena',
    'enq',
    'eri',
    'fad',
    'fag',
    'fai',
    'faj',
    'for',
    'frq',
    'gaf',
    'gah',
    'gaj',
    'gam',
    'gao',
    'gap',
    'gat',
    'gaw',
    'gcn',
    'ggl',
    'ghs',
    'gim',
    'gka',
    'gkd',
    'gmu',
    'grg',
    'gsn',
    'gsp',
    'gvf',
    'gyb',
    'hap',
    'hih',
    'hkk',
    'hui',
    'igo',
    'imi',
    'imo',
    'ino',
    'iou',
    'ipi',
    'irx',
    'isa',
    'iwo',
    'jil',
    'kbq',
    'kco',
    'kew',
    'kgf',
    'kgq',
    'kgu',
    'khe',
    'kjs',
    'kjy',
    'kkl',
    'klh',
    'klm',
    'klt',
    'kmf',
    'kmg',
    'kmh',
    'kmu',
    'kop',
    'koz',
    'kpf',
    'kpq',
    'kpr',
    'kpw',
    'kqa',
    'kqb',
    'ksr',
    'kti',
    'kts',
    'ktt',
    'kue',
    'kuo',
    'kvz',
    'kwr',
    'kyc',
    'kyg',
    'kyy',
    'kzv',
    'lei',
    'leq',
    'mbw',
    'mci',
    'mcz',
    'mdc',
    'med',
    'mhf',
    'mhl',
    'mjj',
    'mjn',
    'mkr',
    'mlh',
    'mlp',
    'mmi',
    'mmq',
    'mnz',
    'mpp',
    'mpt',
    'mpv',
    'mqe',
    'mqv',
    'mqw',
    'msx',
    'msz',
    'mtc',
    'mtg',
    'mtv',
    'mux',
    'mvq',
    'nac',
    'naf',
    'nbk',
    'nbq',
    'nca',
    'ndx',
    'nej',
    'net',
    'nib',
    'nif',
    'nii',
    'nis',
    'nkg',
    'nkj',
    'nks',
    'nlc',
    'nlk',
    'nnf',
    'nnk',
    'noc',
    'nof',
    'noh',
    'nop',
    'nou',
    'nps',
    'nxr',
    'okv',
    'omo',
    'omw',
    'ons',
    'opk',
    'opm',
    'pda',
    'ped',
    'pla',
    'pmr',
    'pnr',
    'prw',
    'psa',
    'pup',
    'rea',
    'rmp',
    'rpt',
    'rwo',
    'saw',
    'sbq',
    'sej',
    'six',
    'skc',
    'skm',
    'sks',
    'sll',
    'slw',
    'smc',
    'snp',
    'snr',
    'snx',
    'snz',
    'spd',
    'spl',
    'sra',
    'ssd',
    'ssj',
    'sst',
    'ssx',
    'stm',
    'sue',
    'sug',
    'swm',
    'szb',
    'taw',
    'tbg',
    'tif',
    'tim',
    'tkx',
    'tlf',
    'tml',
    'tnh',
    'txt',
    'tya',
    'tyn',
    'ubu',
    'ufi',
    'uhn',
    'ukg',
    'urg',
    'urm',
    'urw',
    'usa',
    'usu',
    'utu',
    'uvh',
    'waj',
    'wdg',
    'wgi',
    'whg',
    'wlw',
    'wmc',
    'wms',
    'wnb',
    'wnc',
    'wng',
    'wno',
    'wnu',
    'wod',
    'wsk',
    'wsr',
    'wtf',
    'wul',
    'xes',
    'xow',
    'xse',
    'xsp',
    'xte',
    'yac',
    'ybm',
    'ybo',
    'yby',
    'ydk',
    'ygm',
    'ygr',
    'yir',
    'ykr',
    'yli',
    'ynl',
    'yon',
    'yrw',
    'ytw',
    'yut',
    'yuw',
    'zia',
    'zuh'
  ],
  'phi' => [
    'akl',
    'bik',
    'blf',
    'bno',
    'bnq',
    'ceb',
    'cps',
    'fil',
    'gor',
    'hil',
    'ibg',
    'ibl',
    'ify',
    'ilk',
    'ilo',
    'kak',
    'krj',
    'kyj',
    'kyk',
    'loc',
    'mdh',
    'mno',
    'mog',
    'mrw',
    'msb',
    'pag',
    'pam',
    'rth',
    'sgd',
    'snl',
    'sxn',
    'tbl',
    'tdn',
    'tne',
    'tnt',
    'tnw',
    'tom',
    'txs',
    'war'
  ],
  'aav' => [
    'irr',
    'kdt',
    'mkh',
    'mun',
    'nyl',
    'sss',
    'tth'
  ],
  'gem' => [
    'gme',
    'gmq',
    'gmw'
  ],
  'aql' => [
    'alg',
    'wiy',
    'yur'
  ],
  'tuw' => [
    'eve',
    'evn',
    'gld',
    'juc',
    'mnc',
    'neg',
    'oaa',
    'oac',
    'orh',
    'sjo',
    'ude',
    'ulc'
  ],
  'ijo' => [
    'iby',
    'ijc',
    'ije',
    'ijn',
    'ijs',
    'nkx',
    'okd',
    'okr',
    'orr'
  ],
  'oto' => [
    'mat',
    'maz',
    'mmc',
    'ocu',
    'ote',
    'otl',
    'otm',
    'otn',
    'otq',
    'ots',
    'ott',
    'otx',
    'otz',
    'pbs',
    'pei',
    'pmq',
    'pmz'
  ],
  'bat' => [
    'lav',
    'lit',
    'ltg',
    'ndf',
    'olt',
    'prg',
    'sgs',
    'svx',
    'sxl',
    'xcu',
    'xgl',
    'xsv',
    'xzm'
  ],
  'ssa' => [
    'csu',
    'dzg',
    'fvr',
    'gly',
    'guk',
    'ikx',
    'kau',
    'kbl',
    'kie',
    'kmq',
    'lgn',
    'mde',
    'mls',
    'rou',
    'sdv',
    'son',
    'teu',
    'tuq',
    'udu',
    'wti',
    'xmr',
    'xom'
  ],
  'hok' => [
    'acv',
    'atw',
    'boi',
    'cid',
    'coc',
    'crz',
    'esq',
    'inz',
    'kju',
    'klb',
    'kyh',
    'mov',
    'mrc',
    'obi',
    'peb',
    'pef',
    'pej',
    'peq',
    'pom',
    'poo',
    'ppi',
    'puy',
    'sei',
    'sht',
    'sln',
    'veo',
    'was',
    'ynn',
    'yuf',
    'yum'
  ],
  'iro' => [
    'cay',
    'chr',
    'lre',
    'moh',
    'ntw',
    'one',
    'ono',
    'see',
    'sqn',
    'tus',
    'wya'
  ],
  'fiu' => [
    'chm',
    'est',
    'fin',
    'fit',
    'fkv',
    'hun',
    'izh',
    'kca',
    'koi',
    'kom',
    'krl',
    'liv',
    'mdf',
    'mns',
    'mrj',
    'myv',
    'olo',
    'smi',
    'udm',
    'vep',
    'vot',
    'vro'
  ],
  'ine' => [
    'aln',
    'anp',
    'bat',
    'cel',
    'cms',
    'gem',
    'grk',
    'hit',
    'hlu',
    'hye',
    'hyx',
    'iir',
    'imy',
    'itc',
    'plq',
    'scx',
    'sdt',
    'sla',
    'sqi',
    'sqj',
    'txb',
    'txh',
    'xcl',
    'xcr',
    'xdc',
    'xlc',
    'xld',
    'xlg',
    'xls',
    'xlu',
    'xmk',
    'xpg',
    'xps',
    'xsd',
    'xto',
    'xve'
  ],
  'btk' => [
    'akb',
    'bbc',
    'btd',
    'btm',
    'bts',
    'btx',
    'btz'
  ],
  'mkh' => [
    'aem',
    'alk',
    'aml',
    'bbh',
    'bdq',
    'bgk',
    'bgl',
    'blr',
    'brb',
    'bru',
    'brv',
    'btq',
    'caq',
    'cbn',
    'cma',
    'cmo',
    'cog',
    'crv',
    'crw',
    'cua',
    'cwg',
    'dnu',
    'hal',
    'hld',
    'hnu',
    'hre',
    'huo',
    'jah',
    'jeh',
    'jhi',
    'kdt',
    'kha',
    'khf',
    'khm',
    'kjg',
    'kjm',
    'knq',
    'kns',
    'kpm',
    'krr',
    'krv',
    'kta',
    'ktv',
    'kuf',
    'kxm',
    'kxy',
    'lbn',
    'lbo',
    'lcp',
    'lnh',
    'lwl',
    'lyg',
    'mef',
    'mhe',
    'mlf',
    'mml',
    'mng',
    'mnn',
    'mnq',
    'mnw',
    'moo',
    'mqt',
    'mra',
    'mtq',
    'mzt',
    'ncb',
    'ncq',
    'nev',
    'ngt',
    'nik',
    'nuo',
    'nyl',
    'omx',
    'oog',
    'oyb',
    'pac',
    'pbv',
    'pcb',
    'pce',
    'phg',
    'pkt',
    'pll',
    'ply',
    'pnx',
    'prk',
    'prt',
    'pry',
    'puo',
    'qok',
    'rbb',
    'ren',
    'ril',
    'rka',
    'rmx',
    'sbo',
    'scb',
    'scq',
    'sct',
    'sea',
    'sed',
    'sii',
    'smu',
    'spu',
    'sqq',
    'ssm',
    'sss',
    'stg',
    'sti',
    'stt',
    'stu',
    'syo',
    'sza',
    'szc',
    'tdf',
    'tdr',
    'tea',
    'tef',
    'thm',
    'tkz',
    'tlq',
    'tmo',
    'tnz',
    'tou',
    'tpu',
    'tth',
    'tto',
    'tyh',
    'uuu',
    'vie',
    'vwa',
    'wbm',
    'xao',
    'xkk',
    'xnh',
    'yin',
    'zng'
  ],
  'alg' => [
    'aaq',
    'abe',
    'alq',
    'arp',
    'atj',
    'ats',
    'bla',
    'chy',
    'ciw',
    'cre',
    'crj',
    'crk',
    'crl',
    'crm',
    'crr',
    'csw',
    'cwd',
    'del',
    'kic',
    'mez',
    'mia',
    'mic',
    'mjy',
    'moe',
    'mof',
    'nnt',
    'nsk',
    'nwa',
    'ojb',
    'ojc',
    'ojg',
    'oji',
    'ojs',
    'ojw',
    'otw',
    'pim',
    'pot',
    'pqm',
    'psy',
    'qyp',
    'sac',
    'sjw',
    'umu',
    'unm',
    'wam',
    'xlb',
    'xlo',
    'xnt',
    'xpq'
  ],
  'bai' => [
    'bbj',
    'bko',
    'byv',
    'fmp',
    'jgo',
    'nla',
    'nnh',
    'nnz',
    'nwe',
    'xmg',
    'ybb'
  ],
  'tai' => [
    'aho',
    'aio',
    'blt',
    'cuu',
    'eee',
    'khb',
    'kht',
    'kkh',
    'ksu',
    'lao',
    'mlc',
    'nod',
    'nut',
    'pcc',
    'pdi',
    'phk',
    'pht',
    'phu',
    'shn',
    'skb',
    'soa',
    'sou',
    'tdd',
    'tha',
    'thi',
    'tiz',
    'tjl',
    'tmm',
    'tnu',
    'tpo',
    'try',
    'tsl',
    'tts',
    'twh',
    'tyj',
    'tyr',
    'tys',
    'tyt',
    'tyz',
    'uan',
    'yno',
    'yoy',
    'zch',
    'zeh',
    'zgb',
    'zgm',
    'zgn',
    'zhd',
    'zhn',
    'zlj',
    'zln',
    'zlq',
    'zqe',
    'zyb',
    'zyg',
    'zyj',
    'zyn',
    'zzj'
  ],
  'urj' => [
    'ekk',
    'fiu',
    'kpv',
    'lud',
    'mhr',
    'syd'
  ],
  'csu' => [
    'asv',
    'avu',
    'bct',
    'bdh',
    'bdo',
    'bex',
    'bjv',
    'blm',
    'bmi',
    'bot',
    'bvq',
    'bxv',
    'dgk',
    'dsi',
    'efe',
    'fgr',
    'fuu',
    'gbn',
    'glu',
    'gqr',
    'gvl',
    'hor',
    'jyy',
    'kah',
    'kbo',
    'kcm',
    'ksp',
    'kwg',
    'kwv',
    'kxj',
    'kyq',
    'lap',
    'led',
    'les',
    'lgg',
    'lmi',
    'log',
    'luc',
    'lul',
    'mdi',
    'mdj',
    'mdk',
    'mgc',
    'mgd',
    'mge',
    'mhi',
    'mne',
    'mwm',
    'mwu',
    'mxh',
    'myb',
    'ndp',
    'ndy',
    'niy',
    'nmc',
    'nwm',
    'omi',
    'sba',
    'sbz',
    'snm',
    'sys',
    'vae',
    'yul'
  ],
  'xnd' => [
    'ath',
    'eya',
    'hoi',
    'tfn',
    'tli'
  ],
  'aus' => [
    'bck',
    'dbl',
    'ddj',
    'gbu',
    'gni',
    'kdd',
    'kjn',
    'kld',
    'mep',
    'nha',
    'nuy',
    'piu',
    'pkn',
    'vma',
    'vmb',
    'wbp',
    'wmt',
    'xbp',
    'xrg',
    'yii',
    'yij'
  ],
  'sem' => [
    'aao',
    'abh',
    'abv',
    'acm',
    'acq',
    'acw',
    'acx',
    'acy',
    'adf',
    'aeb',
    'aec',
    'afb',
    'agj',
    'aii',
    'aij',
    'ajp',
    'ajt',
    'aju',
    'akk',
    'amh',
    'amw',
    'apc',
    'apd',
    'ara',
    'arb',
    'arc',
    'arq',
    'ars',
    'ary',
    'arz',
    'auz',
    'avl',
    'ayh',
    'ayl',
    'ayn',
    'ayp',
    'bbz',
    'bhm',
    'bhn',
    'bjf',
    'cld',
    'dlk',
    'gdq',
    'gez',
    'gft',
    'gru',
    'har',
    'hbo',
    'heb',
    'hoh',
    'hrt',
    'hss',
    'huy',
    'inm',
    'ior',
    'jpa',
    'jrb',
    'jye',
    'kcn',
    'kqd',
    'lhs',
    'lsd',
    'mey',
    'mid',
    'mlt',
    'mvz',
    'mys',
    'myz',
    'oar',
    'pga',
    'phn',
    'rzh',
    'sam',
    'sgw',
    'shu',
    'shv',
    'smp',
    'sqr',
    'sqt',
    'ssh',
    'stv',
    'syc',
    'syn',
    'tig',
    'tir',
    'tmr',
    'trg',
    'tru',
    'uga',
    'wle',
    'xaa',
    'xeb',
    'xhd',
    'xna',
    'xpu',
    'xqt',
    'xsa',
    'yhd',
    'yud',
    'zwa'
  ],
  'day' => [
    'bth',
    'lra',
    'sdo',
    'sne'
  ],
  'sgn' => [
    'csn',
    'fcs',
    'fsl',
    'ils',
    'isg',
    'rsl'
  ],
  'dra' => [
    'aaf',
    'all',
    'bfq',
    'brh',
    'brw',
    'cde',
    'ctt',
    'daq',
    'emu',
    'era',
    'fmu',
    'gau',
    'gdb',
    'ggo',
    'gno',
    'gon',
    'hoy',
    'ima',
    'iru',
    'kan',
    'kej',
    'kep',
    'kev',
    'kfa',
    'kfb',
    'kfc',
    'kfd',
    'kfe',
    'kff',
    'kfg',
    'kfh',
    'kmj',
    'kpb',
    'kru',
    'kwx',
    'kxl',
    'kxu',
    'kxv',
    'mal',
    'mha',
    'mjo',
    'mjp',
    'mjq',
    'mjr',
    'mjt',
    'mju',
    'mjv',
    'mmk',
    'mrr',
    'mut',
    'muv',
    'nit',
    'oty',
    'pcf',
    'pcg',
    'pci',
    'peg',
    'pkr',
    'pty',
    'qkn',
    'sle',
    'tam',
    'tcx',
    'tcy',
    'tel',
    'thn',
    'udg',
    'ull',
    'url',
    'vis',
    'vmd',
    'wbq',
    'wkl',
    'wku',
    'xua',
    'xub',
    'xuj',
    'yea',
    'yeu',
    'ymr'
  ],
  'wak' => [
    'dtd',
    'has',
    'hei',
    'kwk',
    'myh',
    'nuk'
  ],
  'kar' => [
    'blk',
    'bwe',
    'eky',
    'ghk',
    'jkm',
    'kjp',
    'kjt',
    'kpp',
    'ksw',
    'kvl',
    'kvq',
    'kvu',
    'kvy',
    'kxf',
    'kxk',
    'kyu',
    'pdu',
    'pwo',
    'pww',
    'wea'
  ],
  'nub' => [
    'brk',
    'dil',
    'drb',
    'elh',
    'fia',
    'ghl',
    'kdu',
    'kko',
    'kzh',
    'mei',
    'onw',
    'wll'
  ],
  'aqa' => [
    'alc'
  ],
  'xgn' => [
    'bua',
    'bxm',
    'bxr',
    'bxu',
    'drh',
    'dta',
    'khk',
    'kxs',
    'mhj',
    'mjg',
    'mon',
    'mvf',
    'peh',
    'sce',
    'xal',
    'xng',
    'xwo',
    'yuy',
    'zkt'
  ],
  'cdc' => [
    'aal',
    'ajw',
    'anc',
    'ank',
    'auo',
    'bbt',
    'bcw',
    'bcy',
    'bde',
    'bdm',
    'bdn',
    'bhs',
    'bid',
    'bol',
    'bta',
    'btf',
    'bux',
    'bva',
    'bvf',
    'bvh',
    'bvw',
    'bwr',
    'bxq',
    'cie',
    'ckl',
    'ckq',
    'cky',
    'cla',
    'cuv',
    'daa',
    'dbb',
    'dbp',
    'dbq',
    'dgh',
    'dkx',
    'dme',
    'dot',
    'dwa',
    'fie',
    'fkk',
    'fli',
    'gab',
    'gde',
    'gdf',
    'gdk',
    'gdu',
    'gea',
    'gek',
    'gew',
    'gid',
    'gis',
    'giz',
    'gji',
    'glo',
    'glw',
    'gnd',
    'gou',
    'gqa',
    'grd',
    'gwn',
    'hau',
    'hbb',
    'hed',
    'hia',
    'hig',
    'hna',
    'hod',
    'hwo',
    'hya',
    'jaf',
    'jeu',
    'jia',
    'jie',
    'jim',
    'jmb',
    'jmi',
    'juu',
    'kai',
    'kbz',
    'kcs',
    'ker',
    'kil',
    'kkr',
    'kks',
    'kna',
    'kof',
    'kot',
    'kpa',
    'kqp',
    'kqx',
    'ksq',
    'ktc',
    'kuh',
    'kul',
    'kvf',
    'kvi',
    'kvj',
    'kwl',
    'ldd',
    'lln',
    'lme',
    'maf',
    'mcn',
    'mcw',
    'meq',
    'mes',
    'mew',
    'mfh',
    'mfi',
    'mfj',
    'mfk',
    'mfl',
    'mfm',
    'mif',
    'mje',
    'mjs',
    'mkf',
    'mlj',
    'mlr',
    'mlw',
    'mmf',
    'mmy',
    'mou',
    'moz',
    'mpg',
    'mpi',
    'mpk',
    'mqb',
    'mrt',
    'mse',
    'msv',
    'mtl',
    'mub',
    'mug',
    'muj',
    'muy',
    'mvh',
    'mxf',
    'mxu',
    'nbh',
    'ndm',
    'ngi',
    'ngs',
    'ngw',
    'ngx',
    'nja',
    'nmi',
    'nnc',
    'nnn',
    'pbi',
    'pcw',
    'pip',
    'piy',
    'plj',
    'pqa',
    'saa',
    'say',
    'scw',
    'sir',
    'sok',
    'sor',
    'sur',
    'swq',
    'swy',
    'syk',
    'tak',
    'tal',
    'tan',
    'tax',
    'tdk',
    'tgd',
    'tmc',
    'tng',
    'trj',
    'tsh',
    'ttr',
    'twc',
    'ubi',
    'udl',
    'vem',
    'wji',
    'xed',
    'xmd',
    'xmj',
    'zah',
    'zaz',
    'zim',
    'ziz',
    'zns',
    'zrn',
    'zua',
    'zuy'
  ],
  'mun' => [
    'asr',
    'bfw',
    'bix',
    'biy',
    'cdz',
    'ekl',
    'gaq',
    'gbj',
    'hoc',
    'jun',
    'juy',
    'kfp',
    'kfq',
    'khr',
    'ksz',
    'mjx',
    'mmj',
    'pcj',
    'sat',
    'srb',
    'trd',
    'unr'
  ],
  'smi' => [
    'sia',
    'sjd',
    'sje',
    'sjk',
    'sjt',
    'sju',
    'sma',
    'sme',
    'smj',
    'smn',
    'sms'
  ],
  'itc' => [
    'lat',
    'osc',
    'qbb',
    'qhr',
    'roa',
    'spx',
    'xfa',
    'xum'
  ],
  'hmx' => [
    'bje',
    'bmt',
    'bpn',
    'buh',
    'bwn',
    'bwx',
    'cqd',
    'hea',
    'hma',
    'hmc',
    'hmd',
    'hme',
    'hmf',
    'hmg',
    'hmh',
    'hmi',
    'hmj',
    'hml',
    'hmm',
    'hmn',
    'hmp',
    'hmq',
    'hms',
    'hmv',
    'hmw',
    'hmy',
    'hmz',
    'hnj',
    'hrm',
    'huj',
    'ium',
    'mji',
    'mmr',
    'muq',
    'mww',
    'pha',
    'pnu',
    'sfm',
    'shx'
  ],
  'mno' => [
    'atd',
    'bgs',
    'bkd',
    'cgc',
    'mba',
    'mbb',
    'mbd',
    'mbi',
    'mbs',
    'mbt',
    'mkx',
    'mqk',
    'msm',
    'mta',
    'obo'
  ],
  'zlw' => [
    'ces',
    'csb',
    'czk',
    'pol',
    'pox',
    'slk',
    'szl',
    'wen'
  ],
  'bih' => [],
  'cdd' => [
    'ari',
    'cad',
    'kii',
    'paw',
    'wic'
  ]
};
$LanguageParent = {
  'lrl' => 'ira',
  'zha' => 'tai',
  'dmr' => 'pqe',
  'sga' => 'cel',
  'tha' => 'tai',
  'pra' => 'inc',
  'hlt' => 'sit',
  'twq' => 'son',
  'poo' => 'hok',
  'bfb' => 'inc',
  'gdi' => 'alv',
  'pcw' => 'cdc',
  'coq' => 'ath',
  'glh' => 'inc',
  'gni' => 'aus',
  'pbv' => 'mkh',
  'sue' => 'ngf',
  'ekr' => 'alv',
  'itv' => 'poz',
  'haz' => 'ira',
  'bbl' => 'ccn',
  'nbh' => 'cdc',
  'aim' => 'sit',
  'bxk' => 'bnt',
  'tfr' => 'cba',
  'mhx' => 'sit',
  'bwy' => 'alv',
  'nhq' => 'nah',
  'mxf' => 'cdc',
  'xoc' => 'alv',
  'bhv' => 'poz',
  'mqt' => 'mkh',
  'dot' => 'cdc',
  'juh' => 'alv',
  'ajw' => 'cdc',
  'tek' => 'bnt',
  'kgf' => 'ngf',
  'puu' => 'bnt',
  'kpm' => 'mkh',
  'gmb' => 'pqe',
  'nuq' => 'pqe',
  'xlo' => 'alg',
  'kry' => 'ccn',
  'bhq' => 'poz',
  'yat' => 'bnt',
  'ruq' => 'roa',
  'emy' => 'myn',
  'bkc' => 'alv',
  'hmv' => 'hmx',
  'izh' => 'fiu',
  'mvr' => 'pqe',
  'ktp' => 'sit',
  'spb' => 'pqe',
  'ndq' => 'bnt',
  'mru' => 'alv',
  'nsw' => 'pqe',
  'hba' => 'bnt',
  'stb' => 'poz',
  'tsj' => 'sit',
  'opk' => 'ngf',
  'yun' => 'alv',
  'pes' => 'ira',
  'fuc' => 'alv',
  'lae' => 'sit',
  'bqt' => 'alv',
  'xna' => 'sem',
  'tjg' => 'pqw',
  'mwz' => 'bnt',
  'mto' => 'cai',
  'mri' => 'pqe',
  'bfx' => 'poz',
  'sjt' => 'smi',
  'boi' => 'hok',
  'aeq' => 'inc',
  'hms' => 'hmx',
  'umb' => 'bnt',
  'her' => 'bnt',
  'bhu' => 'inc',
  'cjy' => 'zhx',
  'awy' => 'ngf',
  'taw' => 'ngf',
  'ayb' => 'alv',
  'kmp' => 'alv',
  'gaa' => 'alv',
  'xsl' => 'ath',
  'bva' => 'cdc',
  'yaj' => 'bad',
  'bec' => 'alv',
  'xeb' => 'sem',
  'ekk' => 'urj',
  'xrb' => 'alv',
  'nyf' => 'bnt',
  'lmb' => 'pqe',
  'nki' => 'sit',
  'chz' => 'omq',
  'bnx' => 'bnt',
  'hoc' => 'mun',
  'eyo' => 'sdv',
  'zaw' => 'omq',
  'ovd' => 'gmq',
  'aia' => 'pqe',
  'lik' => 'bnt',
  'zeg' => 'pqe',
  'mth' => 'pqe',
  'mzw' => 'alv',
  'bwx' => 'hmx',
  'olu' => 'bnt',
  'ity' => 'poz',
  'nkj' => 'ngf',
  'dde' => 'bnt',
  'ylm' => 'sit',
  'tom' => 'phi',
  'coh' => 'bnt',
  'xtd' => 'omq',
  'lmn' => 'inc',
  'ndc' => 'bnt',
  'xtp' => 'omq',
  'mdj' => 'csu',
  'lmy' => 'pqe',
  'hra' => 'sit',
  'gap' => 'ngf',
  'lzh' => 'sit',
  'kle' => 'sit',
  'rim' => 'bnt',
  'mpo' => 'pqe',
  'dbq' => 'cdc',
  'tdt' => 'pqe',
  'mjo' => 'dra',
  'anh' => 'ngf',
  'zae' => 'omq',
  'wgo' => 'pqe',
  'khg' => 'sit',
  'kho' => 'ira',
  'tdv' => 'alv',
  'ymd' => 'sit',
  'xcu' => 'bat',
  'kkm' => 'alv',
  'mlw' => 'cdc',
  'wow' => 'pqw',
  'spd' => 'ngf',
  'lml' => 'pqe',
  'btk' => 'pqw',
  'age' => 'ngf',
  'ica' => 'alv',
  'rjg' => 'pqe',
  'guj' => 'inc',
  'prf' => 'poz',
  'jna' => 'sit',
  'emi' => 'pqe',
  'gbo' => 'kro',
  'kgy' => 'sit',
  'ijo' => 'alv',
  'dcr' => 'gmw',
  'byd' => 'poz',
  'tqq' => 'cus',
  'mji' => 'hmx',
  'aol' => 'pqe',
  'wru' => 'pqw',
  'scv' => 'alv',
  'hwc' => 'gmw',
  'ntz' => 'ira',
  'tdl' => 'alv',
  'max' => 'poz',
  'xng' => 'xgn',
  'lld' => 'roa',
  'leu' => 'pqe',
  'aca' => 'awd',
  'kei' => 'pqe',
  'mny' => 'bnt',
  'fwe' => 'bnt',
  'lbx' => 'pqw',
  'nyr' => 'bnt',
  'vau' => 'bnt',
  'ber' => 'afa',
  'epi' => 'alv',
  'kzd' => 'pqe',
  'emb' => 'poz',
  'non' => 'gmq',
  'mqe' => 'ngf',
  'rkm' => 'dmn',
  'sgr' => 'ira',
  'nzy' => 'alv',
  'sju' => 'smi',
  'has' => 'wak',
  'mxx' => 'dmn',
  'tel' => 'dra',
  'dud' => 'alv',
  'mwk' => 'dmn',
  'erh' => 'alv',
  'lep' => 'sit',
  'cbq' => 'alv',
  'mpk' => 'cdc',
  'yei' => 'alv',
  'yta' => 'sit',
  'ost' => 'alv',
  'lss' => 'inc',
  'bly' => 'alv',
  'woo' => 'pqe',
  'muo' => 'alv',
  'mtd' => 'pqw',
  'aaz' => 'pqe',
  'oks' => 'alv',
  'kxx' => 'bnt',
  'kge' => 'pqw',
  'myx' => 'bnt',
  'ali' => 'ngf',
  'myc' => 'bnt',
  'moz' => 'cdc',
  'bwr' => 'cdc',
  'aeb' => 'sem',
  'klj' => 'trk',
  'cqd' => 'hmx',
  'yiz' => 'sit',
  'ymq' => 'sit',
  'bde' => 'cdc',
  'btz' => 'btk',
  'wbm' => 'mkh',
  'pov' => 'roa',
  'gwa' => 'alv',
  'sad' => 'khi',
  'cts' => 'poz',
  'igs' => 'art',
  'zul' => 'bnt',
  'nuh' => 'alv',
  'rau' => 'sit',
  'gjk' => 'inc',
  'gml' => 'gmw',
  'avl' => 'sem',
  'bos' => 'zls',
  'kog' => 'cba',
  'inp' => 'awd',
  'nfl' => 'pqe',
  'kwv' => 'csu',
  'slh' => 'sal',
  'tni' => 'pqe',
  'hbu' => 'pqe',
  'kzh' => 'nub',
  'fud' => 'pqe',
  'pwo' => 'kar',
  'dkr' => 'poz',
  'zat' => 'omq',
  'zgr' => 'pqe',
  'aze' => 'trk',
  'lmp' => 'alv',
  'suj' => 'bnt',
  'ili' => 'trk',
  'piu' => 'aus',
  'apw' => 'apa',
  'sih' => 'pqe',
  'bnf' => 'pqe',
  'aas' => 'cus',
  'btp' => 'pqe',
  'btu' => 'alv',
  'dan' => 'gmq',
  'dje' => 'son',
  'bmv' => 'alv',
  'lhh' => 'pqe',
  'tpp' => 'cai',
  'tih' => 'poz',
  'mrs' => 'pqe',
  'khe' => 'ngf',
  'ttc' => 'myn',
  'byn' => 'cus',
  'sdv' => 'ssa',
  'bdj' => 'alv',
  'muv' => 'dra',
  'gbr' => 'alv',
  'snl' => 'phi',
  'cba' => 'cai',
  'avb' => 'pqe',
  'vro' => 'fiu',
  'dho' => 'inc',
  'tuv' => 'sdv',
  'mlh' => 'ngf',
  'sot' => 'bnt',
  'lnu' => 'alv',
  'far' => 'pqe',
  'mcu' => 'alv',
  'mvg' => 'omq',
  'stj' => 'dmn',
  'afh' => 'art',
  'taj' => 'sit',
  'tml' => 'ngf',
  'chl' => 'azc',
  'nkb' => 'sit',
  'atb' => 'sit',
  'thy' => 'alv',
  'nuf' => 'sit',
  'dzn' => 'bnt',
  'kmr' => 'ira',
  'neg' => 'tuw',
  'cle' => 'omq',
  'ykr' => 'ngf',
  'seq' => 'alv',
  'bfd' => 'alv',
  'bez' => 'bnt',
  'alw' => 'cus',
  'wni' => 'bnt',
  'duw' => 'pqw',
  'mxm' => 'pqe',
  'ahl' => 'alv',
  'bea' => 'ath',
  'brz' => 'pqe',
  'ewe' => 'alv',
  'abf' => 'poz',
  'mxy' => 'omq',
  'sau' => 'pqe',
  'kzn' => 'bnt',
  'kad' => 'alv',
  'mtb' => 'alv',
  'kvj' => 'cdc',
  'xmv' => 'pqw',
  'dnt' => 'ngf',
  'btb' => 'bnt',
  'htu' => 'pqe',
  'dlk' => 'sem',
  'saz' => 'inc',
  'ypa' => 'sit',
  'nmr' => 'alv',
  'bht' => 'inc',
  'ngp' => 'bnt',
  'xay' => 'poz',
  'ybb' => 'bai',
  'frm' => 'roa',
  'bug' => 'pqw',
  'mvf' => 'xgn',
  'phq' => 'sit',
  'cps' => 'phi',
  'vep' => 'fiu',
  'bgl' => 'mkh',
  'mbf' => 'poz',
  'yud' => 'sem',
  'cna' => 'sit',
  'tay' => 'fox',
  'mgd' => 'csu',
  'mdx' => 'omv',
  'kfe' => 'dra',
  'mup' => 'inc',
  'kju' => 'hok',
  'she' => 'omv',
  'yua' => 'myn',
  'kmb' => 'bnt',
  'dah' => 'ngf',
  'hoo' => 'bnt',
  'lfn' => 'art',
  'hmd' => 'hmx',
  'eme' => 'tup',
  'for' => 'ngf',
  'vig' => 'alv',
  'com' => 'azc',
  'otr' => 'kdo',
  'ben' => 'inc',
  'wtf' => 'ngf',
  'ssv' => 'pqe',
  'szb' => 'ngf',
  'bxh' => 'pqe',
  'blr' => 'mkh',
  'zab' => 'omq',
  'yit' => 'sit',
  'dui' => 'ngf',
  'xum' => 'itc',
  'cuw' => 'sit',
  'hbs' => 'zls',
  'jac' => 'myn',
  'nuk' => 'wak',
  'yba' => 'alv',
  'cae' => 'alv',
  'mkl' => 'alv',
  'ysr' => 'ypk',
  'ekp' => 'alv',
  'ypz' => 'sit',
  'omw' => 'ngf',
  'cpb' => 'awd',
  'kwg' => 'csu',
  'ldk' => 'alv',
  'poc' => 'myn',
  'auz' => 'sem',
  'qwh' => 'qwe',
  'nxq' => 'sit',
  'btc' => 'bnt',
  'inh' => 'ccn',
  'wom' => 'alv',
  'nnp' => 'sit',
  'koy' => 'ath',
  'lsh' => 'sit',
  'crv' => 'mkh',
  'cni' => 'awd',
  'aht' => 'ath',
  'snv' => 'pqw',
  'trk' => 'tut',
  'dbo' => 'alv',
  'sio' => 'nai',
  'kuj' => 'bnt',
  'llb' => 'bnt',
  'teg' => 'bnt',
  'ybi' => 'sit',
  'ntp' => 'azc',
  'mqq' => 'poz',
  'dgs' => 'alv',
  'pms' => 'roa',
  'num' => 'pqe',
  'nnb' => 'bnt',
  'luv' => 'inc',
  'nim' => 'bnt',
  'gey' => 'bnt',
  'bpu' => 'ngf',
  'cso' => 'omq',
  'udl' => 'cdc',
  'wlk' => 'ath',
  'azo' => 'alv',
  'til' => 'sal',
  'jni' => 'alv',
  'yng' => 'alv',
  'bih' => 'iir',
  'hmb' => 'son',
  'pmy' => 'poz',
  'kop' => 'ngf',
  'kwf' => 'pqe',
  'tch' => 'gmw',
  'jen' => 'alv',
  'lpo' => 'tbq',
  'ude' => 'tuw',
  'pmi' => 'sit',
  'pom' => 'hok',
  'kcq' => 'alv',
  'bik' => 'poz',
  'cal' => 'pqe',
  'kfv' => 'inc',
  'avk' => 'art',
  'bvh' => 'cdc',
  'meu' => 'pqe',
  'kmy' => 'alv',
  'skb' => 'tai',
  'idb' => 'roa',
  'lcs' => 'pqe',
  'txy' => 'pqw',
  'rej' => 'pqw',
  'iwo' => 'ngf',
  'pof' => 'bnt',
  'lkn' => 'pqe',
  'sky' => 'pqe',
  'waz' => 'pqe',
  'atw' => 'hok',
  'zza' => 'ira',
  'kdm' => 'alv',
  'oku' => 'alv',
  'hun' => 'fiu',
  'zne' => 'znd',
  'nis' => 'ngf',
  'mmy' => 'cdc',
  'bcd' => 'pqe',
  'spv' => 'inc',
  'ldi' => 'bnt',
  'skj' => 'sit',
  'tns' => 'pqe',
  'soi' => 'inc',
  'rap' => 'pqe',
  'esq' => 'hok',
  'tkz' => 'mkh',
  'pmm' => 'bnt',
  'mlf' => 'mkh',
  'pwm' => 'poz',
  'kos' => 'pqe',
  'mbm' => 'bnt',
  'stw' => 'pqe',
  'zaa' => 'omq',
  'cih' => 'inc',
  'sjs' => 'ber',
  'afo' => 'alv',
  'pmj' => 'sit',
  'lel' => 'bnt',
  'vic' => 'gmw',
  'mhj' => 'xgn',
  'map' => 'mul',
  'ukh' => 'bnt',
  'plo' => 'cai',
  'tui' => 'alv',
  'xup' => 'ath',
  'mae' => 'alv',
  'pkr' => 'dra',
  'pku' => 'pqw',
  'smn' => 'smi',
  'bcq' => 'omv',
  'mkw' => 'bnt',
  'agj' => 'sem',
  'lgb' => 'pqe',
  'lue' => 'bnt',
  'pcm' => 'gmw',
  'tub' => 'azc',
  'tda' => 'son',
  'anz' => 'paa',
  'mvy' => 'inc',
  'noi' => 'inc',
  'mzt' => 'mkh',
  'aau' => 'paa',
  'sun' => 'pqw',
  'mgm' => 'pqe',
  'bxf' => 'pqe',
  'ath' => 'xnd',
  'gqr' => 'csu',
  'lrn' => 'pqe',
  'gdq' => 'sem',
  'afr' => 'gmw',
  'dsq' => 'son',
  'vme' => 'pqe',
  'onw' => 'nub',
  'tvy' => 'roa',
  'pbr' => 'bnt',
  'jil' => 'ngf',
  'tll' => 'bnt',
  'tec' => 'sdv',
  'ges' => 'pqe',
  'unk' => 'awd',
  'nwb' => 'kro',
  'nfa' => 'pqe',
  'lsm' => 'bnt',
  'qva' => 'qwe',
  'rmf' => 'inc',
  'syi' => 'bnt',
  'wad' => 'pqe',
  'mkk' => 'bnt',
  'raa' => 'sit',
  'kqv' => 'poz',
  'khx' => 'bnt',
  'tso' => 'bnt',
  'fum' => 'alv',
  'roa' => 'itc',
  'swm' => 'ngf',
  'kao' => 'dmn',
  'saj' => 'paa',
  'mpv' => 'ngf',
  'run' => 'bnt',
  'gmu' => 'ngf',
  'msi' => 'poz',
  'dir' => 'alv',
  'ras' => 'kdo',
  'mkf' => 'cdc',
  'sor' => 'cdc',
  'xkl' => 'poz',
  'bzd' => 'cba',
  'agc' => 'alv',
  'peb' => 'hok',
  'bwb' => 'pqe',
  'ktk' => 'pqe',
  'lea' => 'bnt',
  'yik' => 'sit',
  'tre' => 'pqe',
  'zoq' => 'cai',
  'mkx' => 'mno',
  'xho' => 'bnt',
  'bpz' => 'pqe',
  'hmg' => 'hmx',
  'mot' => 'cba',
  'swa' => 'bnt',
  'goh' => 'gmw',
  'pcf' => 'dra',
  'gbm' => 'inc',
  'duq' => 'pqw',
  'krl' => 'fiu',
  'tuk' => 'trk',
  'klx' => 'pqe',
  'jax' => 'poz',
  'nlo' => 'bnt',
  'hau' => 'cdc',
  'mzv' => 'alv',
  'zyn' => 'tai',
  'mon' => 'xgn',
  'lka' => 'pqe',
  'zaz' => 'cdc',
  'bja' => 'bnt',
  'ley' => 'pqw',
  'pbt' => 'ira',
  'nuo' => 'mkh',
  'tpr' => 'tup',
  'ikl' => 'alv',
  'ztl' => 'omq',
  'tgi' => 'pqe',
  'zbw' => 'pqw',
  'zlj' => 'tai',
  'dza' => 'alv',
  'bwz' => 'bnt',
  'yyz' => 'sit',
  'hrw' => 'pqe',
  'piy' => 'cdc',
  'oub' => 'kro',
  'phi' => 'pqw',
  'nxe' => 'pqe',
  'lyg' => 'mkh',
  'san' => 'pra',
  'xsb' => 'poz',
  'bri' => 'bnt',
  'isa' => 'ngf',
  'kxb' => 'alv',
  'teu' => 'ssa',
  'nku' => 'alv',
  'trj' => 'cdc',
  'lcp' => 'mkh',
  'sdo' => 'poz',
  'juy' => 'mun',
  'ded' => 'ngf',
  'bzn' => 'pqe',
  'tgn' => 'poz',
  'trf' => 'gmw',
  'oma' => 'sio',
  'kwm' => 'bnt',
  'vmw' => 'bnt',
  'vkt' => 'poz',
  'sce' => 'xgn',
  'xac' => 'sit',
  'ymn' => 'pqe',
  'crx' => 'ath',
  'png' => 'alv',
  'xcl' => 'hyx',
  'kcs' => 'cdc',
  'min' => 'pqw',
  'prw' => 'ngf',
  'tak' => 'cdc',
  'khr' => 'mun',
  'kmh' => 'ngf',
  'umu' => 'alg',
  'xct' => 'sit',
  'klh' => 'ngf',
  'ngb' => 'alv',
  'akh' => 'ngf',
  'kjv' => 'zls',
  'mqj' => 'poz',
  'ctg' => 'inc',
  'saa' => 'cdc',
  'taa' => 'ath',
  'okx' => 'alv',
  'mli' => 'poz',
  'dub' => 'inc',
  'aju' => 'sem',
  'mzm' => 'alv',
  'cfd' => 'alv',
  'knx' => 'poz',
  'bvi' => 'alv',
  'syn' => 'sem',
  'bac' => 'poz',
  'kyb' => 'poz',
  'jdg' => 'inc',
  'giz' => 'cdc',
  'mvn' => 'pqe',
  'uli' => 'pqe',
  'dnn' => 'dmn',
  'kfh' => 'dra',
  'eka' => 'alv',
  'urn' => 'pqe',
  'glo' => 'cdc',
  'kef' => 'alv',
  'nkt' => 'bnt',
  'anl' => 'sit',
  'spe' => 'pqe',
  'nht' => 'nah',
  'kbp' => 'alv',
  'zpv' => 'omq',
  'kov' => 'alv',
  'lam' => 'bnt',
  'guh' => 'awd',
  'btn' => 'poz',
  'nml' => 'alv',
  'lol' => 'bnt',
  'uan' => 'tai',
  'cyo' => 'poz',
  'jvd' => 'gmw',
  'luj' => 'bnt',
  'gob' => 'awd',
  'xzh' => 'sit',
  'tbn' => 'cba',
  'tdh' => 'sit',
  'jak' => 'poz',
  'xti' => 'omq',
  'stm' => 'ngf',
  'hca' => 'inc',
  'ywu' => 'sit',
  'kbl' => 'ssa',
  'gul' => 'gmw',
  'bap' => 'sit',
  'bnp' => 'pqe',
  'add' => 'alv',
  'emk' => 'dmn',
  'adi' => 'sit',
  'hei' => 'wak',
  'tny' => 'bnt',
  'ell' => 'grk',
  'kvz' => 'ngf',
  'xsd' => 'ine',
  'qwe' => 'sai',
  'sma' => 'smi',
  'iko' => 'alv',
  'tum' => 'bnt',
  'bwe' => 'kar',
  'skg' => 'poz',
  'kyy' => 'ngf',
  'mfc' => 'alv',
  'xpq' => 'alg',
  'nmn' => 'khi',
  'qhr' => 'itc',
  'fur' => 'roa',
  'bqk' => 'bad',
  'tul' => 'alv',
  'bgg' => 'sit',
  'lhi' => 'sit',
  'mjg' => 'xgn',
  'bba' => 'alv',
  'hro' => 'cmc',
  'gbx' => 'alv',
  'nbc' => 'sit',
  'jnl' => 'sit',
  'kew' => 'ngf',
  'nxi' => 'bnt',
  'plb' => 'pqe',
  'sil' => 'alv',
  'ikv' => 'alv',
  'tlj' => 'bnt',
  'baa' => 'pqe',
  'drd' => 'sit',
  'bsb' => 'poz',
  'cir' => 'pqe',
  'rmn' => 'inc',
  'sbs' => 'bnt',
  'nah' => 'azc',
  'anp' => 'inc',
  'gka' => 'ngf',
  'gwd' => 'cus',
  'mxb' => 'omq',
  'myh' => 'wak',
  'ndi' => 'alv',
  'nag' => 'inc',
  'nwi' => 'pqe',
  'lak' => 'alv',
  'kzl' => 'pqe',
  'mcn' => 'cdc',
  'hap' => 'ngf',
  'mdk' => 'csu',
  'pmb' => 'znd',
  'dij' => 'pqe',
  'emu' => 'dra',
  'gye' => 'alv',
  'wew' => 'pqe',
  'gha' => 'ber',
  'rmy' => 'inc',
  'sti' => 'mkh',
  'tcy' => 'dra',
  'mbo' => 'bnt',
  'wmm' => 'poz',
  'nbv' => 'alv',
  'yur' => 'aql',
  'rnl' => 'sit',
  'nij' => 'pqw',
  'wrn' => 'kdo',
  'wwo' => 'pqe',
  'lej' => 'bnt',
  'kzp' => 'poz',
  'blq' => 'pqe',
  'mqu' => 'sdv',
  'zpe' => 'omq',
  'iku' => 'esx',
  'gcn' => 'ngf',
  'eot' => 'alv',
  'apt' => 'sit',
  'bua' => 'xgn',
  'sam' => 'sem',
  'gnz' => 'alv',
  'bgf' => 'alv',
  'abl' => 'pqw',
  'bxc' => 'bnt',
  'txa' => 'poz',
  'bbz' => 'sem',
  'mal' => 'dra',
  'tpn' => 'tup',
  'buh' => 'hmx',
  'ibe' => 'alv',
  'trx' => 'poz',
  'ghn' => 'pqe',
  'art' => 'mul',
  'wry' => 'inc',
  'mrq' => 'pqe',
  'dev' => 'ngf',
  'arq' => 'sem',
  'flr' => 'bnt',
  'khl' => 'pqe',
  'grn' => 'tup',
  'akd' => 'alv',
  'daa' => 'cdc',
  'mnz' => 'ngf',
  'snp' => 'ngf',
  'fue' => 'alv',
  'wet' => 'pqe',
  'yrl' => 'tup',
  'zum' => 'ira',
  'clw' => 'trk',
  'fag' => 'ngf',
  'wiy' => 'aql',
  'pnt' => 'grk',
  'tlx' => 'pqe',
  'tet' => 'pqe',
  'mbd' => 'mno',
  'cwd' => 'alg',
  'iro' => 'nai',
  'trc' => 'omq',
  'brd' => 'sit',
  'bys' => 'alv',
  'cma' => 'mkh',
  'wkd' => 'pqe',
  'ate' => 'ngf',
  'cgc' => 'mno',
  'kzq' => 'sit',
  'mqc' => 'pqe',
  'avu' => 'csu',
  'apf' => 'poz',
  'sef' => 'alv',
  'pol' => 'zlw',
  'tld' => 'poz',
  'agq' => 'alv',
  'nkn' => 'bnt',
  'nke' => 'pqe',
  'kst' => 'alv',
  'che' => 'ccn',
  'trv' => 'fox',
  'smw' => 'pqw',
  'aho' => 'tai',
  'ije' => 'ijo',
  'krn' => 'kro',
  'xnt' => 'alg',
  'ghh' => 'sit',
  'kot' => 'cdc',
  'kzt' => 'poz',
  'uby' => 'ccn',
  'tol' => 'ath',
  'abc' => 'poz',
  'yij' => 'aus',
  'pme' => 'pqe',
  'bah' => 'gmw',
  'shw' => 'kdo',
  'nxa' => 'pqe',
  'wrx' => 'pqe',
  'vra' => 'pqe',
  'sng' => 'bnt',
  'tmt' => 'pqe',
  'yuw' => 'ngf',
  'ubu' => 'ngf',
  'kax' => 'paa',
  'kcg' => 'alv',
  'nnz' => 'bai',
  'juo' => 'alv',
  'dzl' => 'sit',
  'wof' => 'alv',
  'fod' => 'alv',
  'kde' => 'bnt',
  'ghc' => 'cel',
  'bkn' => 'poz',
  'zpj' => 'omq',
  'udu' => 'ssa',
  'lbm' => 'inc',
  'isn' => 'bnt',
  'mfy' => 'azc',
  'kna' => 'cdc',
  'mvw' => 'bnt',
  'abx' => 'pqw',
  'tcp' => 'sit',
  'lna' => 'bad',
  'mvo' => 'pqe',
  'zte' => 'omq',
  'kfl' => 'alv',
  'isi' => 'alv',
  'ywt' => 'sit',
  'hme' => 'hmx',
  'cpo' => 'dmn',
  'aqr' => 'pqe',
  'kuf' => 'mkh',
  'bwo' => 'omv',
  'urm' => 'ngf',
  'gnc' => 'ber',
  'mpl' => 'pqe',
  'kwc' => 'bnt',
  'xve' => 'cel',
  'mhq' => 'sio',
  'six' => 'ngf',
  'zos' => 'cai',
  'pgg' => 'inc',
  'cdo' => 'zhx',
  'par' => 'azc',
  'dmm' => 'alv',
  'cdd' => 'nai',
  'bhh' => 'ira',
  'pai' => 'alv',
  'bwd' => 'pqe',
  'nbo' => 'alv',
  'mqz' => 'pqe',
  'njn' => 'sit',
  'pls' => 'omq',
  'kvn' => 'cba',
  'smi' => 'fiu',
  'saq' => 'sdv',
  'wiv' => 'pqe',
  'irx' => 'ngf',
  'adl' => 'sit',
  'pek' => 'pqe',
  'ywq' => 'sit',
  'uji' => 'alv',
  'wnu' => 'ngf',
  'cro' => 'sio',
  'xse' => 'ngf',
  'bgz' => 'poz',
  'kkh' => 'tai',
  'biv' => 'alv',
  'nhb' => 'dmn',
  'leh' => 'bnt',
  'mde' => 'ssa',
  'scg' => 'poz',
  'kag' => 'poz',
  'uzn' => 'trk',
  'tpi' => 'gmw',
  'krp' => 'alv',
  'kyk' => 'phi',
  'vol' => 'art',
  'aln' => 'sqj',
  'bid' => 'cdc',
  'jms' => 'alv',
  'lbq' => 'pqe',
  'yrk' => 'syd',
  'tal' => 'cdc',
  'cng' => 'sit',
  'tpt' => 'cai',
  'bxu' => 'xgn',
  'szl' => 'zlw',
  'sar' => 'awd',
  'mlj' => 'cdc',
  'npo' => 'sit',
  'apm' => 'apa',
  'ono' => 'iro',
  'oaa' => 'tuw',
  'duk' => 'ngf',
  'arp' => 'alg',
  'zhi' => 'alv',
  'zms' => 'bnt',
  'heh' => 'bnt',
  'gid' => 'cdc',
  'sza' => 'mkh',
  'ull' => 'dra',
  'gvl' => 'csu',
  'ngz' => 'bnt',
  'tik' => 'alv',
  'ajt' => 'sem',
  'bdn' => 'cdc',
  'bft' => 'sit',
  'jeh' => 'mkh',
  'bzw' => 'alv',
  'itk' => 'roa',
  'xal' => 'xgn',
  'mvd' => 'pqe',
  'ktm' => 'pqe',
  'kjo' => 'inc',
  'phk' => 'tai',
  'tuy' => 'sdv',
  'bmq' => 'alv',
  'maj' => 'omq',
  'soo' => 'bnt',
  'tim' => 'ngf',
  'dmg' => 'poz',
  'scn' => 'roa',
  'mfj' => 'cdc',
  'koa' => 'pqe',
  'bjo' => 'bad',
  'pkn' => 'aus',
  'hmr' => 'sit',
  'kak' => 'phi',
  'swh' => 'bnt',
  'cnk' => 'sit',
  'zmz' => 'bad',
  'lcd' => 'pqe',
  'vnm' => 'pqe',
  'kjn' => 'aus',
  'tyj' => 'tai',
  'lef' => 'alv',
  'czo' => 'zhx',
  'wmh' => 'pqe',
  'gwc' => 'inc',
  'idc' => 'alv',
  'mzj' => 'dmn',
  'ptn' => 'pqe',
  'lzz' => 'ccs',
  'kjp' => 'kar',
  'cid' => 'hok',
  'brr' => 'pqe',
  'ndf' => 'bat',
  'sou' => 'tai',
  'ato' => 'alv',
  'gea' => 'cdc',
  'mhs' => 'pqe',
  'zuy' => 'cdc',
  'urj' => 'mul',
  'yul' => 'csu',
  'mei' => 'nub',
  'sok' => 'cdc',
  'trq' => 'omq',
  'nsf' => 'sit',
  'vas' => 'inc',
  'phv' => 'ira',
  'cab' => 'awd',
  'bwg' => 'bnt',
  'brc' => 'gmw',
  'tgl' => 'poz',
  'aab' => 'alv',
  'dmc' => 'ngf',
  'bwa' => 'pqe',
  'slk' => 'zlw',
  'ajz' => 'sit',
  'mgo' => 'alv',
  'now' => 'bnt',
  'ckv' => 'fox',
  'txb' => 'ine',
  'bfl' => 'bad',
  'fap' => 'alv',
  'bcl' => 'bik',
  'pad' => 'auf',
  'ndn' => 'bnt',
  'faj' => 'ngf',
  'xmc' => 'bnt',
  'sbq' => 'ngf',
  'juu' => 'cdc',
  'bol' => 'cdc',
  'kyn' => 'poz',
  'bda' => 'alv',
  'tht' => 'ath',
  'ksy' => 'inc',
  'oci' => 'roa',
  'wep' => 'gmw',
  'mva' => 'pqe',
  'iou' => 'ngf',
  'cua' => 'mkh',
  'otw' => 'alg',
  'phr' => 'inc',
  'doz' => 'omv',
  'bvt' => 'pqe',
  'dix' => 'pqe',
  'bma' => 'alv',
  'ror' => 'pqe',
  'kro' => 'alv',
  'thl' => 'inc',
  'atq' => 'poz',
  'sqh' => 'alv',
  'diz' => 'bnt',
  'lgn' => 'ssa',
  'lbk' => 'poz',
  'khu' => 'bnt',
  'kyc' => 'ngf',
  'tcb' => 'ath',
  'kcv' => 'bnt',
  'ljp' => 'pqw',
  'cen' => 'alv',
  'kah' => 'csu',
  'vbb' => 'pqe',
  'zad' => 'omq',
  'bru' => 'mkh',
  'brj' => 'pqe',
  'apa' => 'ath',
  'bbp' => 'bad',
  'rbl' => 'bik',
  'bzb' => 'poz',
  'kcr' => 'kdo',
  'ald' => 'kro',
  'spp' => 'alv',
  'gut' => 'cba',
  'cmc' => 'pqw',
  'bvv' => 'awd',
  'snr' => 'ngf',
  'cuv' => 'cdc',
  'pmq' => 'oto',
  'kkt' => 'sit',
  'xsn' => 'alv',
  'mlb' => 'bnt',
  'tql' => 'pqe',
  'cop' => 'afa',
  'oum' => 'pqe',
  'npy' => 'poz',
  'hmh' => 'hmx',
  'sto' => 'sio',
  'fuq' => 'alv',
  'jut' => 'gmq',
  'nhz' => 'nah',
  'xma' => 'bnt',
  'kpk' => 'alv',
  'lmk' => 'sit',
  'xnb' => 'fox',
  'gbz' => 'ira',
  'ess' => 'ypk',
  'aai' => 'pqe',
  'sgz' => 'pqe',
  'naf' => 'ngf',
  'grh' => 'alv',
  'csu' => 'ssa',
  'sts' => 'inc',
  'phn' => 'sem',
  'loo' => 'bnt',
  'bps' => 'poz',
  'mgy' => 'bnt',
  'yiv' => 'sit',
  'mwa' => 'pqe',
  'sst' => 'ngf',
  'mmj' => 'mun',
  'cjm' => 'cmc',
  'ifm' => 'bnt',
  'gde' => 'cdc',
  'gnj' => 'dmn',
  'ruk' => 'alv',
  'kmi' => 'alv',
  'dhd' => 'inc',
  'kco' => 'ngf',
  'nrm' => 'pqw',
  'sdm' => 'poz',
  'fui' => 'alv',
  'cpx' => 'zhx',
  'caf' => 'ath',
  'dug' => 'bnt',
  'yaq' => 'azc',
  'ils' => 'sgn',
  'kht' => 'tai',
  'shz' => 'alv',
  'zao' => 'omq',
  'chu' => 'zls',
  'amh' => 'sem',
  'hoa' => 'pqe',
  'nos' => 'sit',
  'ero' => 'sit',
  'gkd' => 'ngf',
  'bje' => 'hmx',
  'ttf' => 'bnt',
  'tve' => 'pqe',
  'asa' => 'bnt',
  'eee' => 'tai',
  'ktn' => 'tup',
  'pcl' => 'inc',
  'dus' => 'sit',
  'xua' => 'dra',
  'lat' => 'itc',
  'uku' => 'alv',
  'ypb' => 'sit',
  'qwc' => 'qwe',
  'llm' => 'poz',
  'tyi' => 'bnt',
  'ojv' => 'pqe',
  'bpd' => 'bad',
  'cwb' => 'bnt',
  'bmu' => 'ngf',
  'ets' => 'alv',
  'cay' => 'iro',
  'nee' => 'pqe',
  'moa' => 'dmn',
  'pam' => 'phi',
  'bwt' => 'bnt',
  'reg' => 'bnt',
  'wlx' => 'alv',
  'zkt' => 'xgn',
  'hhr' => 'alv',
  'bvg' => 'bnt',
  'yzk' => 'sit',
  'xsi' => 'pqe',
  'ymz' => 'sit',
  'nne' => 'bnt',
  'nep' => 'inc',
  'zyb' => 'tai',
  'mqa' => 'pqe',
  'bnq' => 'phi',
  'xxb' => 'alv',
  'kzy' => 'bnt',
  'jnj' => 'omv',
  'faf' => 'pqe',
  'ena' => 'ngf',
  'guc' => 'awd',
  'snz' => 'ngf',
  'ugo' => 'sit',
  'wbf' => 'alv',
  'smh' => 'sit',
  'mby' => 'inc',
  'biq' => 'pqe',
  'dur' => 'alv',
  'yoy' => 'tai',
  'yah' => 'ira',
  'dyi' => 'alv',
  'aps' => 'pqe',
  'hna' => 'cdc',
  'bxr' => 'xgn',
  'gri' => 'pqe',
  'mhz' => 'pqe',
  'kdc' => 'bnt',
  'ple' => 'pqe',
  'mcy' => 'pqe',
  'mgr' => 'bnt',
  'mmr' => 'hmx',
  'pqa' => 'cdc',
  'nub' => 'sdv',
  'nik' => 'mkh',
  'zty' => 'omq',
  'ctp' => 'omq',
  'lum' => 'bnt',
  'aua' => 'pqe',
  'sco' => 'gmw',
  'iru' => 'dra',
  'mtn' => 'cai',
  'srf' => 'pqe',
  'tmg' => 'roa',
  'quk' => 'qwe',
  'sve' => 'pqe',
  'smd' => 'bnt',
  'quh' => 'qwe',
  'mea' => 'alv',
  'dgx' => 'ngf',
  'cuy' => 'cai',
  'vif' => 'bnt',
  'txe' => 'poz',
  'ahk' => 'sit',
  'ace' => 'cmc',
  'sne' => 'poz',
  'bkx' => 'pqe',
  'mfp' => 'poz',
  'thv' => 'ber',
  'tth' => 'mkh',
  'tzn' => 'pqe',
  'tne' => 'phi',
  'ntd' => 'poz',
  'pmu' => 'inc',
  'tcl' => 'sit',
  'sbu' => 'sit',
  'jbn' => 'ber',
  'cwg' => 'mkh',
  'geq' => 'znd',
  'jah' => 'mkh',
  'swp' => 'pqe',
  'nye' => 'bnt',
  'tic' => 'kdo',
  'kaw' => 'pqw',
  'ply' => 'mkh',
  'lgm' => 'bnt',
  'ypn' => 'sit',
  'moo' => 'mkh',
  'anf' => 'alv',
  'swg' => 'gmw',
  'tfi' => 'alv',
  'vwa' => 'mkh',
  'twm' => 'tbq',
  'bju' => 'alv',
  'aio' => 'tai',
  'ndo' => 'bnt',
  'qpp' => 'inc',
  'shs' => 'sal',
  'yai' => 'ira',
  'fao' => 'gmq',
  'olm' => 'alv',
  'zqe' => 'tai',
  'gcr' => 'roa',
  'spo' => 'sal',
  'bad' => 'alv',
  'hmp' => 'hmx',
  'mdq' => 'bnt',
  'vum' => 'bnt',
  'apb' => 'pqe',
  'jun' => 'mun',
  'kpp' => 'kar',
  'pip' => 'cdc',
  'nkw' => 'bnt',
  'ktl' => 'ira',
  'ccj' => 'alv',
  'bjn' => 'pqw',
  'yog' => 'poz',
  'nob' => 'gmq',
  'zch' => 'tai',
  'hik' => 'pqe',
  'ulb' => 'alv',
  'dnk' => 'pqe',
  'gla' => 'cel',
  'nii' => 'ngf',
  'lix' => 'poz',
  'ngu' => 'nah',
  'meh' => 'omq',
  'cte' => 'omq',
  'gry' => 'kro',
  'hbb' => 'cdc',
  'mqi' => 'pqe',
  'nyn' => 'bnt',
  'fuv' => 'alv',
  'mwu' => 'csu',
  'kis' => 'pqe',
  'ycn' => 'awd',
  'pbo' => 'alv',
  'tjn' => 'dmn',
  'muh' => 'alv',
  'kwr' => 'ngf',
  'mgn' => 'alv',
  'fsl' => 'sgn',
  'man' => 'dmn',
  'bqw' => 'alv',
  'sct' => 'mkh',
  'jiy' => 'sit',
  'vmb' => 'aus',
  'inb' => 'qwe',
  'lub' => 'bnt',
  'pix' => 'pqe',
  'abw' => 'ngf',
  'cqu' => 'qwe',
  'skw' => 'gmw',
  'mlq' => 'dmn',
  'sxw' => 'alv',
  'qxr' => 'qwe',
  'uzb' => 'trk',
  'xkk' => 'mkh',
  'ahg' => 'cus',
  'atn' => 'ira',
  'ssl' => 'alv',
  'tkx' => 'ngf',
  'pce' => 'mkh',
  'rcf' => 'roa',
  'gnq' => 'poz',
  'kzi' => 'poz',
  'tkt' => 'inc',
  'sie' => 'bnt',
  'nrn' => 'gmq',
  'nyl' => 'mkh',
  'skf' => 'tup',
  'toi' => 'bnt',
  'tzl' => 'art',
  'mkb' => 'inc',
  'agu' => 'myn',
  'xpr' => 'ira',
  'kes' => 'alv',
  'xuj' => 'dra',
  'atm' => 'poz',
  'nga' => 'alv',
  'myj' => 'alv',
  'xon' => 'alv',
  'haq' => 'bnt',
  'ibo' => 'alv',
  'nmw' => 'pqe',
  'val' => 'pqe',
  'gaq' => 'mun',
  'sii' => 'mkh',
  'mnf' => 'alv',
  'ndg' => 'bnt',
  'mir' => 'cai',
  'msa' => 'poz',
  'aor' => 'pqe',
  'yip' => 'sit',
  'bmc' => 'pqe',
  'tqr' => 'kdo',
  'ukr' => 'zle',
  'lok' => 'dmn',
  'sig' => 'alv',
  'sxl' => 'bat',
  'ddd' => 'sdv',
  'txg' => 'sit',
  'aoe' => 'ngf',
  'arw' => 'awd',
  'umm' => 'alv',
  'dnr' => 'ngf',
  'ogb' => 'alv',
  'awd' => 'sai',
  'nkg' => 'ngf',
  'mek' => 'pqe',
  'sjk' => 'smi',
  'adq' => 'alv',
  'ces' => 'zlw',
  'xsm' => 'alv',
  'mig' => 'omq',
  'ndj' => 'bnt',
  'oua' => 'ber',
  'tnq' => 'awd',
  'mlo' => 'alv',
  'muz' => 'sdv',
  'brk' => 'nub',
  'jkr' => 'sit',
  'crm' => 'alg',
  'kfx' => 'inc',
  'cou' => 'alv',
  'smk' => 'poz',
  'tkl' => 'pqe',
  'bhc' => 'pqe',
  'ggg' => 'inc',
  'lmi' => 'csu',
  'mpy' => 'pqe',
  'sch' => 'sit',
  'khq' => 'son',
  'sps' => 'pqe',
  'rou' => 'ssa',
  'jit' => 'bnt',
  'sdt' => 'ine',
  'xkf' => 'sit',
  'kph' => 'alv',
  'pnz' => 'alv',
  'cjh' => 'sal',
  'oac' => 'tuw',
  'gzi' => 'ira',
  'tlp' => 'cai',
  'pro' => 'roa',
  'mtv' => 'ngf',
  'nzd' => 'bnt',
  'btg' => 'kro',
  'pha' => 'hmx',
  'vin' => 'bnt',
  'gew' => 'cdc',
  'ada' => 'alv',
  'pnk' => 'awd',
  'slv' => 'zls',
  'ttb' => 'alv',
  'wmt' => 'aus',
  'mff' => 'alv',
  'vma' => 'aus',
  'rel' => 'cus',
  'epo' => 'art',
  'mxh' => 'csu',
  'moi' => 'alv',
  'nsd' => 'sit',
  'doe' => 'bnt',
  'div' => 'inc',
  'zhw' => 'alv',
  'thm' => 'mkh',
  'ijn' => 'ijo',
  'unz' => 'poz',
  'vor' => 'alv',
  'lbu' => 'pqe',
  'kkj' => 'bnt',
  'bsc' => 'alv',
  'chq' => 'omq',
  'kxa' => 'pqe',
  'ssy' => 'cus',
  'kzb' => 'pqe',
  'kli' => 'poz',
  'pag' => 'phi',
  'tmv' => 'bnt',
  'myk' => 'alv',
  'iow' => 'sio',
  'pga' => 'sem',
  'vel' => 'gmw',
  'sak' => 'bnt',
  'ccm' => 'poz',
  'dny' => 'auf',
  'hyx' => 'ine',
  'usu' => 'ngf',
  'hmm' => 'hmx',
  'xxk' => 'pqe',
  'gga' => 'pqe',
  'blw' => 'poz',
  'cce' => 'bnt',
  'cpf' => 'crp',
  'pej' => 'hok',
  'mbt' => 'mno',
  'akt' => 'pqe',
  'gra' => 'inc',
  'xsc' => 'ira',
  'bji' => 'cus',
  'ita' => 'roa',
  'awa' => 'inc',
  'une' => 'alv',
  'wun' => 'bnt',
  'aph' => 'sit',
  'ahs' => 'alv',
  'bok' => 'bnt',
  'len' => 'cai',
  'ksk' => 'sio',
  'bdo' => 'csu',
  'auo' => 'cdc',
  'myz' => 'sem',
  'lob' => 'alv',
  'boz' => 'dmn',
  'anr' => 'inc',
  'plv' => 'poz',
  'gpe' => 'gmw',
  'kya' => 'bnt',
  'prh' => 'poz',
  'xmx' => 'pqe',
  'and' => 'pqe',
  'cdh' => 'inc',
  'imy' => 'ine',
  'ymp' => 'pqe',
  'cla' => 'cdc',
  'nzb' => 'bnt',
  'alg' => 'aql',
  'nkd' => 'sit',
  'mgp' => 'sit',
  'mgj' => 'alv',
  'biu' => 'sit',
  'tck' => 'bnt',
  'cwe' => 'bnt',
  'ssi' => 'inc',
  'nap' => 'roa',
  'bmp' => 'ngf',
  'gdb' => 'dra',
  'alf' => 'alv',
  'jbo' => 'art',
  'kmz' => 'trk',
  'niu' => 'pqe',
  'tbm' => 'alv',
  'xpg' => 'ine',
  'mzq' => 'pqw',
  'ybn' => 'awd',
  'gaw' => 'ngf',
  'imo' => 'ngf',
  'mjr' => 'dra',
  'kus' => 'alv',
  'nyo' => 'bnt',
  'kfd' => 'dra',
  'src' => 'roa',
  'syk' => 'cdc',
  'poh' => 'myn',
  'abb' => 'bnt',
  'ndt' => 'alv',
  'pho' => 'sit',
  'nhi' => 'nah',
  'bux' => 'cdc',
  'sqi' => 'sqj',
  'huk' => 'pqe',
  'mwv' => 'pqw',
  'shv' => 'sem',
  'rbb' => 'mkh',
  'kej' => 'dra',
  'pim' => 'alg',
  'ktt' => 'ngf',
  'hij' => 'bnt',
  'vis' => 'dra',
  'skr' => 'inc',
  'grv' => 'kro',
  'cib' => 'alv',
  'nin' => 'alv',
  'pud' => 'poz',
  'tlo' => 'kdo',
  'ruh' => 'sit',
  'bbi' => 'bnt',
  'wmw' => 'bnt',
  'suc' => 'poz',
  'gmy' => 'grk',
  'grj' => 'kro',
  'kfn' => 'alv',
  'hns' => 'inc',
  'ngn' => 'alv',
  'tgw' => 'alv',
  'unu' => 'pqe',
  'nou' => 'ngf',
  'twb' => 'poz',
  'llp' => 'pqe',
  'psy' => 'alg',
  'cdi' => 'inc',
  'vmx' => 'omq',
  'tro' => 'sit',
  'maw' => 'alv',
  'nas' => 'paa',
  'wya' => 'iro',
  'erw' => 'pqe',
  'noq' => 'bnt',
  'syd' => 'urj',
  'maq' => 'omq',
  'yby' => 'ngf',
  'jer' => 'alv',
  'raz' => 'pqw',
  'zpr' => 'omq',
  'kjc' => 'pqw',
  'rmt' => 'inc',
  'yeu' => 'dra',
  'chj' => 'omq',
  'sbr' => 'poz',
  'xcr' => 'ine',
  'ulc' => 'tuw',
  'ssn' => 'cus',
  'nme' => 'sit',
  'xes' => 'ngf',
  'wno' => 'ngf',
  'bil' => 'alv',
  'rgk' => 'sit',
  'fal' => 'alv',
  'bho' => 'inc',
  'dln' => 'sit',
  'tou' => 'mkh',
  'kon' => 'bnt',
  'zpu' => 'omq',
  'sbk' => 'bnt',
  'ola' => 'sit',
  'nre' => 'sit',
  'kpz' => 'sdv',
  'ibm' => 'alv',
  'pcc' => 'tai',
  'xtj' => 'omq',
  'kwh' => 'pqe',
  'dgd' => 'alv',
  'tks' => 'ira',
  'rug' => 'pqe',
  'tbr' => 'kdo',
  'sin' => 'inc',
  'ttg' => 'poz',
  'xmb' => 'alv',
  'lrr' => 'sit',
  'lew' => 'poz',
  'trm' => 'iir',
  'sus' => 'dmn',
  'prg' => 'bat',
  'myu' => 'tup',
  'bqu' => 'bnt',
  'noe' => 'inc',
  'ghr' => 'inc',
  'opa' => 'alv',
  'xkj' => 'ira',
  'dhv' => 'pqe',
  'zoc' => 'cai',
  'hed' => 'cdc',
  'knn' => 'inc',
  'stq' => 'gmw',
  'huq' => 'cmc',
  'bfp' => 'alv',
  'bjt' => 'alv',
  'suk' => 'bnt',
  'rmx' => 'mkh',
  'las' => 'alv',
  'bnj' => 'poz',
  'xqt' => 'sem',
  'arv' => 'cus',
  'sea' => 'mkh',
  'hbn' => 'kdo',
  'gby' => 'alv',
  'zpn' => 'omq',
  'kqa' => 'ngf',
  'nsm' => 'sit',
  'snb' => 'poz',
  'bwj' => 'alv',
  'baf' => 'bnt',
  'nui' => 'bnt',
  'ahm' => 'kro',
  'bbu' => 'alv',
  'jam' => 'gmw',
  'pbu' => 'ira',
  'tdx' => 'pqw',
  'srv' => 'poz',
  'xao' => 'mkh',
  'eve' => 'tuw',
  'nho' => 'pqe',
  'tup' => 'sai',
  'tcw' => 'cai',
  'hur' => 'sal',
  'cde' => 'dra',
  'ztq' => 'omq',
  'ncd' => 'sit',
  'dma' => 'bnt',
  'ged' => 'alv',
  'kib' => 'kdo',
  'tpf' => 'pqe',
  'maz' => 'oto',
  'kyi' => 'pqw',
  'sia' => 'smi',
  'bta' => 'cdc',
  'fnb' => 'pqe',
  'gso' => 'alv',
  'yap' => 'pqe',
  'aek' => 'pqe',
  'nph' => 'sit',
  'kmu' => 'ngf',
  'bxe' => 'afa',
  'bee' => 'sit',
  'kqt' => 'poz',
  'qer' => 'gmq',
  'bdk' => 'ccn',
  'sbc' => 'pqe',
  'wbj' => 'cus',
  'tqt' => 'cai',
  'one' => 'iro',
  'mnn' => 'mkh',
  'lbe' => 'ccn',
  'ldd' => 'cdc',
  'sol' => 'pqe',
  'mlc' => 'tai',
  'nuj' => 'bnt',
  'bge' => 'inc',
  'bkp' => 'bnt',
  'tdo' => 'alv',
  'hut' => 'sit',
  'kbj' => 'bnt',
  'nqg' => 'alv',
  'lid' => 'pqe',
  'bkk' => 'inc',
  'sev' => 'alv',
  'vrs' => 'pqe',
  'skx' => 'poz',
  'csw' => 'alg',
  'mnq' => 'mkh',
  'taz' => 'kdo',
  'ytw' => 'ngf',
  'whg' => 'ngf',
  'ssm' => 'mkh',
  'sut' => 'omq',
  'iyo' => 'alv',
  'sdc' => 'roa',
  'mjm' => 'pqe',
  'gux' => 'alv',
  'sry' => 'pqe',
  'omb' => 'pqe',
  'btm' => 'btk',
  'bhj' => 'sit',
  'daf' => 'dmn',
  'njy' => 'bnt',
  'nnn' => 'cdc',
  'yix' => 'sit',
  'hrt' => 'sem',
  'zil' => 'dmn',
  'ign' => 'awd',
  'wok' => 'alv',
  'bqa' => 'alv',
  'lek' => 'pqe',
  'ccs' => 'cau',
  'mvp' => 'poz',
  'sll' => 'ngf',
  'guz' => 'bnt',
  'cpa' => 'omq',
  'liy' => 'bad',
  'hdy' => 'cus',
  'coz' => 'omq',
  'abi' => 'alv',
  'kgb' => 'pqe',
  'zph' => 'omq',
  'hgw' => 'pqe',
  'rad' => 'cmc',
  'vki' => 'alv',
  'pst' => 'ira',
  'phd' => 'inc',
  'xns' => 'sit',
  'wbk' => 'iir',
  'fvr' => 'ssa',
  'lia' => 'alv',
  'kpr' => 'ngf',
  'grw' => 'pqe',
  'sgh' => 'ira',
  'asi' => 'ngf',
  'kab' => 'ber',
  'fas' => 'ira',
  'zpl' => 'omq',
  'ptw' => 'sal',
  'wbb' => 'pqe',
  'mlr' => 'cdc',
  'haw' => 'pqe',
  'zpd' => 'omq',
  'mhw' => 'bnt',
  'slw' => 'ngf',
  'tsh' => 'cdc',
  'gmn' => 'alv',
  'bab' => 'alv',
  'mdt' => 'bnt',
  'doy' => 'alv',
  'bdb' => 'poz',
  'sac' => 'alg',
  'swn' => 'ber',
  'kwx' => 'dra',
  'nmz' => 'alv',
  'xaa' => 'sem',
  'qud' => 'qwe',
  'tbg' => 'ngf',
  'rak' => 'pqe',
  'tzj' => 'myn',
  'csn' => 'sgn',
  'pgk' => 'pqe',
  'juk' => 'alv',
  'koq' => 'bnt',
  'clm' => 'sal',
  'ndy' => 'csu',
  'hiw' => 'pqe',
  'kmf' => 'ngf',
  'orn' => 'poz',
  'yes' => 'alv',
  'aik' => 'alv',
  'sso' => 'pqe',
  'jia' => 'cdc',
  'sqr' => 'sem',
  'hoi' => 'ath',
  'iso' => 'alv',
  'new' => 'sit',
  'mev' => 'dmn',
  'okh' => 'ira',
  'zzj' => 'tai',
  'kxl' => 'dra',
  'omo' => 'ngf',
  'inz' => 'hok',
  'rol' => 'poz',
  'wwa' => 'alv',
  'kcc' => 'alv',
  'sle' => 'dra',
  'chy' => 'alg',
  'fuf' => 'alv',
  'tpv' => 'pqe',
  'mzs' => 'roa',
  'cmo' => 'mkh',
  'twt' => 'tup',
  'nxo' => 'bnt',
  'bkw' => 'bnt',
  'kod' => 'pqe',
  'qxa' => 'qwe',
  'cll' => 'alv',
  'jhi' => 'mkh',
  'loe' => 'poz',
  'dsn' => 'pqe',
  'ypk' => 'esx',
  'bot' => 'csu',
  'boo' => 'dmn',
  'hpo' => 'sit',
  'wlc' => 'bnt',
  'bnl' => 'cus',
  'ors' => 'poz',
  'mlg' => 'poz',
  'iya' => 'alv',
  'mag' => 'inc',
  'ibh' => 'cmc',
  'alq' => 'alg',
  'lke' => 'bnt',
  'mog' => 'phi',
  'lzn' => 'sit',
  'ton' => 'pqe',
  'lgq' => 'alv',
  'bhe' => 'inc',
  'orh' => 'tuw',
  'czk' => 'zlw',
  'doi' => 'inc',
  'lbf' => 'sit',
  'vlp' => 'pqe',
  'huo' => 'mkh',
  'mlp' => 'ngf',
  'rri' => 'pqe',
  'ikk' => 'alv',
  'lui' => 'azc',
  'nsu' => 'nah',
  'bza' => 'dmn',
  'nmo' => 'sit',
  'cpc' => 'awd',
  'elh' => 'nub',
  'luz' => 'ira',
  'kkd' => 'alv',
  'mib' => 'omq',
  'kqk' => 'alv',
  'vmr' => 'bnt',
  'bsp' => 'alv',
  'jmb' => 'cdc',
  'bbn' => 'pqe',
  'gak' => 'paa',
  'oni' => 'pqe',
  'ktj' => 'kro',
  'haj' => 'inc',
  'tsz' => 'cai',
  'oar' => 'sem',
  'dmn' => 'nic',
  'ala' => 'alv',
  'jku' => 'alv',
  'azn' => 'nah',
  'gmw' => 'gem',
  'pkg' => 'pqe',
  'nkp' => 'pqe',
  'ngl' => 'bnt',
  'crj' => 'alg',
  'blc' => 'sal',
  'raf' => 'sit',
  'ksm' => 'alv',
  'cos' => 'roa',
  'mie' => 'omq',
  'ema' => 'alv',
  'mcj' => 'alv',
  'kgk' => 'tup',
  'toj' => 'myn',
  'jpn' => 'jpx',
  'twu' => 'pqe',
  'cnu' => 'ber',
  'ior' => 'sem',
  'tiu' => 'poz',
  'mok' => 'paa',
  'lua' => 'bnt',
  'lbv' => 'pqe',
  'bub' => 'alv',
  'otm' => 'oto',
  'sid' => 'cus',
  'niq' => 'sdv',
  'auu' => 'ngf',
  'ped' => 'ngf',
  'aji' => 'pqe',
  'les' => 'csu',
  'blj' => 'poz',
  'nhp' => 'nah',
  'dwz' => 'inc',
  'rtm' => 'pqe',
  'ilv' => 'alv',
  'mzn' => 'ira',
  'pub' => 'sit',
  'utu' => 'ngf',
  'srk' => 'poz',
  'wsi' => 'pqe',
  'tep' => 'azc',
  'ppi' => 'hok',
  'nmq' => 'bnt',
  'kdt' => 'mkh',
  'nyy' => 'bnt',
  'icr' => 'gmw',
  'kdu' => 'nub',
  'mes' => 'cdc',
  'kyf' => 'kro',
  'ich' => 'alv',
  'mgl' => 'pqe',
  'nma' => 'sit',
  'agf' => 'pqe',
  'das' => 'kro',
  'lmu' => 'pqe',
  'xke' => 'poz',
  'tkg' => 'pqw',
  'kjb' => 'myn',
  'sas' => 'pqw',
  'nfr' => 'alv',
  'sgc' => 'sdv',
  'knj' => 'myn',
  'bmd' => 'alv',
  'tgb' => 'poz',
  'rea' => 'ngf',
  'shu' => 'sem',
  'nhn' => 'nah',
  'nsa' => 'sit',
  'bul' => 'zls',
  'kqw' => 'pqe',
  'kek' => 'myn',
  'bwc' => 'bnt',
  'spl' => 'ngf',
  'krv' => 'mkh',
  'tem' => 'alv',
  'rro' => 'pqe',
  'abo' => 'alv',
  'mjt' => 'dra',
  'gab' => 'cdc',
  'zhd' => 'tai',
  'tee' => 'cai',
  'kss' => 'alv',
  'mxp' => 'cai',
  'xwl' => 'alv',
  'ypm' => 'sit',
  'jab' => 'alv',
  'coa' => 'poz',
  'bdu' => 'bnt',
  'jaa' => 'auf',
  'twn' => 'alv',
  'pmr' => 'ngf',
  'kul' => 'cdc',
  'rof' => 'bnt',
  'esi' => 'esx',
  'biw' => 'bnt',
  'sqa' => 'alv',
  'mta' => 'mno',
  'mju' => 'dra',
  'nok' => 'sal',
  'dii' => 'bnt',
  'ywl' => 'sit',
  'pac' => 'mkh',
  'chm' => 'urj',
  'bmi' => 'csu',
  'tgj' => 'sit',
  'tgg' => 'pqe',
  'uum' => 'trk',
  'cip' => 'omq',
  'jod' => 'dmn',
  'wms' => 'ngf',
  'rmv' => 'art',
  'mml' => 'mkh',
  'yot' => 'alv',
  'spr' => 'pqe',
  'gas' => 'inc',
  'kip' => 'sit',
  'gbh' => 'alv',
  'kac' => 'sit',
  'khj' => 'alv',
  'tlb' => 'paa',
  'uiv' => 'alv',
  'mlu' => 'pqe',
  'thk' => 'bnt',
  'kcw' => 'bnt',
  'cux' => 'omq',
  'suw' => 'bnt',
  'ilu' => 'pqe',
  'ulw' => 'cai',
  'deg' => 'alv',
  'duf' => 'pqe',
  'gji' => 'cdc',
  'piv' => 'pqe',
  'spt' => 'sit',
  'mqn' => 'pqw',
  'hui' => 'ngf',
  'sda' => 'pqw',
  'kft' => 'inc',
  'biy' => 'mun',
  'yid' => 'gmw',
  'kkv' => 'poz',
  'ist' => 'roa',
  'snq' => 'bnt',
  'cvn' => 'omq',
  'tyz' => 'tai',
  'kjk' => 'pqw',
  'crk' => 'alg',
  'lwl' => 'mkh',
  'nno' => 'gmq',
  'mhi' => 'csu',
  'srn' => 'gmw',
  'mjj' => 'ngf',
  'mrm' => 'pqe',
  'nem' => 'pqe',
  'blm' => 'csu',
  'mwc' => 'pqe',
  'bwq' => 'dmn',
  'atv' => 'trk',
  'byv' => 'bai',
  'cco' => 'omq',
  'duu' => 'tbq',
  'pll' => 'mkh',
  'rmp' => 'ngf',
  'iki' => 'alv',
  'mxe' => 'pqe',
  'kec' => 'kdo',
  'bro' => 'sit',
  'thn' => 'dra',
  'ajp' => 'sem',
  'urk' => 'poz',
  'apc' => 'sem',
  'hul' => 'pqe',
  'lbb' => 'pqe',
  'vkk' => 'poz',
  'ymi' => 'sit',
  'mww' => 'hmx',
  'dkx' => 'cdc',
  'urr' => 'pqe',
  'wuy' => 'pqe',
  'gli' => 'pqe',
  'gle' => 'cel',
  'kxd' => 'pqw',
  'bxd' => 'sit',
  'ltu' => 'pqe',
  'hmi' => 'hmx',
  'tsa' => 'bnt',
  'wam' => 'alg',
  'rka' => 'mkh',
  'ruu' => 'poz',
  'zmb' => 'bnt',
  'rjs' => 'inc',
  'daq' => 'dra',
  'gan' => 'zhx',
  'ttu' => 'pqe',
  'mel' => 'poz',
  'lht' => 'pqe',
  'kvf' => 'cdc',
  'cel' => 'ine',
  'kjy' => 'ngf',
  'xwo' => 'xgn',
  'crw' => 'mkh',
  'jow' => 'dmn',
  'sbb' => 'pqe',
  'pwn' => 'fox',
  'ila' => 'pqe',
  'auj' => 'ber',
  'sml' => 'pqw',
  'bel' => 'zle',
  'bki' => 'pqe',
  'crc' => 'pqe',
  'gce' => 'ath',
  'bbe' => 'alv',
  'aut' => 'pqe',
  'hye' => 'hyx',
  'ahi' => 'kro',
  'ses' => 'son',
  'mhb' => 'bnt',
  'nge' => 'alv',
  'svx' => 'bat',
  'jrb' => 'sem',
  'vap' => 'sit',
  'sdx' => 'poz',
  'ppu' => 'map',
  'zam' => 'omq',
  'mij' => 'alv',
  'tvl' => 'pqe',
  'ybo' => 'ngf',
  'mjq' => 'dra',
  'clh' => 'inc',
  'zsm' => 'poz',
  'duh' => 'inc',
  'nbr' => 'alv',
  'fos' => 'fox',
  'moh' => 'iro',
  'otq' => 'oto',
  'ktc' => 'cdc',
  'akv' => 'ccn',
  'itd' => 'poz',
  'oos' => 'ira',
  'ory' => 'inc',
  'yre' => 'dmn',
  'xsr' => 'sit',
  'idu' => 'alv',
  'kim' => 'trk',
  'jle' => 'kdo',
  'wmc' => 'ngf',
  'pww' => 'kar',
  'xas' => 'syd',
  'wav' => 'alv',
  'wbl' => 'ira',
  'irk' => 'cus',
  'nym' => 'bnt',
  'nbi' => 'sit',
  'gox' => 'bad',
  'ddo' => 'ccn',
  'mii' => 'omq',
  'npa' => 'sit',
  'sge' => 'poz',
  'hah' => 'pqe',
  'lus' => 'sit',
  'yvt' => 'awd',
  'txm' => 'poz',
  'mnb' => 'poz',
  'tmh' => 'ber',
  'fkk' => 'cdc',
  'pea' => 'poz',
  'ikz' => 'bnt',
  'lmo' => 'roa',
  'grd' => 'cdc',
  'dtp' => 'poz',
  'asb' => 'sio',
  'sla' => 'ine',
  'odk' => 'inc',
  'roh' => 'roa',
  'nxm' => 'ber',
  'rus' => 'zle',
  'lkj' => 'poz',
  'ara' => 'sem',
  'sdb' => 'ira',
  'dcc' => 'inc',
  'lyn' => 'bnt',
  'abk' => 'ccn',
  'viv' => 'pqe',
  'srp' => 'zls',
  'lih' => 'pqe',
  'skc' => 'ngf',
  'tiz' => 'tai',
  'tos' => 'cai',
  'enn' => 'alv',
  'koo' => 'bnt',
  'hod' => 'cdc',
  'gxx' => 'kro',
  'pbi' => 'cdc',
  'ztp' => 'omq',
  'sha' => 'alv',
  'onu' => 'pqe',
  'nss' => 'pqe',
  'tvu' => 'bnt',
  'hia' => 'cdc',
  'tis' => 'poz',
  'mbp' => 'cba',
  'dux' => 'dmn',
  'hal' => 'mkh',
  'gsw' => 'gmw',
  'mwi' => 'pqe',
  'knq' => 'mkh',
  'cad' => 'cdd',
  'khw' => 'inc',
  'gog' => 'bnt',
  'ifa' => 'poz',
  'jbe' => 'ber',
  'quy' => 'qwe',
  'zmx' => 'bnt',
  'xrg' => 'aus',
  'bfj' => 'alv',
  'fam' => 'alv',
  'sdn' => 'roa',
  'ydg' => 'ira',
  'lox' => 'pqe',
  'wsr' => 'ngf',
  'sjl' => 'sit',
  'ige' => 'alv',
  'cnh' => 'sit',
  'xem' => 'poz',
  'bcr' => 'ath',
  'igl' => 'alv',
  'cdn' => 'sit',
  'cur' => 'sit',
  'qum' => 'myn',
  'bce' => 'alv',
  'gop' => 'pqe',
  'twp' => 'pqe',
  'uzs' => 'trk',
  'ane' => 'pqe',
  'mid' => 'sem',
  'top' => 'cai',
  'wll' => 'nub',
  'cwa' => 'bnt',
  'row' => 'pqe',
  'ycp' => 'sit',
  'cia' => 'pqw',
  'sxg' => 'sit',
  'peq' => 'hok',
  'obr' => 'sit',
  'lhm' => 'sit',
  'gcl' => 'gmw',
  'mqy' => 'pqe',
  'cai' => 'mul',
  'dil' => 'nub',
  'kte' => 'sit',
  'sgt' => 'sit',
  'tli' => 'xnd',
  'qxu' => 'qwe',
  'rod' => 'alv',
  'drr' => 'pqe',
  'fuh' => 'alv',
  'srg' => 'poz',
  'chw' => 'bnt',
  'wym' => 'gmw',
  'tgp' => 'pqe',
  'mhe' => 'mkh',
  'bin' => 'alv',
  'ifk' => 'poz',
  'urd' => 'inc',
  'alt' => 'trk',
  'bmj' => 'inc',
  'ruf' => 'bnt',
  'lwt' => 'pqe',
  'yal' => 'dmn',
  'nib' => 'ngf',
  'mwt' => 'poz',
  'gdg' => 'poz',
  'rgn' => 'roa',
  'pkp' => 'pqe',
  'tao' => 'poz',
  'evn' => 'tuw',
  'vmk' => 'bnt',
  'xvn' => 'gme',
  'hmq' => 'hmx',
  'ott' => 'oto',
  'soy' => 'alv',
  'yao' => 'bnt',
  'quw' => 'qwe',
  'rth' => 'phi',
  'bcc' => 'ira',
  'srh' => 'ira',
  'vaf' => 'ira',
  'ttv' => 'pqe',
  'vmd' => 'dra',
  'rah' => 'sit',
  'won' => 'bnt',
  'bch' => 'pqe',
  'cik' => 'sit',
  'tat' => 'trk',
  'dry' => 'inc',
  'tpj' => 'tup',
  'alv' => 'nic',
  'mjv' => 'dra',
  'sww' => 'pqe',
  'urw' => 'ngf',
  'gmm' => 'alv',
  'thf' => 'sit',
  'bgr' => 'sit',
  'dal' => 'cus',
  'lya' => 'sit',
  'klu' => 'kro',
  'nru' => 'sit',
  'brx' => 'tbq',
  'omx' => 'mkh',
  'sdg' => 'inc',
  'bum' => 'bnt',
  'ltg' => 'bat',
  'sxs' => 'alv',
  'tir' => 'sem',
  'sem' => 'afa',
  'tnw' => 'phi',
  'knk' => 'dmn',
  'mnp' => 'zhx',
  'qok' => 'mkh',
  'kvp' => 'pqe',
  'gad' => 'poz',
  'gur' => 'alv',
  'cji' => 'ccn',
  'job' => 'bnt',
  'dok' => 'poz',
  'aiw' => 'omv',
  'pwg' => 'pqe',
  'swq' => 'cdc',
  'urg' => 'ngf',
  'uur' => 'pqe',
  'uve' => 'pqe',
  'bdh' => 'csu',
  'zmn' => 'bnt',
  'bla' => 'alg',
  'kyq' => 'csu',
  'bnu' => 'poz',
  'coc' => 'hok',
  'bbw' => 'alv',
  'dbd' => 'alv',
  'gou' => 'cdc',
  'yif' => 'sit',
  'mtr' => 'inc',
  'miy' => 'omq',
  'qvs' => 'qwe',
  'dbj' => 'pqw',
  'fni' => 'alv',
  'kgo' => 'kdo',
  'vmj' => 'omq',
  'tgd' => 'cdc',
  'jpr' => 'ira',
  'xmd' => 'cdc',
  'ccc' => 'awd',
  'bbr' => 'ngf',
  'kfq' => 'mun',
  'whk' => 'poz',
  'ksd' => 'pqe',
  'wol' => 'alv',
  'kbs' => 'bnt',
  'tsw' => 'alv',
  'bno' => 'phi',
  'rmg' => 'gmq',
  'kzx' => 'pqe',
  'mka' => 'alv',
  'loc' => 'phi',
  'ttt' => 'ira',
  'kpo' => 'alv',
  'fip' => 'bnt',
  'kat' => 'ccs',
  'bmt' => 'hmx',
  'nkc' => 'bnt',
  'trb' => 'pqe',
  'kbo' => 'csu',
  'dam' => 'alv',
  'xgl' => 'bat',
  'mht' => 'awd',
  'nyq' => 'ira',
  'drg' => 'pqw',
  'abe' => 'alg',
  'ide' => 'alv',
  'kno' => 'dmn',
  'fbl' => 'bik',
  'tkr' => 'ccn',
  'byp' => 'alv',
  'gbn' => 'csu',
  'box' => 'alv',
  'mfg' => 'dmn',
  'hay' => 'bnt',
  'tgt' => 'poz',
  'cod' => 'tup',
  'zeh' => 'tai',
  'uta' => 'alv',
  'sln' => 'hok',
  'nes' => 'sit',
  'hol' => 'bnt',
  'see' => 'iro',
  'nmt' => 'pqe',
  'qvh' => 'qwe',
  'mvt' => 'pqe',
  'mmz' => 'bnt',
  'axk' => 'bnt',
  'yph' => 'sit',
  'zpi' => 'omq',
  'pio' => 'awd',
  'dsh' => 'cus',
  'deh' => 'ira',
  'kpt' => 'ccn',
  'tqp' => 'pqe',
  'urv' => 'pqe',
  'dnj' => 'dmn',
  'aav' => 'mul',
  'yee' => 'paa',
  'akk' => 'sem',
  'mim' => 'omq',
  'jgb' => 'bnt',
  'cau' => 'mul',
  'agt' => 'poz',
  'kcp' => 'kdo',
  'tus' => 'iro',
  'tuc' => 'pqe',
  'mwr' => 'inc',
  'sht' => 'hok',
  'ymr' => 'dra',
  'egl' => 'roa',
  'aka' => 'alv',
  'pyy' => 'sit',
  'bem' => 'bnt',
  'idd' => 'alv',
  'mdm' => 'alv',
  'kpd' => 'pqe',
  'ttm' => 'ath',
  'var' => 'azc',
  'klt' => 'ngf',
  'bnz' => 'alv',
  'lga' => 'pqe',
  'hla' => 'pqe',
  'cli' => 'alv',
  'imi' => 'ngf',
  'lgi' => 'poz',
  'swu' => 'poz',
  'sdj' => 'bnt',
  'kru' => 'dra',
  'bpg' => 'pqe',
  'yii' => 'aus',
  'vgr' => 'inc',
  'bsh' => 'iir',
  'koi' => 'fiu',
  'kal' => 'esx',
  'bpm' => 'ngf',
  'zgb' => 'tai',
  'kvi' => 'cdc',
  'pyx' => 'sit',
  'tov' => 'ira',
  'gbg' => 'alv',
  'psm' => 'tup',
  'tyv' => 'trk',
  'bqp' => 'dmn',
  'hov' => 'poz',
  'grt' => 'sit',
  'fmp' => 'bai',
  'bbm' => 'bnt',
  'snj' => 'alv',
  'mng' => 'mkh',
  'niy' => 'csu',
  'mrd' => 'sit',
  'tga' => 'bnt',
  'sos' => 'dmn',
  'hnn' => 'poz',
  'muj' => 'cdc',
  'cuu' => 'tai',
  'aok' => 'pqe',
  'rgu' => 'pqe',
  'gos' => 'gmw',
  'sqt' => 'sem',
  'txt' => 'ngf',
  'nrf' => 'roa',
  'nya' => 'bnt',
  'ofo' => 'sio',
  'gej' => 'alv',
  'zpm' => 'omq',
  'any' => 'alv',
  'tea' => 'mkh',
  'knp' => 'alv',
  'duz' => 'alv',
  'bbj' => 'bai',
  'doo' => 'alv',
  'wuv' => 'pqe',
  'keq' => 'inc',
  'qkn' => 'dra',
  'siy' => 'ira',
  'soe' => 'bnt',
  'slr' => 'trk',
  'jiq' => 'sit',
  'lma' => 'alv',
  'sal' => 'nai',
  'ani' => 'ccn',
  'kld' => 'aus',
  'zng' => 'mkh',
  'zmq' => 'bnt',
  'agy' => 'poz',
  'bui' => 'bnt',
  'egy' => 'egx',
  'smj' => 'smi',
  'xtu' => 'omq',
  'dum' => 'gmw',
  'pmx' => 'sit',
  'otl' => 'oto',
  'keb' => 'bnt',
  'unr' => 'mun',
  'gwt' => 'inc',
  'byf' => 'alv',
  'bql' => 'ngf',
  'lud' => 'urj',
  'jar' => 'alv',
  'nba' => 'bnt',
  'mhc' => 'myn',
  'nbt' => 'sit',
  'kmg' => 'ngf',
  'jmx' => 'omq',
  'kep' => 'dra',
  'rag' => 'bnt',
  'nch' => 'nah',
  'tlq' => 'mkh',
  'uig' => 'trk',
  'obo' => 'mno',
  'dox' => 'cus',
  'diq' => 'ira',
  'xnr' => 'inc',
  'tai' => 'mul',
  'mgs' => 'bnt',
  'kwk' => 'wak',
  'yso' => 'sit',
  'bww' => 'bnt',
  'mfq' => 'alv',
  'hor' => 'csu',
  'trg' => 'sem',
  'kom' => 'urj',
  'njj' => 'alv',
  'rwm' => 'bnt',
  'ldg' => 'alv',
  'shd' => 'inc',
  'pae' => 'bnt',
  'tru' => 'sem',
  'cox' => 'awd',
  'jas' => 'poz',
  'ygm' => 'ngf',
  'kzu' => 'pqe',
  'itc' => 'ine',
  'kqp' => 'cdc',
  'lag' => 'bnt',
  'xwc' => 'sio',
  'swc' => 'bnt',
  'kas' => 'inc',
  'apo' => 'pqe',
  'mrn' => 'pqe',
  'fwa' => 'pqe',
  'kdx' => 'alv',
  'swf' => 'alv',
  'sna' => 'bnt',
  'bjv' => 'csu',
  'abn' => 'alv',
  'trn' => 'awd',
  'obu' => 'alv',
  'ddj' => 'aus',
  'war' => 'phi',
  'lko' => 'bnt',
  'bts' => 'btk',
  'pre' => 'roa',
  'mai' => 'inc',
  'ksf' => 'bnt',
  'gbj' => 'mun',
  'sit' => 'mul',
  'dul' => 'poz',
  'bgq' => 'inc',
  'tbo' => 'pqe',
  'gly' => 'ssa',
  'trw' => 'inc',
  'qxh' => 'qwe',
  'pma' => 'pqe',
  'sdp' => 'sit',
  'oru' => 'ira',
  'woe' => 'pqe',
  'nja' => 'cdc',
  'nuz' => 'nah',
  'sgp' => 'sit',
  'buq' => 'ngf',
  'nlc' => 'ngf',
  'bod' => 'tbq',
  'nif' => 'ngf',
  'knl' => 'poz',
  'kkw' => 'bnt',
  'atp' => 'poz',
  'sde' => 'alv',
  'esx' => 'mul',
  'nyc' => 'bnt',
  'amo' => 'alv',
  'ubl' => 'bik',
  'qxs' => 'sit',
  'lce' => 'pqw',
  'ael' => 'alv',
  'fra' => 'roa',
  'scb' => 'mkh',
  'nmk' => 'pqe',
  'prn' => 'iir',
  'snf' => 'alv',
  'mci' => 'ngf',
  'qun' => 'sal',
  'nla' => 'bai',
  'tef' => 'mkh',
  'tjo' => 'ber',
  'txq' => 'pqe',
  'mpw' => 'awd',
  'amq' => 'pqe',
  'agn' => 'poz',
  'asj' => 'alv',
  'nbk' => 'ngf',
  'klc' => 'alv',
  'tev' => 'pqe',
  'crp' => 'mul',
  'net' => 'ngf',
  'crn' => 'azc',
  'duy' => 'poz',
  'bng' => 'bnt',
  'mkh' => 'aav',
  'odu' => 'alv',
  'mwe' => 'bnt',
  'nle' => 'bnt',
  'zyj' => 'tai',
  'scu' => 'sit',
  'nkz' => 'alv',
  'bze' => 'dmn',
  'guq' => 'tup',
  'bvc' => 'pqe',
  'zgm' => 'tai',
  'mmx' => 'pqe',
  'pee' => 'poz',
  'lot' => 'sdv',
  'kiv' => 'bnt',
  'bzv' => 'alv',
  'iri' => 'alv',
  'bmm' => 'poz',
  'rob' => 'poz',
  'agz' => 'bik',
  'tey' => 'kdo',
  'yob' => 'pqe',
  'sxn' => 'phi',
  'knz' => 'alv',
  'wnk' => 'pqe',
  'msc' => 'dmn',
  'axm' => 'hyx',
  'qxn' => 'qwe',
  'kbi' => 'pqe',
  'rei' => 'inc',
  'ski' => 'pqe',
  'ukg' => 'ngf',
  'mjx' => 'mun',
  'sov' => 'pqe',
  'spg' => 'poz',
  'gho' => 'ber',
  'lip' => 'alv',
  'pex' => 'pqe',
  'bvf' => 'cdc',
  'lkb' => 'bnt',
  'wdg' => 'ngf',
  'pzn' => 'sit',
  'hkk' => 'ngf',
  'zln' => 'tai',
  'brn' => 'cba',
  'tiv' => 'alv',
  'ler' => 'pqe',
  'mtc' => 'ngf',
  'gev' => 'bnt',
  'tsk' => 'sit',
  'aum' => 'alv',
  'rkt' => 'inc',
  'nns' => 'alv',
  'env' => 'alv',
  'pdo' => 'pqw',
  'gbv' => 'alv',
  'pri' => 'pqe',
  'yly' => 'pqe',
  'plc' => 'poz',
  'atg' => 'alv',
  'kbm' => 'pqe',
  'njr' => 'alv',
  'hld' => 'mkh',
  'luq' => 'alv',
  'kpa' => 'cdc',
  'tdi' => 'pqw',
  'lut' => 'sal',
  'swx' => 'auf',
  'plr' => 'alv',
  'jkm' => 'kar',
  'hvv' => 'cai',
  'zpa' => 'omq',
  'ybh' => 'sit',
  'kxj' => 'csu',
  'ame' => 'awd',
  'miz' => 'omq',
  'jaj' => 'pqe',
  'bzm' => 'bnt',
  'nwm' => 'csu',
  'emn' => 'alv',
  'pmn' => 'alv',
  'pau' => 'pqw',
  'xgf' => 'azc',
  'bfu' => 'sit',
  'zna' => 'alv',
  'hot' => 'pqe',
  'ues' => 'poz',
  'ndb' => 'alv',
  'itm' => 'alv',
  'ojb' => 'alg',
  'srx' => 'inc',
  'xdo' => 'bnt',
  'bxl' => 'dmn',
  'led' => 'csu',
  'mzi' => 'omq',
  'lim' => 'gmw',
  'bnk' => 'pqe',
  'dis' => 'sit',
  'kxp' => 'inc',
  'uhn' => 'ngf',
  'ggl' => 'ngf',
  'kev' => 'dra',
  'jii' => 'cus',
  'lts' => 'bnt',
  'ptu' => 'poz',
  'irh' => 'pqe',
  'jpa' => 'sem',
  'sog' => 'ira',
  'mop' => 'myn',
  'mfm' => 'cdc',
  'sfm' => 'hmx',
  'tlh' => 'art',
  'xlb' => 'alg',
  'gam' => 'ngf',
  'aee' => 'inc',
  'myw' => 'pqe',
  'cky' => 'cdc',
  'bzh' => 'pqe',
  'xdc' => 'ine',
  'vko' => 'pqw',
  'kkq' => 'bnt',
  'bsq' => 'kro',
  'cie' => 'cdc',
  'sds' => 'ber',
  'thi' => 'tai',
  'ibl' => 'phi',
  'kdd' => 'aus',
  'vag' => 'alv',
  'agb' => 'alv',
  'crz' => 'hok',
  'ksv' => 'bnt',
  'mpi' => 'cdc',
  'tti' => 'pqe',
  'wak' => 'nai',
  'qxw' => 'qwe',
  'nnh' => 'bai',
  'xkx' => 'pqe',
  'doa' => 'ngf',
  'zaj' => 'bnt',
  'tgq' => 'poz',
  'tft' => 'paa',
  'mjs' => 'cdc',
  'tkp' => 'pqe',
  'mqx' => 'poz',
  'tmi' => 'pqe',
  'uga' => 'sem',
  'pay' => 'cba',
  'cpp' => 'crp',
  'kia' => 'alv',
  'xtc' => 'kdo',
  'atl' => 'bik',
  'iir' => 'ine',
  'lmf' => 'pqe',
  'bdl' => 'pqw',
  'bna' => 'poz',
  'kza' => 'alv',
  'tto' => 'mkh',
  'clt' => 'sit',
  'ndh' => 'bnt',
  'cjs' => 'trk',
  'ote' => 'oto',
  'bny' => 'poz',
  'tcn' => 'sit',
  'cpe' => 'crp',
  'rnp' => 'sit',
  'mfi' => 'cdc',
  'kmm' => 'sit',
  'sbm' => 'bnt',
  'pqe' => 'poz',
  'ikp' => 'alv',
  'sav' => 'alv',
  'pqm' => 'alg',
  'mnw' => 'mkh',
  'xky' => 'poz',
  'lwg' => 'bnt',
  'mxz' => 'pqe',
  'aza' => 'sit',
  'wan' => 'dmn',
  'xpo' => 'nah',
  'kjl' => 'sit',
  'kqe' => 'poz',
  'gyi' => 'bnt',
  'bre' => 'cel',
  'nmb' => 'pqe',
  'dws' => 'art',
  'sat' => 'mun',
  'ncu' => 'alv',
  'krx' => 'alv',
  'yom' => 'bnt',
  'wha' => 'pqe',
  'bai' => 'alv',
  'mew' => 'cdc',
  'pow' => 'omq',
  'bmf' => 'alv',
  'cug' => 'alv',
  'bbv' => 'pqe',
  'asx' => 'ngf',
  'kjr' => 'pqe',
  'wja' => 'alv',
  'pib' => 'awd',
  'xkp' => 'ira',
  'jub' => 'alv',
  'msz' => 'ngf',
  'bhb' => 'inc',
  'igb' => 'alv',
  'gig' => 'inc',
  'bte' => 'alv',
  'ntu' => 'pqe',
  'pil' => 'alv',
  'ccn' => 'cau',
  'ask' => 'iir',
  'krf' => 'pqe',
  'muk' => 'sit',
  'dta' => 'xgn',
  'zyg' => 'tai',
  'dyu' => 'dmn',
  'xtt' => 'omq',
  'koc' => 'alv',
  'rnd' => 'bnt',
  'nvo' => 'bnt',
  'kls' => 'inc',
  'akr' => 'pqe',
  'umn' => 'sit',
  'xnn' => 'poz',
  'bls' => 'poz',
  'zpg' => 'omq',
  'mnh' => 'bad',
  'xto' => 'ine',
  'cha' => 'pqw',
  'gfk' => 'pqe',
  'awm' => 'ngf',
  'lis' => 'sit',
  'lex' => 'pqe',
  'kwp' => 'kro',
  'gmx' => 'bnt',
  'aiy' => 'alv',
  'pyu' => 'fox',
  'bhr' => 'poz',
  'naj' => 'alv',
  'xku' => 'bnt',
  'aip' => 'ngf',
  'ypo' => 'sit',
  'mmc' => 'oto',
  'wsa' => 'pqe',
  'nbb' => 'alv',
  'tbq' => 'sit',
  'met' => 'pqe',
  'qug' => 'qwe',
  'rng' => 'bnt',
  'plw' => 'poz',
  'lsi' => 'sit',
  'ngi' => 'cdc',
  'msb' => 'phi',
  'pcd' => 'roa',
  'thz' => 'ber',
  'ppk' => 'poz',
  'qux' => 'qwe',
  'prs' => 'ira',
  'nlj' => 'bnt',
  'luy' => 'bnt',
  'kxn' => 'poz',
  'aie' => 'pqe',
  'gem' => 'ine',
  'nue' => 'bad',
  'lgk' => 'pqe',
  'lgz' => 'bnt',
  'naz' => 'nah',
  'acf' => 'roa',
  'gix' => 'alv',
  'mpg' => 'cdc',
  'mqw' => 'ngf',
  'mvv' => 'poz',
  'kfb' => 'dra',
  'nxl' => 'pqe',
  'lrt' => 'poz',
  'gek' => 'cdc',
  'trp' => 'tbq',
  'sku' => 'pqe',
  'puy' => 'hok',
  'hmz' => 'hmx',
  'smy' => 'ira',
  'ker' => 'cdc',
  'yon' => 'ngf',
  'kvv' => 'pqe',
  'bse' => 'alv',
  'kff' => 'dra',
  'nnk' => 'ngf',
  'bzx' => 'dmn',
  'dae' => 'alv',
  'dov' => 'bnt',
  'pna' => 'poz',
  'awu' => 'ngf',
  'bsf' => 'alv',
  'pap' => 'roa',
  'dml' => 'inc',
  'nnw' => 'alv',
  'cor' => 'cel',
  'lmr' => 'pqe',
  'tva' => 'pqe',
  'nhc' => 'nah',
  'ydd' => 'gmw',
  'pic' => 'bnt',
  'vmy' => 'omq',
  'jim' => 'cdc',
  'ami' => 'map',
  'byh' => 'sit',
  'cut' => 'omq',
  'mda' => 'alv',
  'njh' => 'sit',
  'ism' => 'pqe',
  'tgh' => 'gmw',
  'mut' => 'dra',
  'dlg' => 'trk',
  'ofs' => 'gmw',
  'dge' => 'ngf',
  'ium' => 'hmx',
  'snk' => 'dmn',
  'kiz' => 'bnt',
  'cpn' => 'alv',
  'dic' => 'kro',
  'ter' => 'awd',
  'kea' => 'roa',
  'cul' => 'auf',
  'xka' => 'inc',
  'jbu' => 'alv',
  'pdi' => 'tai',
  'pkt' => 'mkh',
  'mqm' => 'pqe',
  'glw' => 'cdc',
  'bbc' => 'btk',
  'sxu' => 'gmw',
  'apr' => 'pqe',
  'att' => 'poz',
  'byc' => 'alv',
  'ext' => 'roa',
  'dne' => 'bnt',
  'cns' => 'ngf',
  'ocu' => 'oto',
  'raj' => 'inc',
  'mys' => 'sem',
  'stu' => 'mkh',
  'end' => 'pqe',
  'spx' => 'itc',
  'gat' => 'ngf',
  'cjk' => 'bnt',
  'tnu' => 'tai',
  'iai' => 'pqe',
  'tdg' => 'sit',
  'krj' => 'phi',
  'blv' => 'bnt',
  'zns' => 'cdc',
  'sre' => 'poz',
  'cat' => 'roa',
  'ymh' => 'sit',
  'hok' => 'cai',
  'xco' => 'ira',
  'ilk' => 'phi',
  'kem' => 'pqe',
  'ylu' => 'pqe',
  'juc' => 'tuw',
  'nha' => 'aus',
  'bsu' => 'pqw',
  'ums' => 'poz',
  'wnb' => 'ngf',
  'kxm' => 'mkh',
  'ssz' => 'pqe',
  'ree' => 'pqw',
  'zak' => 'bnt',
  'tpu' => 'mkh',
  'ynk' => 'ypk',
  'apl' => 'apa',
  'drh' => 'xgn',
  'dmo' => 'alv',
  'aat' => 'sqj',
  'xgb' => 'dmn',
  'kjj' => 'ccn',
  'mki' => 'inc',
  'lwu' => 'sit',
  'rif' => 'ber',
  'swk' => 'bnt',
  'seh' => 'bnt',
  'nkv' => 'bnt',
  'dsb' => 'wen',
  'aib' => 'trk',
  'bzg' => 'fox',
  'otx' => 'oto',
  'bis' => 'gmw',
  'tgx' => 'ath',
  'csy' => 'sit',
  'sxb' => 'bnt',
  'ojw' => 'alg',
  'hyw' => 'hyx',
  'bdr' => 'pqw',
  'sax' => 'pqe',
  'cbg' => 'cba',
  'sty' => 'trk',
  'mfn' => 'alv',
  'amv' => 'pqe',
  'tez' => 'ber',
  'gzn' => 'pqe',
  'pgu' => 'paa',
  'ccr' => 'cai',
  'muu' => 'cus',
  'pdc' => 'gmw',
  'lbo' => 'mkh',
  'ysd' => 'sit',
  'scf' => 'roa',
  'mrw' => 'phi',
  'try' => 'tai',
  'kmv' => 'roa',
  'mvq' => 'ngf',
  'frq' => 'ngf',
  'bpr' => 'poz',
  'tji' => 'sit',
  'gil' => 'pqe',
  'usp' => 'myn',
  'pym' => 'alv',
  'bgu' => 'alv',
  'tbk' => 'poz',
  'lit' => 'bat',
  'cya' => 'omq',
  'keu' => 'alv',
  'kvy' => 'kar',
  'tsl' => 'tai',
  'lmq' => 'pqe',
  'mte' => 'pqe',
  'diy' => 'ngf',
  'fpe' => 'gmw',
  'cob' => 'myn',
  'pez' => 'poz',
  'rmm' => 'pqe',
  'kxk' => 'kar',
  'gvm' => 'alv',
  'tdu' => 'pqw',
  'mey' => 'sem',
  'koz' => 'ngf',
  'shh' => 'azc',
  'mif' => 'cdc',
  'goa' => 'dmn',
  'tgo' => 'pqe',
  'ags' => 'alv',
  'thh' => 'azc',
  'bas' => 'bnt',
  'lug' => 'bnt',
  'pdn' => 'pqe',
  'pck' => 'sit',
  'avn' => 'alv',
  'nbw' => 'alv',
  'qvw' => 'qwe',
  'mdu' => 'bnt',
  'qub' => 'qwe',
  'kme' => 'bnt',
  'tku' => 'cai',
  'dzo' => 'sit',
  'szv' => 'bnt',
  'mep' => 'aus',
  'nun' => 'tbq',
  'nlu' => 'alv',
  'gua' => 'alv',
  'pbs' => 'oto',
  'hss' => 'sem',
  'wrp' => 'pqe',
  'tcu' => 'azc',
  'pgs' => 'alv',
  'sop' => 'bnt',
  'two' => 'bnt',
  'bmx' => 'ngf',
  'sjm' => 'pqw',
  'seu' => 'pqe',
  'tio' => 'pqe',
  'mos' => 'alv',
  'tan' => 'cdc',
  'lwe' => 'pqe',
  'isk' => 'ira',
  'qvl' => 'qwe',
  'bka' => 'alv',
  'kuw' => 'bad',
  'dva' => 'pqe',
  'mbu' => 'alv',
  'bli' => 'bnt',
  'jwi' => 'alv',
  'egx' => 'afa',
  'swv' => 'inc',
  'wlm' => 'cel',
  'agx' => 'ccn',
  'riu' => 'pqe',
  'nra' => 'bnt',
  'mnk' => 'dmn',
  'gis' => 'cdc',
  'etx' => 'alv',
  'paa' => 'mul',
  'lwa' => 'bnt',
  'miu' => 'omq',
  'iba' => 'pqw',
  'mtm' => 'syd',
  'xan' => 'cus',
  'ari' => 'cdd',
  'psn' => 'poz',
  'mgh' => 'bnt',
  'mrj' => 'fiu',
  'bop' => 'ngf',
  'deu' => 'gmw',
  'crh' => 'trk',
  'olr' => 'pqe',
  'mks' => 'omq',
  'gsn' => 'ngf',
  'ysg' => 'sit',
  'aij' => 'sem',
  'nps' => 'ngf',
  'ijs' => 'ijo',
  'ewo' => 'bnt',
  'bzy' => 'alv',
  'sje' => 'smi',
  'yiq' => 'sit',
  'bha' => 'inc',
  'bpn' => 'hmx',
  'tly' => 'ira',
  'nuw' => 'pqe',
  'enf' => 'syd',
  'acz' => 'kdo',
  'mcm' => 'roa',
  'tce' => 'ath',
  'kmw' => 'bnt',
  'tnp' => 'pqe',
  'fir' => 'alv',
  'soj' => 'ira',
  'enm' => 'gmw',
  'dup' => 'pqw',
  'mtk' => 'alv',
  'sbo' => 'mkh',
  'hit' => 'ine',
  'utr' => 'alv',
  'rog' => 'cmc',
  'kki' => 'bnt',
  'hke' => 'bnt',
  'ztx' => 'omq',
  'oor' => 'gmw',
  'mcx' => 'bnt',
  'ngc' => 'bnt',
  'jih' => 'sit',
  'gom' => 'inc',
  'tnd' => 'cba',
  'luk' => 'sit',
  'psu' => 'inc',
  'liz' => 'bnt',
  'hlu' => 'ine',
  'qbb' => 'itc',
  'esh' => 'ira',
  'kpq' => 'ngf',
  'mbh' => 'pqe',
  'kvb' => 'poz',
  'byj' => 'alv',
  'bnt' => 'alv',
  'zal' => 'sit',
  'klm' => 'ngf',
  'lcc' => 'pqe',
  'nkx' => 'ijo',
  'ife' => 'alv',
  'fan' => 'bnt',
  'sbe' => 'pqe',
  'ekg' => 'ngf',
  'acp' => 'alv',
  'lif' => 'sit',
  'nhw' => 'nah',
  'xlc' => 'ine',
  'kfu' => 'inc',
  'csv' => 'sit',
  'yka' => 'pqw',
  'lmj' => 'pqe',
  'mvb' => 'ath',
  'ccd' => 'roa',
  'tlm' => 'pqe',
  'xtm' => 'omq',
  'noh' => 'ngf',
  'lio' => 'pqe',
  'lnh' => 'mkh',
  'kgx' => 'poz',
  'ghe' => 'sit',
  'goz' => 'ira',
  'eky' => 'kar',
  'ipk' => 'esx',
  'klb' => 'hok',
  'pci' => 'dra',
  'qxo' => 'qwe',
  'krc' => 'trk',
  'bkm' => 'alv',
  'chx' => 'sit',
  'lbr' => 'sit',
  'jpx' => 'mul',
  'krr' => 'mkh',
  'ike' => 'esx',
  'zmw' => 'bnt',
  'dgi' => 'alv',
  'twd' => 'gmw',
  'kez' => 'alv',
  'mbk' => 'pqe',
  'mzl' => 'cai',
  'ksg' => 'pqe',
  'luo' => 'sdv',
  'bws' => 'bnt',
  'wyr' => 'tup',
  'ale' => 'esx',
  'lbj' => 'sit',
  'srw' => 'pqe',
  'gwb' => 'alv',
  'aql' => 'nai',
  'ibr' => 'alv',
  'ira' => 'iir',
  'zbt' => 'poz',
  'yer' => 'alv',
  'nri' => 'sit',
  'url' => 'dra',
  'meo' => 'poz',
  'gwg' => 'alv',
  'xte' => 'ngf',
  'ozm' => 'bnt',
  'kii' => 'cdd',
  'ken' => 'alv',
  'kcn' => 'sem',
  'mkt' => 'pqe',
  'lsd' => 'sem',
  'xkt' => 'alv',
  'dao' => 'sit',
  'kbu' => 'inc',
  'otd' => 'pqw',
  'xin' => 'cai',
  'kid' => 'alv',
  'kfp' => 'mun',
  'otz' => 'oto',
  'xga' => 'cel',
  'dra' => 'mul',
  'yna' => 'sit',
  'khz' => 'pqe',
  'bku' => 'poz',
  'nmc' => 'csu',
  'mor' => 'kdo',
  'frt' => 'pqe',
  'tvw' => 'poz',
  'ghk' => 'kar',
  'soc' => 'bnt',
  'weh' => 'alv',
  'dee' => 'kro',
  'yaw' => 'awd',
  'mha' => 'dra',
  'clk' => 'sit',
  'mio' => 'omq',
  'kfw' => 'sit',
  'kxy' => 'mkh',
  'zpb' => 'omq',
  'sbn' => 'inc',
  'qvz' => 'qwe',
  'dad' => 'pqe',
  'squ' => 'sal',
  'lah' => 'inc',
  'oka' => 'sal',
  'toz' => 'alv',
  'hbo' => 'sem',
  'ahp' => 'alv',
  'fro' => 'roa',
  'stv' => 'sem',
  'igo' => 'ngf',
  'drb' => 'nub',
  'org' => 'alv',
  'lrv' => 'pqe',
  'wum' => 'bnt',
  'mfl' => 'cdc',
  'thp' => 'sal',
  'twa' => 'sal',
  'spu' => 'mkh',
  'wti' => 'ssa',
  'moj' => 'alv',
  'bef' => 'ngf',
  'yel' => 'bnt',
  'chb' => 'cba',
  'bhd' => 'inc',
  'tmq' => 'pqe',
  'kpe' => 'dmn',
  'the' => 'inc',
  'bsx' => 'alv',
  'xsa' => 'sem',
  'tkq' => 'alv',
  'ttl' => 'bnt',
  'zps' => 'omq',
  'bgx' => 'trk',
  'ing' => 'ath',
  'lie' => 'bnt',
  'lnd' => 'poz',
  'tlk' => 'pqw',
  'msu' => 'pqe',
  'mfu' => 'bnt',
  'phm' => 'bnt',
  'auf' => 'awd',
  'nen' => 'pqe',
  'rtw' => 'inc',
  'gax' => 'cus',
  'lln' => 'cdc',
  'kww' => 'gmw',
  'bgk' => 'mkh',
  'sbz' => 'csu',
  'abr' => 'alv',
  'mjn' => 'ngf',
  'zpz' => 'omq',
  'ldp' => 'alv',
  'mqb' => 'cdc',
  'khi' => 'mul',
  'yih' => 'gmw',
  'ojg' => 'alg',
  'elo' => 'cus',
  'hid' => 'sio',
  'osp' => 'roa',
  'dor' => 'pqe',
  'aus' => 'mul',
  'sjp' => 'inc',
  'mpm' => 'omq',
  'pty' => 'dra',
  'bwu' => 'alv',
  'tbl' => 'phi',
  'sgs' => 'bat',
  'aty' => 'pqe',
  'ptv' => 'pqe',
  'buc' => 'pqw',
  'mve' => 'inc',
  'sij' => 'pqe',
  'tmb' => 'pqe',
  'hmx' => 'mul',
  'mba' => 'mno',
  'ang' => 'gmw',
  'nfd' => 'alv',
  'tmn' => 'poz',
  'apg' => 'poz',
  'bjx' => 'poz',
  'nbl' => 'bnt',
  'khb' => 'tai',
  'ynn' => 'hok',
  'shl' => 'sit',
  'qvn' => 'qwe',
  'mjc' => 'omq',
  'thq' => 'inc',
  'bck' => 'aus',
  'ade' => 'alv',
  'rmq' => 'inc',
  'cbn' => 'mkh',
  'kbt' => 'pqe',
  'don' => 'pqe',
  'boj' => 'ngf',
  'tla' => 'azc',
  'lem' => 'bnt',
  'mbv' => 'alv',
  'akw' => 'bnt',
  'mgz' => 'bnt',
  'nng' => 'sit',
  'bvx' => 'bnt',
  'scs' => 'ath',
  'oge' => 'ccs',
  'lvu' => 'pqe',
  'cdm' => 'sit',
  'ahn' => 'alv',
  'xdy' => 'poz',
  'fkv' => 'fiu',
  'bvq' => 'csu',
  'brh' => 'dra',
  'tst' => 'son',
  'bbo' => 'dmn',
  'sdu' => 'poz',
  'aax' => 'ngf',
  'pni' => 'poz',
  'azg' => 'omq',
  'kgu' => 'ngf',
  'eja' => 'alv',
  'fij' => 'pqe',
  'ulu' => 'pqw',
  'tnv' => 'inc',
  'xta' => 'omq',
  'bof' => 'dmn',
  'tdn' => 'phi',
  'bij' => 'alv',
  'osa' => 'sio',
  'ght' => 'sit',
  'pqw' => 'poz',
  'jrr' => 'alv',
  'yrw' => 'ngf',
  'bni' => 'bnt',
  'ogu' => 'alv',
  'bpj' => 'bnt',
  'mhu' => 'sit',
  'brf' => 'bnt',
  'emg' => 'sit',
  'dar' => 'ccn',
  'kga' => 'dmn',
  'nqk' => 'alv',
  'bpx' => 'inc',
  'ked' => 'bnt',
  'svb' => 'pqe',
  'ban' => 'pqw',
  'gyg' => 'alv',
  'usa' => 'ngf',
  'gdu' => 'cdc',
  'beq' => 'bnt',
  'xfa' => 'itc',
  'tug' => 'alv',
  'lig' => 'dmn',
  'eus' => 'euq',
  'gaf' => 'ngf',
  'kdh' => 'alv',
  'fry' => 'gmw',
  'ssg' => 'pqe',
  'baw' => 'alv',
  'dsi' => 'csu',
  'tab' => 'ccn',
  'ekl' => 'mun',
  'ver' => 'alv',
  'abq' => 'ccn',
  'ngs' => 'cdc',
  'mfv' => 'alv',
  'ykt' => 'sit',
  'bqc' => 'dmn',
  'pbg' => 'awd',
  'dbi' => 'alv',
  'sss' => 'mkh',
  'ogg' => 'alv',
  'kcm' => 'csu',
  'aui' => 'pqe',
  'eto' => 'bnt',
  'rmi' => 'inc',
  'bhk' => 'poz',
  'mme' => 'pqe',
  'kar' => 'tbq',
  'wal' => 'omv',
  'lop' => 'alv',
  'gay' => 'pqw',
  'chr' => 'iro',
  'xsq' => 'bnt',
  'der' => 'sit',
  'pne' => 'poz',
  'toh' => 'bnt',
  'adr' => 'pqe',
  'laf' => 'kdo',
  'kdl' => 'alv',
  'bya' => 'poz',
  'tye' => 'dmn',
  'agw' => 'pqe',
  'cym' => 'cel',
  'aug' => 'alv',
  'peo' => 'ira',
  'kmd' => 'poz',
  'psw' => 'pqe',
  'orz' => 'pqe',
  'sox' => 'bnt',
  'nmi' => 'cdc',
  'ljl' => 'pqe',
  'ttz' => 'sit',
  'obt' => 'cel',
  'chf' => 'myn',
  'ncf' => 'pqe',
  'piz' => 'pqe',
  'yav' => 'bnt',
  'xsp' => 'ngf',
  'bob' => 'cus',
  'ccp' => 'inc',
  'arh' => 'cba',
  'lkh' => 'sit',
  'mje' => 'cdc',
  'asr' => 'mun',
  'znd' => 'alv',
  'ghs' => 'ngf',
  'juw' => 'alv',
  'knb' => 'poz',
  'kfs' => 'inc',
  'toq' => 'sdv',
  'hni' => 'sit',
  'tlr' => 'pqe',
  'hle' => 'sit',
  'bwl' => 'bnt',
  'bhm' => 'sem',
  'kgt' => 'alv',
  'zlq' => 'tai',
  'qxp' => 'qwe',
  'kjm' => 'mkh',
  'pkh' => 'sit',
  'cbw' => 'poz',
  'inj' => 'qwe',
  'prx' => 'sit',
  'dow' => 'alv',
  'kdv' => 'sit',
  'aha' => 'alv',
  'ssj' => 'ngf',
  'coo' => 'sal',
  'ggu' => 'dmn',
  'xvi' => 'iir',
  'xmj' => 'cdc',
  'uvh' => 'ngf',
  'llh' => 'sit',
  'cwt' => 'alv',
  'klg' => 'poz',
  'col' => 'sal',
  'plp' => 'inc',
  'aml' => 'mkh',
  'fon' => 'alv',
  'kuh' => 'cdc',
  'ygp' => 'sit',
  'hmy' => 'hmx',
  'lom' => 'dmn',
  'mov' => 'hok',
  'orx' => 'alv',
  'lrc' => 'ira',
  'sgn' => 'mul',
  'bca' => 'sit',
  'nnc' => 'cdc',
  'avi' => 'alv',
  'drt' => 'gmw',
  'mqg' => 'poz',
  'xlg' => 'ine',
  'czt' => 'sit',
  'har' => 'sem',
  'iii' => 'sit',
  'llg' => 'pqe',
  'akg' => 'pqe',
  'nlg' => 'pqe',
  'yko' => 'bnt',
  'mcz' => 'ngf',
  'srm' => 'gmw',
  'klr' => 'sit',
  'gkp' => 'dmn',
  'arc' => 'sem',
  'sgm' => 'bnt',
  'xog' => 'bnt',
  'nar' => 'alv',
  'nit' => 'dra',
  'vai' => 'dmn',
  'ttr' => 'cdc',
  'xmt' => 'pqe',
  'ssc' => 'bnt',
  'loz' => 'bnt',
  'kbw' => 'pqe',
  'mqh' => 'omq',
  'def' => 'ira',
  'puf' => 'poz',
  'ziz' => 'cdc',
  'btx' => 'btk',
  'srs' => 'ath',
  'all' => 'dra',
  'bln' => 'bik',
  'bdd' => 'pqe',
  'wbp' => 'aus',
  'xkv' => 'bnt',
  'inn' => 'poz',
  'njz' => 'sit',
  'hum' => 'bnt',
  'sgl' => 'ira',
  'aqc' => 'ccn',
  'tkw' => 'pqe',
  'asm' => 'inc',
  'tdq' => 'alv',
  'beh' => 'alv',
  'dng' => 'sit',
  'kri' => 'gmw',
  'wln' => 'roa',
  'boe' => 'alv',
  'zen' => 'ber',
  'vmp' => 'omq',
  'nav' => 'apa',
  'mlt' => 'sem',
  'pht' => 'tai',
  'zmp' => 'bnt',
  'kfg' => 'dra',
  'ckh' => 'sit',
  'jmr' => 'alv',
  'nni' => 'pqe',
  'hrk' => 'pqe',
  'xkq' => 'pqw',
  'pkb' => 'bnt',
  'dio' => 'alv',
  'tls' => 'pqe',
  'mhy' => 'pqw',
  'heb' => 'sem',
  'zor' => 'cai',
  'dop' => 'alv',
  'jmi' => 'cdc',
  'kkr' => 'cdc',
  'uge' => 'pqe',
  'ori' => 'inc',
  'gda' => 'inc',
  'nld' => 'gmw',
  'kta' => 'mkh',
  'huz' => 'ccn',
  'nua' => 'pqe',
  'ach' => 'sdv',
  'hne' => 'inc',
  'dak' => 'sio',
  'lgg' => 'csu',
  'gec' => 'kro',
  'msk' => 'poz',
  'ztu' => 'omq',
  'wkl' => 'dra',
  'zle' => 'sla',
  'olo' => 'fiu',
  'afs' => 'gmw',
  'hii' => 'inc',
  'kws' => 'bnt',
  'syw' => 'sit',
  'pus' => 'ira',
  'mbw' => 'ngf',
  'mef' => 'mkh',
  'ndv' => 'alv',
  'umi' => 'poz',
  'hud' => 'pqe',
  'leb' => 'bnt',
  'brm' => 'znd',
  'mkd' => 'zls',
  'tbw' => 'poz',
  'miq' => 'cai',
  'jml' => 'inc',
  'mug' => 'cdc',
  'luc' => 'csu',
  'skq' => 'dmn',
  'bhs' => 'cdc',
  'lji' => 'poz',
  'mge' => 'csu',
  'frr' => 'gmw',
  'kse' => 'pqe',
  'ayt' => 'poz',
  'ncq' => 'mkh',
  'rgs' => 'cmc',
  'kll' => 'poz',
  'gjn' => 'alv',
  'kpf' => 'ngf',
  'nzm' => 'sit',
  'nde' => 'bnt',
  'nsy' => 'poz',
  'sjo' => 'tuw',
  'wtw' => 'poz',
  'cje' => 'cmc',
  'zpx' => 'omq',
  'gro' => 'tbq',
  'kqn' => 'bnt',
  'oso' => 'alv',
  'pfl' => 'gmw',
  'rai' => 'pqe',
  'ztg' => 'omq',
  'ngg' => 'alv',
  'nfu' => 'alv',
  'gei' => 'pqe',
  'mez' => 'alg',
  'bup' => 'poz',
  'nhy' => 'nah',
  'nor' => 'gmq',
  'nic' => 'mul',
  'fax' => 'roa',
  'dbp' => 'cdc',
  'anv' => 'alv',
  'jaz' => 'pqe',
  'ted' => 'kro',
  'nmh' => 'sit',
  'mcp' => 'bnt',
  'huv' => 'cai',
  'pnh' => 'pqe',
  'bky' => 'alv',
  'nrg' => 'pqe',
  'peh' => 'xgn',
  'xtl' => 'omq',
  'pda' => 'ngf',
  'chp' => 'ath',
  'tog' => 'bnt',
  'ybk' => 'sit',
  'lnl' => 'bad',
  'aso' => 'ngf',
  'tah' => 'pqe',
  'bcz' => 'alv',
  'mla' => 'pqe',
  'btq' => 'mkh',
  'sah' => 'trk',
  'mkr' => 'ngf',
  'sen' => 'alv',
  'myg' => 'alv',
  'kfk' => 'sit',
  'sdf' => 'ira',
  'bim' => 'alv',
  'mwq' => 'sit',
  'lre' => 'iro',
  'tfn' => 'ath',
  'gnh' => 'alv',
  'plk' => 'inc',
  'abm' => 'alv',
  'bvo' => 'alv',
  'quf' => 'qwe',
  'pnp' => 'poz',
  'uha' => 'alv',
  'tpc' => 'omq',
  'nop' => 'ngf',
  'svc' => 'gmw',
  'bae' => 'awd',
  'ixl' => 'myn',
  'glj' => 'alv',
  'tbc' => 'pqe',
  'uun' => 'fox',
  'mhk' => 'alv',
  'kur' => 'ira',
  'lva' => 'pqe',
  'lul' => 'csu',
  'mga' => 'cel',
  'btw' => 'poz',
  'bne' => 'poz',
  'isd' => 'poz',
  'isu' => 'alv',
  'old' => 'bnt',
  'mya' => 'sit',
  'osc' => 'itc',
  'zka' => 'poz',
  'wuu' => 'zhx',
  'nwc' => 'sit',
  'xls' => 'ine',
  'qua' => 'sio',
  'syb' => 'poz',
  'lax' => 'sit',
  'ojc' => 'alg',
  'hak' => 'zhx',
  'tes' => 'poz',
  'hoj' => 'inc',
  'hea' => 'hmx',
  'tyh' => 'mkh',
  'kka' => 'alv',
  'dty' => 'inc',
  'gdf' => 'cdc',
  'pcg' => 'dra',
  'kdr' => 'trk',
  'shc' => 'bnt',
  'ayi' => 'alv',
  'rwk' => 'bnt',
  'kxr' => 'pqe',
  'tsp' => 'alv',
  'ssw' => 'bnt',
  'mhm' => 'bnt',
  'eno' => 'pqw',
  'msm' => 'mno',
  'liw' => 'pqw',
  'prq' => 'awd',
  'buf' => 'bnt',
  'hmw' => 'hmx',
  'sfw' => 'alv',
  'bsm' => 'pqe',
  'cok' => 'azc',
  'kok' => 'inc',
  'pal' => 'ira',
  'hwo' => 'cdc',
  'acn' => 'sit',
  'pbn' => 'alv',
  'nsk' => 'alg',
  'bhi' => 'inc',
  'sag' => 'ngb',
  'eya' => 'xnd',
  'gcf' => 'roa',
  'ldl' => 'alv',
  'gwf' => 'inc',
  'plz' => 'poz',
  'mbi' => 'mno',
  'pef' => 'hok',
  'swj' => 'bnt',
  'mrg' => 'sit',
  'pnm' => 'poz',
  'mmo' => 'pqe',
  'bgy' => 'pqe',
  'ayp' => 'sem',
  'odt' => 'gmw',
  'mom' => 'omq',
  'sdr' => 'inc',
  'pel' => 'pqw',
  'vaa' => 'inc',
  'mjz' => 'inc',
  'ndm' => 'cdc',
  'mgq' => 'bnt',
  'bxw' => 'dmn',
  'puw' => 'pqe',
  'aks' => 'alv',
  'biz' => 'bnt',
  'ddi' => 'pqe',
  'mxg' => 'bnt',
  'suz' => 'sit',
  'alu' => 'pqe',
  'gnd' => 'cdc',
  'cre' => 'alg',
  'kum' => 'trk',
  'xtb' => 'omq',
  'xir' => 'awd',
  'kfo' => 'dmn',
  'kzk' => 'pqe',
  'tax' => 'cdc',
  'xsh' => 'alv',
  'svm' => 'zls',
  'jid' => 'alv',
  'ndu' => 'alv',
  'zoh' => 'cai',
  'ems' => 'ypk',
  'klv' => 'pqe',
  'xhd' => 'sem',
  'pnu' => 'hmx',
  'mxs' => 'omq',
  'nmf' => 'sit',
  'ast' => 'roa',
  'tcd' => 'alv',
  'bko' => 'bai',
  'wku' => 'dra',
  'tgy' => 'alv',
  'bgb' => 'poz',
  'nbe' => 'sit',
  'kje' => 'pqe',
  'kcz' => 'bnt',
  'gct' => 'gmw',
  'ztm' => 'omq',
  'mak' => 'pqw',
  'atj' => 'alg',
  'wes' => 'gmw',
  'poz' => 'map',
  'cot' => 'awd',
  'nyj' => 'bnt',
  'aba' => 'alv',
  'zwa' => 'sem',
  'hil' => 'phi',
  'kuo' => 'ngf',
  'yum' => 'hok',
  'tja' => 'kro',
  'bpk' => 'pqe',
  'acw' => 'sem',
  'ksr' => 'ngf',
  'dhi' => 'sit',
  'jee' => 'sit',
  'ncj' => 'nah',
  'etn' => 'pqe',
  'loj' => 'pqe',
  'dbl' => 'aus',
  'orr' => 'ijo',
  'mdv' => 'omq',
  'ymc' => 'sit',
  'dhm' => 'bnt',
  'fut' => 'pqe',
  'mwg' => 'pqe',
  'rpt' => 'ngf',
  'sep' => 'alv',
  'cek' => 'sit',
  'lvk' => 'paa',
  'zyp' => 'sit',
  'pdu' => 'kar',
  'khn' => 'inc',
  'log' => 'csu',
  'kdp' => 'alv',
  'ngq' => 'bnt',
  'glk' => 'ira',
  'kvu' => 'kar',
  'fcs' => 'sgn',
  'hti' => 'pqe',
  'agd' => 'ngf',
  'sqn' => 'iro',
  'zpt' => 'omq',
  'mcb' => 'awd',
  'mwh' => 'pqe',
  'tnr' => 'alv',
  'xmk' => 'ine',
  'srb' => 'mun',
  'lfa' => 'bnt',
  'mjh' => 'bnt',
  'okb' => 'alv',
  'asc' => 'ngf',
  'lcl' => 'pqe',
  'omq' => 'cai',
  'mjw' => 'sit',
  'mmm' => 'pqe',
  'okd' => 'ijo',
  'lkt' => 'sio',
  'ffm' => 'alv',
  'day' => 'mul',
  'lpn' => 'sit',
  'bxa' => 'pqe',
  'hih' => 'ngf',
  'brt' => 'alv',
  'ybl' => 'alv',
  'lmv' => 'pqe',
  'bei' => 'poz',
  'bqm' => 'bnt',
  'qvp' => 'qwe',
  'ibn' => 'alv',
  'tyt' => 'tai',
  'mft' => 'pqe',
  'gim' => 'ngf',
  'baj' => 'pqe',
  'nsx' => 'bnt',
  'tsb' => 'cus',
  'kxu' => 'dra',
  'smm' => 'inc',
  'emw' => 'pqe',
  'fil' => 'phi',
  'alc' => 'aqa',
  'wdd' => 'bnt',
  'aii' => 'sem',
  'pry' => 'mkh',
  'lhn' => 'poz',
  'mbn' => 'awd',
  'ulm' => 'poz',
  'acd' => 'alv',
  'lon' => 'bnt',
  'huj' => 'hmx',
  'pca' => 'omq',
  'chd' => 'cai',
  'wgb' => 'pqe',
  'pos' => 'cai',
  'dav' => 'bnt',
  'crs' => 'roa',
  'dmx' => 'bnt',
  'eze' => 'alv',
  'kud' => 'pqe',
  'kdz' => 'alv',
  'bqj' => 'alv',
  'ood' => 'azc',
  'due' => 'poz',
  'ctn' => 'sit',
  'snx' => 'ngf',
  'ncx' => 'nah',
  'btv' => 'inc',
  'xce' => 'cel',
  'oyb' => 'mkh',
  'cuc' => 'omq',
  'bgj' => 'alv',
  'kgq' => 'ngf',
  'syl' => 'inc',
  'kuv' => 'pqe',
  'vls' => 'gmw',
  'ych' => 'sit',
  'pbl' => 'alv',
  'crl' => 'alg',
  'scx' => 'ine',
  'gon' => 'dra',
  'poy' => 'bnt',
  'buk' => 'pqe',
  'kzj' => 'poz',
  'ctz' => 'omq',
  'zbc' => 'pqw',
  'bbg' => 'bnt',
  'szc' => 'mkh',
  'lcf' => 'pqw',
  'stt' => 'mkh',
  'nhd' => 'tup',
  'hnj' => 'hmx',
  'zmf' => 'bnt',
  'qus' => 'qwe',
  'gdo' => 'ccn',
  'gow' => 'cus',
  'mou' => 'cdc',
  'dme' => 'cdc',
  'mmg' => 'pqe',
  'hmn' => 'hmx',
  'afb' => 'sem',
  'mow' => 'bnt',
  'buz' => 'alv',
  'frk' => 'gmw',
  'mar' => 'inc',
  'plt' => 'poz',
  'xnd' => 'nai',
  'klo' => 'alv',
  'mxd' => 'poz',
  'pdt' => 'gmw',
  'brw' => 'dra',
  'xuo' => 'alv',
  'kdq' => 'sit',
  'bjk' => 'pqe',
  'sbh' => 'pqe',
  'rab' => 'sit',
  'weo' => 'pqe',
  'bjf' => 'sem',
  'blh' => 'kro',
  'blf' => 'phi',
  'son' => 'ssa',
  'pif' => 'pqe',
  'pwr' => 'inc',
  'nbq' => 'ngf',
  'mcw' => 'cdc',
  'orc' => 'cus',
  'hma' => 'hmx',
  'hoh' => 'sem',
  'ute' => 'azc',
  'bxv' => 'csu',
  'mas' => 'sdv',
  'krh' => 'alv',
  'zls' => 'sla',
  'ijc' => 'ijo',
  'lnb' => 'bnt',
  'bvd' => 'pqe',
  'blz' => 'poz',
  'era' => 'dra',
  'vie' => 'mkh',
  'ebu' => 'bnt',
  'kyd' => 'pqe',
  'liq' => 'cus',
  'rwr' => 'inc',
  'cup' => 'azc',
  'asd' => 'ngf',
  'ire' => 'pqe',
  'jct' => 'trk',
  'xtn' => 'omq',
  'dmk' => 'inc',
  'wme' => 'sit',
  'bay' => 'pqe',
  'bqo' => 'alv',
  'yue' => 'zhx',
  'bkf' => 'bnt',
  'bew' => 'pqw',
  'tlf' => 'ngf',
  'mpu' => 'tup',
  'nxd' => 'bnt',
  'frp' => 'roa',
  'nmy' => 'sit',
  'ikw' => 'alv',
  'acq' => 'sem',
  'mmn' => 'poz',
  'ven' => 'bnt',
  'let' => 'pqe',
  'kij' => 'pqe',
  'gke' => 'alv',
  'ylo' => 'sit',
  'osx' => 'gmw',
  'njm' => 'sit',
  'bdm' => 'cdc',
  'kvo' => 'pqe',
  'uvl' => 'pqe',
  'tdr' => 'mkh',
  'khc' => 'poz',
  'okv' => 'ngf',
  'wod' => 'ngf',
  'gdx' => 'inc',
  'dgc' => 'poz',
  'izi' => 'alv',
  'vkp' => 'roa',
  'spa' => 'roa',
  'pis' => 'gmw',
  'bkd' => 'mno',
  'ybj' => 'alv',
  'klw' => 'poz',
  'mui' => 'pqw',
  'hya' => 'cdc',
  'dtb' => 'poz',
  'ats' => 'alg',
  'rub' => 'bnt',
  'ukp' => 'alv',
  'sbd' => 'dmn',
  'gar' => 'pqe',
  'neh' => 'sit',
  'ayn' => 'sem',
  'etu' => 'alv',
  'blx' => 'poz',
  'jdt' => 'ira',
  'lav' => 'bat',
  'gor' => 'phi',
  'sip' => 'sit',
  'oty' => 'dra',
  'rop' => 'gmw',
  'mit' => 'omq',
  'iti' => 'poz',
  'bfs' => 'sit',
  'quz' => 'qwe',
  'sdz' => 'gmw',
  'adz' => 'pqe',
  'lmx' => 'alv',
  'inc' => 'iir',
  'yej' => 'grk',
  'hnu' => 'mkh',
  'kti' => 'ngf',
  'sym' => 'dmn',
  'cmn' => 'sit',
  'hre' => 'mkh',
  'kln' => 'sdv',
  'mnl' => 'pqe',
  'cdr' => 'alv',
  'djk' => 'gmw',
  'kjh' => 'trk',
  'kpb' => 'dra',
  'ibb' => 'alv',
  'azt' => 'poz',
  'lri' => 'bnt',
  'utp' => 'pqe',
  'gbl' => 'inc',
  'ndx' => 'ngf',
  'tuz' => 'alv',
  'kpl' => 'alv',
  'byw' => 'sit',
  'vmf' => 'gmw',
  'sme' => 'smi',
  'tpq' => 'sit',
  'vnk' => 'pqe',
  'stn' => 'pqe',
  'ntr' => 'alv',
  'kuk' => 'pqe',
  'bqg' => 'alv',
  'bgo' => 'alv',
  'akl' => 'phi',
  'xkn' => 'poz',
  'kwy' => 'bnt',
  'nur' => 'pqe',
  'kny' => 'bnt',
  'ckl' => 'cdc',
  'tdj' => 'poz',
  'kci' => 'alv',
  'bff' => 'alv',
  'nuu' => 'bad',
  'bvu' => 'poz',
  'aem' => 'mkh',
  'luw' => 'alv',
  'bjw' => 'kro',
  'sjb' => 'poz',
  'fad' => 'ngf',
  'ksh' => 'gmw',
  'nul' => 'pqe',
  'rdb' => 'ira',
  'ush' => 'inc',
  'elm' => 'alv',
  'bmn' => 'pqe',
  'gng' => 'alv',
  'fai' => 'ngf',
  'kau' => 'ssa',
  'wsk' => 'ngf',
  'ybm' => 'ngf',
  'omi' => 'csu',
  'kkz' => 'ath',
  'zay' => 'omv',
  'ktz' => 'khi',
  'vmq' => 'omq',
  'soa' => 'tai',
  'mtu' => 'omq',
  'cko' => 'alv',
  'goe' => 'sit',
  'mgi' => 'alv',
  'khv' => 'ccn',
  'knf' => 'alv',
  'fla' => 'sal',
  'mbs' => 'mno',
  'cfg' => 'alv',
  'bnr' => 'pqe',
  'ynl' => 'ngf',
  'jra' => 'cmc',
  'kpc' => 'awd',
  'yec' => 'gmw',
  'pwb' => 'alv',
  'bbk' => 'alv',
  'imr' => 'pqe',
  'bjm' => 'ira',
  'lib' => 'pqe',
  'nhx' => 'nah',
  'mpx' => 'pqe',
  'tpo' => 'tai',
  'bdg' => 'pqw',
  'mtw' => 'poz',
  'nhv' => 'nah',
  'cda' => 'sit',
  'sck' => 'inc',
  'nty' => 'sit',
  'tod' => 'dmn',
  'tcm' => 'paa',
  'ttp' => 'poz',
  'jge' => 'ccs',
  'pxm' => 'cai',
  'quv' => 'myn',
  'tuu' => 'ath',
  'rut' => 'ccn',
  'mat' => 'oto',
  'poq' => 'cai',
  'kil' => 'cdc',
  'kye' => 'alv',
  'efi' => 'alv',
  'ctt' => 'dra',
  'nbm' => 'alv',
  'vav' => 'inc',
  'ttq' => 'ber',
  'nan' => 'zhx',
  'fia' => 'nub',
  'sej' => 'ngf',
  'mrk' => 'pqe',
  'txs' => 'phi',
  'sbl' => 'poz',
  'mry' => 'poz',
  'erk' => 'pqe',
  'mpa' => 'bnt',
  'wae' => 'gmw',
  'nrc' => 'cel',
  'jal' => 'pqe',
  'tmw' => 'poz',
  'bax' => 'alv',
  'bct' => 'csu',
  'nej' => 'ngf',
  'rwo' => 'ngf',
  'bqh' => 'tbq',
  'kjt' => 'kar',
  'amb' => 'alv',
  'lei' => 'ngf',
  'nbn' => 'pqe',
  'fie' => 'cdc',
  'mjk' => 'pqe',
  'pye' => 'kro',
  'pns' => 'poz',
  'wtm' => 'inc',
  'ktb' => 'cus',
  'tin' => 'ccn',
  'esk' => 'esx',
  'nhe' => 'nah',
  'gqa' => 'cdc',
  'anm' => 'tbq',
  'qvc' => 'qwe',
  'gba' => 'alv',
  'rup' => 'roa',
  'kko' => 'nub',
  'bqr' => 'poz',
  'zea' => 'gmw',
  'bph' => 'ccn',
  'jau' => 'pqe',
  'lbn' => 'mkh',
  'mmh' => 'awd',
  'sjr' => 'pqe',
  'iff' => 'pqe',
  'dga' => 'alv',
  'tya' => 'ngf',
  'hlb' => 'inc',
  'adj' => 'alv',
  'vid' => 'bnt',
  'jad' => 'dmn',
  'nev' => 'mkh',
  'bvj' => 'alv',
  'sab' => 'cba',
  'itt' => 'poz',
  'alj' => 'poz',
  'msj' => 'alv',
  'neq' => 'cai',
  'kvm' => 'alv',
  'sko' => 'poz',
  'gdl' => 'cus',
  'snw' => 'alv',
  'mck' => 'bnt',
  'pny' => 'alv',
  'oss' => 'ira',
  'skh' => 'pqw',
  'tiy' => 'poz',
  'sec' => 'sal',
  'nct' => 'sit',
  'kzs' => 'poz',
  'nia' => 'pqw',
  'bkv' => 'alv',
  'nbp' => 'alv',
  'asy' => 'ngf',
  'wly' => 'sit',
  'lij' => 'roa',
  'msh' => 'poz',
  'skz' => 'pqe',
  'ybe' => 'trk',
  'kpw' => 'ngf',
  'gel' => 'alv',
  'cpg' => 'grk',
  'apj' => 'apa',
  'pnq' => 'alv',
  'ykn' => 'sit',
  'puj' => 'poz',
  'bdv' => 'inc',
  'seg' => 'bnt',
  'gmq' => 'gem',
  'kvc' => 'pqe',
  'tdk' => 'cdc',
  'bbh' => 'mkh',
  'bet' => 'kro',
  'mrc' => 'hok',
  'cry' => 'alv',
  'xlp' => 'cel',
  'tyx' => 'bnt',
  'tnk' => 'pqe',
  'say' => 'cdc',
  'nac' => 'ngf',
  'mmk' => 'dra',
  'btr' => 'pqe',
  'kik' => 'bnt',
  'xbr' => 'pqe',
  'zpo' => 'omq',
  'alm' => 'pqe',
  'jav' => 'pqw',
  'rml' => 'inc',
  'blk' => 'kar',
  'cui' => 'awd',
  'yig' => 'sit',
  'dmv' => 'poz',
  'jaf' => 'cdc',
  'mkv' => 'pqe',
  'ebr' => 'alv',
  'qwm' => 'trk',
  'xsy' => 'fox',
  'xpc' => 'trk',
  'kcj' => 'alv',
  'kvx' => 'inc',
  'ygr' => 'ngf',
  'npl' => 'nah',
  'ota' => 'trk',
  'kif' => 'sit',
  'ida' => 'bnt',
  'sks' => 'ngf',
  'ots' => 'oto',
  'scp' => 'sit',
  'gnb' => 'sit',
  'hue' => 'cai',
  'mpz' => 'sit',
  'kqs' => 'alv',
  'ekm' => 'bnt',
  'sew' => 'pqe',
  'chg' => 'trk',
  'glu' => 'csu',
  'ymm' => 'cus',
  'ldm' => 'alv',
  'ubr' => 'pqe',
  'bfc' => 'sit',
  'bus' => 'dmn',
  'kkl' => 'ngf',
  'sbp' => 'bnt',
  'euq' => 'mul',
  'bxq' => 'cdc',
  'tpw' => 'tup',
  'myn' => 'cai',
  'xmw' => 'pqw',
  'kvl' => 'kar',
  'yns' => 'bnt',
  'ykk' => 'pqe',
  'vmh' => 'ira',
  'bar' => 'gmw',
  'lks' => 'bnt',
  'tmm' => 'tai',
  'tut' => 'mul',
  'kng' => 'bnt',
  'zia' => 'ngf',
  'pln' => 'roa',
  'aku' => 'alv',
  'ndl' => 'bnt',
  'pfa' => 'pqe',
  'kca' => 'fiu',
  'vmg' => 'pqe',
  'avd' => 'ira',
  'lra' => 'poz',
  'wul' => 'ngf',
  'sir' => 'cdc',
  'ipi' => 'ngf',
  'xzm' => 'bat',
  'wlo' => 'poz',
  'tts' => 'tai',
  'xbc' => 'ira',
  'bav' => 'alv',
  'tmc' => 'cdc',
  'llq' => 'poz',
  'usk' => 'alv',
  'myl' => 'pqw',
  'nte' => 'bnt',
  'ino' => 'ngf',
  'mxv' => 'omq',
  'akb' => 'btk',
  'wlr' => 'pqe',
  'gbs' => 'alv',
  'crd' => 'sal',
  'gal' => 'pqe',
  'hav' => 'bnt',
  'tuf' => 'cba',
  'kwl' => 'cdc',
  'khy' => 'bnt',
  'dig' => 'bnt',
  'kix' => 'sit',
  'bqd' => 'alv',
  'ren' => 'mkh',
  'rar' => 'pqe',
  'dac' => 'pqe',
  'bqv' => 'alv',
  'nil' => 'pqe',
  'plh' => 'pqe',
  'bbq' => 'alv',
  'xbo' => 'trk',
  'ble' => 'alv',
  'fak' => 'alv',
  'mbb' => 'mno',
  'bcu' => 'pqe',
  'oog' => 'mkh',
  'cjo' => 'awd',
  'ogo' => 'alv',
  'guw' => 'alv',
  'mvm' => 'sit',
  'xmg' => 'bai',
  'sgd' => 'phi',
  'dgh' => 'cdc',
  'xub' => 'dra',
  'rhg' => 'inc',
  'gol' => 'alv',
  'cdc' => 'afa',
  'nlv' => 'nah',
  'tta' => 'sio',
  'sli' => 'gmw',
  'grk' => 'ine',
  'tms' => 'kdo',
  'ojs' => 'alg',
  'mub' => 'cdc',
  'tlt' => 'pqe',
  'snd' => 'inc',
  'ptt' => 'poz',
  'cak' => 'myn',
  'jat' => 'inc',
  'bgp' => 'ira',
  'zpf' => 'omq',
  'bsw' => 'cus',
  'kqx' => 'cdc',
  'tzh' => 'myn',
  'ula' => 'alv',
  'rue' => 'zle',
  'tbu' => 'azc',
  'mum' => 'pqe',
  'bnd' => 'pqe',
  'gae' => 'awd',
  'tcf' => 'omq',
  'mrv' => 'pqe',
  'abg' => 'ngf',
  'azz' => 'nah',
  'kqg' => 'alv',
  'vmm' => 'omq',
  'hag' => 'alv',
  'bll' => 'sio',
  'wne' => 'ira',
  'auy' => 'ngf',
  'yiu' => 'sit',
  'kxs' => 'xgn',
  'din' => 'sdv',
  'mxt' => 'omq',
  'aal' => 'cdc',
  'jiu' => 'sit',
  'mxu' => 'cdc',
  'ntm' => 'alv',
  'int' => 'sit',
  'xps' => 'ine',
  'lbl' => 'bik',
  'mse' => 'cdc',
  'nyk' => 'bnt',
  'vun' => 'bnt',
  'mbq' => 'pqe',
  'tor' => 'bad',
  'hsn' => 'zhx',
  'mmu' => 'bnt',
  'ddw' => 'pqe',
  'bhg' => 'ngf',
  'kva' => 'ccn',
  'llu' => 'pqe',
  'tnh' => 'ngf',
  'shn' => 'tai',
  'pps' => 'omq',
  'msw' => 'alv',
  'tte' => 'pqe',
  'skn' => 'poz',
  'pan' => 'inc',
  'nix' => 'bnt',
  'kke' => 'dmn',
  'acy' => 'sem',
  'kns' => 'mkh',
  'kty' => 'bnt',
  'tuw' => 'tut',
  'glc' => 'alv',
  'lki' => 'ira',
  'sdh' => 'ira',
  'udj' => 'pqe',
  'szg' => 'bnt',
  'ers' => 'tbq',
  'mgc' => 'csu',
  'kkg' => 'poz',
  'wbq' => 'dra',
  'ldh' => 'alv',
  'mer' => 'bnt',
  'mql' => 'alv',
  'muy' => 'cdc',
  'tvm' => 'pqe',
  'kai' => 'cdc',
  'acv' => 'hok',
  'nnd' => 'pqe',
  'bat' => 'ine',
  'xkg' => 'dmn',
  'zac' => 'omq',
  'reb' => 'pqe',
  'zlw' => 'sla',
  'slp' => 'pqe',
  'erg' => 'pqe',
  'mzk' => 'alv',
  'mqv' => 'ngf',
  'yaz' => 'alv',
  'tmr' => 'sem',
  'xgn' => 'tut',
  'btt' => 'alv',
  'ncb' => 'mkh',
  'llc' => 'dmn',
  'tzm' => 'ber',
  'slu' => 'pqe',
  'xks' => 'poz',
  'anu' => 'sdv',
  'lhp' => 'sit',
  'apx' => 'pqe',
  'kdf' => 'pqe',
  'koh' => 'bnt',
  'sqj' => 'ine',
  'ckq' => 'cdc',
  'mqk' => 'mno',
  'pmt' => 'pqe',
  'bmg' => 'bnt',
  'udg' => 'dra',
  'ndk' => 'bnt',
  'kwn' => 'bnt',
  'bwi' => 'awd',
  'btd' => 'btk',
  'yky' => 'alv',
  'awb' => 'ngf',
  'ksn' => 'poz',
  'kof' => 'cdc',
  'mke' => 'inc',
  'kin' => 'bnt',
  'tbt' => 'bnt',
  'chk' => 'pqe',
  'mjl' => 'inc',
  'bnn' => 'fox',
  'tpa' => 'pqe',
  'guo' => 'awd',
  'gah' => 'ngf',
  'loi' => 'alv',
  'ars' => 'sem',
  'kdn' => 'bnt',
  'ais' => 'map',
  'kts' => 'ngf',
  'wec' => 'kro',
  'aix' => 'pqe',
  'opm' => 'ngf',
  'goq' => 'pqw',
  'tvn' => 'sit',
  'bsj' => 'alv',
  'ofu' => 'alv',
  'too' => 'cai',
  'bpa' => 'pqe',
  'skm' => 'ngf',
  'kfa' => 'dra',
  'bdt' => 'alv',
  'zom' => 'sit',
  'cus' => 'afa',
  'mra' => 'mkh',
  'was' => 'hok',
  'fuu' => 'csu',
  'mkn' => 'poz',
  'tiq' => 'alv',
  'smx' => 'bnt',
  'lsa' => 'ira',
  'mdh' => 'phi',
  'vot' => 'fiu',
  'daz' => 'ngf',
  'siz' => 'ber',
  'leo' => 'bnt',
  'tig' => 'sem',
  'ssd' => 'ngf',
  'nli' => 'inc',
  'grr' => 'ber',
  'ssf' => 'fox',
  'syx' => 'bnt',
  'azm' => 'omq',
  'tke' => 'bnt',
  'bvb' => 'bnt',
  'smv' => 'inc',
  'xmz' => 'pqw',
  'adx' => 'tbq',
  'mdr' => 'pqw',
  'nbd' => 'bnt',
  'tsu' => 'fox',
  'maf' => 'cdc',
  'abs' => 'pqw',
  'als' => 'sqj',
  'cly' => 'omq',
  'wbr' => 'inc',
  'qxl' => 'qwe',
  'cbo' => 'alv',
  'zir' => 'alv',
  'tcz' => 'sit',
  'tii' => 'bnt',
  'dai' => 'alv',
  'syo' => 'mkh',
  'zho' => 'sit',
  'lww' => 'pqe',
  'bek' => 'pqe',
  'mgv' => 'bnt',
  'nhm' => 'nah',
  'xcb' => 'cel',
  'drn' => 'pqe',
  'yin' => 'mkh',
  'mni' => 'sit',
  'wyy' => 'pqe',
  'bqz' => 'bnt',
  'noc' => 'ngf',
  'boh' => 'bnt',
  'khf' => 'mkh',
  'bxp' => 'bnt',
  'ddg' => 'paa',
  'sly' => 'poz',
  'och' => 'zhx',
  'dos' => 'alv',
  'ngt' => 'mkh',
  'bex' => 'csu',
  'dzg' => 'ssa',
  'mdc' => 'ngf',
  'rga' => 'pqe',
  'ksx' => 'pqe',
  'btf' => 'cdc',
  'lmg' => 'pqe',
  'tsv' => 'bnt',
  'uba' => 'alv',
  'anx' => 'pqe',
  'veo' => 'hok',
  'agk' => 'bik',
  'ytp' => 'sit',
  'tln' => 'poz',
  'duo' => 'poz',
  'vae' => 'csu',
  'gdd' => 'pqe',
  'nnu' => 'alv',
  'tpm' => 'alv',
  'tij' => 'sit',
  'bkh' => 'bnt',
  'ksw' => 'kar',
  'snm' => 'csu',
  'mvh' => 'cdc',
  'qve' => 'qwe',
  'pnx' => 'mkh',
  'plf' => 'poz',
  'hrx' => 'gmw',
  'idr' => 'alv',
  'gwx' => 'alv',
  'tac' => 'azc',
  'zhx' => 'sit',
  'woc' => 'pqe',
  'ktq' => 'pqw',
  'tau' => 'ath',
  'syr' => 'sem',
  'skp' => 'poz',
  'kir' => 'trk',
  'ckx' => 'alv',
  'mko' => 'alv',
  'omv' => 'afa',
  'bou' => 'bnt',
  'apk' => 'apa',
  'nyu' => 'bnt',
  'xmr' => 'ssa',
  'res' => 'alv',
  'ngx' => 'cdc',
  'tlc' => 'cai',
  'fuj' => 'kdo',
  'bcv' => 'alv',
  'ydk' => 'ngf',
  'sro' => 'roa',
  'urh' => 'alv',
  'oml' => 'bnt',
  'pcj' => 'mun',
  'pcb' => 'mkh',
  'ctl' => 'omq',
  'thr' => 'inc',
  'dez' => 'bnt',
  'npn' => 'pqe',
  'mtx' => 'omq',
  'cim' => 'gmw',
  'bwn' => 'hmx',
  'ufi' => 'ngf',
  'zga' => 'bnt',
  'deq' => 'alv',
  'fah' => 'alv',
  'ncl' => 'nah',
  'dkk' => 'poz',
  'aqn' => 'poz',
  'pmf' => 'poz',
  'cpu' => 'awd',
  'ngo' => 'bnt',
  'kra' => 'inc',
  'kkx' => 'poz',
  'kqb' => 'ngf',
  'vmz' => 'omq',
  'tcs' => 'gmw',
  'dna' => 'ngf',
  'dka' => 'sit',
  'zbl' => 'art',
  'ccl' => 'bnt',
  'bcw' => 'cdc',
  'wbw' => 'pqe',
  'afe' => 'alv',
  'czh' => 'zhx',
  'grm' => 'poz',
  'rma' => 'cba',
  'gwn' => 'cdc',
  'glr' => 'kro',
  'ayh' => 'sem',
  'mxa' => 'omq',
  'tdd' => 'tai',
  'lai' => 'bnt',
  'sse' => 'pqw',
  'mfa' => 'pqw',
  'xmm' => 'poz',
  'kam' => 'bnt',
  'nxr' => 'ngf',
  'mun' => 'aav',
  'sei' => 'hok',
  'boy' => 'bnt',
  'cja' => 'cmc',
  'xtq' => 'ira',
  'ron' => 'roa',
  'lcq' => 'pqe',
  'txx' => 'poz',
  'dtr' => 'pqw',
  'tag' => 'kdo',
  'nci' => 'nah',
  'atk' => 'poz',
  'oyy' => 'pqe',
  'isg' => 'sgn',
  'bds' => 'cus',
  'noz' => 'omv',
  'kxi' => 'poz',
  'xkb' => 'alv',
  'twc' => 'cdc',
  'bcg' => 'alv',
  'lac' => 'myn',
  'bdq' => 'mkh',
  'kcf' => 'alv',
  'diu' => 'bnt',
  'bov' => 'alv',
  'msv' => 'cdc',
  'hop' => 'azc',
  'byo' => 'sit',
  'cfm' => 'sit',
  'gsl' => 'alv',
  'mzb' => 'ber',
  'efe' => 'csu',
  'raq' => 'sit',
  'fox' => 'map',
  'ycl' => 'sit',
  'ceb' => 'phi',
  'udm' => 'fiu',
  'lhs' => 'sem',
  'lap' => 'csu',
  'dbb' => 'cdc',
  'fmu' => 'dra',
  'kqf' => 'pqe',
  'bmk' => 'pqe',
  'sci' => 'poz',
  'npi' => 'inc',
  'ppl' => 'nah',
  'lzl' => 'pqe',
  'kub' => 'alv',
  'sby' => 'bnt',
  'bkt' => 'bnt',
  'gie' => 'kro',
  'chv' => 'trk',
  'bak' => 'trk',
  'bjl' => 'pqe',
  'wab' => 'pqe',
  'plu' => 'awd',
  'vay' => 'sit',
  'bhw' => 'pqe',
  'mab' => 'omq',
  'bnb' => 'poz',
  'yku' => 'sit',
  'hom' => 'bnt',
  'ntw' => 'iro',
  'som' => 'cus',
  'ksq' => 'cdc',
  'liv' => 'fiu',
  'xab' => 'alv',
  'mno' => 'phi',
  'geh' => 'gmw',
  'hch' => 'azc',
  'hwa' => 'kro',
  'shq' => 'bnt',
  'raw' => 'sit',
  'wem' => 'alv',
  'gbu' => 'aus',
  'bpy' => 'inc',
  'jib' => 'alv',
  'ati' => 'alv',
  'gao' => 'ngf',
  'ral' => 'sit',
  'bnm' => 'bnt',
  'hac' => 'ira',
  'fgr' => 'csu',
  'yhd' => 'sem',
  'wgi' => 'ngf',
  'zpc' => 'omq',
  'bjs' => 'gmw',
  'ole' => 'sit',
  'mxo' => 'bnt',
  'aae' => 'sqj',
  'slg' => 'poz',
  'cbk' => 'roa',
  'sai' => 'mul',
  'aey' => 'ngf',
  'gud' => 'kro',
  'xmf' => 'ccs',
  'kbd' => 'ccn',
  'mmt' => 'pqe',
  'xts' => 'omq',
  'ddn' => 'son',
  'ndr' => 'alv',
  'ngr' => 'pqe',
  'vut' => 'alv',
  'nms' => 'pqe',
  'bld' => 'poz',
  'qul' => 'qwe',
  'adf' => 'sem',
  'tbz' => 'alv',
  'ifb' => 'poz',
  'bes' => 'alv',
  'dua' => 'bnt',
  'mlx' => 'pqe',
  'ndw' => 'bnt',
  'bkr' => 'poz',
  'brb' => 'mkh',
  'smc' => 'ngf',
  'tam' => 'dra',
  'aaa' => 'alv',
  'xlu' => 'ine',
  'kma' => 'alv',
  'kxc' => 'cus',
  'mtt' => 'pqe',
  'abu' => 'alv',
  'bhz' => 'poz',
  'kua' => 'bnt',
  'pab' => 'awd',
  'bmw' => 'bnt',
  'ksc' => 'poz',
  'kap' => 'ccn',
  'bwh' => 'alv',
  'nak' => 'pqe',
  'sek' => 'ath',
  'nso' => 'bnt',
  'twh' => 'tai',
  'los' => 'pqe',
  'asg' => 'alv',
  'eki' => 'alv',
  'cch' => 'alv',
  'rnn' => 'pqe',
  'buy' => 'alv',
  'abv' => 'sem',
  'aoa' => 'roa',
  'toc' => 'cai',
  'kml' => 'poz',
  'mdd' => 'alv',
  'aye' => 'alv',
  'sob' => 'pqe',
  'mrb' => 'pqe',
  'phl' => 'inc',
  'naw' => 'alv',
  'nuy' => 'aus',
  'ssx' => 'ngf',
  'pot' => 'alg',
  'kni' => 'alv',
  'ngj' => 'alv',
  'kzc' => 'alv',
  'bbt' => 'cdc',
  'tbe' => 'pqe',
  'aox' => 'awd',
  'ssa' => 'mul',
  'yor' => 'alv',
  'roe' => 'pqe',
  'bgs' => 'mno',
  'jya' => 'tbq',
  'mcs' => 'alv',
  'tge' => 'sit',
  'ldj' => 'alv',
  'kow' => 'alv',
  'hus' => 'myn',
  'apu' => 'awd',
  'tco' => 'sit',
  'kwu' => 'bnt',
  'ukq' => 'alv',
  'mrp' => 'pqe',
  'gme' => 'gem',
  'sra' => 'ngf',
  'ztn' => 'omq',
  'hoe' => 'alv',
  'bga' => 'alv',
  'bom' => 'alv',
  'oui' => 'trk',
  'daw' => 'poz',
  'nbu' => 'sit',
  'uda' => 'alv',
  'dni' => 'ngf',
  'zsr' => 'omq',
  'mtl' => 'cdc',
  'zhb' => 'sit',
  'kfc' => 'dra',
  'ego' => 'alv',
  'rmc' => 'inc',
  'lmd' => 'kdo',
  'hve' => 'cai',
  'mtg' => 'ngf',
  'sgk' => 'sit',
  'kdo' => 'nic',
  'qvi' => 'qwe',
  'yki' => 'pqe',
  'eng' => 'gmw',
  'amk' => 'pqe',
  'cgk' => 'sit',
  'fay' => 'ira',
  'aul' => 'pqe',
  'qya' => 'art',
  'xnh' => 'mkh',
  'ria' => 'sit',
  'awc' => 'alv',
  'peg' => 'dra',
  'nut' => 'tai',
  'alo' => 'pqe',
  'xow' => 'ngf',
  'kaa' => 'trk',
  'eke' => 'alv',
  'dhs' => 'bnt',
  'bmh' => 'ngf',
  'axx' => 'pqe',
  'kmq' => 'ssa',
  'ned' => 'alv',
  'pem' => 'bnt',
  'abd' => 'poz',
  'msn' => 'pqe',
  'cta' => 'omq',
  'tsc' => 'bnt',
  'tpl' => 'omq',
  'ngw' => 'cdc',
  'pfe' => 'alv',
  'gin' => 'ccn',
  'cam' => 'pqe',
  'enq' => 'ngf',
  'qvj' => 'qwe',
  'ypg' => 'sit',
  'txh' => 'ine',
  'zai' => 'omq',
  'sib' => 'poz',
  'ful' => 'alv',
  'zua' => 'cdc',
  'mhn' => 'gmw',
  'mgw' => 'bnt',
  'kbn' => 'alv',
  'saf' => 'alv',
  'btj' => 'poz',
  'hae' => 'cus',
  'sba' => 'csu',
  'yac' => 'ngf',
  'nhu' => 'alv',
  'rgr' => 'awd',
  'ldn' => 'art',
  'yim' => 'sit',
  'kxv' => 'dra',
  'vao' => 'pqe',
  'tng' => 'cdc',
  'bir' => 'ngf',
  'prk' => 'mkh',
  'kwd' => 'pqe',
  'kaf' => 'sit',
  'mku' => 'dmn',
  'lla' => 'alv',
  'kiu' => 'ira',
  'ima' => 'dra',
  'dtd' => 'wak',
  'swb' => 'bnt',
  'ncc' => 'pqe',
  'bix' => 'mun',
  'lhu' => 'tbq',
  'yaf' => 'bnt',
  'pox' => 'zlw',
  'gve' => 'pqe',
  'cdf' => 'sit',
  'aqa' => 'sai',
  'jda' => 'sit',
  'mmw' => 'pqe',
  'zar' => 'omq',
  'bep' => 'poz',
  'tkv' => 'pqe',
  'wsv' => 'inc',
  'ktv' => 'mkh',
  'afu' => 'alv',
  'bfz' => 'inc',
  'bve' => 'poz',
  'gmd' => 'alv',
  'mfb' => 'pqw',
  'mrh' => 'sit',
  'mlz' => 'poz',
  'bvm' => 'alv',
  'zsu' => 'pqe',
  'ubi' => 'cdc',
  'dob' => 'pqe',
  'sjd' => 'smi',
  'xbp' => 'aus',
  'loy' => 'sit',
  'amu' => 'omq',
  'fin' => 'fiu',
  'dbm' => 'alv',
  'bwp' => 'ngf',
  'ktr' => 'poz',
  'nkh' => 'sit',
  'bfo' => 'alv',
  'mpn' => 'pqe',
  'kne' => 'poz',
  'lan' => 'alv',
  'tgf' => 'sit',
  'brl' => 'bnt',
  'bhn' => 'sem',
  'wen' => 'zlw',
  'cuh' => 'bnt',
  'kyr' => 'tup',
  'ksu' => 'tai',
  'goo' => 'pqe',
  'snc' => 'pqe',
  'uya' => 'alv',
  'aoz' => 'pqe',
  'shk' => 'sdv',
  'zas' => 'omq',
  'csk' => 'alv',
  'scq' => 'mkh',
  'srr' => 'alv',
  'mau' => 'omq',
  'kou' => 'alv',
  'gvs' => 'pqe',
  'sgu' => 'pqe',
  'bmo' => 'alv',
  'tgs' => 'pqe',
  'evh' => 'alv',
  'frc' => 'roa',
  'upv' => 'pqe',
  'ayk' => 'alv',
  'lng' => 'gmw',
  'fit' => 'fiu',
  'mmq' => 'ngf',
  'ayl' => 'sem',
  'smt' => 'sit',
  'aub' => 'sit',
  'cdj' => 'inc',
  'ktw' => 'ath',
  'mkm' => 'pqw',
  'nda' => 'bnt',
  'nwe' => 'bai',
  'nrz' => 'pqe',
  'gna' => 'alv',
  'bns' => 'inc',
  'bhl' => 'ngf',
  'khm' => 'mkh',
  'kdj' => 'sdv',
  'nst' => 'sit',
  'mad' => 'pqw',
  'dag' => 'alv',
  'phh' => 'sit',
  'rir' => 'poz',
  'ind' => 'pqw',
  'kyj' => 'phi',
  'mmf' => 'cdc',
  'sys' => 'csu',
  'mfk' => 'cdc',
  'not' => 'awd',
  'oto' => 'omq',
  'lil' => 'sal',
  'uuu' => 'mkh',
  'app' => 'pqe',
  'aig' => 'gmw',
  'nlk' => 'ngf',
  'kaz' => 'trk',
  'pmo' => 'pqe',
  'leq' => 'ngf',
  'tsg' => 'poz',
  'muq' => 'hmx',
  'isl' => 'gmq',
  'poe' => 'omq',
  'xpu' => 'sem',
  'gaj' => 'ngf',
  'bth' => 'poz',
  'xsv' => 'bat',
  'ish' => 'alv',
  'zmi' => 'poz',
  'bvw' => 'cdc',
  'cms' => 'ine',
  'pbp' => 'alv',
  'ivb' => 'poz',
  'ave' => 'ira',
  'mip' => 'omq',
  'ggb' => 'kro',
  'est' => 'urj',
  'bml' => 'bnt',
  'tia' => 'ber',
  'lgh' => 'sit',
  'yir' => 'ngf',
  'kfz' => 'alv',
  'gbk' => 'inc',
  'tjl' => 'tai',
  'kly' => 'poz',
  'nmg' => 'bnt',
  'bxm' => 'xgn',
  'fab' => 'roa',
  'kvr' => 'pqw',
  'huy' => 'sem',
  'guk' => 'ssa',
  'ved' => 'inc',
  'uln' => 'gmw',
  'zca' => 'omq',
  'wmn' => 'pqe',
  'dgr' => 'ath',
  'tsd' => 'grk',
  'awv' => 'ngf',
  'apd' => 'sem',
  'abp' => 'poz',
  'scl' => 'inc',
  'bci' => 'alv',
  'act' => 'gmw',
  'ukw' => 'alv',
  'yan' => 'cai',
  'ady' => 'ccn',
  'nka' => 'bnt',
  'mhr' => 'urj',
  'sbw' => 'bnt',
  'wss' => 'alv',
  'buj' => 'alv',
  'bby' => 'alv',
  'lky' => 'sdv',
  'itw' => 'alv',
  'sed' => 'mkh',
  'alk' => 'mkh',
  'hsb' => 'wen',
  'omr' => 'inc',
  'okr' => 'ijo',
  'bxs' => 'alv',
  'hmc' => 'hmx',
  'azb' => 'trk',
  'ldb' => 'alv',
  'yay' => 'alv',
  'mlv' => 'pqe',
  'awx' => 'ngf',
  'gld' => 'tuw',
  'kks' => 'cdc',
  'bib' => 'dmn',
  'dlm' => 'roa',
  'drs' => 'cus',
  'rkh' => 'pqe',
  'tsn' => 'bnt',
  'srd' => 'roa',
  'vmc' => 'omq',
  'blt' => 'tai',
  'wuh' => 'sit',
  'vem' => 'cdc',
  'iof' => 'kdo',
  'glv' => 'cel',
  'pih' => 'gmw',
  'mho' => 'bnt',
  'nnq' => 'bnt',
  'stg' => 'mkh',
  'kvh' => 'pqe',
  'zlm' => 'poz',
  'tbx' => 'pqe',
  'tnn' => 'pqe',
  'bal' => 'ira',
  'dms' => 'poz',
  'wea' => 'kar',
  'nof' => 'ngf',
  'lin' => 'bnt',
  'ill' => 'poz',
  'mma' => 'alv',
  'ary' => 'sem',
  'oke' => 'alv',
  'bgt' => 'pqe',
  'brs' => 'poz',
  'tox' => 'pqe',
  'kzo' => 'bnt',
  'bvk' => 'poz',
  'www' => 'alv',
  'msq' => 'pqe',
  'xtg' => 'cel',
  'xwe' => 'alv',
  'aaf' => 'dra',
  'xpi' => 'cel',
  'yut' => 'ngf',
  'muc' => 'alv',
  'amw' => 'sem',
  'xpe' => 'dmn',
  'kwz' => 'khi',
  'tnl' => 'pqe',
  'mrl' => 'pqe',
  'mls' => 'ssa',
  'jmn' => 'sit',
  'yas' => 'bnt',
  'eko' => 'bnt',
  'pss' => 'pqe',
  'ruo' => 'roa',
  'shi' => 'ber',
  'ann' => 'alv',
  'tpz' => 'pqe',
  'huw' => 'pqe',
  'bun' => 'alv',
  'psh' => 'inc',
  'zin' => 'bnt',
  'kji' => 'pqe',
  'bfm' => 'alv',
  'nie' => 'alv',
  'gez' => 'sem',
  'fli' => 'cdc',
  'gmh' => 'gmw',
  'nsh' => 'alv',
  'arz' => 'sem',
  'tif' => 'ngf',
  'dgg' => 'pqe',
  'mtq' => 'mkh',
  'ccg' => 'alv',
  'grz' => 'pqe',
  'mvz' => 'sem',
  'myb' => 'csu',
  'tur' => 'trk',
  'ptr' => 'pqe',
  'ssb' => 'pqw',
  'alp' => 'pqe',
  'mfo' => 'alv',
  'srq' => 'tup',
  'qws' => 'qwe',
  'llf' => 'pqe',
  'txc' => 'ath',
  'eip' => 'ngf',
  'kpg' => 'pqe',
  'bjr' => 'ngf',
  'nlx' => 'inc',
  'ghl' => 'nub',
  'tvt' => 'sit',
  'nto' => 'bnt',
  'jvn' => 'poz',
  'meq' => 'cdc',
  'drc' => 'roa',
  'lun' => 'bnt',
  'enh' => 'syd',
  'lle' => 'pqe',
  'nyg' => 'bnt',
  'lpx' => 'sdv',
  'nca' => 'ngf',
  'gru' => 'sem',
  'wob' => 'kro',
  'mxr' => 'pqw',
  'ilo' => 'phi',
  'enb' => 'sdv',
  'zdj' => 'bnt',
  'gdk' => 'cdc',
  'bag' => 'bnt',
  'osi' => 'poz',
  'dgk' => 'csu',
  'tkb' => 'inc',
  'sjw' => 'alg',
  'zhn' => 'tai',
  'ymx' => 'sit',
  'rmz' => 'sit',
  'zpw' => 'omq',
  'gip' => 'pqe',
  'hat' => 'roa',
  'cvg' => 'sit',
  'blp' => 'pqe',
  'jek' => 'dmn',
  'wka' => 'cus',
  'por' => 'roa',
  'llk' => 'pqw',
  'pey' => 'gmw',
  'fiu' => 'urj',
  'sms' => 'smi',
  'dhn' => 'inc',
  'taq' => 'ber',
  'sub' => 'bnt',
  'nvh' => 'pqe',
  'mky' => 'pqe',
  'hka' => 'bnt',
  'bfg' => 'poz',
  'zax' => 'omq',
  'agv' => 'poz',
  'zau' => 'sit',
  'zap' => 'omq',
  'bam' => 'dmn',
  'hup' => 'ath',
  'pli' => 'inc',
  'tkd' => 'pqe',
  'zpq' => 'omq',
  'elu' => 'pqe',
  'pat' => 'pqe',
  'kuu' => 'ath',
  'bfy' => 'inc',
  'kzf' => 'poz',
  'hts' => 'khi',
  'mhl' => 'ngf',
  'blo' => 'alv',
  'tqu' => 'paa',
  'mzd' => 'bnt',
  'lto' => 'bnt',
  'ibg' => 'phi',
  'tnx' => 'pqe',
  'waj' => 'ngf',
  'stl' => 'gmw',
  'anc' => 'cdc',
  'atz' => 'poz',
  'gyb' => 'ngf',
  'tap' => 'bnt',
  'lrz' => 'pqe',
  'wnc' => 'ngf',
  'pnl' => 'alv',
  'sqm' => 'alv',
  'clc' => 'ath',
  'zah' => 'cdc',
  'lao' => 'tai',
  'tra' => 'inc',
  'gex' => 'cus',
  'shy' => 'ber',
  'wat' => 'pqe',
  'tmo' => 'mkh',
  'sgi' => 'alv',
  'ebo' => 'bnt',
  'ngy' => 'bnt',
  'lme' => 'cdc',
  'olt' => 'bat',
  'xty' => 'omq',
  'bip' => 'bnt',
  'nkk' => 'pqe',
  'aec' => 'sem',
  'ttj' => 'bnt',
  'lor' => 'alv',
  'ajg' => 'alv',
  'aar' => 'cus',
  'trd' => 'mun',
  'qup' => 'qwe',
  'nyd' => 'bnt',
  'aot' => 'sit',
  'cks' => 'roa',
  'bgd' => 'inc',
  'god' => 'kro',
  'ndz' => 'alv',
  'hoy' => 'dra',
  'iry' => 'poz',
  'cnw' => 'sit',
  'loq' => 'bnt',
  'slx' => 'bnt',
  'cmr' => 'sit',
  'mco' => 'cai',
  'cld' => 'sem',
  'nuv' => 'alv',
  'ncn' => 'pqe',
  'knu' => 'dmn',
  'zaf' => 'omq',
  'mxc' => 'bnt',
  'bfw' => 'mun',
  'bau' => 'alv',
  'lad' => 'roa',
  'hem' => 'bnt',
  'mzz' => 'pqe',
  'mam' => 'myn',
  'mxl' => 'alv',
  'mah' => 'pqe',
  'aaw' => 'pqe',
  'lwm' => 'sit',
  'med' => 'ngf',
  'nau' => 'pqe',
  'bbd' => 'ngf',
  'udi' => 'ccn',
  'mof' => 'alg',
  'mux' => 'ngf',
  'gft' => 'sem',
  'gno' => 'dra',
  'atd' => 'mno',
  'dim' => 'omv',
  'buw' => 'bnt',
  'azc' => 'cai',
  'myv' => 'fiu',
  'qxc' => 'qwe',
  'qvm' => 'qwe',
  'rsl' => 'sgn',
  'zgh' => 'ber',
  'ksb' => 'bnt',
  'jul' => 'sit',
  'yli' => 'ngf',
  'dwa' => 'cdc',
  'mws' => 'bnt',
  'nzk' => 'znd',
  'low' => 'poz',
  'kha' => 'mkh',
  'dri' => 'alv',
  'kay' => 'tup',
  'tnb' => 'cba',
  'bvy' => 'poz',
  'sns' => 'pqe',
  'bra' => 'inc',
  'ruc' => 'bnt',
  'acm' => 'sem',
  'wib' => 'alv',
  'smo' => 'pqe',
  'nxg' => 'pqe',
  'maa' => 'omq',
  'bzo' => 'bnt',
  'clu' => 'poz',
  'bzt' => 'art',
  'gbp' => 'alv',
  'ysy' => 'sit',
  'ava' => 'ccn',
  'khk' => 'xgn',
  'shr' => 'bnt',
  'ynq' => 'alv',
  'key' => 'inc',
  'zrn' => 'cdc',
  'pug' => 'alv',
  'kgn' => 'ira',
  'scw' => 'cdc',
  'mix' => 'omq',
  'yea' => 'dra',
  'toy' => 'poz',
  'qyp' => 'alg',
  'pbe' => 'omq',
  'mrt' => 'cdc',
  'mpp' => 'ngf',
  'xaw' => 'azc',
  'ste' => 'pqe',
  'akf' => 'alv',
  'mdi' => 'csu',
  'iby' => 'ijo',
  'mfh' => 'cdc',
  'mpd' => 'awd',
  'dpp' => 'poz',
  'aez' => 'ngf',
  'ntk' => 'bnt',
  'mnj' => 'ira',
  'bkj' => 'bnt',
  'phu' => 'tai',
  'puo' => 'mkh',
  'enu' => 'sit',
  'ine' => 'mul',
  'wbi' => 'bnt',
  'jeu' => 'cdc',
  'rav' => 'sit',
  'bks' => 'poz',
  'lje' => 'poz',
  'ksz' => 'mun',
  'gvf' => 'ngf',
  'wah' => 'pqe',
  'kzv' => 'ngf',
  'ktu' => 'bnt',
  'bjz' => 'ngf',
  'owl' => 'cel',
  'nza' => 'alv',
  'cuj' => 'awd',
  'mnv' => 'pqe',
  'zoo' => 'omq',
  'gbq' => 'alv',
  'csb' => 'zlw',
  'mrr' => 'dra',
  'szw' => 'pqe',
  'bcy' => 'cdc',
  'dya' => 'alv',
  'mia' => 'alg',
  'wci' => 'alv',
  'pup' => 'ngf',
  'wic' => 'cdd',
  'byb' => 'alv',
  'cml' => 'poz',
  'opt' => 'azc',
  'abh' => 'sem',
  'tgc' => 'pqe',
  'beb' => 'bnt',
  'yuf' => 'hok',
  'gju' => 'inc',
  'ile' => 'art',
  'hvk' => 'pqe',
  'nyb' => 'alv',
  'byq' => 'map',
  'mic' => 'alg',
  'neb' => 'dmn',
  'gag' => 'trk',
  'aiq' => 'ira',
  'ciw' => 'alg',
  'del' => 'alg',
  'mjy' => 'alg',
  'afa' => 'mul',
  'arb' => 'sem',
  'mln' => 'pqe',
  'mil' => 'omq',
  'fll' => 'alv',
  'nai' => 'mul',
  'asz' => 'pqe',
  'xhe' => 'inc',
  'azd' => 'nah',
  'sya' => 'pqw',
  'ysn' => 'sit',
  'ijj' => 'alv',
  'kfm' => 'ira',
  'obl' => 'alv',
  'wud' => 'alv',
  'kfy' => 'inc',
  'csa' => 'omq',
  'pua' => 'cai',
  'sel' => 'syd',
  'xom' => 'ssa',
  'dre' => 'sit',
  'acr' => 'myn',
  'mmi' => 'ngf',
  'mdp' => 'bnt',
  'ksp' => 'csu',
  'bzk' => 'gmw',
  'sqq' => 'mkh',
  'sjn' => 'art',
  'kjz' => 'sit',
  'msx' => 'ngf',
  'bkz' => 'pqw',
  'kqm' => 'alv',
  'anw' => 'alv',
  'byi' => 'bnt',
  'nzi' => 'alv',
  'pon' => 'pqe',
  'mwn' => 'bnt',
  'skt' => 'bnt',
  'yml' => 'pqe',
  'mih' => 'omq',
  'vnp' => 'pqe',
  'mxq' => 'cai',
  'roc' => 'cmc',
  'ssk' => 'sit',
  'wli' => 'paa',
  'orm' => 'cus',
  'hvn' => 'pqe',
  'nhh' => 'inc',
  'nlz' => 'pqe',
  'xed' => 'cdc',
  'kug' => 'alv',
  'enw' => 'alv',
  'bcs' => 'alv',
  'onp' => 'sit',
  'kck' => 'bnt',
  'bto' => 'bik',
  'ega' => 'alv',
  'bsg' => 'ira',
  'tae' => 'awd',
  'hig' => 'cdc',
  'bsl' => 'alv',
  'wau' => 'awd',
  'yhl' => 'sit',
  'kbq' => 'ngf',
  'heg' => 'pqe',
  'ayg' => 'alv',
  'wle' => 'sem',
  'zbe' => 'pqw',
  'jmc' => 'bnt',
  'haa' => 'ath',
  'mdw' => 'bnt',
  'nql' => 'bnt',
  'grc' => 'grk',
  'krw' => 'kro',
  'etb' => 'alv',
  'dww' => 'pqe',
  'ndd' => 'alv',
  'ray' => 'pqe',
  'xkz' => 'sit',
  'ngv' => 'alv',
  'slm' => 'pqw',
  'gwi' => 'ath',
  'wji' => 'cdc',
  'brg' => 'awd',
  'bsi' => 'bnt',
  'jie' => 'cdc',
  'qvy' => 'sit',
  'gkn' => 'alv',
  'fer' => 'alv',
  'bqi' => 'ira',
  'jye' => 'sem',
  'izr' => 'alv',
  'ktf' => 'bnt',
  'sur' => 'cdc',
  'nup' => 'alv',
  'tzo' => 'myn',
  'bhp' => 'pqe',
  'cnb' => 'sit',
  'cuk' => 'cba',
  'nnl' => 'sit',
  'vec' => 'roa',
  'bed' => 'pqe',
  'bkb' => 'poz',
  'mza' => 'omq',
  'auq' => 'pqe',
  'gyr' => 'tup',
  'mox' => 'pqe',
  'aaq' => 'alg',
  'kyu' => 'kar',
  'lnn' => 'pqe',
  'crb' => 'awd',
  'kmo' => 'paa',
  'bsr' => 'alv',
  'slz' => 'pqe',
  'bzz' => 'alv',
  'wng' => 'ngf',
  'ske' => 'pqe',
  'eri' => 'ngf',
  'syc' => 'sem',
  'pse' => 'pqw',
  'paw' => 'cdd',
  'iwk' => 'poz',
  'ckb' => 'ira',
  'tpe' => 'sit',
  'pum' => 'sit',
  'aqg' => 'alv',
  'kjg' => 'mkh',
  'hno' => 'inc',
  'lgu' => 'pqe',
  'wbh' => 'bnt',
  'bnc' => 'poz',
  'how' => 'sit',
  'ido' => 'art',
  'lkc' => 'sit',
  'ahb' => 'pqe',
  'ney' => 'kro',
  'bgn' => 'ira',
  'kbz' => 'cdc',
  'ixc' => 'omq',
  'qxq' => 'trk',
  'caq' => 'mkh',
  'hrv' => 'zls',
  'kjs' => 'ngf',
  'jmd' => 'pqe',
  'ahh' => 'ngf',
  'rom' => 'inc',
  'ykm' => 'pqe',
  'ser' => 'azc',
  'ora' => 'pqe',
  'aud' => 'pqe',
  'zaq' => 'omq',
  'caa' => 'myn',
  'win' => 'sio',
  'soz' => 'bnt',
  'txn' => 'pqe',
  'igw' => 'alv',
  'laa' => 'poz',
  'mhf' => 'ngf',
  'bhy' => 'bnt',
  'yuy' => 'xgn',
  'ril' => 'mkh',
  'que' => 'qwe',
  'sgy' => 'ira',
  'mwm' => 'csu',
  'bif' => 'alv',
  'vit' => 'alv',
  'nhg' => 'nah',
  'tuq' => 'ssa',
  'irr' => 'aav',
  'got' => 'gme',
  'nal' => 'pqe',
  'bqx' => 'alv',
  'mdf' => 'fiu',
  'nnt' => 'alg',
  'ssh' => 'sem',
  'ypp' => 'sit',
  'pop' => 'pqe',
  'ify' => 'phi',
  'efa' => 'alv',
  'hml' => 'hmx',
  'gya' => 'alv',
  'kbg' => 'sit',
  'nwa' => 'alg',
  'grg' => 'ngf',
  'ths' => 'sit',
  'kxf' => 'kar',
  'mgg' => 'bnt',
  'ngd' => 'bnt',
  'phg' => 'mkh',
  'mll' => 'pqe',
  'tar' => 'azc',
  'lch' => 'bnt',
  'ppm' => 'pqe',
  'rnw' => 'bnt',
  'tgk' => 'ira',
  'twl' => 'bnt',
  'twx' => 'bnt',
  'bfq' => 'dra',
  'emx' => 'inc',
  'zpp' => 'omq',
  'otk' => 'trk',
  'nov' => 'art',
  'nse' => 'bnt',
  'tvs' => 'bnt',
  'noy' => 'alv',
  'gpa' => 'alv',
  'cbj' => 'alv',
  'txo' => 'sit',
  'kqr' => 'pqw',
  'ogc' => 'alv',
  'mpt' => 'ngf',
  'pia' => 'azc',
  'quc' => 'myn',
  'lgl' => 'pqe',
  'spq' => 'roa',
  'nti' => 'alv',
  'mna' => 'pqe',
  'tdy' => 'poz',
  'cnl' => 'omq',
  'bwf' => 'pqe',
  'kmj' => 'dra',
  'bss' => 'bnt',
  'mro' => 'sit',
  'gwe' => 'bnt',
  'kdk' => 'pqe',
  'qur' => 'qwe',
  'mye' => 'bnt',
  'nat' => 'alv',
  'tyn' => 'ngf',
  'ngf' => 'paa',
  'kcu' => 'bnt',
  'hob' => 'pqe',
  'prt' => 'mkh',
  'rmo' => 'inc',
  'hin' => 'inc',
  'wag' => 'pqe',
  'dnw' => 'ngf',
  'tbf' => 'pqe',
  'awo' => 'alv',
  'rax' => 'alv',
  'bme' => 'alv',
  'bud' => 'alv',
  'mvx' => 'pqe',
  'pcn' => 'alv',
  'wxa' => 'zhx',
  'kpv' => 'urj',
  'obi' => 'hok',
  'ksl' => 'pqe',
  'tcx' => 'dra',
  'bzi' => 'sit',
  'nsg' => 'sdv',
  'zts' => 'omq',
  'mdn' => 'bnt',
  'tys' => 'tai',
  'tlu' => 'pqe',
  'jnd' => 'inc',
  'wap' => 'awd',
  'mua' => 'alv',
  'xld' => 'ine',
  'zkr' => 'sit',
  'cjv' => 'ngf',
  'fub' => 'alv',
  'lse' => 'bnt',
  'kic' => 'alg',
  'nkr' => 'pqe',
  'inm' => 'sem',
  'acx' => 'sem',
  'str' => 'sal',
  'ikt' => 'esx',
  'ndp' => 'csu',
  'kys' => 'pqw',
  'unm' => 'alg',
  'bej' => 'cus',
  'slq' => 'trk',
  'ykl' => 'sit',
  'ank' => 'cdc',
  'djo' => 'poz',
  'goy' => 'alv',
  'kqo' => 'kro',
  'hnd' => 'inc',
  'csh' => 'sit',
  'kcy' => 'son',
  'rki' => 'sit',
  'szn' => 'pqe',
  'nds' => 'gmw',
  'nog' => 'trk',
  'cnt' => 'omq',
  'zpy' => 'omq',
  'cbl' => 'sit',
  'zgn' => 'tai',
  'plq' => 'ine',
  'lgr' => 'pqe',
  'yey' => 'bnt',
  'kwb' => 'alv',
  'gsp' => 'ngf',
  'zav' => 'omq',
  'saw' => 'ngf',
  'tdf' => 'mkh',
  'krd' => 'pqe',
  'ttw' => 'poz',
  'mwl' => 'roa',
  'trs' => 'omq',
  'jyy' => 'csu',
  'cri' => 'roa',
  'cgg' => 'bnt',
  'nsn' => 'pqe',
  'ptp' => 'pqe',
  'qlm' => 'gmw',
  'tyr' => 'tai',
  'rji' => 'sit',
  'bzj' => 'gmw',
  'kue' => 'ngf',
  'dro' => 'poz',
  'xbm' => 'cel',
  'aru' => 'auf',
  'oji' => 'alg',
  'pnc' => 'poz',
  'ltc' => 'zhx',
  'paq' => 'inc',
  'cog' => 'mkh',
  'omg' => 'tup',
  'dec' => 'kdo',
  'ltz' => 'gmw',
  'cnc' => 'sit',
  'bzl' => 'poz',
  'ymk' => 'bnt',
  'plj' => 'cdc',
  'iyx' => 'bnt',
  'twy' => 'pqw',
  'mfe' => 'roa',
  'bpq' => 'poz',
  'zsa' => 'pqe',
  'tlv' => 'pqe',
  'nae' => 'pqe',
  'aao' => 'sem',
  'otn' => 'oto',
  'ort' => 'inc',
  'law' => 'poz',
  'tpx' => 'omq',
  'tnt' => 'phi',
  'zpk' => 'omq',
  'twr' => 'azc',
  'tbj' => 'pqe',
  'auh' => 'bnt',
  'bdx' => 'poz',
  'srz' => 'ira',
  'tjs' => 'sit',
  'sbx' => 'poz',
  'mlk' => 'bnt',
  'wed' => 'pqe',
  'itz' => 'myn',
  'tvd' => 'alv',
  'lup' => 'bnt',
  'bpi' => 'ngf',
  'men' => 'dmn',
  'bie' => 'ngf',
  'kpn' => 'tup',
  'zim' => 'cdc',
  'nmm' => 'sit',
  'smr' => 'pqw',
  'den' => 'ath',
  'ldq' => 'alv',
  'sod' => 'bnt',
  'tmy' => 'pqe',
  'ncr' => 'alv',
  'mqp' => 'pqe',
  'bxg' => 'bnt',
  'bzc' => 'poz',
  'tdb' => 'inc',
  'akp' => 'alv',
  'mfd' => 'alv',
  'mss' => 'pqe',
  'kie' => 'ssa',
  'klk' => 'alv',
  'cbb' => 'awd',
  'beg' => 'pqw',
  'bzq' => 'pqe',
  'bcp' => 'bnt',
  'doh' => 'alv',
  'asv' => 'csu',
  'pei' => 'oto',
  'alz' => 'sdv',
  'lti' => 'pqe',
  'grb' => 'kro',
  'bbs' => 'alv',
  'qwa' => 'qwe',
  'cac' => 'myn',
  'sez' => 'sit',
  'ppn' => 'pqe',
  'njb' => 'sit',
  'hji' => 'poz',
  'kkk' => 'pqe',
  'cme' => 'alv',
  'cow' => 'sal',
  'teo' => 'sdv',
  'kzr' => 'alv',
  'kyh' => 'hok',
  'esu' => 'ypk',
  'ggo' => 'dra',
  'mbz' => 'omq',
  'ytl' => 'sit',
  'ons' => 'ngf',
  'ikx' => 'ssa',
  'dnu' => 'mkh',
  'buu' => 'bnt',
  'ifu' => 'poz',
  'sld' => 'alv',
  'asl' => 'pqe',
  'pnr' => 'ngf',
  'ebg' => 'alv',
  'wlw' => 'ngf',
  'pao' => 'azc',
  'nnf' => 'ngf',
  'vrt' => 'pqe',
  'swe' => 'gmq',
  'sho' => 'dmn',
  'xcg' => 'cel',
  'dyo' => 'alv',
  'lns' => 'alv',
  'ina' => 'art',
  'mxi' => 'roa',
  'bgi' => 'poz',
  'bcm' => 'pqe',
  'sxr' => 'fox',
  'kgj' => 'sit',
  'sxe' => 'bnt',
  'agh' => 'bnt',
  'cjp' => 'cba',
  'smu' => 'mkh',
  'vah' => 'inc',
  'aeu' => 'sit',
  'gym' => 'cba',
  'laz' => 'pqe',
  'sfe' => 'poz',
  'nhk' => 'nah',
  'kyg' => 'ngf',
  'cea' => 'sal',
  'mce' => 'omq',
  'bsy' => 'poz',
  'nus' => 'sdv',
  'smp' => 'sem',
  'poi' => 'cai',
  'swy' => 'cdc',
  'its' => 'alv',
  'sgb' => 'poz',
  'glg' => 'roa',
  'ctd' => 'sit',
  'kcl' => 'pqe',
  'han' => 'bnt',
  'gaz' => 'cus',
  'sqo' => 'ira',
  'mnr' => 'azc',
  'aws' => 'ngf',
  'frd' => 'pqe',
  'dun' => 'pqw',
  'una' => 'pqe',
  'mee' => 'pqe',
  'kae' => 'map',
  'shx' => 'hmx',
  'hmf' => 'hmx',
  'bmb' => 'bnt',
  'brv' => 'mkh',
  'mjp' => 'dra',
  'yno' => 'tai',
  'bgc' => 'inc',
  'lou' => 'roa',
  'awn' => 'cus',
  'nek' => 'pqe',
  'rmw' => 'inc',
  'bty' => 'pqe',
  'gui' => 'tup',
  'goc' => 'pqe',
  'hif' => 'inc',
  'bev' => 'kro',
  'llx' => 'pqe',
  'lez' => 'ccn',
  'ctu' => 'myn',
  'wls' => 'pqe',
  'keo' => 'sdv',
  'orv' => 'zle',
  'crr' => 'alg',
  'nao' => 'sit',
  'itb' => 'poz',
  'gne' => 'alv',
  'ztt' => 'omq',
  'tnz' => 'mkh',
  'pnb' => 'inc',
  'rat' => 'ira',
  'bjj' => 'inc',
  'lar' => 'alv',
  'mpr' => 'pqe',
  'yam' => 'alv',
  'kaj' => 'alv',
  'piw' => 'bnt',
  'ass' => 'alv',
  'tvk' => 'pqe',
  'mnc' => 'tuw',
  'nmd' => 'bnt',
  'sws' => 'pqe',
  'pbf' => 'omq',
  'lhl' => 'inc',
  'lee' => 'alv',
  'kkf' => 'sit',
  'nod' => 'tai',
  'pmz' => 'oto',
  'drq' => 'sit',
  'ehu' => 'alv',
  'nqo' => 'nic',
  'pla' => 'ngf',
  'gqi' => 'tbq',
  'gyn' => 'gmw',
  'mns' => 'fiu',
  'hrm' => 'hmx',
  'cdz' => 'mun',
  'pmh' => 'inc',
  'mwo' => 'pqe',
  'mxj' => 'tbq',
  'lpa' => 'pqe',
  'psa' => 'ngf',
  'eli' => 'kdo',
  'gvr' => 'sit',
  'qxt' => 'qwe',
  'bgw' => 'inc',
  'slt' => 'sit',
  'shm' => 'ira',
  'kqd' => 'sem',
  'nih' => 'bnt',
  'jgo' => 'bai',
  'clo' => 'cai',
  'tsr' => 'pqe',
  'usi' => 'sit',
  'rin' => 'alv',
  'nio' => 'syd',
  'idt' => 'pqe',
  'bdp' => 'bnt',
  'prc' => 'ira',
  'xkc' => 'ira',
  'kyw' => 'inc',
  'vkl' => 'pqw',
  'jns' => 'inc',
  'lcm' => 'pqe',
  'stp' => 'azc',
  'kdg' => 'bnt',
  'njo' => 'tbq',
  'mkj' => 'pqe',
  'czn' => 'omq',
  'ggt' => 'pqe',
  'jud' => 'dmn',
  'bfa' => 'sdv',
  'kmk' => 'poz',
  'kve' => 'poz',
  'kvq' => 'kar',
  'sug' => 'ngf',
  'bcn' => 'alv',
  'sgw' => 'sem',
  'lli' => 'bnt',
  'gau' => 'dra',
  'chc' => 'sio',
  'jae' => 'pqe',
  'hrz' => 'ira',
  'mne' => 'csu',
  'neu' => 'art',
  'psi' => 'inc',
  'azj' => 'trk',
  'lbw' => 'pqw',
  'zuh' => 'ngf',
  'dbr' => 'cus',
  'kan' => 'dra',
  'suv' => 'sit',
  'dru' => 'fox',
  'qvo' => 'qwe',
  'hao' => 'pqe',
  'bjg' => 'alv',
  'ilb' => 'bnt',
  'naq' => 'khi',
  'cfa' => 'alv',
  'rzh' => 'sem',
  'lrm' => 'bnt',
  'arg' => 'roa',
  'dgo' => 'inc',
  'ldo' => 'alv',
  'njx' => 'bnt',
  'ayu' => 'alv',
  'moe' => 'alg',
  'sva' => 'ccs',
  'xkd' => 'poz',
  'nks' => 'ngf',
  'gwr' => 'bnt',
  'kfr' => 'inc',
  'hmj' => 'hmx',
  'mhp' => 'poz',
  'ivv' => 'poz'
};
$ISO2Glottolog = {
  'gem' => 'germ1287',
  'aav' => 'aust1305',
  'aql' => 'algi1248',
  'tuw' => 'tung1282',
  'sio' => 'siou1252',
  'zle' => 'east1426',
  'trk' => 'turk1311',
  'ira' => 'iran1269',
  'omq' => 'otom1299',
  'ath' => 'atha1247',
  'ngf' => 'nucl1709',
  'gmw' => 'west2793',
  'pqe' => 'cent2237',
  'cmc' => 'cham1327',
  'map' => 'aust1307',
  'alv' => 'atla1278',
  'bad' => 'band1341',
  'syd' => 'samo1298',
  'awd' => 'araw1281',
  'auf' => 'araw1282',
  'pra' => 'midd1350',
  'hmx' => 'hmon1336',
  'zlw' => 'west2792',
  'mno' => 'mano1276',
  'bih' => 'biha1245',
  'cdd' => 'cadd1255',
  'wak' => 'waka1280',
  'dra' => 'drav1251',
  'kar' => 'kare1337',
  'nub' => 'hara1258',
  'aqa' => 'kawe1237',
  'xgn' => 'mong1329',
  'cdc' => 'chad1250',
  'mun' => 'mund1335',
  'smi' => 'saam1281',
  'itc' => 'ital1284',
  'ine' => 'indo1319',
  'btk' => 'toba1265',
  'mkh' => 'aust1305',
  'alg' => 'algo1256',
  'tai' => 'daic1237',
  'bai' => 'bami1239',
  'urj' => 'ural1272',
  'csu' => 'cent2225',
  'sem' => 'semi1276',
  'xnd' => 'atha1245',
  'ijo' => 'ijoo1239',
  'oto' => 'otop1242',
  'bat' => 'prus1238',
  'iro' => 'iroq1247',
  'ber' => 'berb1260',
  'egx' => 'egyp1246',
  'poz' => 'mala1545',
  'ccs' => 'kart1248',
  'cba' => 'chib1249',
  'afa' => 'afro1255',
  'inc' => 'indo1321',
  'sit' => 'sino1245',
  'kro' => 'siam1242',
  'zls' => 'sout3147',
  'nah' => 'azte1234',
  'myn' => 'maya1287',
  'gme' => 'east2805',
  'son' => 'song1307',
  'grk' => 'grae1234',
  'bnt' => 'narr1281',
  'roa' => 'roma1334',
  'ypk' => 'yupi1267',
  'azc' => 'utoa1244',
  'esx' => 'eski1264',
  'znd' => 'zand1246',
  'sla' => 'slav1255',
  'cel' => 'celt1248',
  'tup' => 'tupi1287',
  'apa' => 'apac1239',
  'dmn' => 'mand1469',
  'sal' => 'sali1255',
  'cus' => 'cush1243',
  'wen' => 'sorb1249',
  'iir' => 'indo1320',
  'plf' => 'cent2245',
  'gmq' => 'nort3160'
};
$Glottolog2ISO = {
  'indo1319' => 'ine',
  'celt1248' => 'cel',
  'narr1281' => 'bnt',
  'biha1245' => 'bih',
  'sorb1249' => 'wen',
  'nubi1251' => 'nub',
  'atha1245' => 'xnd',
  'aust1305' => 'mkh',
  'algi1248' => 'aql',
  'siam1242' => 'kro',
  'kare1337' => 'kar',
  'slav1255' => 'sla',
  'araw1282' => 'auf',
  'mano1276' => 'mno',
  'afro1255' => 'afa',
  'cent2245' => 'plf',
  'utoa1244' => 'azc',
  'prus1238' => 'bat',
  'cent2225' => 'csu',
  'chib1249' => 'cba',
  'kart1248' => 'ccs',
  'drav1251' => 'dra',
  'midd1350' => 'pra',
  'saam1281' => 'smi',
  'east2280' => 'bat',
  'cush1243' => 'cus',
  'kawe1237' => 'aqa',
  'mala1545' => 'poz',
  'sout3147' => 'zls',
  'hmon1336' => 'hmx',
  'roma1334' => 'roa',
  'ural1272' => 'urj',
  'indo1321' => 'inc',
  'semi1276' => 'sem',
  'cham1327' => 'cmc',
  'atha1247' => 'ath',
  'otom1299' => 'omq',
  'toba1265' => 'btk',
  'west2792' => 'zlw',
  'otop1242' => 'oto',
  'cadd1255' => 'cdd',
  'zand1246' => 'znd',
  'cent2237' => 'pqe',
  'grae1234' => 'grk',
  'iroq1247' => 'iro',
  'band1341' => 'bad',
  'tupi1287' => 'tup',
  'egyp1246' => 'egx',
  'nort3160' => 'gmq',
  'algo1256' => 'alg',
  'song1307' => 'son',
  'ital1284' => 'itc',
  'mand1469' => 'dmn',
  'sino1245' => 'sit',
  'azte1234' => 'nah',
  'tung1282' => 'tuw',
  'chad1250' => 'cdc',
  'maya1287' => 'myn',
  'waka1280' => 'wak',
  'samo1298' => 'syd',
  'mong1329' => 'xgn',
  'araw1281' => 'awd',
  'eski1264' => 'esx',
  'apac1239' => 'apa',
  'east1426' => 'zle',
  'east2805' => 'gme',
  'iran1269' => 'ira',
  'hara1258' => 'nub',
  'yupi1267' => 'ypk',
  'daic1237' => 'tai',
  'turk1311' => 'trk',
  'krua1234' => 'kro',
  'gree1276' => 'grk',
  'sali1255' => 'sal',
  'siou1252' => 'sio',
  'ijoo1239' => 'ijo',
  'mund1335' => 'mun',
  'berb1260' => 'ber',
  'west2793' => 'gmw',
  'bami1239' => 'bai',
  'germ1287' => 'gem',
  'nucl1709' => 'ngf',
  'indo1320' => 'iir',
  'aust1307' => 'map',
  'atla1278' => 'alv'
};
#-*-perl-*-

=head1 SUBROUTINES

=head2 @langcodes = language_group( $groupcode )

Returns a list of language codes within the given language group.

=cut


sub language_group{
    my %children = ();
    if (exists $$LanguageGroup{$_[0]}){
	foreach my $l (@{$$LanguageGroup{$_[0]}}){
	    if (exists $$LanguageGroup{$l}){
		foreach (&language_group($l)){
		    $children{$_}++;
		}
	    }
	    else{
		$children{$l}++;
	    }
	}
    }
    else{
	return ($_[0]);
    }
    return sort keys %children;
}


=head2 @langcodes = language_group_children( $groupcode )

Returns a list of language codes that are immediate children of the given language group.

=cut

sub language_group_children{
    if (exists $$LanguageGroup{$_[0]}){
	return @{$$LanguageGroup{$_[0]}};
    }
    print STDERR "unknown language group $_[0]\n";
    return ();
}


=head2 @parentcode = language_group( $langcode )

Returns the parent language code for the given language.

=cut


sub language_parent{
    if (exists $$LanguageParent{$_[0]}){
	return $$LanguageParent{$_[0]};
    }
    print STDERR "no parent found for '$_[0]'\n";
    return undef;
}


sub iso2glottolog{
    return $$ISO2Glottolog{$_[0]} if (exists $$ISO2Glottolog{$_[0]});
    print STDERR "no glottolog ID found for '$_[0]'\n";
    return undef;
}

sub glottolog2iso{
    return $$Glottolog2ISO{$_[0]} if (exists $$Glottolog2ISO{$_[0]});
    print STDERR "no ISO639-5 code found for '$_[0]'\n";
    return undef;
}


## don't need the functions below, just use ISO::639::3
##

# =head2 $name = language_group_name( $groupcode )

# Returns the name of the language group

# =cut


# sub language_group_name{
#     return ISO::639::3::get_language_name($_[0]);
# }


# =head2 $code = language_group_code( $groupname )

# Returns the name of the language group

# =cut


# sub language_group_name{
#     return ISO::639::3::get_iso639_3($_[0]);
# }



1;

