/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CastUtils;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.DataEntryUrlBox;
import com.coremedia.iso.boxes.DataInformationBox;
import com.coremedia.iso.boxes.DataReferenceBox;
import com.coremedia.iso.boxes.FileTypeBox;
import com.coremedia.iso.boxes.HandlerBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaHeaderBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.StaticChunkOffsetBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieExtendsBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentRandomAccessBox;
import com.coremedia.iso.boxes.fragment.MovieFragmentRandomAccessOffsetBox;
import com.coremedia.iso.boxes.fragment.SampleFlags;
import com.coremedia.iso.boxes.fragment.TrackExtendsBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentRandomAccessBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import com.googlecode.mp4parser.authoring.DateHelper;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.ByteBufferHelper;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.authoring.builder.Mp4Builder;
import com.googlecode.mp4parser.authoring.builder.SyncSampleIntersectFinderImpl;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentedMp4Builder
implements Mp4Builder {
    FragmentIntersectionFinder intersectionFinder = new SyncSampleIntersectFinderImpl();
    private static final Logger LOG = Logger.getLogger(FragmentedMp4Builder.class.getName());

    public List<String> getAllowedHandlers() {
        return Arrays.asList("soun", "vide");
    }

    public Box createFtyp(Movie movie) {
        LinkedList<String> minorBrands = new LinkedList<String>();
        minorBrands.add("isom");
        minorBrands.add("iso2");
        minorBrands.add("avc1");
        return new FileTypeBox("isom", 0L, minorBrands);
    }

    protected List<Box> createMoofMdat(final Movie movie) {
        LinkedList<Box> boxes = new LinkedList<Box>();
        int maxNumberOfFragments = 0;
        for (Track track : movie.getTracks()) {
            int currentLength = this.intersectionFinder.sampleNumbers(track, movie).length;
            int n = maxNumberOfFragments = currentLength > maxNumberOfFragments ? currentLength : maxNumberOfFragments;
        }
        int sequence = 1;
        int i = 0;
        while (i < maxNumberOfFragments) {
            LinkedList<Track> sizeSortedTracks = new LinkedList<Track>(movie.getTracks());
            final int j = i;
            Collections.sort(sizeSortedTracks, new Comparator<Track>(){

                @Override
                public int compare(Track o1, Track o2) {
                    int[] startSamples1 = FragmentedMp4Builder.this.intersectionFinder.sampleNumbers(o1, movie);
                    int startSample1 = startSamples1[j];
                    int endSample1 = j + 1 < startSamples1.length ? startSamples1[j + 1] : o1.getSamples().size();
                    int[] startSamples2 = FragmentedMp4Builder.this.intersectionFinder.sampleNumbers(o2, movie);
                    int startSample2 = startSamples2[j];
                    int endSample2 = j + 1 < startSamples2.length ? startSamples2[j + 1] : o2.getSamples().size();
                    List<ByteBuffer> samples1 = o1.getSamples().subList(startSample1, endSample1);
                    List<ByteBuffer> samples2 = o2.getSamples().subList(startSample2, endSample2);
                    int size1 = 0;
                    for (ByteBuffer byteBuffer : samples1) {
                        size1 += byteBuffer.limit();
                    }
                    int size2 = 0;
                    for (ByteBuffer byteBuffer : samples2) {
                        size2 += byteBuffer.limit();
                    }
                    return size1 - size2;
                }
            });
            for (Track track : sizeSortedTracks) {
                int endSample;
                int[] startSamples;
                if (!this.getAllowedHandlers().isEmpty() && !this.getAllowedHandlers().contains(track.getHandler()) || i >= (startSamples = this.intersectionFinder.sampleNumbers(track, movie)).length) continue;
                int startSample = startSamples[i];
                int n = endSample = i + 1 < startSamples.length ? startSamples[i + 1] : track.getSamples().size();
                if (startSample == endSample) continue;
                boxes.add(this.createMoof(startSample, endSample, track, sequence));
                boxes.add(this.createMdat(startSample, endSample, track, sequence++));
            }
            ++i;
        }
        return boxes;
    }

    @Override
    public IsoFile build(Movie movie) throws IOException {
        LOG.info("Creating movie " + movie);
        IsoFile isoFile = new IsoFile();
        isoFile.addBox(this.createFtyp(movie));
        isoFile.addBox(this.createMoov(movie));
        for (Box box : this.createMoofMdat(movie)) {
            isoFile.addBox(box);
        }
        isoFile.addBox(this.createMfra(movie, isoFile));
        return isoFile;
    }

    protected Box createMdat(int startSample, int endSample, Track track, int i) {
        final List<ByteBuffer> samples = ByteBufferHelper.mergeAdjacentBuffers(this.getSamples(startSample, endSample, track, i));
        return new Box(){
            ContainerBox parent;

            public ContainerBox getParent() {
                return this.parent;
            }

            public void setParent(ContainerBox parent) {
                this.parent = parent;
            }

            public long getSize() {
                long size = 8L;
                for (ByteBuffer sample : samples) {
                    size += (long)sample.limit();
                }
                return size;
            }

            public String getType() {
                return "mdat";
            }

            public void getBox(WritableByteChannel writableByteChannel) throws IOException {
                ByteBuffer header = ByteBuffer.allocate(8);
                IsoTypeWriter.writeUInt32(header, CastUtils.l2i(this.getSize()));
                header.put(IsoFile.fourCCtoBytes(this.getType()));
                header.rewind();
                writableByteChannel.write(header);
                if (writableByteChannel instanceof GatheringByteChannel) {
                    int STEPSIZE = 1024;
                    int i = 0;
                    while ((double)i < Math.ceil((double)samples.size() / (double)STEPSIZE)) {
                        List sublist = samples.subList(i * STEPSIZE, (i + 1) * STEPSIZE < samples.size() ? (i + 1) * STEPSIZE : samples.size());
                        ByteBuffer[] sampleArray = sublist.toArray(new ByteBuffer[sublist.size()]);
                        do {
                            ((GatheringByteChannel)writableByteChannel).write(sampleArray);
                        } while (sampleArray[sampleArray.length - 1].remaining() > 0);
                        ++i;
                    }
                } else {
                    for (ByteBuffer sample : samples) {
                        sample.rewind();
                        writableByteChannel.write(sample);
                    }
                }
            }

            public void parse(ReadableByteChannel inFC, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
            }
        };
    }

    public static void dumpHex(ByteBuffer bb) {
        byte[] b = new byte[bb.limit()];
        bb.get(b);
        System.err.println(Hex.encodeHex(b));
        bb.rewind();
    }

    protected Box createTfhd(int startSample, int endSample, Track track, int sequenceNumber) {
        TrackFragmentHeaderBox tfhd = new TrackFragmentHeaderBox();
        SampleFlags sf = new SampleFlags();
        tfhd.setDefaultSampleFlags(sf);
        tfhd.setBaseDataOffset(-1L);
        tfhd.setTrackId(track.getTrackMetaData().getTrackId());
        return tfhd;
    }

    protected Box createMfhd(int startSample, int endSample, Track track, int sequenceNumber) {
        MovieFragmentHeaderBox mfhd = new MovieFragmentHeaderBox();
        mfhd.setSequenceNumber(sequenceNumber);
        return mfhd;
    }

    protected Box createTraf(int startSample, int endSample, Track track, int sequenceNumber) {
        TrackFragmentBox traf = new TrackFragmentBox();
        traf.addBox(this.createTfhd(startSample, endSample, track, sequenceNumber));
        for (Box box : this.createTruns(startSample, endSample, track, sequenceNumber)) {
            traf.addBox(box);
        }
        return traf;
    }

    protected List<ByteBuffer> getSamples(int startSample, int endSample, Track track, int sequenceNumber) {
        return track.getSamples().subList(startSample, endSample);
    }

    protected List<? extends Box> createTruns(int startSample, int endSample, Track track, int sequenceNumber) {
        List<ByteBuffer> samples = this.getSamples(startSample, endSample, track, sequenceNumber);
        long[] sampleSizes = new long[samples.size()];
        int i = 0;
        while (i < sampleSizes.length) {
            sampleSizes[i] = samples.get(i).limit();
            ++i;
        }
        TrackRunBox trun = new TrackRunBox();
        trun.setSampleDurationPresent(true);
        trun.setSampleSizePresent(true);
        ArrayList<TrackRunBox.Entry> entries = new ArrayList<TrackRunBox.Entry>(endSample - startSample);
        LinkedList<TimeToSampleBox.Entry> timeQueue = new LinkedList<TimeToSampleBox.Entry>(track.getDecodingTimeEntries());
        long durationEntriesLeft = ((TimeToSampleBox.Entry)timeQueue.peek()).getCount();
        LinkedList<CompositionTimeToSample.Entry> compositionTimeQueue = track.getCompositionTimeEntries() != null && track.getCompositionTimeEntries().size() > 0 ? new LinkedList<CompositionTimeToSample.Entry>(track.getCompositionTimeEntries()) : null;
        long compositionTimeEntriesLeft = compositionTimeQueue != null ? ((CompositionTimeToSample.Entry)compositionTimeQueue.peek()).getCount() : -1;
        trun.setSampleCompositionTimeOffsetPresent(compositionTimeEntriesLeft > 0L);
        boolean sampleFlagsRequired = track.getSampleDependencies() != null && !track.getSampleDependencies().isEmpty() || track.getSyncSamples() != null && track.getSyncSamples().length != 0;
        trun.setSampleFlagsPresent(sampleFlagsRequired);
        int i2 = 0;
        while (i2 < sampleSizes.length) {
            TrackRunBox.Entry entry = new TrackRunBox.Entry();
            entry.setSampleSize(sampleSizes[i2]);
            if (sampleFlagsRequired) {
                SampleFlags sflags = new SampleFlags();
                if (track.getSampleDependencies() != null && !track.getSampleDependencies().isEmpty()) {
                    SampleDependencyTypeBox.Entry e = track.getSampleDependencies().get(i2);
                    sflags.setSampleDependsOn(e.getSampleDependsOn());
                    sflags.setSampleIsDependedOn(e.getSampleIsDependentOn());
                    sflags.setSampleHasRedundancy(e.getSampleHasRedundancy());
                }
                if (track.getSyncSamples() != null && track.getSyncSamples().length > 0) {
                    if (Arrays.binarySearch(track.getSyncSamples(), (long)(startSample + i2 + 1)) >= 0) {
                        sflags.setSampleIsDifferenceSample(false);
                        sflags.setSampleDependsOn(2);
                    } else {
                        sflags.setSampleIsDifferenceSample(true);
                        sflags.setSampleDependsOn(1);
                    }
                }
                entry.setSampleFlags(sflags);
            }
            entry.setSampleDuration(((TimeToSampleBox.Entry)timeQueue.peek()).getDelta());
            if (--durationEntriesLeft == 0L && timeQueue.size() > 1) {
                timeQueue.remove();
                durationEntriesLeft = ((TimeToSampleBox.Entry)timeQueue.peek()).getCount();
            }
            if (compositionTimeQueue != null) {
                trun.setSampleCompositionTimeOffsetPresent(true);
                entry.setSampleCompositionTimeOffset(((CompositionTimeToSample.Entry)compositionTimeQueue.peek()).getOffset());
                if (--compositionTimeEntriesLeft == 0L && compositionTimeQueue.size() > 1) {
                    compositionTimeQueue.remove();
                    compositionTimeEntriesLeft = ((CompositionTimeToSample.Entry)compositionTimeQueue.element()).getCount();
                }
            }
            entries.add(entry);
            ++i2;
        }
        trun.setEntries(entries);
        return Collections.singletonList(trun);
    }

    protected Box createMoof(int startSample, int endSample, Track track, int sequenceNumber) {
        MovieFragmentBox moof = new MovieFragmentBox();
        moof.addBox(this.createMfhd(startSample, endSample, track, sequenceNumber));
        moof.addBox(this.createTraf(startSample, endSample, track, sequenceNumber));
        TrackRunBox firstTrun = moof.getTrackRunBoxes().get(0);
        firstTrun.setDataOffset(1);
        firstTrun.setDataOffset((int)(8L + moof.getSize()));
        return moof;
    }

    protected Box createMvhd(Movie movie) {
        MovieHeaderBox mvhd = new MovieHeaderBox();
        mvhd.setCreationTime(DateHelper.convert(new Date()));
        mvhd.setModificationTime(DateHelper.convert(new Date()));
        long movieTimeScale = movie.getTimescale();
        long duration = 0L;
        for (Track track : movie.getTracks()) {
            long tracksDuration = this.getDuration(track) * movieTimeScale / track.getTrackMetaData().getTimescale();
            if (tracksDuration <= duration) continue;
            duration = tracksDuration;
        }
        mvhd.setDuration(duration);
        mvhd.setTimescale(movieTimeScale);
        long nextTrackId = 0L;
        for (Track track : movie.getTracks()) {
            long l = nextTrackId = nextTrackId < track.getTrackMetaData().getTrackId() ? track.getTrackMetaData().getTrackId() : nextTrackId;
        }
        mvhd.setNextTrackId(++nextTrackId);
        return mvhd;
    }

    protected Box createMoov(Movie movie) {
        MovieBox movieBox = new MovieBox();
        movieBox.addBox(this.createMvhd(movie));
        movieBox.addBox(this.createMvex(movie));
        for (Track track : movie.getTracks()) {
            movieBox.addBox(this.createTrak(track, movie));
        }
        return movieBox;
    }

    protected Box createTfra(Track track, IsoFile isoFile) {
        TrackFragmentRandomAccessBox tfra = new TrackFragmentRandomAccessBox();
        tfra.setVersion(1);
        LinkedList<TrackFragmentRandomAccessBox.Entry> offset2timeEntries = new LinkedList<TrackFragmentRandomAccessBox.Entry>();
        List<Box> boxes = isoFile.getBoxes();
        long offset = 0L;
        long duration = 0L;
        for (Box box : boxes) {
            if (box instanceof MovieFragmentBox) {
                List<TrackFragmentBox> trafs = ((MovieFragmentBox)box).getBoxes(TrackFragmentBox.class);
                int i = 0;
                while (i < trafs.size()) {
                    TrackFragmentBox traf = trafs.get(i);
                    if (traf.getTrackFragmentHeaderBox().getTrackId() == track.getTrackMetaData().getTrackId()) {
                        List<TrackRunBox> truns = traf.getBoxes(TrackRunBox.class);
                        int j = 0;
                        while (j < truns.size()) {
                            LinkedList<TrackFragmentRandomAccessBox.Entry> offset2timeEntriesThisTrun = new LinkedList<TrackFragmentRandomAccessBox.Entry>();
                            TrackRunBox trun = truns.get(j);
                            int k = 0;
                            while (k < trun.getEntries().size()) {
                                TrackRunBox.Entry trunEntry = trun.getEntries().get(k);
                                SampleFlags sf = null;
                                if (k == 0 && trun.isFirstSampleFlagsPresent()) {
                                    sf = trun.getFirstSampleFlags();
                                } else if (trun.isSampleFlagsPresent()) {
                                    sf = trunEntry.getSampleFlags();
                                } else {
                                    List<MovieExtendsBox> mvexs = isoFile.getMovieBox().getBoxes(MovieExtendsBox.class);
                                    for (MovieExtendsBox mvex : mvexs) {
                                        List<TrackExtendsBox> trexs = mvex.getBoxes(TrackExtendsBox.class);
                                        for (TrackExtendsBox trex : trexs) {
                                            if (trex.getTrackId() != track.getTrackMetaData().getTrackId()) continue;
                                            sf = trex.getDefaultSampleFlags();
                                        }
                                    }
                                }
                                if (sf == null) {
                                    throw new RuntimeException("Could not find any SampleFlags to indicate random access or not");
                                }
                                if (sf.getSampleDependsOn() == 2) {
                                    offset2timeEntriesThisTrun.add(new TrackFragmentRandomAccessBox.Entry(duration, offset, i + 1, j + 1, k + 1));
                                }
                                duration += trunEntry.getSampleDuration();
                                ++k;
                            }
                            if (offset2timeEntriesThisTrun.size() == trun.getEntries().size() && trun.getEntries().size() > 0) {
                                offset2timeEntries.add((TrackFragmentRandomAccessBox.Entry)offset2timeEntriesThisTrun.get(0));
                            } else {
                                offset2timeEntries.addAll(offset2timeEntriesThisTrun);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            offset += box.getSize();
        }
        tfra.setEntries(offset2timeEntries);
        tfra.setTrackId(track.getTrackMetaData().getTrackId());
        return tfra;
    }

    protected Box createMfra(Movie movie, IsoFile isoFile) {
        MovieFragmentRandomAccessBox mfra = new MovieFragmentRandomAccessBox();
        for (Track track : movie.getTracks()) {
            mfra.addBox(this.createTfra(track, isoFile));
        }
        MovieFragmentRandomAccessOffsetBox mfro = new MovieFragmentRandomAccessOffsetBox();
        mfra.addBox(mfro);
        mfro.setMfraSize(mfra.getSize());
        return mfra;
    }

    protected Box createTrex(Movie movie, Track track) {
        TrackExtendsBox trex = new TrackExtendsBox();
        trex.setTrackId(track.getTrackMetaData().getTrackId());
        trex.setDefaultSampleDescriptionIndex(1L);
        trex.setDefaultSampleDuration(0L);
        trex.setDefaultSampleSize(0L);
        SampleFlags sf = new SampleFlags();
        if ("soun".equals(track.getHandler())) {
            sf.setSampleDependsOn(2);
            sf.setSampleIsDependedOn(2);
        }
        trex.setDefaultSampleFlags(sf);
        return trex;
    }

    protected Box createMvex(Movie movie) {
        MovieExtendsBox mvex = new MovieExtendsBox();
        for (Track track : movie.getTracks()) {
            mvex.addBox(this.createTrex(movie, track));
        }
        return mvex;
    }

    protected Box createTkhd(Movie movie, Track track) {
        TrackHeaderBox tkhd = new TrackHeaderBox();
        int flags = 0;
        if (track.isEnabled()) {
            ++flags;
        }
        if (track.isInMovie()) {
            flags += 2;
        }
        if (track.isInPreview()) {
            flags += 4;
        }
        if (track.isInPoster()) {
            flags += 8;
        }
        tkhd.setFlags(flags);
        tkhd.setAlternateGroup(track.getTrackMetaData().getGroup());
        tkhd.setCreationTime(DateHelper.convert(track.getTrackMetaData().getCreationTime()));
        tkhd.setDuration(this.getDuration(track) * movie.getTimescale() / track.getTrackMetaData().getTimescale());
        tkhd.setHeight(track.getTrackMetaData().getHeight());
        tkhd.setWidth(track.getTrackMetaData().getWidth());
        tkhd.setLayer(track.getTrackMetaData().getLayer());
        tkhd.setModificationTime(DateHelper.convert(new Date()));
        tkhd.setTrackId(track.getTrackMetaData().getTrackId());
        tkhd.setVolume(track.getTrackMetaData().getVolume());
        return tkhd;
    }

    protected Box createMdhd(Movie movie, Track track) {
        MediaHeaderBox mdhd = new MediaHeaderBox();
        mdhd.setCreationTime(DateHelper.convert(track.getTrackMetaData().getCreationTime()));
        mdhd.setDuration(this.getDuration(track));
        mdhd.setTimescale(track.getTrackMetaData().getTimescale());
        mdhd.setLanguage(track.getTrackMetaData().getLanguage());
        return mdhd;
    }

    protected Box createStbl(Movie movie, Track track) {
        SampleTableBox stbl = new SampleTableBox();
        stbl.addBox(track.getSampleDescriptionBox());
        stbl.addBox(new TimeToSampleBox());
        stbl.addBox(new StaticChunkOffsetBox());
        return stbl;
    }

    protected Box createMinf(Track track, Movie movie) {
        MediaInformationBox minf = new MediaInformationBox();
        minf.addBox(track.getMediaHeaderBox());
        minf.addBox(this.createDinf(movie, track));
        minf.addBox(this.createStbl(movie, track));
        return minf;
    }

    protected Box createMdiaHdlr(Track track, Movie movie) {
        HandlerBox hdlr = new HandlerBox();
        hdlr.setHandlerType(track.getHandler());
        return hdlr;
    }

    protected Box createMdia(Track track, Movie movie) {
        MediaBox mdia = new MediaBox();
        mdia.addBox(this.createMdhd(movie, track));
        mdia.addBox(this.createMdiaHdlr(track, movie));
        mdia.addBox(this.createMinf(track, movie));
        return mdia;
    }

    protected Box createTrak(Track track, Movie movie) {
        LOG.info("Creating Track " + track);
        TrackBox trackBox = new TrackBox();
        trackBox.addBox(this.createTkhd(movie, track));
        trackBox.addBox(this.createMdia(track, movie));
        return trackBox;
    }

    protected DataInformationBox createDinf(Movie movie, Track track) {
        DataInformationBox dinf = new DataInformationBox();
        DataReferenceBox dref = new DataReferenceBox();
        dinf.addBox(dref);
        DataEntryUrlBox url = new DataEntryUrlBox();
        url.setFlags(1);
        dref.addBox(url);
        return dinf;
    }

    public void setIntersectionFinder(FragmentIntersectionFinder intersectionFinder) {
        this.intersectionFinder = intersectionFinder;
    }

    protected long getDuration(Track track) {
        long duration = 0L;
        for (TimeToSampleBox.Entry entry : track.getDecodingTimeEntries()) {
            duration += entry.getCount() * entry.getDelta();
        }
        return duration;
    }
}

