/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDVariableText;

public class PDChoiceField
extends PDVariableText {
    public PDChoiceField(PDAcroForm theAcroForm, COSDictionary field) {
        super(theAcroForm, field);
    }

    public void setValue(String optionValue) throws IOException {
        int indexSelected = -1;
        COSArray options = (COSArray)this.getDictionary().getDictionaryObject("Opt");
        if (options.size() == 0) {
            throw new IOException("Error: You cannot set a value for a choice field if there are no options.");
        }
        for (int i = 0; i < options.size() && indexSelected == -1; ++i) {
            COSBase option = options.getObject(i);
            if (option instanceof COSArray) {
                COSArray keyValuePair = (COSArray)option;
                COSString key = (COSString)keyValuePair.getObject(0);
                COSString value = (COSString)keyValuePair.getObject(1);
                if (!optionValue.equals(key.getString()) && !optionValue.equals(value.getString())) continue;
                super.setValue(value.getString());
                this.getDictionary().setItem(COSName.getPDFName("V"), (COSBase)key);
                indexSelected = i;
                continue;
            }
            COSString value = (COSString)option;
            if (!optionValue.equals(value.getString())) continue;
            super.setValue(optionValue);
            indexSelected = i;
        }
        if (indexSelected == -1) {
            throw new IOException("Error: '" + optionValue + "' was not an available option.");
        }
        COSArray indexArray = (COSArray)this.getDictionary().getDictionaryObject("I");
        if (indexArray != null) {
            indexArray.clear();
            indexArray.add(COSInteger.get(indexSelected));
        }
    }
}

