/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.utils;

import at.ac.tuwien.dbai.pdfwrap.model.document.TextSegment;
import at.ac.tuwien.dbai.pdfwrap.utils.StreamGobbler;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.media.jai.Histogram;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public class Utils {
    public static boolean IS_OCR = false;
    public static final String EMPTY_STRING = "";
    public static final boolean DISPLAY_TIMINGS = true;
    public static final float PDF_POINT_RESOLUTION = 72.0f;
    public static final float XML_RESOLUTION = 300.0f;
    public static final float neighbourLOSMin = 0.4f;
    public static final float neighbourOverlapTolerance = 0.2f;
    public static final float sameLineTolerance = 0.3f;
    public static RenderingHints hints = new RenderingHints(null);

    static {
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
    }

    public static String getRootDir() throws IOException {
        File currentDir = new File(".");
        return currentDir.getCanonicalPath();
    }

    public static float gaussian(float x, float mean, float sd) {
        float mu = mean;
        float sigma = sd;
        float k1 = (float)(1.0 / ((double)sigma * Math.sqrt(Math.PI * 2)));
        float k2 = -1.0f / (2.0f * (sigma * sigma));
        return (float)((double)k1 * Math.exp((x - mu) * (x - mu) * k2));
    }

    public static float normgaussian(float x, float mean, float sd) {
        return Utils.gaussian(x, mean, sd) / Utils.gaussian(mean, mean, sd);
    }

    public static float avg(float num1, float num2) {
        return (num1 + num2) / 2.0f;
    }

    public static BufferedImage rotate90CW(BufferedImage bi) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        BufferedImage biFlip = new BufferedImage(height, width, 1);
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                biFlip.setRGB(j, width - 1 - i, bi.getRGB(i, j));
                ++j;
            }
            ++i;
        }
        return biFlip;
    }

    public static BufferedImage rotate90ACW(BufferedImage bi) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        BufferedImage biFlip = new BufferedImage(height, width, 1);
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                biFlip.setRGB(height - 1 - j, i, bi.getRGB(i, j));
                ++j;
            }
            ++i;
        }
        return biFlip;
    }

    public static float findMode(List floats, float tolerance) {
        Iterator numIter = floats.iterator();
        ArrayList<Float> values = new ArrayList<Float>();
        ArrayList<Integer> frequencies = new ArrayList<Integer>();
        while (numIter.hasNext()) {
            Float thisObj = (Float)numIter.next();
            float thisVal = thisObj.floatValue();
            int arrayIndex = -1;
            int n = 0;
            while (n < values.size()) {
                float valAtN = ((Float)values.get(n)).floatValue();
                if (Utils.within(thisVal, valAtN, tolerance)) {
                    arrayIndex = n;
                    n = values.size();
                }
                ++n;
            }
            if (arrayIndex != -1) {
                int frequency = (Integer)frequencies.get(arrayIndex);
                frequencies.set(arrayIndex, new Integer(++frequency));
                continue;
            }
            values.add(thisObj);
            frequencies.add(new Integer(1));
        }
        int highestIndex = 0;
        int highestValue = -1;
        int n = 0;
        while (n < frequencies.size()) {
            if ((Integer)frequencies.get(n) > highestValue) {
                highestValue = (Integer)frequencies.get(n);
                highestIndex = n;
            }
            ++n;
        }
        return ((Float)values.get(highestIndex)).floatValue();
    }

    public static int findModalFreq(List floats, float tolerance) {
        Iterator numIter = floats.iterator();
        ArrayList<Float> values = new ArrayList<Float>();
        ArrayList<Integer> frequencies = new ArrayList<Integer>();
        while (numIter.hasNext()) {
            Float thisObj = (Float)numIter.next();
            float thisVal = thisObj.floatValue();
            int arrayIndex = -1;
            int n = 0;
            while (n < values.size()) {
                float valAtN = ((Float)values.get(n)).floatValue();
                if (Utils.within(thisVal, valAtN, tolerance)) {
                    arrayIndex = n;
                    n = values.size();
                }
                ++n;
            }
            if (arrayIndex != -1) {
                int frequency = (Integer)frequencies.get(arrayIndex);
                frequencies.set(arrayIndex, new Integer(++frequency));
                continue;
            }
            values.add(thisObj);
            frequencies.add(new Integer(1));
        }
        int highestIndex = 0;
        int highestValue = -1;
        int n = 0;
        while (n < frequencies.size()) {
            if ((Integer)frequencies.get(n) > highestValue) {
                highestValue = (Integer)frequencies.get(n);
                highestIndex = n;
            }
            ++n;
        }
        return highestValue;
    }

    private int findModalFontSize(Collection textBlocks) throws Exception {
        int[] count = new int[96];
        Iterator textIter = textBlocks.iterator();
        while (textIter.hasNext()) {
            TextSegment thisBlock = null;
            try {
                while (textIter.hasNext() && (thisBlock == null || thisBlock.isEmpty())) {
                    thisBlock = (TextSegment)textIter.next();
                }
            }
            catch (ClassCastException e) {
                throw new Exception("Objects in the collection must be of type TextSegment.");
            }
            if (thisBlock == null || !(thisBlock.getFontSize() > 0.0f) || !(thisBlock.getFontSize() <= 96.0f)) continue;
            int n = new Double(thisBlock.getFontSize()).intValue();
            count[n] = count[n] + 1;
        }
        int highest = 0;
        int n = 0;
        while (n < count.length) {
            if (count[n] > count[highest]) {
                highest = n;
            }
            ++n;
        }
        return highest;
    }

    public static int findIndexOfHighestValuedObject(List l) {
        int retVal = -1;
        Object highestObject = null;
        int n = 0;
        while (n < l.size()) {
            if (highestObject == null) {
                highestObject = l.get(n);
                retVal = 0;
            } else if (((Comparable)l.get(n)).compareTo(highestObject) > 0) {
                highestObject = l.get(n);
                retVal = n;
            }
            ++n;
        }
        if (retVal == -1) {
            System.err.println("returning -1 with " + l.size() + " items");
        }
        return retVal;
    }

    public static boolean sameFontSize(TextSegment seg1, TextSegment seg2) {
        float afs = (seg1.getFontSize() + seg2.getFontSize()) / 2.0f;
        if (!IS_OCR) {
            return Utils.within(seg1.getFontSize(), seg2.getFontSize(), afs * 0.1f);
        }
        return Utils.within(seg1.getFontSize(), seg2.getFontSize(), afs * 0.5f);
    }

    public static boolean within(float first, float second, float variance) {
        return second > first - variance && second < first + variance;
    }

    public static boolean between(float number, float boundary1, float boundary2) {
        return number >= boundary1 && number <= boundary2 || number <= boundary1 && number >= boundary2;
    }

    public static float minimum(float first, float second) {
        if (first < second) {
            return first;
        }
        return second;
    }

    public static float maximum(float first, float second) {
        if (first < second) {
            return second;
        }
        return first;
    }

    public static float calculateThreshold(TextSegment seg1, TextSegment seg2, float multiple) {
        return Utils.minimum(seg1.getFontSize(), seg2.getFontSize()) * multiple;
    }

    public static String stripClassName(String fullName) {
        String retVal = new String();
        int n = fullName.length() - 1;
        while (n >= 0) {
            String thisChar = fullName.substring(n, n + 1);
            if (!thisChar.equals(".")) {
                retVal = thisChar.concat(retVal);
            } else {
                n = -1;
            }
            --n;
        }
        return retVal;
    }

    public static String replaceBackslashes(String inputString) {
        String retVal = new String();
        int n = 0;
        while (n < inputString.length()) {
            String thisChar = inputString.substring(n, n + 1);
            retVal = thisChar.equals("\\") ? retVal.concat("/") : retVal.concat(thisChar);
            ++n;
        }
        return retVal;
    }

    public static boolean containsSubstring(String test, String substring) {
        int index1 = test.indexOf(substring);
        return index1 != -1;
    }

    public static String removeInvalidXMLCharacters(String s) {
        StringBuilder out = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            int codePoint = s.codePointAt(i);
            if (codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF) {
                out.append(Character.toChars(codePoint));
            }
            i += Character.charCount(codePoint);
        }
        return out.toString();
    }

    public static BufferedImage convertToBinary(BufferedImage sourceImg) {
        double[][] matrix = new double[][]{{0.3, 0.59, 0.11, 0.0}};
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(sourceImg);
        pb.add(matrix);
        RenderedOp src = JAI.create((String)"BandCombine", (ParameterBlock)pb, null);
        Histogram histogram = (Histogram)JAI.create((String)"histogram", (RenderedImage)src).getProperty("histogram");
        double[] threshold = histogram.getPTileThreshold(0.5);
        RenderedOp dst = JAI.create((String)"binarize", (RenderedImage)src, (Object)new Double(threshold[0]));
        return dst.getAsBufferedImage();
    }

    public static void executeCommand(String s, String stdout, String stderr) throws IOException {
        Runtime rt = Runtime.getRuntime();
        Process p = rt.exec(s);
        StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream());
        StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream());
        errorGobbler.start();
        outputGobbler.start();
        try {
            int n = p.waitFor();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        stdout = errorGobbler.getData();
        stderr = outputGobbler.getData();
    }

    public static void executeCommand(String[] sa, String stdout, String stderr) throws IOException {
        Runtime rt = Runtime.getRuntime();
        Process p = rt.exec(sa);
        StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream());
        StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream());
        errorGobbler.start();
        outputGobbler.start();
        try {
            int n = p.waitFor();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        stdout = errorGobbler.getData();
        stderr = outputGobbler.getData();
        System.out.println(stdout);
        System.err.println(stderr);
    }
}

