/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.util.PDFTextStripper;
import org.apache.pdfbox.util.TextPosition;

public class PDFTextStripperByArea
extends PDFTextStripper {
    private List regions = new ArrayList();
    private Map regionArea = new HashMap();
    private Map regionCharacterList = new HashMap();
    private Map regionText = new HashMap();

    public PDFTextStripperByArea() throws IOException {
        this.setPageSeparator("");
    }

    public void addRegion(String regionName, Rectangle2D rect) {
        this.regions.add(regionName);
        this.regionArea.put(regionName, rect);
    }

    public List getRegions() {
        return this.regions;
    }

    public String getTextForRegion(String regionName) {
        StringWriter text = (StringWriter)this.regionText.get(regionName);
        return text.toString();
    }

    public void extractRegions(PDPage page) throws IOException {
        Iterator regionIter = this.regions.iterator();
        while (regionIter.hasNext()) {
            this.setStartPage(this.getCurrentPageNo());
            this.setEndPage(this.getCurrentPageNo());
            String regionName = (String)regionIter.next();
            Vector regionCharactersByArticle = new Vector();
            regionCharactersByArticle.add(new ArrayList());
            this.regionCharacterList.put(regionName, regionCharactersByArticle);
            this.regionText.put(regionName, new StringWriter());
        }
        PDStream contentStream = page.getContents();
        if (contentStream != null) {
            COSStream contents = contentStream.getStream();
            this.processPage(page, contents);
        }
    }

    protected void processTextPosition(TextPosition text) {
        for (String region : this.regionArea.keySet()) {
            Rectangle2D rect = (Rectangle2D)this.regionArea.get(region);
            if (!rect.contains(text.getX(), text.getY())) continue;
            this.charactersByArticle = (Vector)this.regionCharacterList.get(region);
            super.processTextPosition(text);
        }
    }

    protected void writePage() throws IOException {
        for (String region : this.regionArea.keySet()) {
            this.charactersByArticle = (Vector)this.regionCharacterList.get(region);
            this.output = (StringWriter)this.regionText.get(region);
            super.writePage();
        }
    }
}

