# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package JobAd::GEN::Skill;

use strict;
use warnings;

use base 'JobAd';
use JSON;
use Gantry::Utils::TablePerms;

use JobAd::Model::skill qw(
    $SKILL
);

#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'Skill' );

    my $real_location = $self->location() || '';
    if ( $real_location ) {
        $real_location =~ s{/+$}{};
        $real_location .= '/';
    }

    my @header_options = (
        {
            text => 'Add',
            link => $real_location . "add",
            type => 'create',
        },
    );

    my $retval = {
        headings       => [
            'Ident',
            'Description',
        ],
    };

    my $params = $self->params;

    my $search = {};
    if ( $params->{ search } ) {
        my $form = $self->form();

        my @searches;
        foreach my $field ( @{ $form->{ fields } } ) {
            if ( $field->{ searchable } ) {
                push( @searches,
                    ( $field->{ name } => { 'like', "%$params->{ search }%"  } )
                );
            }
        }

        $search = {
            -or => \@searches
        } if scalar( @searches ) > 0;
    }

    my @row_options = (
        {
            text => 'Edit',
            type => 'update',
        },
        {
            text => 'Delete',
            type => 'delete',
        },
    );

    my $perm_obj = Gantry::Utils::TablePerms->new(
        {
            site           => $self,
            real_location  => $real_location,
            header_options => \@header_options,
            row_options    => \@row_options,
        }
    );

    $retval->{ header_options } = $perm_obj->real_header_options;

    my $limit_to_user_id = $perm_obj->limit_to_user_id;
    $search->{ user_id } = $limit_to_user_id if ( $limit_to_user_id );

    my $schema = $self->get_schema();
    my @rows   = $SKILL->get_listing(
        {
            schema   => $schema,
            where    => $search,
        }
    );

    ROW:
    foreach my $row ( @rows ) {
        last ROW if $perm_obj->hide_all_data;

        my $id = $row->id;

        push(
            @{ $retval->{rows} }, {
                orm_row => $row,
                data => [
                    $row->ident,
                    $row->description,
                ],
                options => $perm_obj->real_row_options( $row ),
            }
        );
    }

    if ( $params->{ json } ) {
        $self->template_disable( 1 );

        my $obj = {
            headings        => $retval->{ headings },
            header_options  => $retval->{ header_options },
            rows            => $retval->{ rows },
        };

        my $json = objToJson( $obj, { skipinvalid => 1 } );
        return( $json );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
sub form {
    my ( $self, $row ) = @_;

    my $selections = $SKILL->get_form_selections(
            { schema => $self->get_schema() }
    );

    return {
        row        => $row,
        legend => $self->path_info =~ /edit/i ? 'Edit' : 'Add',
        fields     => [
            {
                name => 'ident',
                label => 'Ident',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'description',
                label => 'Description',
                type => 'text',
                is => 'varchar',
            },
        ],
    };
} # END form

#-----------------------------------------------------------------
# $self->init( $r )
#-----------------------------------------------------------------
sub init {
    my ( $self, $r ) = @_;

    # process SUPER's init code
    $self->SUPER::init( $r );

    $self->set_auth_require( $self->fish_config( 'auth_require' ) || '' );
    $self->set_auth_groups( $self->fish_config( 'auth_groups' ) || '' );
} # END init

#-----------------------------------------------------------------
# $self->set_auth_require( $new_value )
#-----------------------------------------------------------------
sub set_auth_require {
    my ( $self, $value ) = @_;

    $self->{ __auth_require__ } = $value;
}

#-----------------------------------------------------------------
# $self->auth_require(  )
#-----------------------------------------------------------------
sub auth_require {
    my $self = shift;

    return $self->{ __auth_require__ };
}

#-----------------------------------------------------------------
# $self->set_auth_groups( $new_value )
#-----------------------------------------------------------------
sub set_auth_groups {
    my ( $self, $value ) = @_;

    $self->{ __auth_groups__ } = $value;
}

#-----------------------------------------------------------------
# $self->auth_groups(  )
#-----------------------------------------------------------------
sub auth_groups {
    my $self = shift;

    return $self->{ __auth_groups__ };
}


1;

=head1 NAME

JobAd::GEN::Skill - generated support module for JobAd::Skill

=head1 SYNOPSIS

In JobAd::Skill:

    use base 'JobAd::GEN::Skill';

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in JobAd::Skill to provide the methods below.
Feel free to override them.

=head1 METHODS

=over 4

=item do_main

=item form


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

