/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.execsqlrow;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.execsqlrow.ExecSQLRowData;
import org.pentaho.di.trans.steps.execsqlrow.ExecSQLRowMeta;
import org.pentaho.di.trans.steps.execsqlrow.Messages;

public class ExecSQLRow
extends BaseStep
implements StepInterface {
    private ExecSQLRowMeta meta;
    private ExecSQLRowData data;

    public ExecSQLRow(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public static final RowMetaAndData getResultRow(Result result, String upd, String ins, String del, String read) {
        ValueMeta meta;
        RowMetaAndData resultRow = new RowMetaAndData();
        if (upd != null && upd.length() > 0) {
            meta = new ValueMeta(upd, 5);
            meta.setLength(10, 0);
            resultRow.addValue(meta, (Object)new Long(result.getNrLinesUpdated()));
        }
        if (ins != null && ins.length() > 0) {
            meta = new ValueMeta(ins, 5);
            meta.setLength(10, 0);
            resultRow.addValue(meta, (Object)new Long(result.getNrLinesOutput()));
        }
        if (del != null && del.length() > 0) {
            meta = new ValueMeta(del, 5);
            meta.setLength(10, 0);
            resultRow.addValue(meta, (Object)new Long(result.getNrLinesDeleted()));
        }
        if (read != null && read.length() > 0) {
            meta = new ValueMeta(read, 5);
            meta.setLength(10, 0);
            resultRow.addValue(meta, (Object)new Long(result.getNrLinesRead()));
        }
        return resultRow;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block14: {
            this.meta = (ExecSQLRowMeta)smi;
            this.data = (ExecSQLRowData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                if (Const.isEmpty((String)this.meta.getSqlFieldName())) {
                    throw new KettleException(Messages.getString("ExecSQLRow.Error.SQLFieldFieldMissing"));
                }
                if (this.data.indexOfSQLFieldname < 0) {
                    this.data.indexOfSQLFieldname = this.getInputRowMeta().indexOfValue(this.meta.getSqlFieldName());
                    if (this.data.indexOfSQLFieldname < 0) {
                        throw new KettleException(Messages.getString("ExecSQLRow.Exception.CouldnotFindField", this.meta.getSqlFieldName()));
                    }
                }
            }
            String SQLScript = this.getInputRowMeta().getString(row, this.data.indexOfSQLFieldname);
            try {
                if (this.log.isDebug()) {
                    this.logDebug(Messages.getString("ExecSQLRow.Log.ExecutingSQLScript") + Const.CR + SQLScript);
                }
                this.data.result = this.data.db.execStatement(SQLScript);
                RowMetaAndData add = ExecSQLRow.getResultRow(this.data.result, this.meta.getUpdateField(), this.meta.getInsertField(), this.meta.getDeleteField(), this.meta.getReadField());
                row = RowDataUtil.addRowData((Object[])row, (int)this.getInputRowMeta().size(), (Object[])add.getData());
                if (this.meta.getCommitSize() > 0 && !this.data.db.isAutoCommit()) {
                    if (this.meta.getCommitSize() == 1) {
                        this.data.db.commit();
                    } else if (this.getLinesWritten() % (long)this.meta.getCommitSize() == 0L) {
                        this.data.db.commit();
                    }
                }
                this.putRow(this.data.outputRowMeta, row);
                if (this.checkFeedback(this.getLinesWritten()) && this.log.isBasic()) {
                    this.logBasic(Messages.getString("ExecSQLRow.Log.LineNumber") + this.getLinesWritten());
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("ExecSQLRow.Log.ErrorInStep") + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block14;
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, null, "ExecSQLRow001");
            }
        }
        return true;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExecSQLRowMeta)smi;
        this.data = (ExecSQLRowData)sdi;
        if (this.log.isBasic()) {
            this.logBasic(Messages.getString("ExecSQLRow.Log.FinishingReadingQuery"));
        }
        if (this.data.db != null) {
            this.data.db.disconnect();
        }
        super.dispose(smi, sdi);
    }

    public void stopRunning(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (ExecSQLRowMeta)smi;
        this.data = (ExecSQLRowData)sdi;
        if (this.data.db != null) {
            this.data.db.cancelQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExecSQLRowMeta)smi;
        this.data = (ExecSQLRowData)sdi;
        if (super.init(smi, sdi)) {
            this.data.db = new Database(this.meta.getDatabaseMeta());
            this.data.db.shareVariablesWith((VariableSpace)this);
            try {
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getThreadName(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(Messages.getString("ExecSQLRow.Log.ConnectedToDB"));
                }
                if (this.meta.getCommitSize() > 1) {
                    this.data.db.setCommit(this.meta.getCommitSize());
                }
                return true;
            }
            catch (KettleException e) {
                this.logError(Messages.getString("ExecSQLRow.Log.ErrorOccurred") + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

