/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.netty;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.Cipher;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SslContextBuilder {
    private static final Logger logger = LogManager.getLogger(SslContextBuilder.class);
    private final File sslKeyFile;
    private final File sslCertificateFile;
    private SslClientVerifyMode verifyMode = SslClientVerifyMode.NONE;
    public static final Set<String> SUPPORTED_CIPHERS = new HashSet<String>(Arrays.asList(((SSLServerSocketFactory)SSLServerSocketFactory.getDefault()).getSupportedCipherSuites()));
    private static final String[] DEFAULT_CIPHERS;
    private static final String[] DEFAULT_CIPHERS_LIMITED;
    private String[] ciphers = DEFAULT_CIPHERS;
    private String[] protocols = new String[]{"TLSv1.2", "TLSv1.3"};
    private String[] certificateAuthorities;
    private final String passphrase;

    public SslContextBuilder(String sslCertificateFilePath, String sslKeyFilePath, String pass) throws IllegalArgumentException {
        this.sslCertificateFile = new File(sslCertificateFilePath);
        if (!this.sslCertificateFile.canRead()) {
            throw new IllegalArgumentException(String.format("Certificate file cannot be read. Please confirm the user running Logstash has permissions to read: %s", sslCertificateFilePath));
        }
        this.sslKeyFile = new File(sslKeyFilePath);
        if (!this.sslKeyFile.canRead()) {
            throw new IllegalArgumentException(String.format("Private key file cannot be read. Please confirm the user running Logstash has permissions to read: %s", sslKeyFilePath));
        }
        this.passphrase = pass;
    }

    public SslContextBuilder setProtocols(String[] protocols) {
        this.protocols = protocols;
        return this;
    }

    public SslContextBuilder setCipherSuites(String[] ciphersSuite) throws IllegalArgumentException {
        for (String cipher : ciphersSuite) {
            if (!SUPPORTED_CIPHERS.contains(cipher)) {
                if (!SslContextBuilder.isUnlimitedJCEAvailable()) {
                    logger.warn("JCE Unlimited Strength Jurisdiction Policy not installed");
                }
                throw new IllegalArgumentException("Cipher `" + cipher + "` is not available");
            }
            logger.debug("{} cipher is supported", (Object)cipher);
        }
        this.ciphers = ciphersSuite;
        return this;
    }

    public SslContextBuilder setClientAuthentication(SslClientVerifyMode verifyMode, String[] certificateAuthorities) {
        if (this.isClientAuthenticationEnabled(verifyMode) && (certificateAuthorities == null || certificateAuthorities.length < 1)) {
            throw new IllegalArgumentException("Certificate authorities are required to enable client authentication");
        }
        this.verifyMode = verifyMode;
        this.certificateAuthorities = certificateAuthorities;
        return this;
    }

    private boolean isClientAuthenticationEnabled(SslClientVerifyMode mode) {
        return mode == SslClientVerifyMode.OPTIONAL || mode == SslClientVerifyMode.REQUIRED;
    }

    public boolean isClientAuthenticationRequired() {
        return this.verifyMode == SslClientVerifyMode.REQUIRED;
    }

    public static String[] getDefaultCiphers() {
        if (SslContextBuilder.isUnlimitedJCEAvailable()) {
            return DEFAULT_CIPHERS;
        }
        logger.warn("JCE Unlimited Strength Jurisdiction Policy not installed - max key length is 128 bits");
        return DEFAULT_CIPHERS_LIMITED;
    }

    public static boolean isUnlimitedJCEAvailable() {
        try {
            return Cipher.getMaxAllowedKeyLength("AES") > 128;
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("AES not available", (Throwable)e);
            return false;
        }
    }

    public SslContext buildContext() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Available ciphers: {}", SUPPORTED_CIPHERS);
            logger.debug("Ciphers: {}", (Object)Arrays.toString(this.ciphers));
        }
        io.netty.handler.ssl.SslContextBuilder builder = io.netty.handler.ssl.SslContextBuilder.forServer((File)this.sslCertificateFile, (File)this.sslKeyFile, (String)this.passphrase).ciphers(Arrays.asList(this.ciphers)).protocols(this.protocols);
        if (this.isClientAuthenticationEnabled(this.verifyMode)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Certificate Authorities: {}", (Object)Arrays.toString(this.certificateAuthorities));
            }
            builder.clientAuth(this.verifyMode.toClientAuth()).trustManager(this.loadCertificateCollection(this.certificateAuthorities));
        }
        try {
            return builder.build();
        }
        catch (SSLException e) {
            logger.debug("Failed to initialize SSL", (Throwable)e);
            if (("failed to initialize the server-side SSL context".equals(e.getMessage()) || "failed to initialize the client-side SSL context".equals(e.getMessage())) && e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        catch (Exception e) {
            logger.debug("Failed to initialize SSL", (Throwable)e);
            throw e;
        }
    }

    private X509Certificate[] loadCertificateCollection(String[] certificates) throws IOException, CertificateException {
        logger.debug("Load certificates collection");
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ArrayList collections = new ArrayList();
        for (String certificate : certificates) {
            logger.debug("Loading certificates from file {}", (Object)certificate);
            try (FileInputStream in = new FileInputStream(certificate);){
                List certificatesChains = (List)certificateFactory.generateCertificates(in);
                collections.addAll(certificatesChains);
            }
        }
        return collections.toArray(new X509Certificate[collections.size()]);
    }

    String[] getProtocols() {
        return this.protocols != null ? (String[])this.protocols.clone() : null;
    }

    String[] getCertificateAuthorities() {
        return this.certificateAuthorities != null ? (String[])this.certificateAuthorities.clone() : null;
    }

    String[] getCiphers() {
        return this.ciphers != null ? (String[])this.ciphers.clone() : null;
    }

    SslClientVerifyMode getVerifyMode() {
        return this.verifyMode;
    }

    static {
        String[] defaultCipherCandidates = new String[]{"TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256", "TLS_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"};
        DEFAULT_CIPHERS = (String[])Arrays.stream(defaultCipherCandidates).filter(SUPPORTED_CIPHERS::contains).toArray(String[]::new);
        DEFAULT_CIPHERS_LIMITED = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"};
    }

    public static enum SslClientVerifyMode {
        NONE(ClientAuth.NONE),
        OPTIONAL(ClientAuth.OPTIONAL),
        REQUIRED(ClientAuth.REQUIRE);

        private final ClientAuth clientAuth;

        private SslClientVerifyMode(ClientAuth clientAuth) {
            this.clientAuth = clientAuth;
        }

        public ClientAuth toClientAuth() {
            return this.clientAuth;
        }
    }
}

