/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.ModelDrawArea;
import de.escape.quincunx.dxf.reader.DxfLAYER;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class LayerList
extends List
implements ItemListener {
    private Hashtable layerHash;
    private ModelDrawArea drawingArea;

    public LayerList(ModelDrawArea drawArea) {
        this(null, drawArea);
    }

    public LayerList(Hashtable layerTable, ModelDrawArea drawArea) {
        super(100, true);
        this.layerHash = layerTable;
        this.drawingArea = drawArea;
        this.addItemListener(this);
        this.setLayer(layerTable);
    }

    public void setLayer(Hashtable layerTable) {
        Rectangle bounds = this.getBounds();
        if (this.getItemCount() > 0) {
            this.removeAll();
        }
        this.layerHash = layerTable;
        if (layerTable != null) {
            Enumeration layers = layerTable.elements();
            while (layers.hasMoreElements()) {
                DxfLAYER l = null;
                try {
                    l = (DxfLAYER)layers.nextElement();
                }
                catch (Exception x) {
                    System.out.println(x);
                    break;
                }
                if (!l.isReferenced()) continue;
                int pos = 0;
                while (pos < this.getItemCount()) {
                    if (l.getName().compareTo(this.getItem(pos)) < 0) break;
                    ++pos;
                }
                this.add(l.getName(), pos);
            }
            int index = this.getItemCount() - 1;
            while (index >= 0) {
                DxfLAYER l = (DxfLAYER)layerTable.get(this.getItem(index));
                if (l.getVisibility()) {
                    this.select(index);
                } else {
                    this.deselect(index);
                }
                --index;
            }
            this.setBounds(bounds);
            this.makeVisible(0);
            this.invalidate();
            this.getParent().repaint();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        switch (event.getStateChange()) {
            case 1: 
            case 2: {
                DxfLAYER l = (DxfLAYER)this.layerHash.get(this.getItem((Integer)event.getItem()));
                l.setVisibility(event.getStateChange() == 1);
                if (!l.isReferenced()) break;
                this.drawingArea.updateView();
                break;
            }
        }
    }

    public void invertSelections() {
        int i = this.getItemCount() - 1;
        while (i >= 0) {
            DxfLAYER l = (DxfLAYER)this.layerHash.get(this.getItem(i));
            if (this.isIndexSelected(i)) {
                this.deselect(i);
                l.setVisibility(false);
            } else {
                this.select(i);
                l.setVisibility(true);
            }
            --i;
        }
        this.drawingArea.updateView();
    }

    public void selectAll() {
        boolean anyChange = false;
        int i = this.getItemCount() - 1;
        while (i >= 0) {
            DxfLAYER l = (DxfLAYER)this.layerHash.get(this.getItem(i));
            if (!this.isIndexSelected(i)) {
                this.select(i);
                l.setVisibility(true);
                if (l.isReferenced()) {
                    anyChange = true;
                }
            }
            --i;
        }
        if (anyChange) {
            this.drawingArea.updateView();
        }
    }

    public void setSelected(int index, boolean state) {
        if (state != this.isIndexSelected(index)) {
            DxfLAYER l = (DxfLAYER)this.layerHash.get(this.getItem(index));
            if (state) {
                this.select(index);
                l.setVisibility(true);
            } else {
                this.deselect(index);
                l.setVisibility(false);
            }
            if (l.isReferenced()) {
                this.drawingArea.updateView();
            }
        }
    }

    int getIndex(String name) {
        int index = this.getItemCount() - 1;
        while (index >= 0) {
            if (this.getItem(index).equals(name)) break;
            --index;
        }
        return index;
    }
}

