/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HKDFunction {
    public static final String KEY = "key";
    public static final String IV = "iv";
    public static final String FINISHED = "finished";
    public static final String DERIVED = "derived";
    public static final String BINDER_KEY_EXT = "ext binder";
    public static final String BINDER_KEY_RES = "res binder";
    public static final String CLIENT_EARLY_TRAFFIC_SECRET = "c e traffic";
    public static final String EARLY_EXPORTER_MASTER_SECRET = "e exp master";
    public static final String CLIENT_HANDSHAKE_TRAFFIC_SECRET = "c hs traffic";
    public static final String SERVER_HANDSHAKE_TRAFFIC_SECRET = "s hs traffic";
    public static final String CLIENT_APPLICATION_TRAFFIC_SECRET = "c ap traffic";
    public static final String SERVER_APPLICATION_TRAFFIC_SECRET = "s ap traffic";
    public static final String EXPORTER_MASTER_SECRET = "exp master";
    public static final String ESNI_IV = "esni iv";
    public static final String ESNI_KEY = "esni key";
    public static final String RESUMPTION_MASTER_SECRET = "res master";
    public static final String RESUMPTION = "resumption";

    public static byte[] extract(HKDFAlgorithm hkdfAlgortihm, byte[] salt, byte[] ikm) throws CryptoException {
        try {
            Mac mac = Mac.getInstance(hkdfAlgortihm.getMacAlgorithm().getJavaName());
            if (salt == null || salt.length == 0) {
                salt = new byte[mac.getMacLength()];
                Arrays.fill(salt, (byte)0);
            }
            SecretKeySpec keySpec = new SecretKeySpec(salt, hkdfAlgortihm.getMacAlgorithm().getJavaName());
            mac.init(keySpec);
            mac.update(ikm);
            return mac.doFinal();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new CryptoException(ex);
        }
    }

    public static byte[] expand(HKDFAlgorithm hkdfAlgortihm, byte[] prk, byte[] info, int outLen) throws CryptoException {
        try {
            Mac mac = Mac.getInstance(hkdfAlgortihm.getMacAlgorithm().getJavaName());
            SecretKeySpec keySpec = new SecretKeySpec(prk, hkdfAlgortihm.getMacAlgorithm().getJavaName());
            mac.init(keySpec);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            byte[] ti = new byte[]{};
            int i = 1;
            while (stream.toByteArray().length < outLen) {
                mac.update(ti);
                mac.update(info);
                if (Integer.toHexString(i).length() % 2 != 0) {
                    mac.update(ArrayConverter.hexStringToByteArray((String)("0" + Integer.toHexString(i))));
                } else {
                    mac.update(ArrayConverter.hexStringToByteArray((String)Integer.toHexString(i)));
                }
                ti = mac.doFinal();
                if (ti.length == 0) {
                    throw new CryptoException("Could not expand HKDF. Mac Algorithm of 0 size");
                }
                stream.write(ti);
                ++i;
            }
            return Arrays.copyOfRange(stream.toByteArray(), 0, outLen);
        }
        catch (IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new CryptoException(ex);
        }
    }

    private static byte[] labelEncoder(byte[] hashValue, String labelIn, int outLen) {
        String label = "tls13 " + labelIn;
        int labelLength = label.getBytes().length;
        int hashValueLength = hashValue.length;
        byte[] result = ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.intToBytes((int)outLen, (int)2), ArrayConverter.intToBytes((int)labelLength, (int)1), label.getBytes(), ArrayConverter.intToBytes((int)hashValueLength, (int)1), hashValue});
        return result;
    }

    public static byte[] deriveSecret(HKDFAlgorithm hkdfAlgortihm, String hashAlgorithm, byte[] prk, String labelIn, byte[] toHash) throws CryptoException {
        try {
            MessageDigest hashFunction = MessageDigest.getInstance(hashAlgorithm);
            hashFunction.update(toHash);
            byte[] hashValue = hashFunction.digest();
            int outLen = Mac.getInstance(hkdfAlgortihm.getMacAlgorithm().getJavaName()).getMacLength();
            return HKDFunction.expandLabel(hkdfAlgortihm, prk, labelIn, hashValue, outLen);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptoException("Could not initialize HKDF", ex);
        }
    }

    public static byte[] expandLabel(HKDFAlgorithm hkdfAlgortihm, byte[] prk, String labelIn, byte[] hashValue, int outLen) throws CryptoException {
        byte[] info = HKDFunction.labelEncoder(hashValue, labelIn, outLen);
        return HKDFunction.expand(hkdfAlgortihm, prk, info, outLen);
    }

    static byte[] deriveSecret(HKDFAlgorithm hkdfAlgorithm, byte[] hexStringToByteArray, String tls13_derived, byte[] hexStringToByteArray0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private HKDFunction() {
    }
}

