/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.gtk;

import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import org.netbeans.swing.plaf.gtk.GtkToolBarButtonUI;

public class GtkToolbarUI
extends BasicToolBarUI
implements ContainerListener {
    private static final ButtonUI buttonui = new GtkToolBarButtonUI();

    private GtkToolbarUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new GtkToolbarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(false);
        jComponent.addContainerListener(this);
        this.installButtonUIs(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.setBorder(null);
        jComponent.removeContainerListener(this);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, UIManager.getColor("controlHighlight"), 0.0f, jComponent.getHeight(), UIManager.getColor("control"));
        ((Graphics2D)graphics).setPaint(gradientPaint);
        Insets insets = jComponent.getInsets();
        graphics.fillRect(insets.left, insets.top, jComponent.getWidth() - (insets.left + insets.top), jComponent.getHeight() - (insets.top + insets.bottom));
    }

    @Override
    protected Border createRolloverBorder() {
        return BorderFactory.createEmptyBorder(2, 2, 2, 2);
    }

    @Override
    protected Border createNonRolloverBorder() {
        return this.createRolloverBorder();
    }

    private Border createNonRolloverToggleBorder() {
        return this.createRolloverBorder();
    }

    @Override
    protected void setBorderToRollover(Component component) {
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).setBorderPainted(false);
            ((AbstractButton)component).setBorder(BorderFactory.createEmptyBorder());
            ((AbstractButton)component).setContentAreaFilled(false);
            ((AbstractButton)component).setOpaque(false);
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(false);
        }
    }

    @Override
    protected void setBorderToNormal(Component component) {
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).setBorderPainted(false);
            ((AbstractButton)component).setContentAreaFilled(false);
            ((AbstractButton)component).setOpaque(false);
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(false);
        }
    }

    @Override
    public void setFloating(boolean bl, Point point) {
    }

    private void installButtonUI(Component component) {
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).setUI(buttonui);
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(false);
        }
    }

    private void installButtonUIs(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.installButtonUI(componentArray[i]);
        }
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        this.installButtonUI(containerEvent.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
    }
}

