/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.util;

import org.openjdk.jmc.common.IDescribable;

public class LabeledIdentifier
implements IDescribable {
    private final String interfaceId;
    private final long implId;
    private final String name;
    private final String description;

    public LabeledIdentifier(String interfaceId, long implId, String name, String description) {
        this.interfaceId = interfaceId;
        this.implId = implId;
        this.name = name;
        this.description = description;
    }

    public String getInterfaceId() {
        return this.interfaceId;
    }

    public long getImplementationId() {
        return this.implId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDeclaredDescription() {
        return this.description;
    }

    @Override
    public String getDescription() {
        return this.interfaceId + " (" + this.implId + ")" + (this.description == null ? "" : " " + this.description);
    }

    public int hashCode() {
        return (int)(this.implId >>> 32 ^ this.implId) ^ this.interfaceId.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof LabeledIdentifier && ((LabeledIdentifier)obj).implId == this.implId && ((LabeledIdentifier)obj).interfaceId.equals(this.interfaceId);
    }

    public String toString() {
        return this.getName();
    }
}

