/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.util.function.IntUnaryOperator;
import org.apache.commons.io.build.AbstractOriginSupplier;
import org.apache.commons.io.file.PathUtils;

public abstract class AbstractStreamBuilder<T, B extends AbstractStreamBuilder<T, B>>
extends AbstractOriginSupplier<T, B> {
    private static final OpenOption[] DEFAULT_OPEN_OPTIONS = PathUtils.EMPTY_OPEN_OPTION_ARRAY;
    private int bufferSize = 8192;
    private int bufferSizeDefault = 8192;
    private int bufferSizeMax = Integer.MAX_VALUE;
    private Charset charset = Charset.defaultCharset();
    private Charset charsetDefault = Charset.defaultCharset();
    private OpenOption[] openOptions = DEFAULT_OPEN_OPTIONS;
    private final IntUnaryOperator defaultSizeChecker;
    private IntUnaryOperator bufferSizeChecker = this.defaultSizeChecker = size -> size > this.bufferSizeMax ? this.throwIae(size, this.bufferSizeMax) : size;

    protected int getBufferSize() {
        return this.bufferSize;
    }

    private int throwIae(int size, int max) {
        throw new IllegalArgumentException(String.format("Request %,d exceeds maximum %,d", size, max));
    }
}

