/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.columnexists;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.columnexists.ColumnExistsData;
import org.pentaho.di.trans.steps.columnexists.ColumnExistsMeta;
import org.pentaho.di.trans.steps.columnexists.Messages;

public class ColumnExists
extends BaseStep
implements StepInterface {
    private ColumnExistsMeta meta;
    private ColumnExistsData data;

    public ColumnExists(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block15: {
            this.meta = (ColumnExistsMeta)smi;
            this.data = (ColumnExistsData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            boolean columnexists = false;
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                if (Const.isEmpty((String)this.meta.getDynamicColumnnameField())) {
                    this.logError(Messages.getString("ColumnExists.Error.ColumnnameFieldMissing"));
                    throw new KettleException(Messages.getString("ColumnExists.Error.ColumnnameFieldMissing"));
                }
                if (this.meta.isTablenameInField()) {
                    if (Const.isEmpty((String)this.meta.getDynamicTablenameField())) {
                        this.logError(Messages.getString("ColumnExists.Error.TablenameFieldMissing"));
                        throw new KettleException(Messages.getString("ColumnExists.Error.TablenameFieldMissing"));
                    }
                    if (this.data.indexOfTablename < 0) {
                        this.data.indexOfTablename = this.getInputRowMeta().indexOfValue(this.meta.getDynamicTablenameField());
                        if (this.data.indexOfTablename < 0) {
                            this.logError(Messages.getString("ColumnExists.Exception.CouldnotFindField") + "[" + this.meta.getDynamicTablenameField() + "]");
                            throw new KettleException(Messages.getString("ColumnExists.Exception.CouldnotFindField", this.meta.getDynamicTablenameField()));
                        }
                    }
                } else {
                    this.data.tablename = !Const.isEmpty((String)this.data.schemaname) ? this.data.db.getDatabaseMeta().getQuotedSchemaTableCombination(this.data.schemaname, this.data.tablename) : this.data.db.getDatabaseMeta().quoteField(this.data.tablename);
                }
                if (this.data.indexOfColumnname < 0) {
                    this.data.indexOfColumnname = this.getInputRowMeta().indexOfValue(this.meta.getDynamicColumnnameField());
                    if (this.data.indexOfColumnname < 0) {
                        this.logError(Messages.getString("ColumnExists.Exception.CouldnotFindField") + "[" + this.meta.getDynamicColumnnameField() + "]");
                        throw new KettleException(Messages.getString("ColumnExists.Exception.CouldnotFindField", this.meta.getDynamicColumnnameField()));
                    }
                }
            }
            try {
                if (this.meta.isTablenameInField()) {
                    this.data.tablename = this.getInputRowMeta().getString(r, this.data.indexOfTablename);
                    this.data.tablename = !Const.isEmpty((String)this.data.schemaname) ? this.data.db.getDatabaseMeta().getQuotedSchemaTableCombination(this.data.schemaname, this.data.tablename) : this.data.db.getDatabaseMeta().quoteField(this.data.tablename);
                }
                String columnname = this.getInputRowMeta().getString(r, this.data.indexOfColumnname);
                columnname = this.data.db.getDatabaseMeta().quoteField(columnname);
                columnexists = this.data.db.checkColumnExists(columnname, this.data.tablename);
                Object[] outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.getInputRowMeta().size(), (Object)columnexists);
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel(this.toString(), Messages.getString("ColumnExists.LineNumber", this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)), new Object[0]);
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("ColumnExists.ErrorInStepRunning : " + e.getMessage()));
                    throw new KettleStepException(Messages.getString("ColumnExists.Log.ErrorInStep"), (Throwable)e);
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block15;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, this.meta.getResultFieldName(), "ColumnExists001");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        block13: {
            this.meta = (ColumnExistsMeta)smi;
            this.data = (ColumnExistsData)sdi;
            if (super.init(smi, sdi)) {
                if (!this.meta.isTablenameInField()) {
                    if (Const.isEmpty((String)this.meta.getTablename())) {
                        this.log.logError(this.toString(), Messages.getString("ColumnExists.Error.TablenameMissing"), new Object[0]);
                        return false;
                    }
                    this.data.tablename = this.environmentSubstitute(this.meta.getTablename());
                }
                this.data.schemaname = this.meta.getSchemaname();
                if (!Const.isEmpty((String)this.data.schemaname)) {
                    this.data.schemaname = this.environmentSubstitute(this.data.schemaname);
                }
                if (Const.isEmpty((String)this.meta.getResultFieldName())) {
                    this.log.logError(this.toString(), Messages.getString("ColumnExists.Error.ResultFieldMissing"), new Object[0]);
                    return false;
                }
                this.data.db = new Database(this.meta.getDatabase());
                this.data.db.shareVariablesWith((VariableSpace)this);
                try {
                    if (this.getTransMeta().isUsingUniqueConnections()) {
                        Trans trans = this.getTrans();
                        synchronized (trans) {
                            this.data.db.connect(this.getTrans().getThreadName(), this.getPartitionID());
                        }
                    } else {
                        this.data.db.connect(this.getPartitionID());
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(Messages.getString("ColumnExists.Log.ConnectedToDB"));
                    }
                    return true;
                }
                catch (KettleException e) {
                    this.logError(Messages.getString("ColumnExists.Log.DBException") + e.getMessage());
                    if (this.data.db == null) break block13;
                    this.data.db.disconnect();
                }
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ColumnExistsMeta)smi;
        this.data = (ColumnExistsData)sdi;
        if (this.data.db != null) {
            this.data.db.disconnect();
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

