/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import groovy.util.Node;
import java.util.LinkedHashMap;
import java.util.Map;

public class Facet {
    private FacetType type;
    private String name;
    private String version;

    public Facet() {
        this.type = FacetType.installed;
    }

    public Facet(Node node) {
        this(FacetType.valueOf((String)node.name()), (String)node.attribute((Object)"facet"), (String)node.attribute((Object)"version"));
    }

    public Facet(String name, String version) {
        this(FacetType.installed, name, version);
    }

    public Facet(FacetType type, String name, String version) {
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkNotNull((Object)name);
        if (type == FacetType.installed) {
            Preconditions.checkNotNull((Object)version);
        } else {
            Preconditions.checkArgument((version == null ? 1 : 0) != 0);
        }
        this.type = type;
        this.name = name;
        this.version = version;
    }

    public FacetType getType() {
        return this.type;
    }

    public void setType(FacetType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void appendNode(Node node) {
        LinkedHashMap attributes = Maps.newLinkedHashMap();
        attributes.put("facet", this.name);
        if (this.type == FacetType.installed) {
            attributes.put("version", this.version);
        }
        node.appendNode((Object)this.type.name(), (Map)attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Facet facet = (Facet)o;
        return this.type == facet.type && Objects.equal((Object)this.name, (Object)facet.name) && Objects.equal((Object)this.version, (Object)facet.version);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.name, this.version});
    }

    public String toString() {
        return "Facet{type='" + (Object)((Object)this.type) + "', name='" + this.name + "', version='" + this.version + "'}";
    }

    public static enum FacetType {
        installed,
        fixed;

    }
}

