/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.SingleByte;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.JIS_X_0201;

public class X11JIS0201
extends Charset {
    private static Charset jis0201 = new JIS_X_0201();
    private static SingleByte.Encoder enc = (SingleByte.Encoder)jis0201.newEncoder();

    public X11JIS0201() {
        super("X11JIS0201", null);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return jis0201.newDecoder();
    }

    @Override
    public boolean contains(Charset charset) {
        return charset instanceof X11JIS0201;
    }

    private class Encoder
    extends CharsetEncoder {
        private Surrogate.Parser sgp;

        public Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return c >= '\uff61' && c <= '\uff9f' || c == '\u203e' || c == '\u00a5';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            CoderResult coderResult = CoderResult.UNDERFLOW;
            if (n4 - n3 < n2 - n) {
                n2 = n + (n4 - n3);
                coderResult = CoderResult.OVERFLOW;
            }
            try {
                while (n < n2) {
                    char c = cArray[n];
                    int n5 = enc.encode(c);
                    if (n5 == 65533) {
                        if (Character.isSurrogate(c)) {
                            if (this.sgp == null) {
                                this.sgp = new Surrogate.Parser();
                            }
                            if (this.sgp.parse(c, cArray, n, n2) >= 0) {
                                CoderResult coderResult2 = CoderResult.unmappableForLength(2);
                                return coderResult2;
                            }
                        }
                        CoderResult coderResult3 = CoderResult.unmappableForLength(1);
                        return coderResult3;
                    }
                    byArray[n3++] = (byte)n5;
                    ++n;
                }
                CoderResult coderResult4 = coderResult;
                return coderResult4;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }
    }
}

