/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.socketreader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleEOFException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.socketreader.Messages;
import org.pentaho.di.trans.steps.socketreader.SocketReaderData;
import org.pentaho.di.trans.steps.socketreader.SocketReaderMeta;

public class SocketReader
extends BaseStep
implements StepInterface {
    public static final String STRING_FINISHED = "Finished";
    private static final int TIMEOUT_IN_SECONDS = 30;
    private SocketReaderMeta meta;
    private SocketReaderData data;

    public SocketReader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (SocketReaderMeta)smi;
        this.data = (SocketReaderData)sdi;
        try {
            if (this.first) {
                long startTime = System.currentTimeMillis();
                boolean connected = false;
                KettleException lastException = null;
                while (!connected && 30L > (System.currentTimeMillis() - startTime) / 1000L && !this.isStopped()) {
                    try {
                        int port = Integer.parseInt(this.environmentSubstitute(this.meta.getPort()));
                        int bufferSize = Integer.parseInt(this.environmentSubstitute(this.meta.getBufferSize()));
                        this.data.socket = new Socket(this.environmentSubstitute(this.meta.getHostname()), port);
                        connected = true;
                        if (this.meta.isCompressed()) {
                            this.data.outputStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(this.data.socket.getOutputStream()), bufferSize));
                            this.data.inputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(this.data.socket.getInputStream()), bufferSize));
                        } else {
                            this.data.outputStream = new DataOutputStream(new BufferedOutputStream(this.data.socket.getOutputStream(), bufferSize));
                            this.data.inputStream = new DataInputStream(new BufferedInputStream(this.data.socket.getInputStream(), bufferSize));
                        }
                        lastException = null;
                    }
                    catch (Exception e) {
                        lastException = new KettleException("Unable to open socket to server " + this.environmentSubstitute(this.meta.getHostname()) + " port " + this.environmentSubstitute(this.meta.getPort()), (Throwable)e);
                    }
                    if (lastException == null) continue;
                    Thread.sleep(1000L);
                }
                if (lastException != null) {
                    this.logError("Error initialising step: " + lastException.toString());
                    this.logError(Const.getStackTracker(lastException));
                    throw lastException;
                }
                if (this.data.inputStream == null) {
                    throw new KettleException("Unable to connect to the SocketWriter in the 30s timeout period.");
                }
                this.data.rowMeta = new RowMeta(this.data.inputStream);
                this.first = false;
            }
            Object[] r = this.data.rowMeta.readData(this.data.inputStream);
            this.incrementLinesInput();
            if (this.checkFeedback(this.getLinesInput())) {
                this.logBasic(Messages.getString("SocketReader.Log.LineNumber") + this.getLinesInput());
            }
            this.putRow(this.data.rowMeta, r);
        }
        catch (KettleEOFException e) {
            this.setOutputDone();
            return false;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SocketReaderMeta)smi;
        this.data = (SocketReaderData)sdi;
        return super.init(smi, sdi);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        try {
            this.data.inputStream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.data.outputStream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.data.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

