/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.js.K2JsIrCompiler;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinPaths;

public class K2JSCompiler
extends CLICompiler<K2JSCompilerArguments> {
    private K2JsIrCompiler irCompiler = null;
    private final K2JSCompilerPerformanceManager performanceManager = new K2JSCompilerPerformanceManager();

    @NotNull
    private K2JsIrCompiler getIrCompiler() {
        if (this.irCompiler == null) {
            this.irCompiler = new K2JsIrCompiler();
        }
        K2JsIrCompiler k2JsIrCompiler = this.irCompiler;
        if (k2JsIrCompiler == null) {
            K2JSCompiler.$$$reportNull$$$0(0);
        }
        return k2JsIrCompiler;
    }

    @Override
    protected void addPlatformOptions(@NotNull List<String> $self, @NotNull K2JSCompilerArguments arguments) {
        if ($self == null) {
            K2JSCompiler.$$$reportNull$$$0(1);
        }
        if (arguments == null) {
            K2JSCompiler.$$$reportNull$$$0(2);
        }
    }

    public static void main(String ... args) {
        K2JSCompiler.doMain(new K2JSCompiler(), args);
    }

    @Override
    @NotNull
    public K2JSCompilerArguments createArguments() {
        return new K2JSCompilerArguments();
    }

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments, @NotNull CompilerConfiguration configuration2, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths2) {
        if (arguments == null) {
            K2JSCompiler.$$$reportNull$$$0(3);
        }
        if (configuration2 == null) {
            K2JSCompiler.$$$reportNull$$$0(4);
        }
        if (rootDisposable == null) {
            K2JSCompiler.$$$reportNull$$$0(5);
        }
        MessageCollector messageCollector = configuration2.getNotNull(CommonConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        boolean useFir = Boolean.TRUE.equals(configuration2.get(CommonConfigurationKeys.USE_FIR));
        if (K2JSCompilerArgumentsKt.isIrBackendEnabled(arguments) || useFir) {
            ExitCode exitCode = this.getIrCompiler().doExecute(arguments, configuration2.copy(), rootDisposable, paths2);
            if (exitCode == null) {
                K2JSCompiler.$$$reportNull$$$0(6);
            }
            return exitCode;
        }
        messageCollector.report(CompilerMessageSeverity.ERROR, "Old Kotlin/JS compiler is no longer supported. Please migrate to the new JS IR backend", null);
        ExitCode exitCode = ExitCode.COMPILATION_ERROR;
        if (exitCode == null) {
            K2JSCompiler.$$$reportNull$$$0(7);
        }
        return exitCode;
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration2, @NotNull K2JSCompilerArguments arguments, @NotNull Services services) {
        if (configuration2 == null) {
            K2JSCompiler.$$$reportNull$$$0(8);
        }
        if (arguments == null) {
            K2JSCompiler.$$$reportNull$$$0(9);
        }
        if (services == null) {
            K2JSCompiler.$$$reportNull$$$0(10);
        }
        if (K2JSCompilerArgumentsKt.isIrBackendEnabled(arguments)) {
            this.getIrCompiler().setupPlatformSpecificArgumentsAndServices(configuration2, arguments, services);
        }
    }

    @NotNull
    static String calculateSourceMapSourceRoot(@NotNull MessageCollector messageCollector, @NotNull K2JSCompilerArguments arguments) {
        if (messageCollector == null) {
            K2JSCompiler.$$$reportNull$$$0(11);
        }
        if (arguments == null) {
            K2JSCompiler.$$$reportNull$$$0(12);
        }
        File commonPath = null;
        ArrayList<File> pathToRoot = new ArrayList<File>();
        HashMap pathToRootIndexes = new HashMap();
        try {
            for (String path : arguments.getFreeArgs()) {
                File file2;
                if (commonPath == null) {
                    commonPath = file2;
                    for (file2 = new File(path).getCanonicalFile(); file2 != null; file2 = file2.getParentFile()) {
                        pathToRoot.add(file2);
                    }
                    Collections.reverse(pathToRoot);
                    for (int i = 0; i < pathToRoot.size(); ++i) {
                        pathToRootIndexes.put(pathToRoot.get(i), i);
                    }
                    continue;
                }
                while (file2 != null) {
                    Integer existingIndex = (Integer)pathToRootIndexes.get(file2);
                    if (existingIndex != null) {
                        existingIndex = Math.min(existingIndex, pathToRoot.size() - 1);
                        pathToRoot.subList(existingIndex + 1, pathToRoot.size()).clear();
                        commonPath = (File)pathToRoot.get(pathToRoot.size() - 1);
                        break;
                    }
                    file2 = file2.getParentFile();
                }
                if (file2 != null) continue;
                break;
            }
        }
        catch (IOException e) {
            String text = ExceptionUtil.getThrowableText(e);
            messageCollector.report(CompilerMessageSeverity.ERROR, "IO error occurred calculating source root:\n" + text, null);
            return ".";
        }
        return commonPath != null ? commonPath.getPath() : ".";
    }

    @Override
    @NotNull
    public CommonCompilerPerformanceManager getDefaultPerformanceManager() {
        K2JSCompilerPerformanceManager k2JSCompilerPerformanceManager = this.performanceManager;
        if (k2JSCompilerPerformanceManager == null) {
            K2JSCompiler.$$$reportNull$$$0(13);
        }
        return k2JSCompilerPerformanceManager;
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlinc-js";
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        if (versionArray == null) {
            K2JSCompiler.$$$reportNull$$$0(14);
        }
        return new JsMetadataVersion(versionArray);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/js/K2JSCompiler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "$self";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDisposable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageCollector";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIrCompiler";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/js/K2JSCompiler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doExecute";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPerformanceManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addPlatformOptions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setupPlatformSpecificArgumentsAndServices";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calculateSourceMapSourceRoot";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createMetadataVersion";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class K2JSCompilerPerformanceManager
    extends CommonCompilerPerformanceManager {
        public K2JSCompilerPerformanceManager() {
            super("Kotlin to JS Compiler");
        }
    }
}

