/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class JmakProtocolDecoder
extends BaseProtocolDecoder {
    public JmakProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.startsWith("{") || sentence.startsWith("^")) {
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(Unpooled.copiedBuffer((CharSequence)"ACK", (Charset)StandardCharsets.US_ASCII), remoteAddress));
            }
            return null;
        }
        if (!sentence.startsWith("~") || !sentence.endsWith("$")) {
            return null;
        }
        String[] parts = sentence.substring(1, sentence.length() - 1).split("\\|");
        String[] values = parts[0].split(";");
        DeviceSession session = this.getDeviceSession(channel, remoteAddress, values[2]);
        if (session == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(session.getDeviceId());
        this.decodeEvent(position, values);
        if (parts.length >= 2) {
            this.decodeCan(position, parts[1].split(";"));
        }
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(Unpooled.copiedBuffer((CharSequence)"ACK", (Charset)StandardCharsets.US_ASCII), remoteAddress));
        }
        return position;
    }

    private void decodeEvent(Position position, String[] values) {
        String eventName;
        int eventStatus;
        int eventId;
        long mask;
        int index = 0;
        if (BitUtil.check(mask = Long.parseLong(values[index++], 16), 0)) {
            ++index;
        }
        if (BitUtil.check(mask, 1)) {
            ++index;
        }
        if (BitUtil.check(mask, 2)) {
            position.set("count", Long.parseLong(values[index++]));
        }
        if (BitUtil.check(mask, 3) && !values[index++].equals("NULL")) {
            position.set("nickname", values[index - 1]);
        }
        if (BitUtil.check(mask, 4)) {
            position.setTime(new Date(Long.parseLong(values[index++])));
        }
        if (BitUtil.check(mask, 5)) {
            position.setLatitude(Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(mask, 6)) {
            position.setLongitude(Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(mask, 7)) {
            position.setAltitude(Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(mask, 8)) {
            ++index;
        }
        if (BitUtil.check(mask, 9)) {
            position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(values[index++])));
        }
        if (BitUtil.check(mask, 10)) {
            position.set("sat", Integer.parseInt(values[index++]));
        }
        if (BitUtil.check(mask, 11)) {
            position.set("rssi", Integer.parseInt(values[index++]));
        }
        if (BitUtil.check(mask, 12)) {
            position.set("hdop", Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(mask, 13)) {
            position.setCourse(Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(mask, 14)) {
            position.set("ignition", Integer.parseInt(values[index++]) == 1);
        }
        if (BitUtil.check(mask, 15)) {
            position.set("backup", Integer.parseInt(values[index++]) == 1);
        }
        if (BitUtil.check(mask, 16)) {
            position.set("hours", Double.parseDouble(values[index++]) * 3600000.0);
        }
        if (BitUtil.check(mask, 17)) {
            position.set("odometer", Double.parseDouble(values[index++]) * 1000.0);
        }
        if (BitUtil.check(mask, 18)) {
            eventId = Integer.parseInt(values[index++]);
            position.set("event", eventId);
        } else {
            eventId = 0;
        }
        if (BitUtil.check(mask, 19)) {
            eventStatus = Integer.parseInt(values[index++]);
            position.set("eventStatus", eventStatus);
        } else {
            eventStatus = 0;
        }
        if (BitUtil.check(mask, 20)) {
            eventName = values[index++];
            position.set("eventName", eventName);
        } else {
            eventName = null;
        }
        if (eventId == 126 && eventStatus == 4 && eventName != null) {
            position.set("driverUniqueId", eventName);
        }
        if (BitUtil.check(mask, 21)) {
            position.set("vin", Integer.parseInt(values[index++]));
        }
        if (BitUtil.check(mask, 22)) {
            position.set("battery", Integer.parseInt(values[index++]));
        }
        if (BitUtil.check(mask, 23)) {
            position.set("operator", values[index++]);
        }
        if (BitUtil.check(mask, 24)) {
            ++index;
        }
        if (BitUtil.check(mask, 25)) {
            position.setDeviceTime(new Date(Long.parseLong(values[index++])));
        }
        if (BitUtil.check(mask, 26)) {
            position.setValid(Integer.parseInt(values[index++]) >= 1);
        }
        if (BitUtil.check(mask, 27)) {
            int io = Integer.parseInt(values[index++]);
            position.set("in1", BitUtil.check(io, 0));
            position.set("in2", BitUtil.check(io, 1));
            position.set("out1", BitUtil.check(io, 2));
            position.set("out2", BitUtil.check(io, 3));
        }
        if (BitUtil.check(mask, 28)) {
            position.set("driverUniqueId", values[index++]);
        }
        if (BitUtil.check(mask, 29)) {
            ++index;
        }
        if (BitUtil.check(mask, 30)) {
            position.set("message", values[index++]);
        }
        if (BitUtil.check(mask, 31)) {
            ++index;
        }
        if (BitUtil.check(mask, 32)) {
            ++index;
        }
        if (BitUtil.check(mask, 33)) {
            ++index;
        }
        if (BitUtil.check(mask, 34)) {
            ++index;
        }
    }

    private void decodeCan(Position position, String[] values) {
        long mask;
        int index = 0;
        if (BitUtil.check(mask = Long.parseLong(values[index++], 16), 0)) {
            position.set("obdOdometer", Double.parseDouble(values[index++]) * 1000.0);
        }
        if (BitUtil.check(mask, 1)) {
            position.set("hours", Double.parseDouble(values[index++]) * 3600000.0);
        }
        if (BitUtil.check(mask, 2)) {
            position.set("obdSpeed", Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(mask, 3)) {
            position.set("rpm", Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(mask, 4)) {
            position.set("canStatus", Integer.parseInt(values[index++]));
        }
        if (BitUtil.check(mask, 5)) {
            ++index;
        }
        if (BitUtil.check(mask, 6)) {
            position.set("throttle", Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(mask, 7)) {
            ++index;
        }
        if (BitUtil.check(mask, 8)) {
            position.set("fuel", Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(mask, 9)) {
            ++index;
        }
        if (BitUtil.check(mask, 10)) {
            position.set("autonomy", Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(mask, 11)) {
            ++index;
        }
        if (BitUtil.check(mask, 12)) {
            position.set("fuelConsumption", Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(mask, 13)) {
            position.set("fuelUsed", Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(mask, 14)) {
            position.set("oilTemperature", Double.parseDouble(values[index++]));
        }
    }
}

