/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples;

import java.io.ByteArrayInputStream;
import java.security.Key;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.samples.SampleUtils;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResolverUsageHTTP {
    public static void main(String[] stringArray) throws Exception {
        ResourceResolver.registerAtStart((String)"org.apache.xml.security.samples.utils.resolver.OfflineResolver");
        String string = "file:/Y:/signature.xml";
        String string2 = "#xpointer(id(&quot;id2&quot;))";
        String string3 = "<?xml version='1.0'?>\n<!DOCTYPE doc [\n<!ATTLIST e9 Id ID #IMPLIED>\n]>\n<doc>\n   <!-- A comment -->\n   <Signature xmlns='http://www.w3.org/2000/09/xmldsig#'>\n    <SignedInfo>\n      <CanonicalizationMethod Algorithm='http://www.w3.org/TR/2001/REC-xml-c14n-20010315' />\n      <SignatureMethod Algorithm='http://www.w3.org/2000/09/xmldsig#rsa-sha1' />\n      <Reference URI='http://www.w3.org/TR/xml-stylesheet'>\n         <DigestMethod Algorithm='http://www.w3.org/2000/09/xmldsig#sha1' />\n         <DigestValue>60NvZvtdTB+7UnlLp/H24p7h4bs=</DigestValue>\n      </Reference>\n      <Reference URI='#xpointer(id(&quot;id2&quot;))'>\n         <DigestMethod Algorithm='http://www.w3.org/2000/09/xmldsig#sha1' />\n         <DigestValue>RJeREVHXdM5ysghhvpIYGJJaNQI=</DigestValue>\n      </Reference>\n      <Reference URI='http://www.nue.et-inf.uni-siegen.de/index.html'>\n         <DigestMethod Algorithm='http://www.w3.org/2000/09/xmldsig#sha1' />\n         <DigestValue>Hpg+6h1k1jYY5yr3TRzDZzw23CQ=</DigestValue>\n      </Reference>\n      <Reference URI='http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/id2.xml'>\n         <Transforms>\n            <Transform Algorithm='http://www.w3.org/TR/1999/REC-xpath-19991116'>\n               <XPath>self::text()</XPath>\n            </Transform>\n         </Transforms>\n         <DigestMethod Algorithm='http://www.w3.org/2000/09/xmldsig#sha1' />\n         <DigestValue>RK9DKU4NnECPpNAb+QxMwTmSL+w=</DigestValue>\n      </Reference>\n    </SignedInfo>\n    <SignatureValue>\n       KTe1H5Hjp8hwahNFoUqHDuPJNNqhS1U3BBBH5/gByItNIwV18nMiLq4KunzFnOqD\n       xzTuO0/T+wsoYC1xOEuCDxyIujNCaJfLh+rCi5THulnc8KSHHEoPQ+7fA1VjmO31\n       2iw1iENOi7m//wzKlIHuxZCJ5nvolT21PV6nSE4DHlA=\n    </SignatureValue>\n   </Signature>\n   <e9 Id='N3'><!-- A comment -->Das N3 Element</e9>\n   <e9 Id='id2'><!-- A comment --> Das id2 Element</e9>\n</doc> \n";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(string3.getBytes()));
        Element element = SampleUtils.createDSctx(document, "ds", "http://www.w3.org/2000/09/xmldsig#");
        Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)"//ds:Signature[1]", (Node)element);
        XMLSignature xMLSignature = new XMLSignature(element2, string);
        boolean bl = xMLSignature.checkSignatureValue((Key)xMLSignature.getKeyInfo().getPublicKey());
        System.out.println("Signature " + (bl ? "Verification successful" : "Verification failed"));
        System.out.println("Canonicalized SignedInfo:");
        System.out.println(new String(xMLSignature.getSignedInfo().getCanonicalizedOctetStream()));
    }
}

