// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Accessible;
use crate::AccessibleRole;
use crate::Adjustment;
use crate::Align;
use crate::Buildable;
use crate::ConstraintTarget;
use crate::CornerType;
use crate::DirectionType;
use crate::LayoutManager;
use crate::Overflow;
use crate::PolicyType;
use crate::PositionType;
use crate::ScrollType;
use crate::Widget;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectExt;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkScrolledWindow")]
    pub struct ScrolledWindow(Object<ffi::GtkScrolledWindow>) @extends Widget, @implements Accessible, Buildable, ConstraintTarget;

    match fn {
        type_ => || ffi::gtk_scrolled_window_get_type(),
    }
}

impl ScrolledWindow {
    #[doc(alias = "gtk_scrolled_window_new")]
    pub fn new() -> ScrolledWindow {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_scrolled_window_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`ScrolledWindow`] objects.
    ///
    /// This method returns an instance of [`ScrolledWindowBuilder`](crate::builders::ScrolledWindowBuilder) which can be used to create [`ScrolledWindow`] objects.
    pub fn builder() -> ScrolledWindowBuilder {
        ScrolledWindowBuilder::default()
    }

    #[doc(alias = "gtk_scrolled_window_get_child")]
    #[doc(alias = "get_child")]
    pub fn child(&self) -> Option<Widget> {
        unsafe { from_glib_none(ffi::gtk_scrolled_window_get_child(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_scrolled_window_get_hadjustment")]
    #[doc(alias = "get_hadjustment")]
    pub fn hadjustment(&self) -> Adjustment {
        unsafe {
            from_glib_none(ffi::gtk_scrolled_window_get_hadjustment(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_scrolled_window_get_has_frame")]
    #[doc(alias = "get_has_frame")]
    pub fn has_frame(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_scrolled_window_get_has_frame(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_scrolled_window_get_hscrollbar")]
    #[doc(alias = "get_hscrollbar")]
    pub fn hscrollbar(&self) -> Widget {
        unsafe {
            from_glib_none(ffi::gtk_scrolled_window_get_hscrollbar(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_scrolled_window_get_kinetic_scrolling")]
    #[doc(alias = "get_kinetic_scrolling")]
    pub fn is_kinetic_scrolling(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_scrolled_window_get_kinetic_scrolling(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_scrolled_window_get_max_content_height")]
    #[doc(alias = "get_max_content_height")]
    pub fn max_content_height(&self) -> i32 {
        unsafe { ffi::gtk_scrolled_window_get_max_content_height(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_scrolled_window_get_max_content_width")]
    #[doc(alias = "get_max_content_width")]
    pub fn max_content_width(&self) -> i32 {
        unsafe { ffi::gtk_scrolled_window_get_max_content_width(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_scrolled_window_get_min_content_height")]
    #[doc(alias = "get_min_content_height")]
    pub fn min_content_height(&self) -> i32 {
        unsafe { ffi::gtk_scrolled_window_get_min_content_height(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_scrolled_window_get_min_content_width")]
    #[doc(alias = "get_min_content_width")]
    pub fn min_content_width(&self) -> i32 {
        unsafe { ffi::gtk_scrolled_window_get_min_content_width(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_scrolled_window_get_overlay_scrolling")]
    #[doc(alias = "get_overlay_scrolling")]
    pub fn is_overlay_scrolling(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_scrolled_window_get_overlay_scrolling(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_scrolled_window_get_placement")]
    #[doc(alias = "get_placement")]
    pub fn placement(&self) -> CornerType {
        unsafe {
            from_glib(ffi::gtk_scrolled_window_get_placement(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_scrolled_window_get_policy")]
    #[doc(alias = "get_policy")]
    pub fn policy(&self) -> (PolicyType, PolicyType) {
        unsafe {
            let mut hscrollbar_policy = mem::MaybeUninit::uninit();
            let mut vscrollbar_policy = mem::MaybeUninit::uninit();
            ffi::gtk_scrolled_window_get_policy(
                self.to_glib_none().0,
                hscrollbar_policy.as_mut_ptr(),
                vscrollbar_policy.as_mut_ptr(),
            );
            let hscrollbar_policy = hscrollbar_policy.assume_init();
            let vscrollbar_policy = vscrollbar_policy.assume_init();
            (from_glib(hscrollbar_policy), from_glib(vscrollbar_policy))
        }
    }

    #[doc(alias = "gtk_scrolled_window_get_propagate_natural_height")]
    #[doc(alias = "get_propagate_natural_height")]
    pub fn propagates_natural_height(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_scrolled_window_get_propagate_natural_height(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_scrolled_window_get_propagate_natural_width")]
    #[doc(alias = "get_propagate_natural_width")]
    pub fn propagates_natural_width(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_scrolled_window_get_propagate_natural_width(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_scrolled_window_get_vadjustment")]
    #[doc(alias = "get_vadjustment")]
    pub fn vadjustment(&self) -> Adjustment {
        unsafe {
            from_glib_none(ffi::gtk_scrolled_window_get_vadjustment(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_scrolled_window_get_vscrollbar")]
    #[doc(alias = "get_vscrollbar")]
    pub fn vscrollbar(&self) -> Widget {
        unsafe {
            from_glib_none(ffi::gtk_scrolled_window_get_vscrollbar(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_scrolled_window_set_child")]
    pub fn set_child(&self, child: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_scrolled_window_set_child(
                self.to_glib_none().0,
                child.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_scrolled_window_set_hadjustment")]
    pub fn set_hadjustment(&self, hadjustment: Option<&impl IsA<Adjustment>>) {
        unsafe {
            ffi::gtk_scrolled_window_set_hadjustment(
                self.to_glib_none().0,
                hadjustment.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_scrolled_window_set_has_frame")]
    pub fn set_has_frame(&self, has_frame: bool) {
        unsafe {
            ffi::gtk_scrolled_window_set_has_frame(self.to_glib_none().0, has_frame.into_glib());
        }
    }

    #[doc(alias = "gtk_scrolled_window_set_kinetic_scrolling")]
    pub fn set_kinetic_scrolling(&self, kinetic_scrolling: bool) {
        unsafe {
            ffi::gtk_scrolled_window_set_kinetic_scrolling(
                self.to_glib_none().0,
                kinetic_scrolling.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_scrolled_window_set_max_content_height")]
    pub fn set_max_content_height(&self, height: i32) {
        unsafe {
            ffi::gtk_scrolled_window_set_max_content_height(self.to_glib_none().0, height);
        }
    }

    #[doc(alias = "gtk_scrolled_window_set_max_content_width")]
    pub fn set_max_content_width(&self, width: i32) {
        unsafe {
            ffi::gtk_scrolled_window_set_max_content_width(self.to_glib_none().0, width);
        }
    }

    #[doc(alias = "gtk_scrolled_window_set_min_content_height")]
    pub fn set_min_content_height(&self, height: i32) {
        unsafe {
            ffi::gtk_scrolled_window_set_min_content_height(self.to_glib_none().0, height);
        }
    }

    #[doc(alias = "gtk_scrolled_window_set_min_content_width")]
    pub fn set_min_content_width(&self, width: i32) {
        unsafe {
            ffi::gtk_scrolled_window_set_min_content_width(self.to_glib_none().0, width);
        }
    }

    #[doc(alias = "gtk_scrolled_window_set_overlay_scrolling")]
    pub fn set_overlay_scrolling(&self, overlay_scrolling: bool) {
        unsafe {
            ffi::gtk_scrolled_window_set_overlay_scrolling(
                self.to_glib_none().0,
                overlay_scrolling.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_scrolled_window_set_placement")]
    pub fn set_placement(&self, window_placement: CornerType) {
        unsafe {
            ffi::gtk_scrolled_window_set_placement(
                self.to_glib_none().0,
                window_placement.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_scrolled_window_set_policy")]
    pub fn set_policy(&self, hscrollbar_policy: PolicyType, vscrollbar_policy: PolicyType) {
        unsafe {
            ffi::gtk_scrolled_window_set_policy(
                self.to_glib_none().0,
                hscrollbar_policy.into_glib(),
                vscrollbar_policy.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_scrolled_window_set_propagate_natural_height")]
    pub fn set_propagate_natural_height(&self, propagate: bool) {
        unsafe {
            ffi::gtk_scrolled_window_set_propagate_natural_height(
                self.to_glib_none().0,
                propagate.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_scrolled_window_set_propagate_natural_width")]
    pub fn set_propagate_natural_width(&self, propagate: bool) {
        unsafe {
            ffi::gtk_scrolled_window_set_propagate_natural_width(
                self.to_glib_none().0,
                propagate.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_scrolled_window_set_vadjustment")]
    pub fn set_vadjustment(&self, vadjustment: Option<&impl IsA<Adjustment>>) {
        unsafe {
            ffi::gtk_scrolled_window_set_vadjustment(
                self.to_glib_none().0,
                vadjustment.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_scrolled_window_unset_placement")]
    pub fn unset_placement(&self) {
        unsafe {
            ffi::gtk_scrolled_window_unset_placement(self.to_glib_none().0);
        }
    }

    #[doc(alias = "hscrollbar-policy")]
    pub fn hscrollbar_policy(&self) -> PolicyType {
        glib::ObjectExt::property(self, "hscrollbar-policy")
    }

    #[doc(alias = "hscrollbar-policy")]
    pub fn set_hscrollbar_policy(&self, hscrollbar_policy: PolicyType) {
        glib::ObjectExt::set_property(self, "hscrollbar-policy", &hscrollbar_policy)
    }

    #[doc(alias = "vscrollbar-policy")]
    pub fn vscrollbar_policy(&self) -> PolicyType {
        glib::ObjectExt::property(self, "vscrollbar-policy")
    }

    #[doc(alias = "vscrollbar-policy")]
    pub fn set_vscrollbar_policy(&self, vscrollbar_policy: PolicyType) {
        glib::ObjectExt::set_property(self, "vscrollbar-policy", &vscrollbar_policy)
    }

    #[doc(alias = "window-placement")]
    pub fn window_placement(&self) -> CornerType {
        glib::ObjectExt::property(self, "window-placement")
    }

    #[doc(alias = "window-placement")]
    pub fn set_window_placement(&self, window_placement: CornerType) {
        glib::ObjectExt::set_property(self, "window-placement", &window_placement)
    }

    #[doc(alias = "edge-overshot")]
    pub fn connect_edge_overshot<F: Fn(&Self, PositionType) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn edge_overshot_trampoline<
            F: Fn(&ScrolledWindow, PositionType) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            pos: ffi::GtkPositionType,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), from_glib(pos))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"edge-overshot\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    edge_overshot_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "edge-reached")]
    pub fn connect_edge_reached<F: Fn(&Self, PositionType) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn edge_reached_trampoline<
            F: Fn(&ScrolledWindow, PositionType) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            pos: ffi::GtkPositionType,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), from_glib(pos))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"edge-reached\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    edge_reached_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "move-focus-out")]
    pub fn connect_move_focus_out<F: Fn(&Self, DirectionType) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_focus_out_trampoline<
            F: Fn(&ScrolledWindow, DirectionType) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            direction_type: ffi::GtkDirectionType,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), from_glib(direction_type))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-focus-out\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_focus_out_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_move_focus_out(&self, direction_type: DirectionType) {
        self.emit_by_name::<()>("move-focus-out", &[&direction_type]);
    }

    #[doc(alias = "scroll-child")]
    pub fn connect_scroll_child<F: Fn(&Self, ScrollType, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn scroll_child_trampoline<
            F: Fn(&ScrolledWindow, ScrollType, bool) -> bool + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            scroll: ffi::GtkScrollType,
            horizontal: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                from_glib(scroll),
                from_glib(horizontal),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"scroll-child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    scroll_child_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_scroll_child(&self, scroll: ScrollType, horizontal: bool) -> bool {
        self.emit_by_name("scroll-child", &[&scroll, &horizontal])
    }

    #[doc(alias = "child")]
    pub fn connect_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_child_trampoline<F: Fn(&ScrolledWindow) + 'static>(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_child_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "hadjustment")]
    pub fn connect_hadjustment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hadjustment_trampoline<F: Fn(&ScrolledWindow) + 'static>(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hadjustment\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hadjustment_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "has-frame")]
    pub fn connect_has_frame_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_frame_trampoline<F: Fn(&ScrolledWindow) + 'static>(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-frame\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_has_frame_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "hscrollbar-policy")]
    pub fn connect_hscrollbar_policy_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_hscrollbar_policy_trampoline<
            F: Fn(&ScrolledWindow) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hscrollbar-policy\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hscrollbar_policy_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "kinetic-scrolling")]
    pub fn connect_kinetic_scrolling_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_kinetic_scrolling_trampoline<
            F: Fn(&ScrolledWindow) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::kinetic-scrolling\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_kinetic_scrolling_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "max-content-height")]
    pub fn connect_max_content_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_content_height_trampoline<
            F: Fn(&ScrolledWindow) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-content-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_max_content_height_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "max-content-width")]
    pub fn connect_max_content_width_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_content_width_trampoline<
            F: Fn(&ScrolledWindow) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-content-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_max_content_width_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "min-content-height")]
    pub fn connect_min_content_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_min_content_height_trampoline<
            F: Fn(&ScrolledWindow) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::min-content-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_min_content_height_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "min-content-width")]
    pub fn connect_min_content_width_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_min_content_width_trampoline<
            F: Fn(&ScrolledWindow) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::min-content-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_min_content_width_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "overlay-scrolling")]
    pub fn connect_overlay_scrolling_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_overlay_scrolling_trampoline<
            F: Fn(&ScrolledWindow) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::overlay-scrolling\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_overlay_scrolling_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "propagate-natural-height")]
    pub fn connect_propagate_natural_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_propagate_natural_height_trampoline<
            F: Fn(&ScrolledWindow) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::propagate-natural-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_propagate_natural_height_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "propagate-natural-width")]
    pub fn connect_propagate_natural_width_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_propagate_natural_width_trampoline<
            F: Fn(&ScrolledWindow) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::propagate-natural-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_propagate_natural_width_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vadjustment")]
    pub fn connect_vadjustment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_vadjustment_trampoline<F: Fn(&ScrolledWindow) + 'static>(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::vadjustment\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_vadjustment_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vscrollbar-policy")]
    pub fn connect_vscrollbar_policy_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_vscrollbar_policy_trampoline<
            F: Fn(&ScrolledWindow) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::vscrollbar-policy\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_vscrollbar_policy_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "window-placement")]
    pub fn connect_window_placement_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_window_placement_trampoline<
            F: Fn(&ScrolledWindow) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::window-placement\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_window_placement_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for ScrolledWindow {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`ScrolledWindow`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct ScrolledWindowBuilder {
    child: Option<Widget>,
    hadjustment: Option<Adjustment>,
    has_frame: Option<bool>,
    hscrollbar_policy: Option<PolicyType>,
    kinetic_scrolling: Option<bool>,
    max_content_height: Option<i32>,
    max_content_width: Option<i32>,
    min_content_height: Option<i32>,
    min_content_width: Option<i32>,
    overlay_scrolling: Option<bool>,
    propagate_natural_height: Option<bool>,
    propagate_natural_width: Option<bool>,
    vadjustment: Option<Adjustment>,
    vscrollbar_policy: Option<PolicyType>,
    window_placement: Option<CornerType>,
    can_focus: Option<bool>,
    can_target: Option<bool>,
    css_classes: Option<Vec<String>>,
    css_name: Option<String>,
    cursor: Option<gdk::Cursor>,
    focus_on_click: Option<bool>,
    focusable: Option<bool>,
    halign: Option<Align>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    layout_manager: Option<LayoutManager>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    opacity: Option<f64>,
    overflow: Option<Overflow>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    accessible_role: Option<AccessibleRole>,
}

impl ScrolledWindowBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`ScrolledWindowBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`ScrolledWindow`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> ScrolledWindow {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref child) = self.child {
            properties.push(("child", child));
        }
        if let Some(ref hadjustment) = self.hadjustment {
            properties.push(("hadjustment", hadjustment));
        }
        if let Some(ref has_frame) = self.has_frame {
            properties.push(("has-frame", has_frame));
        }
        if let Some(ref hscrollbar_policy) = self.hscrollbar_policy {
            properties.push(("hscrollbar-policy", hscrollbar_policy));
        }
        if let Some(ref kinetic_scrolling) = self.kinetic_scrolling {
            properties.push(("kinetic-scrolling", kinetic_scrolling));
        }
        if let Some(ref max_content_height) = self.max_content_height {
            properties.push(("max-content-height", max_content_height));
        }
        if let Some(ref max_content_width) = self.max_content_width {
            properties.push(("max-content-width", max_content_width));
        }
        if let Some(ref min_content_height) = self.min_content_height {
            properties.push(("min-content-height", min_content_height));
        }
        if let Some(ref min_content_width) = self.min_content_width {
            properties.push(("min-content-width", min_content_width));
        }
        if let Some(ref overlay_scrolling) = self.overlay_scrolling {
            properties.push(("overlay-scrolling", overlay_scrolling));
        }
        if let Some(ref propagate_natural_height) = self.propagate_natural_height {
            properties.push(("propagate-natural-height", propagate_natural_height));
        }
        if let Some(ref propagate_natural_width) = self.propagate_natural_width {
            properties.push(("propagate-natural-width", propagate_natural_width));
        }
        if let Some(ref vadjustment) = self.vadjustment {
            properties.push(("vadjustment", vadjustment));
        }
        if let Some(ref vscrollbar_policy) = self.vscrollbar_policy {
            properties.push(("vscrollbar-policy", vscrollbar_policy));
        }
        if let Some(ref window_placement) = self.window_placement {
            properties.push(("window-placement", window_placement));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref can_target) = self.can_target {
            properties.push(("can-target", can_target));
        }
        if let Some(ref css_classes) = self.css_classes {
            properties.push(("css-classes", css_classes));
        }
        if let Some(ref css_name) = self.css_name {
            properties.push(("css-name", css_name));
        }
        if let Some(ref cursor) = self.cursor {
            properties.push(("cursor", cursor));
        }
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref focusable) = self.focusable {
            properties.push(("focusable", focusable));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref layout_manager) = self.layout_manager {
            properties.push(("layout-manager", layout_manager));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref overflow) = self.overflow {
            properties.push(("overflow", overflow));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        if let Some(ref accessible_role) = self.accessible_role {
            properties.push(("accessible-role", accessible_role));
        }
        glib::Object::new::<ScrolledWindow>(&properties)
            .expect("Failed to create an instance of ScrolledWindow")
    }

    pub fn child(mut self, child: &impl IsA<Widget>) -> Self {
        self.child = Some(child.clone().upcast());
        self
    }

    pub fn hadjustment(mut self, hadjustment: &impl IsA<Adjustment>) -> Self {
        self.hadjustment = Some(hadjustment.clone().upcast());
        self
    }

    pub fn has_frame(mut self, has_frame: bool) -> Self {
        self.has_frame = Some(has_frame);
        self
    }

    pub fn hscrollbar_policy(mut self, hscrollbar_policy: PolicyType) -> Self {
        self.hscrollbar_policy = Some(hscrollbar_policy);
        self
    }

    pub fn kinetic_scrolling(mut self, kinetic_scrolling: bool) -> Self {
        self.kinetic_scrolling = Some(kinetic_scrolling);
        self
    }

    pub fn max_content_height(mut self, max_content_height: i32) -> Self {
        self.max_content_height = Some(max_content_height);
        self
    }

    pub fn max_content_width(mut self, max_content_width: i32) -> Self {
        self.max_content_width = Some(max_content_width);
        self
    }

    pub fn min_content_height(mut self, min_content_height: i32) -> Self {
        self.min_content_height = Some(min_content_height);
        self
    }

    pub fn min_content_width(mut self, min_content_width: i32) -> Self {
        self.min_content_width = Some(min_content_width);
        self
    }

    pub fn overlay_scrolling(mut self, overlay_scrolling: bool) -> Self {
        self.overlay_scrolling = Some(overlay_scrolling);
        self
    }

    pub fn propagate_natural_height(mut self, propagate_natural_height: bool) -> Self {
        self.propagate_natural_height = Some(propagate_natural_height);
        self
    }

    pub fn propagate_natural_width(mut self, propagate_natural_width: bool) -> Self {
        self.propagate_natural_width = Some(propagate_natural_width);
        self
    }

    pub fn vadjustment(mut self, vadjustment: &impl IsA<Adjustment>) -> Self {
        self.vadjustment = Some(vadjustment.clone().upcast());
        self
    }

    pub fn vscrollbar_policy(mut self, vscrollbar_policy: PolicyType) -> Self {
        self.vscrollbar_policy = Some(vscrollbar_policy);
        self
    }

    pub fn window_placement(mut self, window_placement: CornerType) -> Self {
        self.window_placement = Some(window_placement);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn can_target(mut self, can_target: bool) -> Self {
        self.can_target = Some(can_target);
        self
    }

    pub fn css_classes(mut self, css_classes: Vec<String>) -> Self {
        self.css_classes = Some(css_classes);
        self
    }

    pub fn css_name(mut self, css_name: &str) -> Self {
        self.css_name = Some(css_name.to_string());
        self
    }

    pub fn cursor(mut self, cursor: &gdk::Cursor) -> Self {
        self.cursor = Some(cursor.clone());
        self
    }

    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn focusable(mut self, focusable: bool) -> Self {
        self.focusable = Some(focusable);
        self
    }

    pub fn halign(mut self, halign: Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn layout_manager(mut self, layout_manager: &impl IsA<LayoutManager>) -> Self {
        self.layout_manager = Some(layout_manager.clone().upcast());
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn overflow(mut self, overflow: Overflow) -> Self {
        self.overflow = Some(overflow);
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }

    pub fn accessible_role(mut self, accessible_role: AccessibleRole) -> Self {
        self.accessible_role = Some(accessible_role);
        self
    }
}

impl fmt::Display for ScrolledWindow {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("ScrolledWindow")
    }
}
