/* == Start of generated table == */
/*
 * The following tables are generated by running:
 *
 *   ./gen-break-table.py SentenceBreakProperty.txt IndicSyllabicCategory.txt EastAsianWidth.txt DerivedCoreProperties.txt | indent
 *
 * on files with these headers:
 *
 * # SentenceBreakProperty-15.1.0.txt
 * # Date: 2023-07-28, 23:34:37 GMT
 * # © 2023 Unicode®, Inc.
 * # Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
 * # For terms of use, see https://www.unicode.org/terms_of_use.html
 * #
 * # Unicode Character Database
 * #   For documentation, see https://www.unicode.org/reports/tr44/
 * # IndicSyllabicCategory-15.1.0.txt
 * # Date: 2023-01-05
 * # © 2023 Unicode®, Inc.
 * # Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
 * # For terms of use, see https://www.unicode.org/terms_of_use.html
 * #
 * # For documentation, see UAX #44: Unicode Character Database,
 * # at https://www.unicode.org/reports/tr44/
 * #
 * # This file defines the following property:
 * #
 * #    Indic_Syllabic_Category     enumerated property
 * #
 * # Scope: This property is aimed at two general problem
 * # areas involving the analysis and processing of Indic scripts:
 * #
 * #   1. Specification of syllabic structure.
 * #   2. Specification of segmentation rules.
 * #
 * # Both of these problem areas may benefit from having defined subtypes
 * # of Indic script characters which are relevant to how Indic
 * # syllables (or aksaras) are constructed. Note that rules for
 * # syllabic structure in Indic scripts may differ significantly
 * # from how phonological syllables are defined.
 * #
 * # Format:
 * #    Field 0  Unicode code point value or range of code point values
 * #    Field 1  Indic_Syllabic_Category property value
 * #
 * # Field 1 is followed by a comment field, starting with the number sign '#',
 * # which shows the General_Category property value, the Unicode character name
 * # or names, and, in lines with ranges of code points, the code point count in
 * # square brackets.
 * #
 * # The scripts assessed as Indic in the structural sense used for the
 * # Indic_Syllabic_Category are the following:
 * #
 * # Ahom, Balinese, Batak, Bengali, Bhaiksuki, Brahmi, Buginese, Buhid,
 * # Chakma, Cham, Devanagari, Dives Akuru, Dogra, Grantha, Gujarati,
 * # Gunjala Gondi, Gurmukhi, Hanunoo, Javanese, Kaithi, Kannada, Kawi,
 * # Kayah Li, Kharoshthi, Khmer, Khojki, Khudawadi, Lao, Lepcha, Limbu,
 * # Mahajani, Makasar, Malayalam, Marchen, Masaram Gondi, Meetei Mayek,
 * # Modi, Multani, Myanmar, Nandinagari, Newa, New Tai Lue, Oriya,
 * # Phags-pa, Rejang, Saurashtra, Sharada, Siddham, Sinhala, Soyombo,
 * # Sundanese, Syloti Nagri, Tagalog, Tagbanwa, Tai Le, Tai Tham,
 * # Tai Viet, Takri, Tamil, Telugu, Thai, Tibetan, Tirhuta, and
 * # Zanabazar Square.
 * #
 * # All characters for all other scripts not in that list
 * # take the default value for this property, unless they
 * # are individually listed in this data file.
 * #
 * # EastAsianWidth-15.1.0.txt
 * # Date: 2023-07-28, 23:34:08 GMT
 * # © 2023 Unicode®, Inc.
 * # Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
 * # For terms of use, see https://www.unicode.org/terms_of_use.html
 * #
 * # Unicode Character Database
 * #   For documentation, see https://www.unicode.org/reports/tr44/
 * #
 * # East_Asian_Width Property
 * #
 * # This file is a normative contributory data file in the
 * # Unicode Character Database.
 * #
 * # The format is two fields separated by a semicolon.
 * # Field 0: Unicode code point value or range of code point values
 * # Field 1: East_Asian_Width property, consisting of one of the following values:
 * #         "A", "F", "H", "N", "Na", "W"
 * #  - All code points, assigned or unassigned, that are not listed
 * #      explicitly are given the value "N".
 * #  - The unassigned code points in the following blocks default to "W":
 * #         CJK Unified Ideographs Extension A: U+3400..U+4DBF
 * #         CJK Unified Ideographs:             U+4E00..U+9FFF
 * #         CJK Compatibility Ideographs:       U+F900..U+FAFF
 * #  - All undesignated code points in Planes 2 and 3, whether inside or
 * #      outside of allocated blocks, default to "W":
 * #         Plane 2:                            U+20000..U+2FFFD
 * #         Plane 3:                            U+30000..U+3FFFD
 * #
 * # Character ranges are specified as for other property files in the
 * # Unicode Character Database.
 * #
 * # The comments following the number sign "#" list the General_Category
 * # property value or the L& alias of the derived value LC, the Unicode
 * # character name or names, and, in lines with ranges of code points,
 * # the code point count in square brackets.
 * #
 * # For more information, see UAX #11: East Asian Width,
 * # at https://www.unicode.org/reports/tr11/
 * #
 * # @missing: 0000..10FFFF; N
 * # DerivedCoreProperties-15.1.0.txt
 * # Date: 2023-08-07, 15:21:24 GMT
 * # © 2023 Unicode®, Inc.
 * # Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
 * # For terms of use, see https://www.unicode.org/terms_of_use.html
 * #
 * # Unicode Character Database
 * #   For documentation, see https://www.unicode.org/reports/tr44/
 */

#ifndef PANGO_BREAK_TABLE_H
#define PANGO_BREAK_TABLE_H

#include <glib.h>


static inline gboolean
_pango_is_STerm (gunichar wc)
{
  if ((wc >= 0x0021 && wc <= 0x1809))
    {
      if (wc == 0x0021 ||
	  wc == 0x003F || wc == 0x0589 || (wc >= 0x061D && wc <= 0x061F))
	return TRUE;
      if ((wc >= 0x06D4 && wc <= 0x0839))
	{
	  if (wc == 0x06D4)
	    return TRUE;
	  if ((wc >= 0x0700 && wc <= 0x0702))
	    return TRUE;
	  if (wc == 0x07F9)
	    return TRUE;
	  if (wc == 0x0837 || wc == 0x0839)
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x083D && wc <= 0x083E) ||
	  (wc >= 0x0964 && wc <= 0x0965) ||
	  (wc >= 0x104A && wc <= 0x104B) || wc == 0x1362)
	return TRUE;
      if ((wc >= 0x1367 && wc <= 0x1809))
	{
	  if ((wc >= 0x1367 && wc <= 0x1368))
	    return TRUE;
	  if (wc == 0x166E || (wc >= 0x1735 && wc <= 0x1736))
	    return TRUE;
	  if ((wc >= 0x17D4 && wc <= 0x17D5))
	    return TRUE;
	  if (wc == 0x1803 || wc == 0x1809)
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0x1944 && wc <= 0xA92F))
    {
      if ((wc >= 0x1944 && wc <= 0x1B7E))
	{
	  if ((wc >= 0x1944 && wc <= 0x1945))
	    return TRUE;
	  if ((wc >= 0x1AA8 && wc <= 0x1AAB))
	    return TRUE;
	  if ((wc >= 0x1B5A && wc <= 0x1B5B))
	    return TRUE;
	  if ((wc >= 0x1B5E && wc <= 0x1B5F) ||
	      (wc >= 0x1B7D && wc <= 0x1B7E))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x1C3B && wc <= 0x2E2E))
	{
	  if ((wc >= 0x1C3B && wc <= 0x1C3C))
	    return TRUE;
	  if ((wc >= 0x1C7E && wc <= 0x1C7F))
	    return TRUE;
	  if ((wc >= 0x203C && wc <= 0x203D))
	    return TRUE;
	  if ((wc >= 0x2047 && wc <= 0x2049) || wc == 0x2E2E)
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x2E3C && wc <= 0xA60F))
	{
	  if (wc == 0x2E3C)
	    return TRUE;
	  if ((wc >= 0x2E53 && wc <= 0x2E54))
	    return TRUE;
	  if (wc == 0x3002)
	    return TRUE;
	  if (wc == 0xA4FF || (wc >= 0xA60E && wc <= 0xA60F))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0xA6F3 && wc <= 0xA92F))
	{
	  if (wc == 0xA6F3)
	    return TRUE;
	  if (wc == 0xA6F7)
	    return TRUE;
	  if ((wc >= 0xA876 && wc <= 0xA877))
	    return TRUE;
	  if ((wc >= 0xA8CE && wc <= 0xA8CF) || wc == 0xA92F)
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0xA9C8 && wc <= 0x1123C))
    {
      if ((wc >= 0xA9C8 && wc <= 0xA9C9) ||
	  (wc >= 0xAA5D && wc <= 0xAA5F) ||
	  (wc >= 0xAAF0 && wc <= 0xAAF1) || wc == 0xABEB)
	return TRUE;
      if ((wc >= 0xFE56 && wc <= 0x10A57))
	{
	  if ((wc >= 0xFE56 && wc <= 0xFE57))
	    return TRUE;
	  if (wc == 0xFF01)
	    return TRUE;
	  if (wc == 0xFF1F)
	    return TRUE;
	  if (wc == 0xFF61 || (wc >= 0x10A56 && wc <= 0x10A57))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x10F55 && wc <= 0x10F59) ||
	  (wc >= 0x10F86 && wc <= 0x10F89) ||
	  (wc >= 0x11047 && wc <= 0x11048) ||
	  (wc >= 0x110BE && wc <= 0x110C1))
	return TRUE;
      if ((wc >= 0x11141 && wc <= 0x1123C))
	{
	  if ((wc >= 0x11141 && wc <= 0x11143))
	    return TRUE;
	  if ((wc >= 0x111C5 && wc <= 0x111C6) || wc == 0x111CD)
	    return TRUE;
	  if ((wc >= 0x111DE && wc <= 0x111DF))
	    return TRUE;
	  if ((wc >= 0x11238 && wc <= 0x11239) ||
	      (wc >= 0x1123B && wc <= 0x1123C))
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0x112A9 && wc <= 0x1DA88))
    {
      if ((wc >= 0x112A9 && wc <= 0x11642))
	{
	  if (wc == 0x112A9)
	    return TRUE;
	  if ((wc >= 0x1144B && wc <= 0x1144C))
	    return TRUE;
	  if ((wc >= 0x115C2 && wc <= 0x115C3))
	    return TRUE;
	  if ((wc >= 0x115C9 && wc <= 0x115D7) ||
	      (wc >= 0x11641 && wc <= 0x11642))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x1173C && wc <= 0x11A9C))
	{
	  if ((wc >= 0x1173C && wc <= 0x1173E))
	    return TRUE;
	  if (wc == 0x11944)
	    return TRUE;
	  if (wc == 0x11946)
	    return TRUE;
	  if ((wc >= 0x11A42 && wc <= 0x11A43) ||
	      (wc >= 0x11A9B && wc <= 0x11A9C))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x11C41 && wc <= 0x16AF5))
	{
	  if ((wc >= 0x11C41 && wc <= 0x11C42))
	    return TRUE;
	  if ((wc >= 0x11EF7 && wc <= 0x11EF8))
	    return TRUE;
	  if ((wc >= 0x11F43 && wc <= 0x11F44))
	    return TRUE;
	  if ((wc >= 0x16A6E && wc <= 0x16A6F) || wc == 0x16AF5)
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x16B37 && wc <= 0x1DA88))
	{
	  if ((wc >= 0x16B37 && wc <= 0x16B38))
	    return TRUE;
	  if (wc == 0x16B44)
	    return TRUE;
	  if (wc == 0x16E98)
	    return TRUE;
	  if (wc == 0x1BC9F || wc == 0x1DA88)
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  return FALSE;
}

static inline gboolean
_pango_is_Virama (gunichar wc)
{
  if ((wc >= 0x094D && wc <= 0x0BCD))
    {
      if (wc == 0x094D)
	return TRUE;
      if (wc == 0x09CD || wc == 0x0A4D)
	return TRUE;
      if (wc == 0x0ACD)
	return TRUE;
      if (wc == 0x0B4D || wc == 0x0BCD)
	return TRUE;
      return FALSE;
    }
  if ((wc >= 0x0C4D && wc <= 0xA8C4))
    {
      if (wc == 0x0C4D)
	return TRUE;
      if (wc == 0x0CCD || wc == 0x0D4D)
	return TRUE;
      if (wc == 0x0DCA)
	return TRUE;
      if (wc == 0x1B44 || wc == 0xA806 || wc == 0xA8C4)
	return TRUE;
      return FALSE;
    }
  if ((wc >= 0xA9C0 && wc <= 0x1134D))
    {
      if (wc == 0xA9C0)
	return TRUE;
      if (wc == 0x11046 || wc == 0x110B9)
	return TRUE;
      if (wc == 0x111C0)
	return TRUE;
      if (wc == 0x11235 || wc == 0x1134D)
	return TRUE;
      return FALSE;
    }
  if ((wc >= 0x11442 && wc <= 0x11C3F))
    {
      if (wc == 0x11442 || wc == 0x114C2)
	return TRUE;
      if (wc == 0x115BF || wc == 0x1163F)
	return TRUE;
      if (wc == 0x116B6 || wc == 0x11839)
	return TRUE;
      if (wc == 0x119E0 || wc == 0x11C3F)
	return TRUE;
      return FALSE;
    }
  return FALSE;
}

static inline gboolean
_pango_is_Vowel_Dependent (gunichar wc)
{
  if ((wc >= 0x093A && wc <= 0x0CCC))
    {
      if ((wc >= 0x093A && wc <= 0x09CC))
	{
	  if ((wc >= 0x093A && wc <= 0x093B) ||
	      (wc >= 0x093E && wc <= 0x094C))
	    return TRUE;
	  if ((wc >= 0x094E && wc <= 0x094F) ||
	      (wc >= 0x0955 && wc <= 0x0957))
	    return TRUE;
	  if ((wc >= 0x0962 && wc <= 0x0963) ||
	      (wc >= 0x09BE && wc <= 0x09C4))
	    return TRUE;
	  if ((wc >= 0x09C7 && wc <= 0x09C8) ||
	      (wc >= 0x09CB && wc <= 0x09CC))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x09D7 && wc <= 0x0AE3))
	{
	  if (wc == 0x09D7 || (wc >= 0x09E2 && wc <= 0x09E3))
	    return TRUE;
	  if ((wc >= 0x0A3E && wc <= 0x0A42) ||
	      (wc >= 0x0A47 && wc <= 0x0A48))
	    return TRUE;
	  if ((wc >= 0x0A4B && wc <= 0x0A4C) ||
	      (wc >= 0x0ABE && wc <= 0x0AC5))
	    return TRUE;
	  if ((wc >= 0x0AC7 && wc <= 0x0AC9) ||
	      (wc >= 0x0ACB && wc <= 0x0ACC) ||
	      (wc >= 0x0AE2 && wc <= 0x0AE3))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x0B3E && wc <= 0x0BCC))
	{
	  if ((wc >= 0x0B3E && wc <= 0x0B44) ||
	      (wc >= 0x0B47 && wc <= 0x0B48))
	    return TRUE;
	  if ((wc >= 0x0B4B && wc <= 0x0B4C) ||
	      (wc >= 0x0B55 && wc <= 0x0B57))
	    return TRUE;
	  if ((wc >= 0x0B62 && wc <= 0x0B63) ||
	      (wc >= 0x0BBE && wc <= 0x0BC2))
	    return TRUE;
	  if ((wc >= 0x0BC6 && wc <= 0x0BC8) ||
	      (wc >= 0x0BCA && wc <= 0x0BCC))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x0BD7 && wc <= 0x0CCC))
	{
	  if (wc == 0x0BD7 || (wc >= 0x0C3E && wc <= 0x0C44))
	    return TRUE;
	  if ((wc >= 0x0C46 && wc <= 0x0C48) ||
	      (wc >= 0x0C4A && wc <= 0x0C4C))
	    return TRUE;
	  if ((wc >= 0x0C55 && wc <= 0x0C56) ||
	      (wc >= 0x0C62 && wc <= 0x0C63))
	    return TRUE;
	  if ((wc >= 0x0CBE && wc <= 0x0CC4) ||
	      (wc >= 0x0CC6 && wc <= 0x0CC8) ||
	      (wc >= 0x0CCA && wc <= 0x0CCC))
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0x0CD5 && wc <= 0x193A))
    {
      if ((wc >= 0x0CD5 && wc <= 0x0DD4))
	{
	  if ((wc >= 0x0CD5 && wc <= 0x0CD6) ||
	      (wc >= 0x0CE2 && wc <= 0x0CE3))
	    return TRUE;
	  if ((wc >= 0x0D3E && wc <= 0x0D44) ||
	      (wc >= 0x0D46 && wc <= 0x0D48))
	    return TRUE;
	  if ((wc >= 0x0D4A && wc <= 0x0D4C) || wc == 0x0D57)
	    return TRUE;
	  if ((wc >= 0x0D62 && wc <= 0x0D63) ||
	      (wc >= 0x0DCF && wc <= 0x0DD4))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x0DD6 && wc <= 0x0EC4))
	{
	  if (wc == 0x0DD6 || (wc >= 0x0DD8 && wc <= 0x0DDF))
	    return TRUE;
	  if ((wc >= 0x0DF2 && wc <= 0x0DF3) ||
	      (wc >= 0x0E30 && wc <= 0x0E39))
	    return TRUE;
	  if ((wc >= 0x0E40 && wc <= 0x0E45) || wc == 0x0E47)
	    return TRUE;
	  if ((wc >= 0x0EB0 && wc <= 0x0EB9) ||
	      wc == 0x0EBB || (wc >= 0x0EC0 && wc <= 0x0EC4))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x0F71 && wc <= 0x1086))
	{
	  if ((wc >= 0x0F71 && wc <= 0x0F7D) ||
	      (wc >= 0x0F80 && wc <= 0x0F81))
	    return TRUE;
	  if ((wc >= 0x102B && wc <= 0x1035) ||
	      (wc >= 0x1056 && wc <= 0x1059))
	    return TRUE;
	  if (wc == 0x1062 || (wc >= 0x1067 && wc <= 0x1068))
	    return TRUE;
	  if ((wc >= 0x1071 && wc <= 0x1074) ||
	      (wc >= 0x1083 && wc <= 0x1086))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x109C && wc <= 0x193A))
	{
	  if ((wc >= 0x109C && wc <= 0x109D) ||
	      (wc >= 0x1712 && wc <= 0x1713))
	    return TRUE;
	  if ((wc >= 0x1732 && wc <= 0x1733) ||
	      (wc >= 0x1752 && wc <= 0x1753))
	    return TRUE;
	  if ((wc >= 0x1772 && wc <= 0x1773) ||
	      (wc >= 0x17B6 && wc <= 0x17C5))
	    return TRUE;
	  if (wc == 0x17C8 || (wc >= 0x1920 && wc <= 0x1928) || wc == 0x193A)
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0x19B0 && wc <= 0x11344))
    {
      if ((wc >= 0x19B0 && wc <= 0xA802))
	{
	  if ((wc >= 0x19B0 && wc <= 0x19C0) ||
	      (wc >= 0x1A17 && wc <= 0x1A1B))
	    return TRUE;
	  if ((wc >= 0x1A61 && wc <= 0x1A73) ||
	      (wc >= 0x1B35 && wc <= 0x1B43))
	    return TRUE;
	  if ((wc >= 0x1BA4 && wc <= 0x1BA9) ||
	      (wc >= 0x1BE7 && wc <= 0x1BEF))
	    return TRUE;
	  if ((wc >= 0x1C26 && wc <= 0x1C2C) || wc == 0xA802)
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0xA823 && wc <= 0xAAEF))
	{
	  if ((wc >= 0xA823 && wc <= 0xA827) ||
	      (wc >= 0xA8B5 && wc <= 0xA8C3))
	    return TRUE;
	  if (wc == 0xA8FF || (wc >= 0xA947 && wc <= 0xA94E))
	    return TRUE;
	  if ((wc >= 0xA9B4 && wc <= 0xA9BC) || wc == 0xA9E5)
	    return TRUE;
	  if ((wc >= 0xAA29 && wc <= 0xAA32) ||
	      (wc >= 0xAAB0 && wc <= 0xAABE) ||
	      (wc >= 0xAAEB && wc <= 0xAAEF))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0xABE3 && wc <= 0x110C2))
	{
	  if ((wc >= 0xABE3 && wc <= 0xABEA) ||
	      (wc >= 0x10A01 && wc <= 0x10A03))
	    return TRUE;
	  if ((wc >= 0x10A05 && wc <= 0x10A06) ||
	      (wc >= 0x10A0C && wc <= 0x10A0D))
	    return TRUE;
	  if ((wc >= 0x11038 && wc <= 0x11045) ||
	      (wc >= 0x11073 && wc <= 0x11074))
	    return TRUE;
	  if ((wc >= 0x110B0 && wc <= 0x110B8) || wc == 0x110C2)
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x11127 && wc <= 0x11344))
	{
	  if ((wc >= 0x11127 && wc <= 0x11132) ||
	      (wc >= 0x11145 && wc <= 0x11146))
	    return TRUE;
	  if ((wc >= 0x111B3 && wc <= 0x111BF) ||
	      (wc >= 0x111CB && wc <= 0x111CC))
	    return TRUE;
	  if (wc == 0x111CE || (wc >= 0x1122C && wc <= 0x11233))
	    return TRUE;
	  if (wc == 0x11241 ||
	      (wc >= 0x112E0 && wc <= 0x112E8) ||
	      (wc >= 0x1133E && wc <= 0x11344))
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0x11347 && wc <= 0x11F40))
    {
      if ((wc >= 0x11347 && wc <= 0x115BB))
	{
	  if ((wc >= 0x11347 && wc <= 0x11348) ||
	      (wc >= 0x1134B && wc <= 0x1134C))
	    return TRUE;
	  if (wc == 0x11357 || (wc >= 0x11362 && wc <= 0x11363))
	    return TRUE;
	  if ((wc >= 0x11435 && wc <= 0x11441) ||
	      (wc >= 0x114B0 && wc <= 0x114BE))
	    return TRUE;
	  if ((wc >= 0x115AF && wc <= 0x115B5) ||
	      (wc >= 0x115B8 && wc <= 0x115BB))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x115DC && wc <= 0x119D7))
	{
	  if ((wc >= 0x115DC && wc <= 0x115DD) ||
	      (wc >= 0x11630 && wc <= 0x1163C))
	    return TRUE;
	  if (wc == 0x11640 || (wc >= 0x116AD && wc <= 0x116B5))
	    return TRUE;
	  if ((wc >= 0x11720 && wc <= 0x1172A) ||
	      (wc >= 0x1182C && wc <= 0x11836))
	    return TRUE;
	  if ((wc >= 0x11930 && wc <= 0x11935) ||
	      (wc >= 0x11937 && wc <= 0x11938) ||
	      (wc >= 0x119D1 && wc <= 0x119D7))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x119DA && wc <= 0x11D36))
	{
	  if ((wc >= 0x119DA && wc <= 0x119DD) || wc == 0x119E4)
	    return TRUE;
	  if ((wc >= 0x11A01 && wc <= 0x11A0A) ||
	      (wc >= 0x11A51 && wc <= 0x11A5B))
	    return TRUE;
	  if ((wc >= 0x11C2F && wc <= 0x11C36) ||
	      (wc >= 0x11C38 && wc <= 0x11C3B))
	    return TRUE;
	  if ((wc >= 0x11CB0 && wc <= 0x11CB4) ||
	      (wc >= 0x11D31 && wc <= 0x11D36))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x11D3A && wc <= 0x11F40))
	{
	  if (wc == 0x11D3A || (wc >= 0x11D3C && wc <= 0x11D3D))
	    return TRUE;
	  if (wc == 0x11D3F ||
	      wc == 0x11D43 || (wc >= 0x11D8A && wc <= 0x11D8E))
	    return TRUE;
	  if ((wc >= 0x11D90 && wc <= 0x11D91) ||
	      (wc >= 0x11D93 && wc <= 0x11D94))
	    return TRUE;
	  if ((wc >= 0x11EF3 && wc <= 0x11EF6) ||
	      (wc >= 0x11F34 && wc <= 0x11F3A) ||
	      (wc >= 0x11F3E && wc <= 0x11F40))
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  return FALSE;
}

static inline gboolean
_pango_is_Consonant_Prefixed (gunichar wc)
{
  if ((wc >= 0x111C2 && wc <= 0x111C3) ||
      wc == 0x1193F || wc == 0x11A3A || (wc >= 0x11A84 && wc <= 0x11A89))
    return TRUE;
  return FALSE;
}

static inline gboolean
_pango_is_Consonant_Preceding_Repha (gunichar wc)
{
  if (wc == 0x0D4E || wc == 0x11941 || wc == 0x11D46 || wc == 0x11F02)
    return TRUE;
  return FALSE;
}

static inline gboolean
_pango_is_Indic_Conjunct_Break_Linker (gunichar wc)
{
  if (wc == 0x094D)
    return TRUE;
  if (wc == 0x09CD || wc == 0x0ACD)
    return TRUE;
  if (wc == 0x0B4D)
    return TRUE;
  if (wc == 0x0C4D || wc == 0x0D4D)
    return TRUE;
  return FALSE;
}

static inline gboolean
_pango_is_Indic_Conjunct_Break_Consonant (gunichar wc)
{
  if ((wc >= 0x0915 && wc <= 0x09B2))
    {
      if ((wc >= 0x0915 && wc <= 0x0939))
	return TRUE;
      if ((wc >= 0x0958 && wc <= 0x095F) || (wc >= 0x0978 && wc <= 0x097F))
	return TRUE;
      if ((wc >= 0x0995 && wc <= 0x09A8))
	return TRUE;
      if ((wc >= 0x09AA && wc <= 0x09B0) || wc == 0x09B2)
	return TRUE;
      return FALSE;
    }
  if ((wc >= 0x09B6 && wc <= 0x0AB3))
    {
      if ((wc >= 0x09B6 && wc <= 0x09B9))
	return TRUE;
      if ((wc >= 0x09DC && wc <= 0x09DD) || wc == 0x09DF)
	return TRUE;
      if ((wc >= 0x09F0 && wc <= 0x09F1))
	return TRUE;
      if ((wc >= 0x0A95 && wc <= 0x0AA8) ||
	  (wc >= 0x0AAA && wc <= 0x0AB0) || (wc >= 0x0AB2 && wc <= 0x0AB3))
	return TRUE;
      return FALSE;
    }
  if ((wc >= 0x0AB5 && wc <= 0x0B39))
    {
      if ((wc >= 0x0AB5 && wc <= 0x0AB9))
	return TRUE;
      if (wc == 0x0AF9 || (wc >= 0x0B15 && wc <= 0x0B28))
	return TRUE;
      if ((wc >= 0x0B2A && wc <= 0x0B30))
	return TRUE;
      if ((wc >= 0x0B32 && wc <= 0x0B33) || (wc >= 0x0B35 && wc <= 0x0B39))
	return TRUE;
      return FALSE;
    }
  if ((wc >= 0x0B5C && wc <= 0x0D3A))
    {
      if ((wc >= 0x0B5C && wc <= 0x0B5D))
	return TRUE;
      if (wc == 0x0B5F || wc == 0x0B71)
	return TRUE;
      if ((wc >= 0x0C15 && wc <= 0x0C28))
	return TRUE;
      if ((wc >= 0x0C2A && wc <= 0x0C39) ||
	  (wc >= 0x0C58 && wc <= 0x0C5A) || (wc >= 0x0D15 && wc <= 0x0D3A))
	return TRUE;
      return FALSE;
    }
  return FALSE;
}

static inline gboolean
_pango_is_Indic_Conjunct_Break_Extend (gunichar wc)
{
  if ((wc >= 0x0300 && wc <= 0x0ECB))
    {
      if ((wc >= 0x0300 && wc <= 0x065F))
	{
	  if ((wc >= 0x0300 && wc <= 0x034E) ||
	      (wc >= 0x0350 && wc <= 0x036F))
	    return TRUE;
	  if ((wc >= 0x0483 && wc <= 0x0487) ||
	      (wc >= 0x0591 && wc <= 0x05BD) || wc == 0x05BF)
	    return TRUE;
	  if ((wc >= 0x05C1 && wc <= 0x05C2) ||
	      (wc >= 0x05C4 && wc <= 0x05C5))
	    return TRUE;
	  if (wc == 0x05C7 ||
	      (wc >= 0x0610 && wc <= 0x061A) ||
	      (wc >= 0x064B && wc <= 0x065F))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x0670 && wc <= 0x0823))
	{
	  if (wc == 0x0670 || (wc >= 0x06D6 && wc <= 0x06DC))
	    return TRUE;
	  if ((wc >= 0x06DF && wc <= 0x06E4) ||
	      (wc >= 0x06E7 && wc <= 0x06E8) ||
	      (wc >= 0x06EA && wc <= 0x06ED))
	    return TRUE;
	  if (wc == 0x0711 || (wc >= 0x0730 && wc <= 0x074A))
	    return TRUE;
	  if ((wc >= 0x07EB && wc <= 0x07F3) ||
	      wc == 0x07FD ||
	      (wc >= 0x0816 && wc <= 0x0819) ||
	      (wc >= 0x081B && wc <= 0x0823))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x0825 && wc <= 0x09FE))
	{
	  if ((wc >= 0x0825 && wc <= 0x0827) ||
	      (wc >= 0x0829 && wc <= 0x082D))
	    return TRUE;
	  if ((wc >= 0x0859 && wc <= 0x085B) ||
	      (wc >= 0x0898 && wc <= 0x089F) ||
	      (wc >= 0x08CA && wc <= 0x08E1))
	    return TRUE;
	  if ((wc >= 0x08E3 && wc <= 0x08FF) || wc == 0x093C)
	    return TRUE;
	  if ((wc >= 0x0951 && wc <= 0x0954) || wc == 0x09BC || wc == 0x09FE)
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x0A3C && wc <= 0x0ECB))
	{
	  if (wc == 0x0A3C || wc == 0x0ABC)
	    return TRUE;
	  if (wc == 0x0B3C || wc == 0x0C3C || (wc >= 0x0C55 && wc <= 0x0C56))
	    return TRUE;
	  if (wc == 0x0CBC || (wc >= 0x0D3B && wc <= 0x0D3C))
	    return TRUE;
	  if ((wc >= 0x0E38 && wc <= 0x0E3A) ||
	      (wc >= 0x0E48 && wc <= 0x0E4B) ||
	      (wc >= 0x0EB8 && wc <= 0x0EBA) ||
	      (wc >= 0x0EC8 && wc <= 0x0ECB))
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0x0F18 && wc <= 0x20F0))
    {
      if ((wc >= 0x0F18 && wc <= 0x0F87))
	{
	  if ((wc >= 0x0F18 && wc <= 0x0F19) || wc == 0x0F35)
	    return TRUE;
	  if (wc == 0x0F37 || wc == 0x0F39 || (wc >= 0x0F71 && wc <= 0x0F72))
	    return TRUE;
	  if (wc == 0x0F74 || (wc >= 0x0F7A && wc <= 0x0F7D))
	    return TRUE;
	  if (wc == 0x0F80 ||
	      (wc >= 0x0F82 && wc <= 0x0F84) ||
	      (wc >= 0x0F86 && wc <= 0x0F87))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x0FC6 && wc <= 0x1A18))
	{
	  if (wc == 0x0FC6 || wc == 0x1037)
	    return TRUE;
	  if ((wc >= 0x1039 && wc <= 0x103A) ||
	      wc == 0x108D || (wc >= 0x135D && wc <= 0x135F))
	    return TRUE;
	  if (wc == 0x1714 || wc == 0x17D2)
	    return TRUE;
	  if (wc == 0x17DD ||
	      wc == 0x18A9 ||
	      (wc >= 0x1939 && wc <= 0x193B) ||
	      (wc >= 0x1A17 && wc <= 0x1A18))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x1A60 && wc <= 0x1C37))
	{
	  if (wc == 0x1A60 || (wc >= 0x1A75 && wc <= 0x1A7C))
	    return TRUE;
	  if (wc == 0x1A7F ||
	      (wc >= 0x1AB0 && wc <= 0x1ABD) ||
	      (wc >= 0x1ABF && wc <= 0x1ACE))
	    return TRUE;
	  if (wc == 0x1B34 || (wc >= 0x1B6B && wc <= 0x1B73))
	    return TRUE;
	  if (wc == 0x1BAB || wc == 0x1BE6 || wc == 0x1C37)
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x1CD0 && wc <= 0x20F0))
	{
	  if ((wc >= 0x1CD0 && wc <= 0x1CD2) ||
	      (wc >= 0x1CD4 && wc <= 0x1CE0))
	    return TRUE;
	  if ((wc >= 0x1CE2 && wc <= 0x1CE8) || wc == 0x1CED || wc == 0x1CF4)
	    return TRUE;
	  if ((wc >= 0x1CF8 && wc <= 0x1CF9) ||
	      (wc >= 0x1DC0 && wc <= 0x1DFF))
	    return TRUE;
	  if (wc == 0x200D ||
	      (wc >= 0x20D0 && wc <= 0x20DC) ||
	      wc == 0x20E1 || (wc >= 0x20E5 && wc <= 0x20F0))
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0x2CEF && wc <= 0x111CA))
    {
      if ((wc >= 0x2CEF && wc <= 0xA82C))
	{
	  if ((wc >= 0x2CEF && wc <= 0x2CF1) || wc == 0x2D7F)
	    return TRUE;
	  if ((wc >= 0x2DE0 && wc <= 0x2DFF) ||
	      (wc >= 0x302A && wc <= 0x302F) ||
	      (wc >= 0x3099 && wc <= 0x309A))
	    return TRUE;
	  if (wc == 0xA66F || (wc >= 0xA674 && wc <= 0xA67D))
	    return TRUE;
	  if ((wc >= 0xA69E && wc <= 0xA69F) ||
	      (wc >= 0xA6F0 && wc <= 0xA6F1) || wc == 0xA82C)
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0xA8E0 && wc <= 0xFB1E))
	{
	  if ((wc >= 0xA8E0 && wc <= 0xA8F1) ||
	      (wc >= 0xA92B && wc <= 0xA92D))
	    return TRUE;
	  if (wc == 0xA9B3 || wc == 0xAAB0 || (wc >= 0xAAB2 && wc <= 0xAAB4))
	    return TRUE;
	  if ((wc >= 0xAAB7 && wc <= 0xAAB8) ||
	      (wc >= 0xAABE && wc <= 0xAABF))
	    return TRUE;
	  if (wc == 0xAAC1 || wc == 0xAAF6 || wc == 0xABED || wc == 0xFB1E)
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0xFE20 && wc <= 0x10D27))
	{
	  if ((wc >= 0xFE20 && wc <= 0xFE2F) || wc == 0x101FD)
	    return TRUE;
	  if (wc == 0x102E0 ||
	      (wc >= 0x10376 && wc <= 0x1037A) || wc == 0x10A0D)
	    return TRUE;
	  if (wc == 0x10A0F || (wc >= 0x10A38 && wc <= 0x10A3A))
	    return TRUE;
	  if (wc == 0x10A3F ||
	      (wc >= 0x10AE5 && wc <= 0x10AE6) ||
	      (wc >= 0x10D24 && wc <= 0x10D27))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x10EAB && wc <= 0x111CA))
	{
	  if ((wc >= 0x10EAB && wc <= 0x10EAC) ||
	      (wc >= 0x10EFD && wc <= 0x10EFF))
	    return TRUE;
	  if ((wc >= 0x10F46 && wc <= 0x10F50) ||
	      (wc >= 0x10F82 && wc <= 0x10F85) || wc == 0x11070)
	    return TRUE;
	  if (wc == 0x1107F || wc == 0x110BA)
	    return TRUE;
	  if ((wc >= 0x11100 && wc <= 0x11102) ||
	      (wc >= 0x11133 && wc <= 0x11134) ||
	      wc == 0x11173 || wc == 0x111CA)
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0x11236 && wc <= 0x1E94A))
    {
      if ((wc >= 0x11236 && wc <= 0x116B7))
	{
	  if (wc == 0x11236 || (wc >= 0x112E9 && wc <= 0x112EA))
	    return TRUE;
	  if ((wc >= 0x1133B && wc <= 0x1133C) ||
	      (wc >= 0x11366 && wc <= 0x1136C) ||
	      (wc >= 0x11370 && wc <= 0x11374))
	    return TRUE;
	  if (wc == 0x11446 || wc == 0x1145E)
	    return TRUE;
	  if (wc == 0x114C3 || wc == 0x115C0 || wc == 0x116B7)
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x1172B && wc <= 0x11F42))
	{
	  if (wc == 0x1172B || wc == 0x1183A)
	    return TRUE;
	  if (wc == 0x1193E || wc == 0x11943 || wc == 0x11A34)
	    return TRUE;
	  if (wc == 0x11A47 || wc == 0x11A99)
	    return TRUE;
	  if (wc == 0x11D42 ||
	      (wc >= 0x11D44 && wc <= 0x11D45) ||
	      wc == 0x11D97 || wc == 0x11F42)
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x16AF0 && wc <= 0x1D244))
	{
	  if ((wc >= 0x16AF0 && wc <= 0x16AF4) ||
	      (wc >= 0x16B30 && wc <= 0x16B36))
	    return TRUE;
	  if (wc == 0x1BC9E ||
	      wc == 0x1D165 || (wc >= 0x1D167 && wc <= 0x1D169))
	    return TRUE;
	  if ((wc >= 0x1D16E && wc <= 0x1D172) ||
	      (wc >= 0x1D17B && wc <= 0x1D182))
	    return TRUE;
	  if ((wc >= 0x1D185 && wc <= 0x1D18B) ||
	      (wc >= 0x1D1AA && wc <= 0x1D1AD) ||
	      (wc >= 0x1D242 && wc <= 0x1D244))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x1E000 && wc <= 0x1E94A))
	{
	  if ((wc >= 0x1E000 && wc <= 0x1E006) ||
	      (wc >= 0x1E008 && wc <= 0x1E018) ||
	      (wc >= 0x1E01B && wc <= 0x1E021))
	    return TRUE;
	  if ((wc >= 0x1E023 && wc <= 0x1E024) ||
	      (wc >= 0x1E026 && wc <= 0x1E02A) || wc == 0x1E08F)
	    return TRUE;
	  if ((wc >= 0x1E130 && wc <= 0x1E136) ||
	      wc == 0x1E2AE || (wc >= 0x1E2EC && wc <= 0x1E2EF))
	    return TRUE;
	  if ((wc >= 0x1E4EC && wc <= 0x1E4EF) ||
	      (wc >= 0x1E8D0 && wc <= 0x1E8D6) ||
	      (wc >= 0x1E944 && wc <= 0x1E94A))
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  return FALSE;
}

static inline gboolean
_pango_is_EastAsianWide (gunichar wc)
{
  if ((wc >= 0x1100 && wc <= 0x27B0))
    {
      if ((wc >= 0x1100 && wc <= 0x25FE))
	{
	  if ((wc >= 0x1100 && wc <= 0x115F) || wc == 0x20A9)
	    return TRUE;
	  if ((wc >= 0x231A && wc <= 0x231B) ||
	      (wc >= 0x2329 && wc <= 0x232A))
	    return TRUE;
	  if ((wc >= 0x23E9 && wc <= 0x23EC) || wc == 0x23F0)
	    return TRUE;
	  if (wc == 0x23F3 || (wc >= 0x25FD && wc <= 0x25FE))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x2614 && wc <= 0x26C5))
	{
	  if ((wc >= 0x2614 && wc <= 0x2615) ||
	      (wc >= 0x2648 && wc <= 0x2653))
	    return TRUE;
	  if (wc == 0x267F || wc == 0x2693)
	    return TRUE;
	  if (wc == 0x26A1 || (wc >= 0x26AA && wc <= 0x26AB))
	    return TRUE;
	  if ((wc >= 0x26BD && wc <= 0x26BE) ||
	      (wc >= 0x26C4 && wc <= 0x26C5))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x26CE && wc <= 0x2705))
	{
	  if (wc == 0x26CE || wc == 0x26D4)
	    return TRUE;
	  if (wc == 0x26EA || (wc >= 0x26F2 && wc <= 0x26F3))
	    return TRUE;
	  if (wc == 0x26F5 || wc == 0x26FA)
	    return TRUE;
	  if (wc == 0x26FD || wc == 0x2705)
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x270A && wc <= 0x27B0))
	{
	  if ((wc >= 0x270A && wc <= 0x270B) || wc == 0x2728)
	    return TRUE;
	  if (wc == 0x274C || wc == 0x274E)
	    return TRUE;
	  if ((wc >= 0x2753 && wc <= 0x2755) || wc == 0x2757)
	    return TRUE;
	  if ((wc >= 0x2795 && wc <= 0x2797) || wc == 0x27B0)
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0x27BF && wc <= 0xFFD7))
    {
      if ((wc >= 0x27BF && wc <= 0x2FFF))
	{
	  if (wc == 0x27BF || (wc >= 0x2B1B && wc <= 0x2B1C))
	    return TRUE;
	  if (wc == 0x2B50 || wc == 0x2B55)
	    return TRUE;
	  if ((wc >= 0x2E80 && wc <= 0x2E99) ||
	      (wc >= 0x2E9B && wc <= 0x2EF3))
	    return TRUE;
	  if ((wc >= 0x2F00 && wc <= 0x2FD5) ||
	      (wc >= 0x2FF0 && wc <= 0x2FFF))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x3000 && wc <= 0x321E))
	{
	  if (wc == 0x3000 || (wc >= 0x3001 && wc <= 0x303E))
	    return TRUE;
	  if ((wc >= 0x3041 && wc <= 0x3096) ||
	      (wc >= 0x3099 && wc <= 0x30FF))
	    return TRUE;
	  if ((wc >= 0x3105 && wc <= 0x312F) ||
	      (wc >= 0x3131 && wc <= 0x318E))
	    return TRUE;
	  if ((wc >= 0x3190 && wc <= 0x31E3) ||
	      (wc >= 0x31EF && wc <= 0x321E))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x3220 && wc <= 0xFE19))
	{
	  if ((wc >= 0x3220 && wc <= 0x3247) ||
	      (wc >= 0x3250 && wc <= 0x4DBF))
	    return TRUE;
	  if ((wc >= 0x4E00 && wc <= 0xA48C) ||
	      (wc >= 0xA490 && wc <= 0xA4C6))
	    return TRUE;
	  if ((wc >= 0xA960 && wc <= 0xA97C) ||
	      (wc >= 0xAC00 && wc <= 0xD7A3))
	    return TRUE;
	  if ((wc >= 0xF900 && wc <= 0xFAFF) ||
	      (wc >= 0xFE10 && wc <= 0xFE19))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0xFE30 && wc <= 0xFFD7))
	{
	  if ((wc >= 0xFE30 && wc <= 0xFE52) ||
	      (wc >= 0xFE54 && wc <= 0xFE66))
	    return TRUE;
	  if ((wc >= 0xFE68 && wc <= 0xFE6B) ||
	      (wc >= 0xFF01 && wc <= 0xFF60))
	    return TRUE;
	  if ((wc >= 0xFF61 && wc <= 0xFFBE) ||
	      (wc >= 0xFFC2 && wc <= 0xFFC7))
	    return TRUE;
	  if ((wc >= 0xFFCA && wc <= 0xFFCF) ||
	      (wc >= 0xFFD2 && wc <= 0xFFD7))
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0xFFDA && wc <= 0x1F3D3))
    {
      if ((wc >= 0xFFDA && wc <= 0x18D08))
	{
	  if ((wc >= 0xFFDA && wc <= 0xFFDC) ||
	      (wc >= 0xFFE0 && wc <= 0xFFE6))
	    return TRUE;
	  if ((wc >= 0xFFE8 && wc <= 0xFFEE) ||
	      (wc >= 0x16FE0 && wc <= 0x16FE4))
	    return TRUE;
	  if ((wc >= 0x16FF0 && wc <= 0x16FF1) ||
	      (wc >= 0x17000 && wc <= 0x187F7))
	    return TRUE;
	  if ((wc >= 0x18800 && wc <= 0x18CD5) ||
	      (wc >= 0x18D00 && wc <= 0x18D08))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x1AFF0 && wc <= 0x1B167))
	{
	  if ((wc >= 0x1AFF0 && wc <= 0x1AFF3) ||
	      (wc >= 0x1AFF5 && wc <= 0x1AFFB))
	    return TRUE;
	  if ((wc >= 0x1AFFD && wc <= 0x1AFFE) ||
	      (wc >= 0x1B000 && wc <= 0x1B122))
	    return TRUE;
	  if (wc == 0x1B132 || (wc >= 0x1B150 && wc <= 0x1B152))
	    return TRUE;
	  if (wc == 0x1B155 || (wc >= 0x1B164 && wc <= 0x1B167))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x1B170 && wc <= 0x1F248))
	{
	  if ((wc >= 0x1B170 && wc <= 0x1B2FB) || wc == 0x1F004)
	    return TRUE;
	  if (wc == 0x1F0CF || wc == 0x1F18E)
	    return TRUE;
	  if ((wc >= 0x1F191 && wc <= 0x1F19A) ||
	      (wc >= 0x1F200 && wc <= 0x1F202))
	    return TRUE;
	  if ((wc >= 0x1F210 && wc <= 0x1F23B) ||
	      (wc >= 0x1F240 && wc <= 0x1F248))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x1F250 && wc <= 0x1F3D3))
	{
	  if ((wc >= 0x1F250 && wc <= 0x1F251) ||
	      (wc >= 0x1F260 && wc <= 0x1F265))
	    return TRUE;
	  if ((wc >= 0x1F300 && wc <= 0x1F320) ||
	      (wc >= 0x1F32D && wc <= 0x1F335))
	    return TRUE;
	  if ((wc >= 0x1F337 && wc <= 0x1F37C) ||
	      (wc >= 0x1F37E && wc <= 0x1F393))
	    return TRUE;
	  if ((wc >= 0x1F3A0 && wc <= 0x1F3CA) ||
	      (wc >= 0x1F3CF && wc <= 0x1F3D3))
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0x1F3E0 && wc <= 0x3FFFD))
    {
      if ((wc >= 0x1F3E0 && wc <= 0x1F567))
	{
	  if ((wc >= 0x1F3E0 && wc <= 0x1F3F0) || wc == 0x1F3F4)
	    return TRUE;
	  if ((wc >= 0x1F3F8 && wc <= 0x1F43E) || wc == 0x1F440)
	    return TRUE;
	  if ((wc >= 0x1F442 && wc <= 0x1F4FC) ||
	      (wc >= 0x1F4FF && wc <= 0x1F53D))
	    return TRUE;
	  if ((wc >= 0x1F54B && wc <= 0x1F54E) ||
	      (wc >= 0x1F550 && wc <= 0x1F567))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x1F57A && wc <= 0x1F6D7))
	{
	  if (wc == 0x1F57A || (wc >= 0x1F595 && wc <= 0x1F596))
	    return TRUE;
	  if (wc == 0x1F5A4 || (wc >= 0x1F5FB && wc <= 0x1F64F))
	    return TRUE;
	  if ((wc >= 0x1F680 && wc <= 0x1F6C5) || wc == 0x1F6CC)
	    return TRUE;
	  if ((wc >= 0x1F6D0 && wc <= 0x1F6D2) ||
	      (wc >= 0x1F6D5 && wc <= 0x1F6D7))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x1F6DC && wc <= 0x1F9FF))
	{
	  if ((wc >= 0x1F6DC && wc <= 0x1F6DF) ||
	      (wc >= 0x1F6EB && wc <= 0x1F6EC))
	    return TRUE;
	  if ((wc >= 0x1F6F4 && wc <= 0x1F6FC) ||
	      (wc >= 0x1F7E0 && wc <= 0x1F7EB))
	    return TRUE;
	  if (wc == 0x1F7F0 || (wc >= 0x1F90C && wc <= 0x1F93A))
	    return TRUE;
	  if ((wc >= 0x1F93C && wc <= 0x1F945) ||
	      (wc >= 0x1F947 && wc <= 0x1F9FF))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x1FA70 && wc <= 0x3FFFD))
	{
	  if ((wc >= 0x1FA70 && wc <= 0x1FA7C) ||
	      (wc >= 0x1FA80 && wc <= 0x1FA88))
	    return TRUE;
	  if ((wc >= 0x1FA90 && wc <= 0x1FABD) ||
	      (wc >= 0x1FABF && wc <= 0x1FAC5))
	    return TRUE;
	  if ((wc >= 0x1FACE && wc <= 0x1FADB) ||
	      (wc >= 0x1FAE0 && wc <= 0x1FAE8))
	    return TRUE;
	  if ((wc >= 0x1FAF0 && wc <= 0x1FAF8) ||
	      (wc >= 0x20000 && wc <= 0x2FFFD) ||
	      (wc >= 0x30000 && wc <= 0x3FFFD))
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  return FALSE;
}

#endif /* PANGO_BREAK_TABLE_H */

/* == End of generated table == */
