/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/
#include "qt_QApplication.h"

#include <qwidcoll.h>
#include <qobjcoll.h>

qt_QApplication *qt_new_QApplication(int argc,char** argv)

{
	return (qt_QApplication *) new QApplication( (int&)argc,(char**)argv );
}

qt_QApplication *qt_new_QApplication1(Display* dpy)

{
	return (qt_QApplication *) new QApplication( (Display*)dpy );
}

void qt_del_QApplication (qt_QApplication *p)
{
delete (QApplication*) p;
}

int qt_QApplication_argc( qt_QApplication *instPointer){
	return (int)((QApplication *)instPointer)->argc();
}
char** qt_QApplication_argv( qt_QApplication *instPointer){
	return (char**)((QApplication *)instPointer)->argv();
}
int qt_QApplication_style()
{
	return (int)QApplication::style();
}
void qt_QApplication_setStyle( int arg1)
{
    QApplication::setStyle( (GUIStyle)arg1);
}
int qt_QApplication_colorSpec()
{
	return (int)QApplication::colorSpec();
}
void qt_QApplication_setColorSpec( int arg1)
{
	QApplication::setColorSpec( (int)arg1);
}
qt_QCursor * qt_QApplication_overrideCursor()
{
	return (qt_QCursor *)QApplication::overrideCursor();
}
void qt_QApplication_setOverrideCursor( qt_QCursor * arg1,int replace)
{
	QApplication::setOverrideCursor( (QCursor&)*arg1,(bool)replace);
}
void qt_QApplication_restoreOverrideCursor()
{
	QApplication::restoreOverrideCursor();
}
int qt_QApplication_hasGlobalMouseTracking()
{
	return (int)QApplication::hasGlobalMouseTracking();
}
void qt_QApplication_setGlobalMouseTracking( int enable)
{
	QApplication::setGlobalMouseTracking( (bool)enable);
}
qt_QPalette * qt_QApplication_palette()
{
	return (qt_QPalette *)QApplication::palette();
}
void qt_QApplication_setPalette( qt_QPalette * arg1,int updateAllWidgets)
{
	QApplication::setPalette( (QPalette&)*arg1,(bool)updateAllWidgets);
}
qt_QFont * qt_QApplication_font()
{
	return (qt_QFont *)QApplication::font();
}
void qt_QApplication_setFont( qt_QFont * arg1,int updateAllWidgets)
{
	QApplication::setFont( (QFont&)*arg1,(bool)updateAllWidgets);
}
qt_QFontMetrics * qt_QApplication_fontMetrics()
{
	return (qt_QFontMetrics *)new QFontMetrics(QApplication::fontMetrics());
}
qt_QWidget * qt_QApplication_mainWidget( qt_QApplication *instPointer){
	return (qt_QWidget *)((QApplication *)instPointer)->mainWidget();
}
void qt_QApplication_setMainWidget( qt_QApplication *instPointer,qt_QWidget * arg1){
	((QApplication *)instPointer)->setMainWidget((QWidget* )arg1);
}


/**************************************/
/*This function didn't wrap*/
/*XXX qt_QApplication_allWidgets()*/
/*{*/
/*	return (XXX)QApplication::allWidgets();*/
/*}*/
/**/



/**************************************/
/*This function didn't wrap*/
/*XXX qt_QApplication_topLevelWidgets()*/
/*{*/
/*	return (XXX)QApplication::topLevelWidgets();*/
/*}*/
/**/

qt_QWidget * qt_QApplication_desktop()
{
	return (qt_QWidget *)QApplication::desktop();
}
qt_QWidget * qt_QApplication_activePopupWidget()
{
	return (qt_QWidget *)QApplication::activePopupWidget();
}
qt_QWidget * qt_QApplication_activeModalWidget()
{
	return (qt_QWidget *)QApplication::activeModalWidget();
}
qt_QClipboard * qt_QApplication_clipboard()
{
	return (qt_QClipboard *)QApplication::clipboard();
}
qt_QWidget * qt_QApplication_focusWidget( qt_QApplication *instPointer){
	return (qt_QWidget *)((QApplication *)instPointer)->focusWidget();
}
qt_QWidget * qt_QApplication_widgetAt( int x,int y,int child)
{
	return (qt_QWidget *)QApplication::widgetAt( (int)x,(int)y,(bool)child);
}
qt_QWidget * qt_QApplication_widgetAt1( qt_QPoint * arg1,int child)
{
	return (qt_QWidget *)QApplication::widgetAt( (QPoint&)*arg1,(bool)child);
}
int qt_QApplication_exec( qt_QApplication *instPointer){
	return (int)((QApplication *)instPointer)->exec();
}
void qt_QApplication_processEvents( qt_QApplication *instPointer){
	((QApplication *)instPointer)->processEvents();
}
void qt_QApplication_processEvents1( qt_QApplication *instPointer,int maxtime){
	((QApplication *)instPointer)->processEvents((int )maxtime);
}
void qt_QApplication_processOneEvent( qt_QApplication *instPointer){
	((QApplication *)instPointer)->processOneEvent();
}
int qt_QApplication_enter_loop( qt_QApplication *instPointer){
	return (int)((QApplication *)instPointer)->enter_loop();
}
void qt_QApplication_exit_loop( qt_QApplication *instPointer){
	((QApplication *)instPointer)->exit_loop();
}
void qt_QApplication_exit( int retcode)
{
	QApplication::exit( (int)retcode);
}
int qt_QApplication_sendEvent( qt_QObject * receiver,qt_QEvent * event)
{
	return (int)QApplication::sendEvent( (QObject*)receiver,(QEvent*)event);
}
void qt_QApplication_postEvent( qt_QObject * receiver,qt_QEvent * event)
{
	QApplication::postEvent( (QObject*)receiver,(QEvent*)event);
}
int qt_QApplication_notify( qt_QApplication *instPointer,qt_QObject * arg1,qt_QEvent * arg2){
	return (int)((QApplication *)instPointer)->notify((QObject* )arg1,(QEvent* )arg2);
}
int qt_QApplication_startingUp()
{
	return (int)QApplication::startingUp();
}
int qt_QApplication_closingDown()
{
	return (int)QApplication::closingDown();
}
void qt_QApplication_flushX()
{
	QApplication::flushX();
}
void qt_QApplication_syncX()
{
	QApplication::syncX();
}
void qt_QApplication_beep()
{
	QApplication::beep();
}
void qt_QApplication_setWinStyleHighlightColor( qt_QColor * arg1)
{
	QApplication::setWinStyleHighlightColor( (QColor&)*arg1);
}
qt_QColor * qt_QApplication_winStyleHighlightColor()
{
	return (qt_QColor *)new QColor (QApplication::winStyleHighlightColor());
}
void qt_QApplication_setDoubleClickInterval( int arg1)
{
	QApplication::setDoubleClickInterval( (int)arg1);
}
int qt_QApplication_doubleClickInterval()
{
	return (int)QApplication::doubleClickInterval();
}
int qt_QApplication_x11EventFilter( qt_QApplication *instPointer,XEvent* arg1){
	return (int)((QApplication *)instPointer)->x11EventFilter((XEvent* )arg1);
}
int qt_QApplication_x11ProcessEvent( qt_QApplication *instPointer,XEvent* arg1){
	return (int)((QApplication *)instPointer)->x11ProcessEvent((XEvent* )arg1);
}
void qt_QApplication_quit( qt_QApplication *instPointer){
	((QApplication *)instPointer)->quit();
}
