/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/
#include "qt_QPainter.h"

qt_QPainter *qt_new_QPainter(){
	return (qt_QPainter *)new QPainter();
}
qt_QPainter *qt_new_QPainter1(qt_QPaintDevice * arg1)

{
	return (qt_QPainter *) new QPainter( (QPaintDevice*)arg1 );
}

void qt_del_QPainter (qt_QPainter *p)
{
delete (QPainter*) p;
}

int qt_QPainter_begin( qt_QPainter *instPointer,qt_QPaintDevice * arg1){
	return (int)((QPainter *)instPointer)->begin((QPaintDevice* )arg1);
}
int qt_QPainter_end( qt_QPainter *instPointer){
	return (int)((QPainter *)instPointer)->end();
}
qt_QPaintDevice * qt_QPainter_device( qt_QPainter *instPointer){
	return (qt_QPaintDevice *)((QPainter *)instPointer)->device();
}
void qt_QPainter_redirect( qt_QPaintDevice * pdev,qt_QPaintDevice * replacement)
{
	QPainter::redirect( (QPaintDevice*)pdev,(QPaintDevice*)replacement);
}
int qt_QPainter_isActive( qt_QPainter *instPointer){
	return (int)((QPainter *)instPointer)->isActive();
}
void qt_QPainter_flush( qt_QPainter *instPointer){
	((QPainter *)instPointer)->flush();
}
void qt_QPainter_save( qt_QPainter *instPointer){
	((QPainter *)instPointer)->save();
}
void qt_QPainter_restore( qt_QPainter *instPointer){
	((QPainter *)instPointer)->restore();
}
qt_QFontMetrics * qt_QPainter_fontMetrics( qt_QPainter *instPointer){
	return (qt_QFontMetrics *)new QFontMetrics(((QPainter *)instPointer)->fontMetrics());
}
qt_QFontInfo * qt_QPainter_fontInfo( qt_QPainter *instPointer){
	return (qt_QFontInfo *)new QFontInfo(((QPainter *)instPointer)->fontInfo());
}
qt_QFont * qt_QPainter_font( qt_QPainter *instPointer){
	return (qt_QFont *)new QFont(((QPainter *)instPointer)->font());
}
void qt_QPainter_setFont( qt_QPainter *instPointer,qt_QFont * arg1){
	((QPainter *)instPointer)->setFont((QFont& )*arg1);
}
qt_QPen * qt_QPainter_pen( qt_QPainter *instPointer){
	return (qt_QPen *)new QPen(((QPainter *)instPointer)->pen());
}
void qt_QPainter_setPen( qt_QPainter *instPointer,qt_QPen * arg1){
	((QPainter *)instPointer)->setPen((QPen& )*arg1);
}
void qt_QPainter_setPen1( qt_QPainter *instPointer,int arg1){
	((QPainter *)instPointer)->setPen((PenStyle )arg1);
}
void qt_QPainter_setPen2( qt_QPainter *instPointer,qt_QColor * arg1){
	((QPainter *)instPointer)->setPen((QColor& )*arg1);
}
qt_QBrush * qt_QPainter_brush( qt_QPainter *instPointer){
	return (qt_QBrush *)new QBrush (((QPainter *)instPointer)->brush());
}
void qt_QPainter_setBrush( qt_QPainter *instPointer,qt_QBrush * arg1){
	((QPainter *)instPointer)->setBrush((QBrush& )*arg1);
}
void qt_QPainter_setBrush1( qt_QPainter *instPointer,int arg1){
	((QPainter *)instPointer)->setBrush((BrushStyle )arg1);
}
void qt_QPainter_setBrush2( qt_QPainter *instPointer,qt_QColor * arg1){
	((QPainter *)instPointer)->setBrush((QColor& )*arg1);
}
qt_QColor * qt_QPainter_backgroundColor( qt_QPainter *instPointer){
	return (qt_QColor *)new QColor(((QPainter *)instPointer)->backgroundColor());
}
void qt_QPainter_setBackgroundColor( qt_QPainter *instPointer,qt_QColor * arg1){
	((QPainter *)instPointer)->setBackgroundColor((QColor& )*arg1);
}
int qt_QPainter_backgroundMode( qt_QPainter *instPointer){
	return (int)((QPainter *)instPointer)->backgroundMode();
}
void qt_QPainter_setBackgroundMode( qt_QPainter *instPointer,int arg1){
	((QPainter *)instPointer)->setBackgroundMode((BGMode )arg1);
}
int qt_QPainter_rasterOp( qt_QPainter *instPointer){
	return (int)((QPainter *)instPointer)->rasterOp();
}
void qt_QPainter_setRasterOp( qt_QPainter *instPointer,int arg1){
	((QPainter *)instPointer)->setRasterOp((RasterOp )arg1);
}
qt_QPoint * qt_QPainter_brushOrigin( qt_QPainter *instPointer){
    QPoint p=((QPainter *)instPointer)->brushOrigin();
    return (qt_QPoint *)new QPoint(p.x(),p.y());
}
void qt_QPainter_setBrushOrigin( qt_QPainter *instPointer,int x,int y){
	((QPainter *)instPointer)->setBrushOrigin((int )x,(int )y);
}
void qt_QPainter_setBrushOrigin1( qt_QPainter *instPointer,qt_QPoint * arg1){
	((QPainter *)instPointer)->setBrushOrigin((QPoint& )*arg1);
}
void qt_QPainter_setViewXForm( qt_QPainter *instPointer,int arg1){
	((QPainter *)instPointer)->setViewXForm((bool )arg1);
}
int qt_QPainter_hasViewXForm( qt_QPainter *instPointer){
	return (int)((QPainter *)instPointer)->hasViewXForm();
}
qt_QRect * qt_QPainter_window( qt_QPainter *instPointer){
    QRect r=((QPainter *)instPointer)->window();
    return (qt_QRect *)new QRect (r.left(),r.top(),r.width(),r.height());
}
void qt_QPainter_setWindow( qt_QPainter *instPointer,qt_QRect * arg1){
	((QPainter *)instPointer)->setWindow((QRect& )*arg1);
}
void qt_QPainter_setWindow1( qt_QPainter *instPointer,int x,int y,int w,int h){
	((QPainter *)instPointer)->setWindow((int )x,(int )y,(int )w,(int )h);
}
qt_QRect * qt_QPainter_viewport( qt_QPainter *instPointer){
    QRect r=((QPainter *)instPointer)->viewport();
    return (qt_QRect *)new QRect (r.left(),r.top(),r.width(),r.height());
}
void qt_QPainter_setViewport( qt_QPainter *instPointer,qt_QRect * arg1){
	((QPainter *)instPointer)->setViewport((QRect& )*arg1);
}
void qt_QPainter_setViewport1( qt_QPainter *instPointer,int x,int y,int w,int h){
	((QPainter *)instPointer)->setViewport((int )x,(int )y,(int )w,(int )h);
}
void qt_QPainter_setWorldXForm( qt_QPainter *instPointer,int arg1){
	((QPainter *)instPointer)->setWorldXForm((bool )arg1);
}
int qt_QPainter_hasWorldXForm( qt_QPainter *instPointer){
	return (int)((QPainter *)instPointer)->hasWorldXForm();
}
qt_QWMatrix * qt_QPainter_worldMatrix( qt_QPainter *instPointer){
    QWMatrix m=((QPainter *)instPointer)->worldMatrix();
    return (qt_QWMatrix *)new QWMatrix(m.m11(),m.m12(),m.m21(),m.m22(),m.dx(),m.dy());
}
void qt_QPainter_setWorldMatrix( qt_QPainter *instPointer,qt_QWMatrix * arg1,int concat){
	((QPainter *)instPointer)->setWorldMatrix((QWMatrix& )*arg1,(bool )concat);
}
void qt_QPainter_translate( qt_QPainter *instPointer,float dx,float dy){
	((QPainter *)instPointer)->translate((float )dx,(float )dy);
}
void qt_QPainter_scale( qt_QPainter *instPointer,float sx,float sy){
	((QPainter *)instPointer)->scale((float )sx,(float )sy);
}
void qt_QPainter_shear( qt_QPainter *instPointer,float sh,float sv){
	((QPainter *)instPointer)->shear((float )sh,(float )sv);
}
void qt_QPainter_rotate( qt_QPainter *instPointer,float a){
	((QPainter *)instPointer)->rotate((float )a);
}
void qt_QPainter_resetXForm( qt_QPainter *instPointer){
	((QPainter *)instPointer)->resetXForm();
}
qt_QPoint * qt_QPainter_xForm( qt_QPainter *instPointer,qt_QPoint * arg1){
    QPoint p=((QPainter *)instPointer)->xForm((QPoint& )*arg1);
    return (qt_QPoint *)new QPoint(p.x(),p.y());
}
qt_QRect * qt_QPainter_xForm1( qt_QPainter *instPointer,qt_QRect * arg1){
    QRect r=((QPainter *)instPointer)->xForm((QRect& )*arg1);
    return (qt_QRect *)new QRect (r.left(),r.top(),r.width(),r.height());
}


/**************************************/
/*This function didn't wrap*/
/*XXX qt_QPainter_xForm2( qt_QPainter *instPointer,XXX arg1){*/
/*	return (XXX)((QPainter *)instPointer)->xForm((QPointArray& )arg1);*/
/*}*/
/**/

qt_QPoint * qt_QPainter_xFormDev( qt_QPainter *instPointer,qt_QPoint * arg1){
    QPoint p=((QPainter *)instPointer)->xFormDev((QPoint& )*arg1);
    return (qt_QPoint *)new QPoint(p.x(),p.y());
}
qt_QRect * qt_QPainter_xFormDev1( qt_QPainter *instPointer,qt_QRect * arg1){
    QRect r=((QPainter *)instPointer)->xFormDev((QRect& )*arg1);
    return (qt_QRect *)new QRect (r.left(),r.top(),r.width(),r.height());
}


/**************************************/
/*This function didn't wrap*/
/*XXX qt_QPainter_xFormDev2( qt_QPainter *instPointer,XXX arg1){*/
/*	return (XXX)((QPainter *)instPointer)->xFormDev((QPointArray& )arg1);*/
/*}*/
/**/

void qt_QPainter_setClipping( qt_QPainter *instPointer,int arg1){
	((QPainter *)instPointer)->setClipping((bool )arg1);
}
int qt_QPainter_hasClipping( qt_QPainter *instPointer){
	return (int)((QPainter *)instPointer)->hasClipping();
}
qt_QRegion * qt_QPainter_clipRegion( qt_QPainter *instPointer){
	return (qt_QRegion *)new QRegion(((QPainter *)instPointer)->clipRegion());
}
void qt_QPainter_setClipRect( qt_QPainter *instPointer,qt_QRect * arg1){
	((QPainter *)instPointer)->setClipRect((QRect& )*arg1);
}
void qt_QPainter_setClipRect1( qt_QPainter *instPointer,int x,int y,int w,int h){
	((QPainter *)instPointer)->setClipRect((int )x,(int )y,(int )w,(int )h);
}
void qt_QPainter_setClipRegion( qt_QPainter *instPointer,qt_QRegion * arg1){
	((QPainter *)instPointer)->setClipRegion((QRegion& )*arg1);
}
void qt_QPainter_drawPoint( qt_QPainter *instPointer,int x,int y){
	((QPainter *)instPointer)->drawPoint((int )x,(int )y);
}
void qt_QPainter_drawPoint1( qt_QPainter *instPointer,qt_QPoint * arg1){
	((QPainter *)instPointer)->drawPoint((QPoint& )*arg1);
}


/**************************************/
/*This function didn't wrap*/
/*void qt_QPainter_drawPoints( qt_QPainter *instPointer,XXX a,int index,int npoints){*/
/*	((QPainter *)instPointer)->drawPoints((QPointArray& )a,(int )index,(int )npoints);*/
/*}*/
/**/

void qt_QPainter_moveTo( qt_QPainter *instPointer,int x,int y){
	((QPainter *)instPointer)->moveTo((int )x,(int )y);
}
void qt_QPainter_moveTo1( qt_QPainter *instPointer,qt_QPoint * arg1){
	((QPainter *)instPointer)->moveTo((QPoint& )*arg1);
}
void qt_QPainter_lineTo( qt_QPainter *instPointer,int x,int y){
	((QPainter *)instPointer)->lineTo((int )x,(int )y);
}
void qt_QPainter_lineTo1( qt_QPainter *instPointer,qt_QPoint * arg1){
	((QPainter *)instPointer)->lineTo((QPoint& )*arg1);
}
void qt_QPainter_drawLine( qt_QPainter *instPointer,int x1,int y1,int x2,int y2){
	((QPainter *)instPointer)->drawLine((int )x1,(int )y1,(int )x2,(int )y2);
}
void qt_QPainter_drawLine1( qt_QPainter *instPointer,qt_QPoint * arg1,qt_QPoint * arg2){
	((QPainter *)instPointer)->drawLine((QPoint& )*arg1,(QPoint& )*arg2);
}
void qt_QPainter_drawRect( qt_QPainter *instPointer,int x,int y,int w,int h){
	((QPainter *)instPointer)->drawRect((int )x,(int )y,(int )w,(int )h);
}
void qt_QPainter_drawRect1( qt_QPainter *instPointer,qt_QRect * arg1){
	((QPainter *)instPointer)->drawRect((QRect& )*arg1);
}
void qt_QPainter_drawWinFocusRect( qt_QPainter *instPointer,int x,int y,int w,int h){
	((QPainter *)instPointer)->drawWinFocusRect((int )x,(int )y,(int )w,(int )h);
}
void qt_QPainter_drawWinFocusRect1( qt_QPainter *instPointer,int x,int y,int w,int h,qt_QColor * bgColor){
	((QPainter *)instPointer)->drawWinFocusRect((int )x,(int )y,(int )w,(int )h,(QColor& )*bgColor);
}
void qt_QPainter_drawWinFocusRect2( qt_QPainter *instPointer,qt_QRect * arg1){
	((QPainter *)instPointer)->drawWinFocusRect((QRect& )*arg1);
}
void qt_QPainter_drawWinFocusRect3( qt_QPainter *instPointer,qt_QRect * arg1,qt_QColor * bgColor){
	((QPainter *)instPointer)->drawWinFocusRect((QRect& )*arg1,(QColor& )*bgColor);
}
void qt_QPainter_drawRoundRect( qt_QPainter *instPointer,int x,int y,int w,int h,int arg1,int arg2){
	((QPainter *)instPointer)->drawRoundRect((int )x,(int )y,(int )w,(int )h,(int )arg1,(int )arg2);
}
void qt_QPainter_drawRoundRect1( qt_QPainter *instPointer,qt_QRect * arg1,int arg2,int arg3){
	((QPainter *)instPointer)->drawRoundRect((QRect& )*arg1,(int )arg2,(int )arg3);
}
void qt_QPainter_drawEllipse( qt_QPainter *instPointer,int x,int y,int w,int h){
	((QPainter *)instPointer)->drawEllipse((int )x,(int )y,(int )w,(int )h);
}
void qt_QPainter_drawEllipse1( qt_QPainter *instPointer,qt_QRect * arg1){
	((QPainter *)instPointer)->drawEllipse((QRect& )*arg1);
}
void qt_QPainter_drawArc( qt_QPainter *instPointer,int x,int y,int w,int h,int a,int alen){
	((QPainter *)instPointer)->drawArc((int )x,(int )y,(int )w,(int )h,(int )a,(int )alen);
}
void qt_QPainter_drawArc1( qt_QPainter *instPointer,qt_QRect * arg1,int a,int alen){
	((QPainter *)instPointer)->drawArc((QRect& )*arg1,(int )a,(int )alen);
}
void qt_QPainter_drawPie( qt_QPainter *instPointer,int x,int y,int w,int h,int a,int alen){
	((QPainter *)instPointer)->drawPie((int )x,(int )y,(int )w,(int )h,(int )a,(int )alen);
}
void qt_QPainter_drawPie1( qt_QPainter *instPointer,qt_QRect * arg1,int a,int alen){
	((QPainter *)instPointer)->drawPie((QRect& )*arg1,(int )a,(int )alen);
}
void qt_QPainter_drawChord( qt_QPainter *instPointer,int x,int y,int w,int h,int a,int alen){
	((QPainter *)instPointer)->drawChord((int )x,(int )y,(int )w,(int )h,(int )a,(int )alen);
}
void qt_QPainter_drawChord1( qt_QPainter *instPointer,qt_QRect * arg1,int a,int alen){
	((QPainter *)instPointer)->drawChord((QRect& )*arg1,(int )a,(int )alen);
}


/**************************************/
/*This function didn't wrap*/
/*void qt_QPainter_drawLineSegments( qt_QPainter *instPointer,XXX arg1,int index,int nlines){*/
/*	((QPainter *)instPointer)->drawLineSegments((QPointArray& )arg1,(int )index,(int )nlines);*/
/*}*/
/**/



/**************************************/
/*This function didn't wrap*/
/*void qt_QPainter_drawPolyline( qt_QPainter *instPointer,XXX arg1,int index,int npoints){*/
/*	((QPainter *)instPointer)->drawPolyline((QPointArray& )arg1,(int )index,(int )npoints);*/
/*}*/
/**/



/**************************************/
/*This function didn't wrap*/
/*void qt_QPainter_drawPolygon( qt_QPainter *instPointer,XXX arg1,int winding,int index,int npoints){*/
/*	((QPainter *)instPointer)->drawPolygon((QPointArray& )arg1,(bool )winding,(int )index,(int )npoints);*/
/*}*/
/**/



/**************************************/
/*This function didn't wrap*/
/*void qt_QPainter_drawQuadBezier( qt_QPainter *instPointer,XXX arg1,int index){*/
/*	((QPainter *)instPointer)->drawQuadBezier((QPointArray& )arg1,(int )index);*/
/*}*/
/**/

void qt_QPainter_drawPixmap( qt_QPainter *instPointer,int x,int y,qt_QPixmap * arg1,int sx,int sy,int sw,int sh){
	((QPainter *)instPointer)->drawPixmap((int )x,(int )y,(QPixmap& )*arg1,(int )sx,(int )sy,(int )sw,(int )sh);
}
void qt_QPainter_drawPixmap1( qt_QPainter *instPointer,qt_QPoint * arg1,qt_QPixmap * arg2,qt_QRect * sr){
	((QPainter *)instPointer)->drawPixmap((QPoint& )*arg1,(QPixmap& )*arg2,(QRect& )*sr);
}
void qt_QPainter_drawPixmap2( qt_QPainter *instPointer,qt_QPoint * arg1,qt_QPixmap * arg2){
	((QPainter *)instPointer)->drawPixmap((QPoint& )*arg1,(QPixmap& )*arg2);
}
void qt_QPainter_drawPicture( qt_QPainter *instPointer,qt_QPicture * arg1){
	((QPainter *)instPointer)->drawPicture((QPicture& )*arg1);
}
void qt_QPainter_fillRect( qt_QPainter *instPointer,int x,int y,int w,int h,qt_QBrush * arg1){
	((QPainter *)instPointer)->fillRect((int )x,(int )y,(int )w,(int )h,(QBrush& )*arg1);
}
void qt_QPainter_fillRect1( qt_QPainter *instPointer,qt_QRect * arg1,qt_QBrush * arg2){
	((QPainter *)instPointer)->fillRect((QRect& )*arg1,(QBrush& )*arg2);
}
void qt_QPainter_eraseRect( qt_QPainter *instPointer,int x,int y,int w,int h){
	((QPainter *)instPointer)->eraseRect((int )x,(int )y,(int )w,(int )h);
}
void qt_QPainter_eraseRect1( qt_QPainter *instPointer,qt_QRect * arg1){
	((QPainter *)instPointer)->eraseRect((QRect& )*arg1);
}
void qt_QPainter_drawText( qt_QPainter *instPointer,int x,int y,char* str,int len){
	((QPainter *)instPointer)->drawText((int )x,(int )y,(char* )str,(int )len);
}
void qt_QPainter_drawText1( qt_QPainter *instPointer,qt_QPoint * arg1,char* str,int len){
	((QPainter *)instPointer)->drawText((QPoint& )*arg1,(char* )str,(int )len);
}
void qt_QPainter_drawText2( qt_QPainter *instPointer,int x,int y,int w,int h,int flags,char* str,int len,qt_QRect * br,char** internal){
	((QPainter *)instPointer)->drawText((int )x,(int )y,(int )w,(int )h,(int )flags,(char* )str,(int )len,(QRect* )br,(char** )internal);
}
void qt_QPainter_drawText3( qt_QPainter *instPointer,qt_QRect * arg1,int flags,char* str,int len,qt_QRect * br,char** internal){
	((QPainter *)instPointer)->drawText((QRect& )*arg1,(int )flags,(char* )str,(int )len,(QRect* )br,(char** )internal);
}
qt_QRect * qt_QPainter_boundingRect( qt_QPainter *instPointer,int x,int y,int w,int h,int flags,char* str,int len,char** intern){
    QRect r=((QPainter *)instPointer)->boundingRect((int )x,(int )y,(int )w,(int )h,(int )flags,(char* )str,(int )len,(char** )intern);
    return (qt_QRect *)new QRect (r.left(),r.top(),r.width(),r.height());
}
qt_QRect * qt_QPainter_boundingRect1( qt_QPainter *instPointer,qt_QRect * arg1,int flags,char* str,int len,char** intern){
    QRect r=((QPainter *)instPointer)->boundingRect((QRect& )*arg1,(int )flags,(char* )str,(int )len,(char** )intern);
    return (qt_QRect *)new QRect (r.left(),r.top(),r.width(),r.height());
}
int qt_QPainter_tabStops( qt_QPainter *instPointer){
	return (int)((QPainter *)instPointer)->tabStops();
}
void qt_QPainter_setTabStops( qt_QPainter *instPointer,int arg1){
	((QPainter *)instPointer)->setTabStops((int )arg1);
}
int qt_QPainter_tabArray( qt_QPainter *instPointer){
	return (int)((QPainter *)instPointer)->tabArray();
}
void qt_QPainter_setTabArray( qt_QPainter *instPointer,int arg1){
	((QPainter *)instPointer)->setTabArray((int* )arg1);
}
unsigned int qt_QPainter_handle( qt_QPainter *instPointer){
	return (unsigned int)((QPainter *)instPointer)->handle();
}
void qt_QPainter_initialize()
{
	QPainter::initialize();
}
void qt_QPainter_cleanup()
{
	QPainter::cleanup();
}
