/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "main.h"

#include "kpuzzle.h"

#include "kpuzzleview.h"
#include "kpuzzleapp.h"
#include "prefs.h"
#include "highscore.h"

#include <qpainter.h>
#include <qpopupmenu.h>
#include <qcache.h>
#include <qbitmap.h>
#include <qpixmap.h>

#include <kglobal.h>
#include <klocale.h>
#include <kcrash.h>
#include <kmenubar.h>
#include <kaccel.h>
#include <kfiledialog.h>
#include <kconfig.h>

#include <kstdaccel.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kpopupmenu.h>

/*#ifdef DEBUG
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>
#endif*/

KPuzzle::KPuzzle() : KMainWindow( 0, "KPuzzle" )
{
        KGlobal::dirs()->addResourceType("pics","share/apps/kpuzzle/data/");

        m_view = new KPuzzleView(this);

        // don't accept dnd
        setAcceptDrops(false);

        // tell the KMainWindow that this is indeed the main widget
        setCentralWidget(m_view);

        // then, setup our actions
        createGUI();

        // and a status bar
        statusBar()->show();

        // allow the view to change the statusbar and caption
        connect(m_view, SIGNAL(sigChangeStatusbar(const QString&)),
                this,   SLOT(changeStatusbar(const QString&)));

#ifdef DEBUG
        KCrash::setCrashHandler(NULL);
#endif
}

KPuzzle::~KPuzzle()
{
}

void KPuzzle::createGUI()
{
        QPopupMenu* fileMenu = new QPopupMenu(menuBar());

        KAction* temp;

        temp = KStdAction::openNew(m_view, SLOT(slotNewGame()), this);
        temp->plug(fileMenu);
        temp->plug(toolBar());

        temp = KStdAction::open(m_view, SLOT(slotOpenGame()), this);
        temp->plug(fileMenu);
        temp->plug(toolBar());

//        m_view->actSave() = KStdAction::save(m_view, SLOT(slotSaveGame()), this);
        m_view->actSave() = KStdAction::save(0,0,this);
        m_view->actSave()->plug(fileMenu);
        m_view->actSave()->plug(toolBar());

//        m_view->actSaveAs() = KStdAction::saveAs(m_view->game(), SLOT(slotSaveGameAs()), this);
        m_view->actSaveAs() = KStdAction::saveAs(0,0, this);
        m_view->actSaveAs()->plug(fileMenu);

//        m_view->actTerminate() = new KAction(i18n("&Terminate game"),QIconSet(QPixmap(PICFILE("stop.xpm"))),0,m_view->game(),
//                                               SLOT(slotStopGame()),this);
        m_view->actTerminate() = new KAction(i18n("&Terminate game"),QIconSet(QPixmap(PICFILE("stop.xpm"))),0,0,
                                             0,this);
        m_view->actTerminate()->plug(fileMenu);

        (new KActionSeparator(this))->plug(fileMenu);
        (new KActionSeparator(this))->plug(toolBar());

        KStdAction::preferences(this, SLOT(slotSetOptions()), this)->plug(fileMenu);

//         m_view->actHighscores() = new KAction(i18n("&Highscores"),0,m_view->game(),
//                                               SLOT(slotHighscores()),this);
        m_view->actHighscores() = new KAction(i18n("&Highscores"),0,this,
                                               SLOT(slotHighscores()),this);
        m_view->actHighscores()->plug(fileMenu);

        KStdAction::quit(kapp, SLOT(quit()), this)->plug(fileMenu);

        menuBar()->insertItem(i18n("&File"),fileMenu);

        QPopupMenu* gameMenu = new QPopupMenu(menuBar());

        m_view->actPause() = new KAction(i18n("&Pause Game"),QIconSet(QPixmap(PICFILE("pause.xpm"))),0,0,
                                                  0,this);
        m_view->actPause()->plug(gameMenu);
        m_view->actPause()->plug(toolBar());

        m_view->actTerminate()->plug(toolBar());

        (new KActionSeparator(this))->plug(toolBar());

        m_view->actShowLarge() = new KAction(i18n("&Show large image"),QIconSet(QPixmap(PICFILE("large.xpm"))),0,0,
                                             0,this);
        m_view->actShowLarge()->plug(gameMenu);
        m_view->actShowLarge()->plug(toolBar());

        m_view->actShowMainPixmap() = new KAction(i18n("&Show full image"),QIconSet(QPixmap(PICFILE("large-main.xpm"))),
                                                  0,0,0,this);
        m_view->actShowMainPixmap()->plug(gameMenu);
        m_view->actShowMainPixmap()->plug(toolBar());


        menuBar()->insertItem(i18n("&Game"),gameMenu);

        KPopupMenu* hMenu = this->helpMenu(i18n("KPuzzle - A KDE jigsaw puzzle game"),false);
        menuBar()->insertItem(i18n("&Help"),hMenu);

        m_view->enableMenuItems(MI_NONE);
}

void KPuzzle::saveProperties(KConfig *config)
{
    // the 'config' object points to the session managed
    // config file.  anything you write here will be available
    // later when this app is restored

        debug("saveProperties called");

        /*  if (m_view->currentURL() != QString::null)
        config->writeEntry("lastURL", m_view->currentURL()); */
}

void KPuzzle::readProperties(KConfig *config)
{
    // the 'config' object points to the session managed
    // config file.  this function is automatically called whenever
    // the app is being restored.  read in here whatever you wrote
    // in 'saveProperties'

        debug("readProperties called");
/*    QString url = config->readEntry("lastURL");

    if (url != QString::null)
        m_view->openURL(KURL(url));*/
}


void KPuzzle::changeStatusbar(const QString& text)
{
    // display the text on the statusbar
    statusBar()->message(text);
}


void KPuzzle::slotSetOptions()
{
//	bool timerActive = m_view->game()->timerActive();
//	if (timerActive) m_view->game()->stopTimer();
        bool gameIsPaused;
        if (m_view->game()) {
                gameIsPaused = m_view->game()->paused();
                m_view->game()->pause(true);
        }
	CPrefsDialog dlg(this);
	KConfig* cfg =  kapp->sessionConfig();
	dlg._usePieceMask = cfg->readBoolEntry("UsePieceMask",SV_USE_PIECE_MASK);
	dlg._turnPiecesAround = cfg->readBoolEntry("TurnPiecesAround",SV_TURN_PIECES_AROUND);
        dlg._rightKeyPansAround = cfg->readBoolEntry("RightKeyPansAround",SV_RIGHT_KEY_PANS_AROUND);
        dlg._showMainPixmap = cfg->readBoolEntry("ShowMainPixmap",SV_SHOW_MAIN_PIXMAP);
	dlg._imageLoading = cfg->readNumEntry("ImageLoading",SV_IMAGE_LOADING);
	dlg.setValues();
	if (dlg.exec() == QDialog::Accepted) {
		dlg.retrieveValues();
		if (dlg._imageLoading == IL_PRELOAD && cfg->readNumEntry("ImageLoading",-1) != IL_PRELOAD) {
			m_view->useGamePixmap(GP_BIGLOGO);
			m_view->useGamePixmap(GP_LOGO);
			m_view->useGamePixmap(GP_WIN);
			m_view->useGamePixmap(GP_LOSE);
			m_view->useGamePixmap(GP_PAUSE);
		}
		cfg->writeEntry("UsePieceMask",dlg._usePieceMask);
		cfg->writeEntry("TurnPiecesAround",dlg._turnPiecesAround);
                cfg->writeEntry("RightKeyPansAround",dlg._rightKeyPansAround);
                cfg->writeEntry("ShowMainPixmap",dlg._showMainPixmap);
		cfg->writeEntry("ImageLoading",dlg._imageLoading);
		cfg->sync();
	}
//	if (timerActive) m_view->game()->startTimer();
        if (m_view->game()) m_view->game()->pause(gameIsPaused);
}

void KPuzzle::slotHighscores()
{
        bool gameIsPaused = false;
        if (m_view->game()) {
                gameIsPaused = m_view->game()->paused();
                m_view->game()->pause(true);
        }
 	CHighscoreDialog hs(this,0);
	hs.initializeDialog();
	hs.exec();
        if (m_view->game()) m_view->game()->pause(gameIsPaused);
}

