/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PIECE_H
#define PIECE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qobject.h>
#include <qpoint.h>
//#include <qtimer.h>
#include <qevent.h>
#include <qfile.h>
#include <qdatastream.h>
#include <qcache.h>
#include <qbitmap.h>

// These vars should be static elements of CPiece, don't ask me why it doesn't work
extern QCache<QBitmap>* maskCache; // cache for piece masks (that represent the shape of a piece)

class KPuzzleApp;

class CPiece : public QObject
{
	Q_OBJECT
 public:
	CPiece(KPuzzleApp* owner,QDataStream* f); // reads data from a file
	CPiece(KPuzzleApp* owner,QPoint pos); // constructs a new piece
	virtual ~CPiece();

// Data
 public:
	QPoint pos() const { return _pos; }

	int& turn() { return _turn; } // Reading & writing. Yes, this is inconsistent
	int turn() const { return _turn; } // Reading only
	//	void setTurn(int t) { _turn = t; }

	QSize pieceSize() const;
	QSize piecesCount() const;
// displace is the size of the piece border
	int displace() const;

        bool hasBeenSet() const { return _hasBeenSet; }
// May this piece be shown?
	bool mayKeepPiece() const;

// Is this the current piece?
        bool isCurrent() const { return _isCurrent; }

 protected:
	KPuzzleApp* _owner;
	QPoint _pos; // Which piece?
	int _turn; // How is the piece turned?
	int _time; // How many seconds has this piece been seen?
	int _faults; // How many times has the player tried to place this piece?
	bool _hasBeenSet;

        bool _isCurrent; // Only important for loading
        int _timerNr;

/*        static QTimer _pieceTimer;
 *        static QCache<QBitmap> _maskCache;*/

// Implementation
 public:
	bool showPiece(); // returns if piece can be shown; if so, makes itself ready (e.g. starting the timer, connect()s)
	void hidePiece(); // destroys all signal/slot connections
	bool setPiece(QPoint p); // returns if the piece can be set
	void getPixmap(QPixmap* p) const; // blits own pixmap into p, including mask
	void getTurnedPixmap(QPixmap* p) const; // blits own transformed pixmap into p
        void stopTimer();
        void startTimer();

	void save(QDataStream* f) const;

 protected:
// piece mask (for irregular form)
	QBitmap* getPieceMask() const;
	void load(QDataStream* f); // called only by the constructor

/*  signals: */
/* 	void sigHidePiece(bool); // tells the app that this piece must be hidden, if the parameter is true,  */
/* 	                         // the game cannot be won because the time or the faults of the piece are too high */

// public slots:
	void timerEvent(QTimerEvent*);

};
















#endif // PIECE_H
