/***************************************************************************
                          kexchange.h  -  description
                             -------------------
    begin                : Mon Mar  4 11:43:40 EET 2002
    copyright            : (C) 2002 by Tero Favorin
    email                : tero@favorin.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KEXCHANGE_H
#define KEXCHANGE_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qdatetime.h>
// include files for KDE 
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>
#include <kurl.h>

class QTabWidget;
class KExConvert;
class KExTable;
class	KExLookup;
class KExDataSource;
class KExPreferences;
/**
  * The base class for Kexchange application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KexchangeView creates your center view, which is connected
  * to the window's Doc object.
  * KexchangeApp reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
class KexchangeApp : public KMainWindow
{
  Q_OBJECT

  public:
    /** construtor of KexchangeApp, calls all init functions to create the application.
     */
    KexchangeApp(QWidget* parent=0, const char* name=0);
    ~KexchangeApp();
		void setEuro(bool b) {showEuro=b;}
		bool getEuro() {return showEuro;}
		void setUpdate(bool b) {autoUpdate=b;}
		bool getUpdate() {return autoUpdate;}

  protected:
    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */ 	
    void saveOptions();
    /** read general Options again and initialize all variables like the recent file list
     */
    void readOptions();
    /** initializes the KActions of the application */
    void initActions();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
    void initStatusBar();

    virtual bool queryExit();

  public slots:
    /** print the actual file */
    void slotFilePrint();
    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
     * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
     */
    void slotFileQuit();
    /** put the marked text/object into the clipboard
     */
    void slotEditCopy();
    /** paste the clipboard into the document
     */
    void slotEditPaste();
    /** Switch currencies
     */
    void slotEditSwitch();
    /** Refresh currencies from data source
     */
    void slotViewRefresh();
    /** toggles the toolbar
     */
    void slotViewToolBar();
    /** toggles the statusbar
     */
    void slotViewStatusBar();
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusMsg(const QString &text);
    /**
			Status messages from data source.
     */
    void slotDataStatus(int s, const QString &text);
    /**
			Data transfer is complete.
     */
    void slotDataReady();
		void slotConfAccels();
		void slotEditToolbars();
		void slotPreferences();
		void slotShowTip();
    /**
			Tab page has changed.
     */
	  void slotTabChanged( QWidget * );
  private:
    /** the configuration object of the application */
    KConfig *config;
		KExDataSource *data;
		bool showEuro;
		bool autoUpdate;
		QDateTime lastUpdate;

    // KAction pointers to enable/disable actions
    //KAction* filePrint;
    KAction* fileQuit;
    KAction* editCopy;
    KAction* editPaste;
    KAction* editSwitch;
    KAction* viewRefresh;
	  KAction* setAccels;
  	KAction* setToolbar;
	  KAction* setPreferences;
  	KAction* helpTip;
    KToggleAction* viewToolBar;
    KToggleAction* viewStatusBar;

	  // Widgets
		QTabWidget* tabs;
		KExConvert* convert;
		KExTable* table;
		KExPreferences* preferences;
};
 
#endif // KEXCHANGE_H
