#include "kpcolortable.h"

KPColorTable::KPColorTable (double _min, double _max)
{

  min = _min;
  max = _max;

}

bool
KPColorTable::addColor (double start, QColor color)
{
  if (start<min || start >max)
    return FALSE;

  KPCTEntry *entry = new KPCTEntry;
  entry->color = color;
  entry->start = start;
  table.append (entry);

  return TRUE;
}

QColor
KPColorTable::color (double c)
{
  KPCTEntry *entry = table.first();

  if (!sorted)
    {
      table.sort();
      sorted=TRUE;
    }

  do
    {

      if ( entry->start >= c)
	{
	  /*	  printf ("   %f  ?  %f  %d  (%d,%d,%d)\n",c, entry->start,
		  (int)entry,
		  entry->color.red(),
		  entry->color.green(),
		  entry->color.blue());
	  */
	  return entry->color;
	}
    } while ( (entry=table.next()) );

 return table.last()->color;
}


