/**
    KPlotW
    A 2D plotting widget for KDE

    Copyright (C) 1999 by David Sweet

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.

*/

#include <stdio.h>  // for debugging
#include <math.h>

#include <QwSpriteField.h>
#include "QwPrinterSpriteFieldView.h"
#include "kplotw.moc"

#include "kpstext.h"
#include "kpmatrix.h"
#include "kpcoords.h"
#include "kporder.h"
#include "kpsaxis.h"
#include "kpstext.h"
#include "kpcolortable.h"

#include "kps2dparametric.h"
#include "kps2dmap.h"
#include "kps2dbars.h"

KPlotW::KPlotW (QWidget *parent, char* name, WFlags flags) : 
  QWidget (parent, name, flags)
{
  QwSpriteField *field = new QwSpriteField (1, 1);
  kview = new KPView (field, this);
  kview->resize (10,10);
}

void
KPlotW::installRMBMenu (QPopupMenu *rmbmenu)
{
  view()->installRMBMenu (rmbmenu);
}

KPS2D *
KPlotW::addPlot (int plottype, KPMatrix *_matrix,
		KPCoords *_coords, KPColorTable *_colortable)
{
  KPS2D *plot=0;
  KPMatrix *matrix;
  KPCoords coords;

  //  if (_colortable!=0)
  //    colortable = _colortable;
  //  else
    //colortable = standarcolortable;
  // For now, don't try to create a Map w/o passing in a colortable!
  if (_colortable==0 && plottype==Map2D)
    {
      fprintf (stderr, "For now, don't try to create a Map w/o passing in a colortable!\n");
      return 0;
    }


  matrix = _matrix;

  if (_coords==0)
    {
      coords = KPCoords (0,1,0,1); //auto flag

      /*      switch (plottype)
	{
	case Parametric2D:
	  coords = KPS2DParametric::autoCoords (matrix);
	  break;
	case Map2D:
	  // y coords are upside down b/c that's how
	  //  matrices should look
	  coords = KPCoords (0, matrix->nCols(),
			     matrix->nRows(), 0);
	  break;
	case Bars:
	  coords = KPCoords (0, matrix->nRows(), 
			     matrix->min(0), matrix->max(0),
			     0, matrix->min(0));
	  break;
	  }*/
    }                                                   
  else
    coords = *_coords;



  switch (plottype)
    {
    case Parametric2D:
      plot = new KPS2DParametric (view(), coords, matrix,
				  .05, .05, .9, .9, ZPLOT);
      plot->setCoords (plot->autoCoords ());
      break;
    case Map2D:
      plot = new KPS2DMap (view(), coords, matrix, 
			   *_colortable, .05, .05, .9, .9,
			   ZPLOT);
      plot->setCoords (plot->autoCoords ());
      break;
    case Bars:
      plot = new KPS2DBars (view(), coords, matrix,
			    .05, .05, .9, .9, ZPLOT);
      plot->setCoords (plot->autoCoords ());
			    
      break;
    }


  return plot;
}

void
KPlotW::resizeEvent (QResizeEvent *r)
{
  int w,h;

  if ( (h=(int) (width()*view()->aspectRatio())) <= height())
    w = width();
  else
    {
      w = (int) (height()/view()->aspectRatio());
      h = height();
    }
  int x0 = (width()-w)/2;
  int y0 = (height()-h)/2;

  view()->setGeometry (x0, y0, w, h);

  /*
  printf ("kview rect:  %d %d %d %d (%d %d %d %d)\n",
	  x0, y0, w, h,
	  view->rect().x(),
	  view->rect().y(),
	  view->rect().width(),
	  view->rect().height());
  */

  QWidget::resizeEvent (r);
}

void
KPlotW::slotPrint ()
{
  view()->print();
}

void
KPlotW::slotPrintDraft ()
{
  view()->printDraft();
}

void
KPlotW::paintEvent ( QPaintEvent *qp )
{
  view()->paintEvent(qp);
  QWidget::paintEvent(qp);
}
