#include <stdio.h>  


#include "kpview.h"
#include "kpmatrix.h"

#include <kputil.h>

#include "kps2dbars.h"

#define NBARS = 100
KPS2DBars::KPS2DBars (KPView *_view, KPCoords &_coords, KPMatrix *_matrix,
		      double _x, double _y, double _w, double _h, int _z)
 : KPS2D (_view, _coords, _matrix, _x, _y, _w, _h, _z)
{
  bdrawrims = true;
  rimcolor = black;
  rimsize0 = .001;

  barcolor = blue;

  computeSizes();
}

void
KPS2DBars::computeSizes (void)
{
  rimsize = kpmax ( 1, (int) (rimsize0*view()->width()) );
}

void
KPS2DBars::reDraw (QPainter *p)
{

  if (matrix())
    {

      if (needRedraw()) 
	{
	  //start drawing from beginning 
	}

      double dx = (double)coords()->owidth()/
	(coords()->cxmax()-coords()->cxmin());

      /*      printf ("BarsCOORDS: %d %d %d %d  %f %f\n",
	      coords()->oX0(),
	      coords()->oY0(),
	      coords()->owidth(),
	      coords()->oheight(),
	      coords()->cxmin(),
	      coords()->cxmax());
      */

      //continue drawing plot



      unsigned int i;
      p->setClipRect ( coords()->oX0(),
		       coords()->oY0(),
		       coords()->owidth(),
		       coords()->oheight() );

      int ybottom = coords()->yc_to_o (coords()->cymin());

      for (i=0; i<matrix()->nRows(); i++)
	{
	  int ytop = coords()->
	    yc_to_o(matrix()->matrix() [i*matrix()->nCols()+1]);
	  int yheight = ybottom-ytop;
	  int xleft = coords()->xc_to_o (i);

	  printf ("BAR: %d %d %d\n", ytop, yheight, xleft);

	  //Bar
	  p->setBrush (barcolor);
	  p->setPen (barcolor);
	  p->drawRect ( xleft, ytop,
			dx, yheight );
	  
	  //Rim
	  if (bdrawrims)
	    {
	      p->setBrush (rimcolor);
	      p->setPen (rimcolor);
	      p->drawRect ( xleft, ytop,
			    rimsize, yheight );
	      p->drawRect ( xleft+dx-rimsize, ytop,
			    rimsize, yheight );
	      p->drawRect ( xleft, ytop,
			    dx, rimsize );

	    }
	  
	}
     
      doneRedrawing();
    }

}


void
KPS2DBars::resizeEvent (QResizeEvent *qre)
{
  computeSizes();
  KPS2D::resizeEvent (qre);
}

KPCoords
KPS2DBars::autoCoords (const KPCoords *c)
{
  //  if (c==0)   //ignore c for now
    {
      if (matrix()==0)
	return KPCoords (0,0,0,0);
      KPCoords coords ( 0, matrix()->nRows(),
			kpmax (matrix()->min(1), 0.),
			matrix()->max(1) );
      return coords;
    }

}
