#include <stdio.h>

#include <qfont.h>
#include <qpopupmenu.h>
#include <qdialog.h>
#include <qlayout.h>
#include <qpushbutton.h>

#include <kputil.h>

#include "kpscoordframe.moc"
#include "kps2d.h"


KPSCoordFrame::KPSCoordFrame (KPView *_view, KPCoords *_coords, int _z)
  : KPSprite (_view, 0, 0, 0, 0, _z)
{
  printf ("KPSCoordFrame\n");
  kcoords=_coords;

  //We should have a good "auto" version of decplaces.  We need two
  //  things to reduce the size of the tick labels:
  //      (1) scientific notation 
  //      (2) some sort of "offset" like: 1.333553... ...1, ...2, ...3,
  // (That sucks, but how can we handle ranges that are near the
  //  high end of the available number of sig figs?)
  decplaces = 2; //configurable later
  
  pointsize0 = .02;
  framesize0 = .001;
  ticksize0 = .022;

  setMovableX(FALSE);
  setMovableY(FALSE);

  blabels = bticks = TRUE;

  //You need to call setRect() in the constructor.  KPSprite
  // can't do that for you.


  computeSizes();
  setRect();
}

void
KPSCoordFrame::computeSizes (void)
{
  int newps = (int) (pointsize0 * view()->width());
  printf ("cs: newps = %d\n",newps);
  tickfont.setPointSize (newps);

  framesize = kpmax ((int) (framesize0 * view()->width()),1);
  framesizeo2 = framesize/2;
  ticksize = kpmax ((int) (ticksize0 * view()->width()),1);
  ticksizeo2 = ticksize/2;

  computeTextSize();
  qsgirth.setWidth (tickyw);
  qsgirth.setHeight (tickxh);
}

void
KPSCoordFrame::computeTextSize(void)
{
  const int extraspace = 2; //keep the selection box away from the tick marks


  int max;
  int max2;
  
  QString tick;
  QWidget qwt;
  QPainter p(&qwt);
  QRect r;

  p.setFont(tickfont);

  max = max2 = 0;

  for (double y = kcoords->cymin(); y<kcoords->cymax();
       y+=kcoords->yTickSpacing())
    {
      tick.setNum (y,'f',decplaces); 
      r = p.boundingRect(QRect(0,0,0,0), 0, tick); 
      if (r.width()>max)
	max = r.width();
      if (r.height()>max2)
	max2 = r.height();
    }
  tickyw = max + extraspace;
  tickyh = max2/2;

  max= max2 = 0;
  for (double x = kcoords->cxmin(); x<=kcoords->cxmax();
       x+=kcoords->xTickSpacing())
    {
      tick.setNum (x,'f', decplaces); 
      r = p.boundingRect(QRect(0,0,0,0), 0, tick); 
      if (r.width()>max)
	max = r.width();
      if (r.height()>max2)
	max2 = r.height();
    }
  tickxw = max/2;
  tickxh = max2 + extraspace;
}

void
KPSCoordFrame::setRect()
{
  removeFromChunks();

  brect = QRect (kcoords->oX0() - tickyw,
		 kcoords->oY0() - tickyh,
		 kcoords->owidth() + tickyw + tickxw,
		 kcoords->oheight() + tickxh + tickyh);

  brectinner = QRect (kcoords->oX0() + ticksize + 1,
		      kcoords->oY0() + ticksize + 1,
		      kcoords->owidth() - 2*ticksize -2,
		      kcoords->oheight() - 2*ticksize -2);


  lx = (double)brect.x()/view()->width();
  ly = (double)brect.y()/view()->height();

  addToChunks();
}      

void
KPSCoordFrame::draw (QPainter &painter)
{

  QRect r;

  painter.setFont (tickfont);

  //Draw frame
  int w = kcoords->xc_to_o(kcoords->cxmax()) - 
    kcoords->xc_to_o(kcoords->cxmin());
  painter.fillRect (kcoords->xc_to_o(kcoords->cxmin()) - framesizeo2,
		    kcoords->yc_to_o (kcoords->cymin()) - framesizeo2,
		    w, framesize, black);
  
  painter.fillRect (kcoords->xc_to_o(kcoords->cxmin()) - framesizeo2,
		    kcoords->yc_to_o (kcoords->cymax()) - framesizeo2,
		    w, framesize, black);

  int h = kcoords->yc_to_o(kcoords->cymax()) - 
    kcoords->yc_to_o(kcoords->cymin());
  painter.fillRect (kcoords->xc_to_o (kcoords->cxmin()) - framesizeo2,
		    kcoords->yc_to_o(kcoords->cymin()) - framesizeo2,
		    framesize, h, black);

  painter.fillRect (kcoords->xc_to_o (kcoords->cxmax()) - framesizeo2,
		    kcoords->yc_to_o(kcoords->cymin()) - framesizeo2,
		    framesize, h, black);


  // Ticks


  //X Ticks
  int ty = kcoords->yc_to_o(kcoords->cymin()) + tickxh;

  QString tick;
  
  for (double x = kcoords->cxmin(); x<=kcoords->cxmax();
       x+=kcoords->xTickSpacing())
    {
      tick.setNum (x,'f', decplaces); 
      r = painter.boundingRect(QRect(0,0,0,0), 0, tick); 
      if (blabels)
	painter.drawText (kcoords->xc_to_o(x) - r.width()/2,
			  ty, tick);
      if (bticks)
	{
	  painter.fillRect (kcoords->xc_to_o(x) - framesizeo2,
			    kcoords->yc_to_o (kcoords->cymin()) - ticksize,
			    framesize, ticksize, black);
	  painter.fillRect (kcoords->xc_to_o(x) - framesizeo2,
			    kcoords->yc_to_o (kcoords->cymax()),
			    framesize, ticksize, black);
	}

    }


  //Y Ticks
  int tx;
  int fudgefactor = 0;

  if (kcoords->cymin()>kcoords->cymax())
    {
      for (double y = kcoords->cymax(); y<=kcoords->cymin();
	   y-=kcoords->yTickSpacing())
	{
	  tick.setNum (y,'f',decplaces); 
	  r = painter.boundingRect(QRect(0,0,0,0), 0, tick);
	  tx = kcoords->xc_to_o (kcoords->cxmin()) - fudgefactor - r.width();
	  if (blabels)
	    painter.drawText (tx, kcoords->yc_to_o(y) + r.height()/2
			      - fudgefactor, tick );
	  
	  if (bticks)
	    {
	      painter.fillRect (kcoords->xc_to_o (kcoords->cxmin()),
				kcoords->yc_to_o(y) - framesizeo2,
				ticksize, framesize, black);
	      painter.fillRect (kcoords->xc_to_o (kcoords->cxmax()) - ticksize,
				kcoords->yc_to_o(y) - framesizeo2,
				ticksize, framesize, black);
	    }
	}
    }
  else
    {
      for (double y = kcoords->cymin(); y<=kcoords->cymax();
	   y+=kcoords->yTickSpacing())
	{
	  tick.setNum (y,'f',decplaces); 
	  r = painter.boundingRect(QRect(0,0,0,0), 0, tick);
	  tx = kcoords->xc_to_o (kcoords->cxmin()) - fudgefactor - r.width();
	  if (blabels)
	    painter.drawText (tx, kcoords->yc_to_o(y) + r.height()/2
			      - fudgefactor, tick );
	  
	  if (bticks)
	    {
	      painter.fillRect (kcoords->xc_to_o (kcoords->cxmin()),
				kcoords->yc_to_o(y) - framesizeo2,
				ticksize, framesize, black);
	      painter.fillRect (kcoords->xc_to_o (kcoords->cxmax()) - ticksize,
				kcoords->yc_to_o(y) - framesizeo2,
				ticksize, framesize, black);
	    }
	}
    }

  if (selected())
    {
      painter.setPen (DashLine);
      painter.setRasterOp (NotROP);
      painter.drawRect (brect);
      painter.drawRect (brectinner);
    }
}

void
KPSCoordFrame::resizeEvent (QResizeEvent *r)
{
  computeSizes();

  setRect();

  KPSprite::resizeEvent  (r);
}


void
KPSCoordFrame::installDefaultRMBMenu (void)
{

  rmbmenu = new QPopupMenu;
  rmbmenu->insertItem ("&Coordinates...", this, SLOT(slotCoords()));

}

void
KPSCoordFrame::slotCoords()
{
  QDialog d (0, 0, TRUE);
  QGridLayout *layout = new QGridLayout (&d, 2, 3, 10);
 
  KPCoordsProp *p = new KPCoordsProp (kcoords, &d);
  layout->addMultiCellWidget (p, 0, 0, 0, 2);
  QPushButton *b = new QPushButton ("OK", &d);
  b->setMinimumSize (b->size());
  b->setMaximumSize (b->size());
  b->setDefault(true);
  connect ( b, SIGNAL (clicked()),
            &d, SLOT (accept()) );
  layout->addWidget (b, 1, 1);
  b = new QPushButton ("Cancel", &d);
  b->setMinimumSize (b->size());
  b->setMaximumSize (b->size());
  connect ( b, SIGNAL (clicked()),
            &d, SLOT (reject()) );
  layout->addWidget (b, 1, 2);

  if (d.exec())
    {
      if (parent()) //must be a KPS2D for now
	{
	  ((KPS2D *)parent())->setCoords (KPCoords (p), false);
	  update();
	}
      else
	*kcoords = * (new KPCoords (p));
    }
}

void
KPSCoordFrame::addToChunks()
{
  if (visible() && spritefield) 
    {
      int chunksize=spritefield->chunkSize();
      int jmax = brect.bottom()/chunksize;
      int imax = brect.right()/chunksize;
      int l=brectinner.left()/chunksize,
	t=brectinner.top()/chunksize,
	r=brectinner.right()/chunksize,
	b=brectinner.bottom()/chunksize;
	       
      for (int j=brect.top()/chunksize; j<=jmax; j++)
	for (int i=brect.left()/chunksize; i<=imax; i++)
	  if ((j>t || j<b) && (i<l || i>r))
	      spritefield->addGraphicToChunk(this,i,j);
    }
 
  lastaddbrect = brect;
}
