/**
 * KPSpline
 * David Sweet
 *
 * This class is a KPMatrix which is a spline interpolation
 *  between points in some given KPMatrix.
 *
 * Adapted from XDraw, a program by 
 **/

#ifndef __KPSPLINE_H__
#define __KPSPLINE_H__

#include "kpmatrix.h"

class KPSpline : public KPMatrix
{
 public:
  /**
   * Create a spline curve from <i>matrix</i>.
   **/
  KPSpline (KPMatrix *matrix, unsigned int _detail);

  /**
   * Is the matrix usable?
   **/
  bool isOK (void) { return bok; }

  /**
   * Call this to generate the matrix.  It is called by the constructor,
   *  but (at some point) it may be useful for an outside person to call it.
   **/
  bool generateMatrix (void);

  ~KPSpline ();

 protected:
  void add (int, double, double);
  bool eval (int, double, double *, double *, bool);
  void fit (void);

  void fit1 (double *, double *, double *);
  double fourfit (double *, double *, int);
  void getcoeff (double *x, double *f,
		 double *a, double *b, double *c, double *d);
  void getcoeff2 (double *x, double *f, double *by, double *cy);      

 private:
  bool bok;
  int splinetype, crudespline;
  int ns;
  unsigned int detail;
  double *x, *u, *f, *g, *t;
  int parameterize;
  KPMatrix *inmat;

};

#endif

