#include <stdio.h>  //for debugging

#include "kpsprite.moc"
#include "kpview.h"

// The variable 'spritefield' contains a pointer to the
//  QwSpriteField.


KPSprite::KPSprite(KPView *_view, 
		   double _x, double _y, double _w, double _h, int _z)
{

  lx0 = lx = _x;
  ly0 = ly = _y;
  lw0 = lw = _w;
  lh0 = lh = _h;

  x (lx*_view->width());
  y (ly*_view->height());
  z (_z);
  setSelected (FALSE);
  kview = _view;
  rmbmenu=0;

  bmovableX = bmovableY = TRUE;

  children = 0;
  myparent = 0;
  //  printf ("KPS %d %d \n",x(),y());
  //  printf ("KPS %f %f  %f %f\n",lx,ly,lw,lh);
  bps = FALSE; 

  lastaddbrect = QRect (-1,-1,0,0);

  //don't need a moveTo or a setRect in here

}

void
KPSprite::installRMBMenu (QPopupMenu *_rmb)
{
  if (rmbmenu)
    delete rmbmenu;
  rmbmenu = _rmb;
}

void
KPSprite::x(int c)
{
  removeFromChunks();
  brect.moveBy(c-brect.x(),0);
  addToChunks();
}

void
KPSprite::y(int c)
{
  removeFromChunks();
  brect.moveBy(0,c-brect.y());
  addToChunks();
}


void
KPSprite::moveBy(int dx, int dy)
{
  if (movableX() || movableY())
    {
      removeFromChunks();
      brect.moveBy(dx,dy);
      addToChunks();
      
      if (view()->userManeuver())
	{
	  lx += (double)dx/view()->width();
	  ly += (double)dy/view()->height();
	}
      
      KPSprite *kps;
      
      if (children)
	{
	  kps = children->first();
	  do
	    {
	      kps->moveBy (dx, dy);
	    } while ( (kps = children->next()) );
	}
    }
}


void
KPSprite::addChild (KPSprite *kps)
{
  if (!children)
    children = new QList<KPSprite>;

  children->append(kps);
  kps->setParent (this);
}

void
KPSprite::removeChild (KPSprite *child)
{
  printf ("RC\n");
  children->removeRef (child);
  printf ("RC2\n");
}

void
KPSprite::setParent (KPSprite *parent)
{
  myparent = parent;
}

void
KPSprite::moveTo(int x, int y)
{
  moveBy (x-brect.x(), y-brect.y());
}


void
KPSprite::z(int a)
{
  alt=a;
  changeChunks();
}

bool
KPSprite::at(int x, int y) const
{
  return brect.contains(QPoint(x,y));
}

bool
KPSprite::at(const class QRect & r) const
{
  return r.intersects(brect);
}

void
KPSprite::makeVisible(bool yes)
{
  if (yes)
    addToChunks();
  else
    removeFromChunks();
}



void
KPSprite::changeChunks()
{
    if (visible() && spritefield) {
	int chunksize=spritefield->chunkSize();
	for (int j=brect.top()/chunksize; j<=brect.bottom()/chunksize; j++) {
	    for (int i=brect.left()/chunksize; i<=brect.right()/chunksize; i++) {
		spritefield->setChangedChunk(i,j);
	    }
	}
    }
}

void
KPSprite::addToChunks()
{
    if (visible() && spritefield) {
	int chunksize=spritefield->chunkSize();
	for (int j=brect.top()/chunksize; j<=brect.bottom()/chunksize; j++) {
	    for (int i=brect.left()/chunksize; i<=brect.right()/chunksize; i++) {
		spritefield->addGraphicToChunk(this,i,j);
	    }
	}
    }

    lastaddbrect = brect;
}

void
KPSprite::removeFromChunks()
{
  //TEST
  lastaddbrect = QRect (0,0,1000,1000);

    if (visible() && spritefield) {
	int chunksize=spritefield->chunkSize();
	for (int j=lastaddbrect.top()/chunksize; j<=lastaddbrect.bottom()/chunksize; j++) {
	    for (int i=lastaddbrect.left()/chunksize; i<=lastaddbrect.right()/chunksize; i++) {
		spritefield->removeGraphicFromChunk(this,i,j);
	    }
	}
    }
}

void
KPSprite::mousePressEvent (QMouseEvent *m)
{

  if (rmbmenu!=0  && m->button()==
      Qt::RightButton)

    rmbmenu->exec(QCursor::pos());

}

KPSprite::~KPSprite()
{
  printf ("~KPS\n");

  view()->spriteLeaving (this);
  removeFromChunks();


  if (children)
  { 
    // We can't just delete the sprites from /children/ directly b/c they
    //  remove themselves from /children/ in their destructors.
    QList<KPSprite> c (*children);
    c.setAutoDelete (true);
    unsigned int i;
    for (i=0;i<c.count();i++)
      c.remove (i);
    delete children;
  }
  if (rmbmenu)
    delete rmbmenu;

  if (myparent)
    myparent->removeChild (this);
}

void
KPSprite::update (void)
{
  view()->update();
  if (children)
    {
      KPSprite *child = children->first();
      while (child!=0)
	{
	  child->update();
	  child=children->next();
	}
    }
  
}

void
KPSprite::resizeEvent (QResizeEvent *r)
{
  moveTo ( (int) ( lx*r->size().width() ),
	   (int) ( ly*r->size().height() ) );

  /*
  KPSprite *child = children->first();
  while (child!=0)
    {
      printf ("CHILD\n");
      printf ("CHILD: %d\n", child->whatami());
      child->resizeEvent (r);
      child=children->next();
    }
  */
  
}

void
KPSprite::slotPopupRedirect (int id)
{
  emit popupRedirect (this, id);
}

void
KPSprite::installDefaultRMBMenu (void)
{
  rmbmenu = new QPopupMenu;
}
